/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.logging;

import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Locale;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.rest.cachemanager.exceptions.CacheUnavailableException;
import org.infinispan.rest.framework.Invocation;
import org.infinispan.rest.framework.Method;
import org.infinispan.rest.framework.RegistrationException;
import org.infinispan.rest.logging.Log;
import org.infinispan.rest.operations.exceptions.NoCacheFoundException;
import org.infinispan.rest.operations.exceptions.ServiceUnavailableException;
import org.infinispan.rest.operations.exceptions.UnacceptableDataFormatException;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;

public class Log_$logger
extends DelegatingBasicLogger
implements Log,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Log_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;

    public Log_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    protected String unsupportedConfigurationOption$str() {
        return "ISPN012004: Unsupported configuration option";
    }

    @Override
    public final UnsupportedOperationException unsupportedConfigurationOption() {
        UnsupportedOperationException result = new UnsupportedOperationException(String.format(this.getLoggingLocale(), this.unsupportedConfigurationOption$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    private static void _copyStackTraceMinusOne(Throwable e) {
        StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }

    @Override
    public final void errorWhileResponding(Throwable t) {
        this.log.logf(FQCN, Logger.Level.ERROR, t, this.errorWhileResponding$str(), new Object[0]);
    }

    protected String errorWhileResponding$str() {
        return "ISPN012005: An error occurred while responding to the client";
    }

    @Override
    public final void uncaughtExceptionInThePipeline(Throwable e) {
        this.log.logf(FQCN, Logger.Level.ERROR, e, this.uncaughtExceptionInThePipeline$str(), new Object[0]);
    }

    protected String uncaughtExceptionInThePipeline$str() {
        return "ISPN012006: Uncaught exception in the pipeline";
    }

    protected String unsupportedDataFormat$str() {
        return "ISPN012007: Cannot convert to %s";
    }

    @Override
    public final UnacceptableDataFormatException unsupportedDataFormat(String mediaType) {
        UnacceptableDataFormatException result = new UnacceptableDataFormatException(String.format(this.getLoggingLocale(), this.unsupportedDataFormat$str(), mediaType));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cacheUnavailable$str() {
        return "ISPN012008: Cache with name '%s' is temporarily unavailable.";
    }

    @Override
    public final ServiceUnavailableException cacheUnavailable(String cacheName) {
        ServiceUnavailableException result = new ServiceUnavailableException(String.format(this.getLoggingLocale(), this.cacheUnavailable$str(), cacheName));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String missingRequiredMediaType$str() {
        return "ISPN012009: Cannot obtain cache '%s', without required MediaType";
    }

    @Override
    public final NullPointerException missingRequiredMediaType(String cacheName) {
        NullPointerException result = new NullPointerException(String.format(this.getLoggingLocale(), this.missingRequiredMediaType$str(), cacheName));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String cacheNotFound$str() {
        return "ISPN012010: Cache with name '%s' not found amongst the configured caches";
    }

    @Override
    public final NoCacheFoundException cacheNotFound(String cacheName) {
        NoCacheFoundException result = new NoCacheFoundException(String.format(this.getLoggingLocale(), this.cacheNotFound$str(), cacheName));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String requestNotAllowedToInternalCaches$str() {
        return "ISPN012011: Remote requests are not allowed to private caches. Do no send remote requests to cache '%s'";
    }

    @Override
    public final CacheUnavailableException requestNotAllowedToInternalCaches(String cacheName) {
        CacheUnavailableException result = new CacheUnavailableException(String.format(this.getLoggingLocale(), this.requestNotAllowedToInternalCaches$str(), cacheName));
        Log_$logger._copyStackTraceMinusOne((Throwable)((Object)result));
        return result;
    }

    protected String requestNotAllowedToInternalCachesWithoutAuthz$str() {
        return "ISPN012012: Remote requests are not allowed to internal caches when authorization is disabled. Do no send remote requests to cache '%s'";
    }

    @Override
    public final CacheUnavailableException requestNotAllowedToInternalCachesWithoutAuthz(String cacheName) {
        CacheUnavailableException result = new CacheUnavailableException(String.format(this.getLoggingLocale(), this.requestNotAllowedToInternalCachesWithoutAuthz$str(), cacheName));
        Log_$logger._copyStackTraceMinusOne((Throwable)((Object)result));
        return result;
    }

    protected String illegalCompressionLevel$str() {
        return "ISPN012014: Illegal compression level '%d'. The value must be >= 0 and <= 9";
    }

    @Override
    public final CacheConfigurationException illegalCompressionLevel(int compressionLevel) {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.illegalCompressionLevel$str(), compressionLevel));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String duplicateResourceMethod$str() {
        return "ISPN012015: Cannot register invocation '%s': resource already registered for method '%s' at the destination path '/%s'";
    }

    @Override
    public final RegistrationException duplicateResourceMethod(String invocationName, Method method, String existingPath) {
        RegistrationException result = new RegistrationException(String.format(this.getLoggingLocale(), this.duplicateResourceMethod$str(), new Object[]{invocationName, method, existingPath}));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void warnInvalidNumber(String header, String value) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.warnInvalidNumber$str(), (Object)header, (Object)value);
    }

    protected String warnInvalidNumber$str() {
        return "ISPN012016: Header '%s' will be ignored, expecting a number but got '%s'";
    }

    protected String authenticationWithoutAuthenticator$str() {
        return "ISPN012017: Cannot enable authentication without an authenticator";
    }

    @Override
    public final CacheConfigurationException authenticationWithoutAuthenticator() {
        CacheConfigurationException result = new CacheConfigurationException(String.format(this.getLoggingLocale(), this.authenticationWithoutAuthenticator$str(), new Object[0]));
        Log_$logger._copyStackTraceMinusOne((Throwable)result);
        return result;
    }

    protected String invalidPath$str() {
        return "ISPN012018: Cannot register invocation with path '%s': '*' is only allowed at the end";
    }

    @Override
    public final RegistrationException invalidPath(String path) {
        RegistrationException result = new RegistrationException(String.format(this.getLoggingLocale(), this.invalidPath$str(), path));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String duplicateResource$str() {
        return "ISPN012019: Cannot register path '%s' for invocation '%s', since it conflicts with resource '%s'";
    }

    @Override
    public final RegistrationException duplicateResource(String candidate, Invocation invocation, String existingPath) {
        RegistrationException result = new RegistrationException(String.format(this.getLoggingLocale(), this.duplicateResource$str(), candidate, invocation, existingPath));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    @Override
    public final void asyncMassIndexerStarted() {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.asyncMassIndexerStarted$str(), new Object[0]);
    }

    protected String asyncMassIndexerStarted$str() {
        return "ISPN012020: MassIndexer started";
    }

    @Override
    public final void asyncMassIndexerSuccess() {
        this.log.logf(FQCN, Logger.Level.INFO, null, this.asyncMassIndexerSuccess$str(), new Object[0]);
    }

    protected String asyncMassIndexerSuccess$str() {
        return "ISPN012021: MassIndexer completed successfully";
    }

    @Override
    public final void errorExecutingMassIndexer(Throwable e) {
        this.log.logf(FQCN, Logger.Level.ERROR, e, this.errorExecutingMassIndexer$str(), new Object[0]);
    }

    protected String errorExecutingMassIndexer$str() {
        return "ISPN012022: Error executing MassIndexer";
    }

    protected String illegalArgument$str() {
        return "ISPN012023: Argument '%s' has illegal value '%s'";
    }

    @Override
    public final IllegalArgumentException illegalArgument(String name, Object value) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.illegalArgument$str(), name, value));
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }

    protected String synchronizedEntries$str() {
        return "ISPN012024: Synchronized %d entries";
    }

    @Override
    public final String synchronizedEntries(long hotrod) {
        return String.format(this.getLoggingLocale(), this.synchronizedEntries$str(), hotrod);
    }

    @Override
    public final void invalidOrigin(String origin, String prop) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.invalidOrigin$str(), (Object)origin, (Object)prop);
    }

    protected String invalidOrigin$str() {
        return "ISPN012025: Ignoring invalid origin '%s' when reading '-D%s'";
    }

    @Override
    public final void warnDeprecatedCall(String invocation) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.warnDeprecatedCall$str(), (Object)invocation);
    }

    protected String warnDeprecatedCall$str() {
        return "ISPN012026: The REST invocation [%s] has been deprecated. Please consult the upgrade guide";
    }

    protected String authorizationNotEnabled$str() {
        return "ISPN012027: Security authorization is not enabled on this server.";
    }

    @Override
    public final String authorizationNotEnabled() {
        return String.format(this.getLoggingLocale(), this.authorizationNotEnabled$str(), new Object[0]);
    }

    protected String principalRoleMapperNotMutable$str() {
        return "ISPN012028: The principal-role mapper is not mutable";
    }

    @Override
    public final String principalRoleMapperNotMutable() {
        return String.format(this.getLoggingLocale(), this.principalRoleMapperNotMutable$str(), new Object[0]);
    }

    protected String rolePermissionMapperNotMutable$str() {
        return "ISPN012029: The role-permission mapper is not mutable";
    }

    @Override
    public final String rolePermissionMapperNotMutable() {
        return String.format(this.getLoggingLocale(), this.rolePermissionMapperNotMutable$str(), new Object[0]);
    }

    protected String heapDumpFailed$str() {
        return "ISPN012030: Heap dump generation failed";
    }

    @Override
    public final RuntimeException heapDumpFailed(IOException e) {
        RuntimeException result = new RuntimeException(String.format(this.getLoggingLocale(), this.heapDumpFailed$str(), new Object[0]), e);
        Log_$logger._copyStackTraceMinusOne(result);
        return result;
    }
}

