/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.resources;

import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.CacheStream;
import org.infinispan.commons.api.CacheContainerAdmin;
import org.infinispan.commons.configuration.attributes.Attribute;
import org.infinispan.commons.configuration.attributes.ConfigurationElement;
import org.infinispan.commons.configuration.io.ConfigurationWriter;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.dataconversion.internal.Json;
import org.infinispan.commons.dataconversion.internal.JsonSerialization;
import org.infinispan.commons.io.StringBuilderWriter;
import org.infinispan.commons.util.ProcessorInfo;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.StoreConfiguration;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ParserRegistry;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.manager.EmbeddedCacheManagerAdmin;
import org.infinispan.marshall.core.EncoderRegistry;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryCreated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryExpired;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryModified;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryRemoved;
import org.infinispan.notifications.cachelistener.event.CacheEntryEvent;
import org.infinispan.partitionhandling.AvailabilityMode;
import org.infinispan.persistence.manager.PersistenceManager;
import org.infinispan.persistence.remote.RemoteStore;
import org.infinispan.persistence.remote.configuration.RemoteStoreConfiguration;
import org.infinispan.persistence.remote.upgrade.SerializationUtils;
import org.infinispan.query.Search;
import org.infinispan.query.core.stats.IndexStatistics;
import org.infinispan.query.core.stats.SearchStatistics;
import org.infinispan.rest.CacheEntryInputStream;
import org.infinispan.rest.CacheKeyInputStream;
import org.infinispan.rest.EventStream;
import org.infinispan.rest.InvocationHelper;
import org.infinispan.rest.NettyRestResponse;
import org.infinispan.rest.ResponseHeader;
import org.infinispan.rest.RestResponseException;
import org.infinispan.rest.ServerSentEvent;
import org.infinispan.rest.cachemanager.RestCacheManager;
import org.infinispan.rest.distribution.CacheDistributionInfo;
import org.infinispan.rest.framework.ContentSource;
import org.infinispan.rest.framework.Method;
import org.infinispan.rest.framework.ResourceHandler;
import org.infinispan.rest.framework.RestRequest;
import org.infinispan.rest.framework.RestResponse;
import org.infinispan.rest.framework.impl.Invocations;
import org.infinispan.rest.logging.Log;
import org.infinispan.rest.resources.BaseCacheResource;
import org.infinispan.rest.resources.MediaTypeUtils;
import org.infinispan.rest.resources.ResourceUtil;
import org.infinispan.rest.resources.SecurityActions;
import org.infinispan.rest.tracing.RestTelemetryService;
import org.infinispan.security.AuditContext;
import org.infinispan.security.AuthorizationPermission;
import org.infinispan.stats.Stats;
import org.infinispan.topology.LocalTopologyManager;
import org.infinispan.upgrade.RollingUpgradeManager;

public class CacheResourceV2
extends BaseCacheResource
implements ResourceHandler {
    private static final int STREAM_BATCH_SIZE = 1000;
    private static final String MIGRATOR_NAME = "hotrod";
    private final ParserRegistry parserRegistry = new ParserRegistry();

    public CacheResourceV2(InvocationHelper invocationHelper, RestTelemetryService telemetryService) {
        super(invocationHelper, telemetryService);
    }

    @Override
    public Invocations getInvocations() {
        return new Invocations.Builder().invocation().methods(Method.PUT, Method.POST).path("/v2/caches/{cacheName}/{cacheKey}").handleWith(this::putValueToCache).invocation().methods(Method.GET, Method.HEAD).path("/v2/caches/{cacheName}/{cacheKey}").handleWith(this::getCacheValue).invocation().method(Method.DELETE).path("/v2/caches/{cacheName}/{cacheKey}").handleWith(this::deleteCacheValue).invocation().methods(Method.GET).path("/v2/caches/{cacheName}").withAction("keys").handleWith(this::streamKeys).invocation().methods(Method.GET).path("/v2/caches/{cacheName}").withAction("entries").handleWith(this::streamEntries).invocation().methods(Method.GET).path("/v2/caches/{cacheName}").withAction("listen").handleWith(this::cacheListen).invocation().methods(Method.GET, Method.HEAD).path("/v2/caches/{cacheName}").withAction("config").handleWith(this::getCacheConfig).invocation().methods(Method.GET).path("/v2/caches/{cacheName}").withAction("stats").handleWith(this::getCacheStats).invocation().methods(Method.GET).path("/v2/caches/{cacheName}").withAction("distribution").handleWith(this::getCacheDistribution).invocation().methods(Method.GET).path("/v2/caches/{cacheName}").withAction("get-mutable-attributes").permission(AuthorizationPermission.ADMIN).handleWith(this::getCacheConfigMutableAttributes).invocation().methods(Method.GET).path("/v2/caches/{cacheName}").withAction("get-mutable-attribute").permission(AuthorizationPermission.ADMIN).handleWith(this::getCacheConfigMutableAttribute).invocation().methods(Method.POST).path("/v2/caches/{cacheName}").withAction("set-mutable-attribute").permission(AuthorizationPermission.ADMIN).handleWith(this::setCacheConfigMutableAttribute).invocation().methods(Method.GET).path("/v2/caches/").handleWith(this::getCacheNames).invocation().methods(Method.POST, Method.PUT).path("/v2/caches/{cacheName}").handleWith(this::createOrUpdate).invocation().method(Method.DELETE).path("/v2/caches/{cacheName}").handleWith(this::removeCache).invocation().method(Method.HEAD).path("/v2/caches/{cacheName}").handleWith(this::cacheExists).invocation().method(Method.GET).path("/v2/caches/{cacheName}").withAction("get-availability").permission(AuthorizationPermission.ADMIN).handleWith(this::getCacheAvailability).invocation().method(Method.POST).path("/v2/caches/{cacheName}").withAction("set-availability").permission(AuthorizationPermission.ADMIN).handleWith(this::setCacheAvailability).invocation().methods(Method.POST).path("/v2/caches/{cacheName}").withAction("clear").handleWith(this::clearEntireCache).invocation().methods(Method.GET).path("/v2/caches/{cacheName}").withAction("size").handleWith(this::getSize).invocation().methods(Method.POST).path("/v2/caches/{cacheName}").withAction("sync-data").handleWith(this::syncData).invocation().methods(Method.POST).path("/v2/caches/{cacheName}").deprecated().withAction("disconnect-source").handleWith(this::deleteSourceConnection).invocation().methods(Method.POST).path("/v2/caches/{cacheName}/rolling-upgrade/source-connection").handleWith(this::addSourceConnection).invocation().methods(Method.DELETE).path("/v2/caches/{cacheName}/rolling-upgrade/source-connection").handleWith(this::deleteSourceConnection).invocation().methods(Method.HEAD).path("/v2/caches/{cacheName}/rolling-upgrade/source-connection").handleWith(this::hasSourceConnections).invocation().methods(Method.GET).path("/v2/caches/{cacheName}/rolling-upgrade/source-connection").handleWith(this::getSourceConnection).invocation().methods(Method.GET, Method.POST).path("/v2/caches/{cacheName}").withAction("search").permission(AuthorizationPermission.BULK_READ).handleWith(this.queryAction::search).invocation().methods(Method.POST).path("/v2/caches").withAction("toJSON").deprecated().handleWith(this::convertToJson).invocation().methods(Method.POST).path("/v2/caches").withAction("convert").handleWith(this::convert).invocation().methods(Method.GET).path("/v2/caches/{cacheName}").handleWith(this::getAllDetails).invocation().methods(Method.POST).path("/v2/caches/{cacheName}").withAction("enable-rebalancing").permission(AuthorizationPermission.ADMIN).name("ENABLE REBALANCE").auditContext(AuditContext.CACHE).handleWith(r -> this.setRebalancing(true, (RestRequest)r)).invocation().methods(Method.POST).path("/v2/caches/{cacheName}").withAction("disable-rebalancing").permission(AuthorizationPermission.ADMIN).name("DISABLE REBALANCE").auditContext(AuditContext.CACHE).handleWith(r -> this.setRebalancing(false, (RestRequest)r)).create();
    }

    private CompletionStage<RestResponse> getSourceConnection(RestRequest request) {
        NettyRestResponse.Builder builder = new NettyRestResponse.Builder();
        String cacheName = request.variables().get("cacheName");
        AdvancedCache<Object, Object> cache = this.invocationHelper.getRestCacheManager().getCache(cacheName, request);
        PersistenceManager persistenceManager = SecurityActions.getPersistenceManager(this.invocationHelper.getRestCacheManager().getInstance(), cache.getName());
        ArrayList remoteStores = new ArrayList(persistenceManager.getStores(RemoteStore.class));
        if (remoteStores.isEmpty()) {
            builder.status(HttpResponseStatus.NOT_FOUND);
            return CompletableFuture.completedFuture(builder.build());
        }
        if (remoteStores.size() != 1) {
            builder.status(HttpResponseStatus.INTERNAL_SERVER_ERROR);
            builder.entity("More than one remote store detected, rolling upgrades aren't supported");
            return CompletableFuture.completedFuture(builder.build());
        }
        RemoteStoreConfiguration storeConfiguration = ((RemoteStore)remoteStores.get(0)).getConfiguration();
        builder.entity(SerializationUtils.toJson((RemoteStoreConfiguration)storeConfiguration));
        return CompletableFuture.completedFuture(builder.build());
    }

    private CompletionStage<RestResponse> hasSourceConnections(RestRequest request) {
        NettyRestResponse.Builder builder = new NettyRestResponse.Builder();
        String cacheName = request.variables().get("cacheName");
        AdvancedCache<Object, Object> cache = this.invocationHelper.getRestCacheManager().getCache(cacheName, request);
        RollingUpgradeManager upgradeManager = (RollingUpgradeManager)cache.getAdvancedCache().getComponentRegistry().getComponent(RollingUpgradeManager.class);
        return CompletableFuture.supplyAsync(() -> {
            try {
                if (!upgradeManager.isConnected(MIGRATOR_NAME)) {
                    builder.status(HttpResponseStatus.NOT_FOUND);
                }
            }
            catch (Exception e) {
                builder.status(HttpResponseStatus.INTERNAL_SERVER_ERROR).entity(e.getMessage());
            }
            return builder.build();
        }, this.invocationHelper.getExecutor());
    }

    private CompletionStage<RestResponse> deleteSourceConnection(RestRequest request) {
        NettyRestResponse.Builder builder = new NettyRestResponse.Builder();
        builder.status(HttpResponseStatus.NO_CONTENT);
        String cacheName = request.variables().get("cacheName");
        AdvancedCache<Object, Object> cache = this.invocationHelper.getRestCacheManager().getCache(cacheName, request);
        RollingUpgradeManager upgradeManager = (RollingUpgradeManager)cache.getAdvancedCache().getComponentRegistry().getComponent(RollingUpgradeManager.class);
        try {
            if (upgradeManager.isConnected(MIGRATOR_NAME)) {
                upgradeManager.disconnectSource(MIGRATOR_NAME);
            } else {
                builder.status(HttpResponseStatus.NOT_MODIFIED);
            }
        }
        catch (Exception e) {
            builder.status(HttpResponseStatus.INTERNAL_SERVER_ERROR).entity(e.getMessage());
        }
        return CompletableFuture.completedFuture(builder.build());
    }

    private CompletionStage<RestResponse> addSourceConnection(RestRequest request) {
        NettyRestResponse.Builder builder = new NettyRestResponse.Builder();
        builder.status(HttpResponseStatus.NO_CONTENT);
        String cacheName = request.variables().get("cacheName");
        ContentSource contents = request.contents();
        byte[] config = contents.rawContent();
        AdvancedCache<Object, Object> cache = this.invocationHelper.getRestCacheManager().getCache(cacheName, request);
        if (cache == null) {
            return ResourceUtil.notFoundResponseFuture();
        }
        if (config == null || config.length == 0) {
            return ResourceUtil.badRequestResponseFuture("A remote-store config must be provided");
        }
        String storeConfig = new String(config, StandardCharsets.UTF_8);
        Json read = Json.read((String)storeConfig);
        if (!read.isObject() || read.at("remote-store") == null || read.asMap().size() != 1) {
            return ResourceUtil.badRequestResponseFuture("Invalid remote-store JSON description: a single remote-store element must be provided");
        }
        return CompletableFuture.supplyAsync(() -> {
            RollingUpgradeManager upgradeManager = (RollingUpgradeManager)cache.getAdvancedCache().getComponentRegistry().getComponent(RollingUpgradeManager.class);
            try {
                RemoteStoreConfiguration storeConfiguration = SerializationUtils.fromJson((String)read.toString());
                if (!upgradeManager.isConnected(MIGRATOR_NAME)) {
                    upgradeManager.connectSource(MIGRATOR_NAME, (StoreConfiguration)storeConfiguration);
                } else {
                    builder.status(HttpResponseStatus.NOT_MODIFIED);
                }
            }
            catch (Exception e) {
                Throwable rootCause = Util.getRootCause((Throwable)e);
                builder.status(HttpResponseStatus.INTERNAL_SERVER_ERROR).entity(rootCause.getMessage());
            }
            return builder.build();
        }, this.invocationHelper.getExecutor());
    }

    private CompletionStage<RestResponse> syncData(RestRequest request) {
        int threads;
        int readBatch;
        NettyRestResponse.Builder builder = new NettyRestResponse.Builder();
        String cacheName = request.variables().get("cacheName");
        String readBatchReq = request.getParameter("read-batch");
        String threadsReq = request.getParameter("threads");
        int n = readBatch = readBatchReq == null ? 10000 : Integer.parseInt(readBatchReq);
        if (readBatch < 1) {
            return CompletableFuture.completedFuture(builder.status(HttpResponseStatus.BAD_REQUEST).entity(Log.REST.illegalArgument("read-batch", readBatch).getMessage()).build());
        }
        int n2 = threads = request.getParameter("threads") == null ? ProcessorInfo.availableProcessors() : Integer.parseInt(threadsReq);
        if (threads < 1) {
            return CompletableFuture.completedFuture(builder.status(HttpResponseStatus.BAD_REQUEST).entity(Log.REST.illegalArgument("threads", threads).getMessage()).build());
        }
        AdvancedCache<Object, Object> cache = this.invocationHelper.getRestCacheManager().getCache(cacheName, request);
        RollingUpgradeManager upgradeManager = (RollingUpgradeManager)cache.getAdvancedCache().getComponentRegistry().getComponent(RollingUpgradeManager.class);
        return CompletableFuture.supplyAsync(() -> {
            try {
                long hotrod = upgradeManager.synchronizeData(MIGRATOR_NAME, readBatch, threads);
                builder.entity(Log.REST.synchronizedEntries(hotrod));
            }
            catch (Exception e) {
                Throwable rootCause = Util.getRootCause((Throwable)e);
                builder.status(HttpResponseStatus.INTERNAL_SERVER_ERROR).entity(rootCause.getMessage());
            }
            return builder.build();
        }, this.invocationHelper.getExecutor());
    }

    private CompletionStage<RestResponse> convert(RestRequest request, MediaType toType) {
        NettyRestResponse.Builder responseBuilder = new NettyRestResponse.Builder();
        String contents = request.contents().asString();
        if (contents == null || contents.isEmpty()) {
            responseBuilder.status(HttpResponseStatus.BAD_REQUEST);
            return CompletableFuture.completedFuture(responseBuilder.build());
        }
        return CompletableFuture.supplyAsync(() -> {
            ParserRegistry parserRegistry = this.invocationHelper.getParserRegistry();
            ConfigurationBuilderHolder builderHolder = parserRegistry.parse(contents, request.contentType());
            Map.Entry entry = builderHolder.getNamedConfigurationBuilders().entrySet().iterator().next();
            Configuration configuration = ((ConfigurationBuilder)entry.getValue()).build();
            StringBuilderWriter out = new StringBuilderWriter();
            try (ConfigurationWriter writer = ConfigurationWriter.to((Writer)out).withType(toType).clearTextSecrets(true).prettyPrint(true).build();){
                parserRegistry.serialize(writer, (String)entry.getKey(), configuration);
            }
            return responseBuilder.contentType(toType).entity(out.toString()).build();
        }, this.invocationHelper.getExecutor());
    }

    private CompletionStage<RestResponse> convertToJson(RestRequest request) {
        return this.convert(request, MediaType.APPLICATION_JSON);
    }

    private CompletionStage<RestResponse> convert(RestRequest request) {
        return this.convert(request, MediaTypeUtils.negotiateMediaType(request, MediaType.APPLICATION_JSON, MediaType.APPLICATION_XML, MediaType.APPLICATION_YAML));
    }

    private CompletionStage<RestResponse> streamKeys(RestRequest request) {
        String cacheName = request.variables().get("cacheName");
        String batchParam = request.getParameter("batch");
        String limitParam = request.getParameter("limit");
        int batch = batchParam == null || batchParam.isEmpty() ? 1000 : Integer.parseInt(batchParam);
        int limit = limitParam == null || limitParam.isEmpty() ? -1 : Integer.parseInt(limitParam);
        AdvancedCache<Object, Object> cache = this.invocationHelper.getRestCacheManager().getCache(cacheName, MediaType.TEXT_PLAIN, MediaType.MATCH_ALL, request);
        if (cache == null) {
            return ResourceUtil.notFoundResponseFuture();
        }
        return CompletableFuture.supplyAsync(() -> {
            NettyRestResponse.Builder responseBuilder = new NettyRestResponse.Builder();
            CacheStream stream = cache.keySet().stream();
            if (limit > -1) {
                stream = stream.limit((long)limit);
            }
            responseBuilder.entity(new CacheKeyInputStream(stream, batch));
            responseBuilder.contentType("application/json");
            return responseBuilder.build();
        }, this.invocationHelper.getExecutor());
    }

    private CompletionStage<RestResponse> streamEntries(RestRequest request) {
        String cacheName = request.variables().get("cacheName");
        String limitParam = request.getParameter("limit");
        String metadataParam = request.getParameter("metadata");
        String batchParam = request.getParameter("batch");
        String negotiateMediaType = request.getParameter("content-negotiation");
        int limit = limitParam == null ? -1 : Integer.parseInt(limitParam);
        boolean metadata = Boolean.parseBoolean(metadataParam);
        int batch = batchParam == null ? 1000 : Integer.parseInt(batchParam);
        boolean negotiate = Boolean.parseBoolean(negotiateMediaType);
        AdvancedCache cache = this.invocationHelper.getRestCacheManager().getCache(cacheName, request).getAdvancedCache();
        if (cache == null) {
            return ResourceUtil.notFoundResponseFuture();
        }
        MediaType keyMediaType = this.getMediaType(negotiate, cache, true);
        MediaType valueMediaType = this.getMediaType(negotiate, cache, false);
        AdvancedCache<Object, Object> streamCache = this.invocationHelper.getRestCacheManager().getCache(cacheName, keyMediaType, valueMediaType, request);
        return CompletableFuture.supplyAsync(() -> {
            NettyRestResponse.Builder responseBuilder = new NettyRestResponse.Builder();
            CacheStream stream = streamCache.entrySet().stream();
            if (limit > -1) {
                stream = stream.limit((long)limit);
            }
            responseBuilder.entity(new CacheEntryInputStream(keyMediaType.match(MediaType.APPLICATION_JSON), valueMediaType.match(MediaType.APPLICATION_JSON), stream, batch, metadata));
            responseBuilder.contentType("application/json");
            responseBuilder.header(ResponseHeader.KEY_CONTENT_TYPE_HEADER.getValue(), keyMediaType.toString());
            responseBuilder.header(ResponseHeader.VALUE_CONTENT_TYPE_HEADER.getValue(), valueMediaType.toString());
            return responseBuilder.build();
        }, this.invocationHelper.getExecutor());
    }

    private CompletionStage<RestResponse> cacheListen(RestRequest request) {
        MediaType accept = MediaTypeUtils.negotiateMediaType(request, MediaType.APPLICATION_JSON, MediaType.TEXT_PLAIN);
        String cacheName = request.variables().get("cacheName");
        boolean includeCurrentState = Boolean.parseBoolean(request.getParameter("includeCurrentState"));
        RestCacheManager<Object> restCacheManager = this.invocationHelper.getRestCacheManager();
        if (!restCacheManager.cacheExists(cacheName)) {
            return ResourceUtil.notFoundResponseFuture();
        }
        AdvancedCache<Object, Object> cache = restCacheManager.getCache(cacheName, accept, accept, request);
        BaseCacheListener listener = includeCurrentState ? new StatefulCacheListener((Cache<?, ?>)cache) : new StatelessCacheListener((Cache<?, ?>)cache);
        NettyRestResponse.Builder responseBuilder = new NettyRestResponse.Builder();
        responseBuilder.contentType(MediaType.TEXT_EVENT_STREAM).entity(listener.getEventStream());
        return cache.addListenerAsync((Object)listener).thenApply(v -> responseBuilder.build());
    }

    private MediaType getMediaType(boolean negotiate, AdvancedCache<?, ?> cache, boolean forKey) {
        MediaType storageMediaType = forKey ? cache.getKeyDataConversion().getStorageMediaType() : cache.getValueDataConversion().getStorageMediaType();
        boolean protoStreamEncoding = MediaType.APPLICATION_PROTOSTREAM.equals((Object)storageMediaType);
        if (negotiate) {
            return this.negotiateEntryMediaType(storageMediaType, protoStreamEncoding);
        }
        return protoStreamEncoding ? MediaType.APPLICATION_JSON : MediaType.TEXT_PLAIN;
    }

    private MediaType negotiateEntryMediaType(MediaType storage, boolean protoStreamEncoding) {
        boolean textSupported;
        EncoderRegistry encoderRegistry = this.invocationHelper.getEncoderRegistry();
        boolean encodingDefined = !MediaType.APPLICATION_UNKNOWN.equals((Object)storage);
        boolean jsonSupported = encodingDefined && encoderRegistry.isConversionSupported(storage, MediaType.APPLICATION_JSON);
        boolean bl = textSupported = encodingDefined && encoderRegistry.isConversionSupported(storage, MediaType.TEXT_PLAIN);
        if (protoStreamEncoding) {
            if (jsonSupported) {
                return MediaType.APPLICATION_JSON;
            }
            if (textSupported) {
                return MediaType.TEXT_PLAIN;
            }
        } else {
            if (textSupported) {
                return MediaType.TEXT_PLAIN;
            }
            if (jsonSupported) {
                return MediaType.APPLICATION_JSON;
            }
        }
        if (encodingDefined) {
            return storage.withEncoding("hex");
        }
        return MediaType.APPLICATION_OCTET_STREAM.withEncoding("hex");
    }

    private CompletionStage<RestResponse> removeCache(RestRequest request) {
        String cacheName = request.variables().get("cacheName");
        RestCacheManager<Object> restCacheManager = this.invocationHelper.getRestCacheManager();
        if (!restCacheManager.cacheExists(cacheName)) {
            return ResourceUtil.notFoundResponseFuture();
        }
        return CompletableFuture.supplyAsync(() -> {
            restCacheManager.getCacheManagerAdmin(request).removeCache(cacheName);
            return new NettyRestResponse.Builder().status(HttpResponseStatus.OK).build();
        }, this.invocationHelper.getExecutor());
    }

    private CompletionStage<RestResponse> cacheExists(RestRequest restRequest) {
        NettyRestResponse.Builder responseBuilder = new NettyRestResponse.Builder();
        String cacheName = restRequest.variables().get("cacheName");
        if (!this.invocationHelper.getRestCacheManager().getInstance().getCacheConfigurationNames().contains(cacheName)) {
            responseBuilder.status(HttpResponseStatus.NOT_FOUND);
        } else {
            responseBuilder.status(HttpResponseStatus.NO_CONTENT);
        }
        return CompletableFuture.completedFuture(responseBuilder.build());
    }

    private CompletableFuture<RestResponse> createOrUpdate(RestRequest request) {
        MediaType sourceType;
        EmbeddedCacheManagerAdmin administration;
        NettyRestResponse.Builder responseBuilder = new NettyRestResponse.Builder();
        List<String> template = request.parameters().get("template");
        String cacheName = request.variables().get("cacheName");
        EnumSet<CacheContainerAdmin.AdminFlag> adminFlags = request.getAdminFlags();
        if (request.method() == Method.PUT) {
            if (adminFlags == null) {
                adminFlags = EnumSet.of(CacheContainerAdmin.AdminFlag.UPDATE);
            } else {
                adminFlags.add(CacheContainerAdmin.AdminFlag.UPDATE);
            }
        }
        EmbeddedCacheManagerAdmin initialAdmin = this.invocationHelper.getRestCacheManager().getCacheManagerAdmin(request);
        EmbeddedCacheManagerAdmin embeddedCacheManagerAdmin = administration = adminFlags == null ? initialAdmin : (EmbeddedCacheManagerAdmin)initialAdmin.withFlags(adminFlags);
        if (template != null && !template.isEmpty()) {
            if (request.method() == Method.PUT) {
                return CompletableFuture.completedFuture(responseBuilder.status(HttpResponseStatus.BAD_REQUEST).build());
            }
            String templateName = template.iterator().next();
            return CompletableFuture.supplyAsync(() -> {
                administration.createCache(cacheName, templateName);
                responseBuilder.status(HttpResponseStatus.OK);
                return responseBuilder.build();
            }, this.invocationHelper.getExecutor());
        }
        ContentSource contents = request.contents();
        byte[] bytes = contents.rawContent();
        if (bytes == null || bytes.length == 0) {
            if (request.method() == Method.PUT) {
                return CompletableFuture.completedFuture(responseBuilder.status(HttpResponseStatus.BAD_REQUEST).build());
            }
            return CompletableFuture.supplyAsync(() -> {
                administration.createCache(cacheName, (String)null);
                responseBuilder.status(HttpResponseStatus.OK);
                return responseBuilder.build();
            }, this.invocationHelper.getExecutor());
        }
        MediaType mediaType = sourceType = request.contentType() == null ? MediaType.APPLICATION_JSON : request.contentType();
        if (!(sourceType.match(MediaType.APPLICATION_JSON) || sourceType.match(MediaType.APPLICATION_XML) || sourceType.match(MediaType.APPLICATION_YAML))) {
            responseBuilder.status(HttpResponseStatus.UNSUPPORTED_MEDIA_TYPE);
            return CompletableFuture.completedFuture(responseBuilder.build());
        }
        GlobalConfiguration globalConfiguration = SecurityActions.getCacheManagerConfiguration(this.invocationHelper.getRestCacheManager().getInstance());
        return CompletableFuture.supplyAsync(() -> {
            try {
                ConfigurationBuilder cfgBuilder;
                ConfigurationBuilderHolder holder = this.invocationHelper.getParserRegistry().parse(new String(bytes, StandardCharsets.UTF_8), sourceType);
                ConfigurationBuilder configurationBuilder = cfgBuilder = holder.getCurrentConfigurationBuilder() != null ? holder.getCurrentConfigurationBuilder() : new ConfigurationBuilder();
                if (request.method() == Method.PUT) {
                    administration.getOrCreateCache(cacheName, cfgBuilder.build(globalConfiguration));
                } else {
                    administration.createCache(cacheName, cfgBuilder.build(globalConfiguration));
                }
                responseBuilder.status(HttpResponseStatus.OK);
            }
            catch (Throwable t) {
                responseBuilder.status(HttpResponseStatus.BAD_REQUEST).entity(t.getMessage());
            }
            return responseBuilder.build();
        }, this.invocationHelper.getExecutor());
    }

    private CompletionStage<RestResponse> getCacheStats(RestRequest request) {
        String cacheName = request.variables().get("cacheName");
        AdvancedCache<Object, Object> cache = this.invocationHelper.getRestCacheManager().getCache(cacheName, request);
        return CompletableFuture.supplyAsync(() -> ResourceUtil.asJsonResponse(cache.getAdvancedCache().getStats().toJson()), this.invocationHelper.getExecutor());
    }

    private CompletionStage<RestResponse> getCacheDistribution(RestRequest request) {
        String cacheName = request.variables().get("cacheName");
        RestCacheManager<Object> cache = this.invocationHelper.getRestCacheManager();
        return ((CompletableFuture)CompletableFuture.supplyAsync(() -> cache.cacheDistribution(cacheName, request), this.invocationHelper.getExecutor()).thenCompose(Function.identity())).thenApply(distributions -> ResourceUtil.asJsonResponse(Json.array((Object[])distributions.stream().map(CacheDistributionInfo::toJson).toArray())));
    }

    private CompletionStage<RestResponse> getAllDetails(RestRequest request) {
        String cacheName = request.variables().get("cacheName");
        AdvancedCache<Object, Object> cache = this.invocationHelper.getRestCacheManager().getCache(cacheName, request);
        if (cache == null) {
            return ResourceUtil.notFoundResponseFuture();
        }
        return CompletableFuture.supplyAsync(() -> this.getDetailResponse((Cache<?, ?>)cache), this.invocationHelper.getExecutor());
    }

    private RestResponse getDetailResponse(Cache<?, ?> cache) {
        Configuration configuration = SecurityActions.getCacheConfiguration(cache.getAdvancedCache());
        EmbeddedCacheManager cacheManager = this.invocationHelper.getRestCacheManager().getInstance();
        GlobalConfiguration globalConfiguration = SecurityActions.getCacheManagerConfiguration(cacheManager);
        PersistenceManager persistenceManager = SecurityActions.getPersistenceManager(cacheManager, cache.getName());
        Stats stats = null;
        Boolean rehashInProgress = null;
        Boolean indexingInProgress = null;
        Boolean queryable = null;
        try {
            stats = cache.getAdvancedCache().getStats();
            DistributionManager distributionManager = cache.getAdvancedCache().getDistributionManager();
            rehashInProgress = distributionManager != null && distributionManager.isRehashInProgress();
        }
        catch (SecurityException distributionManager) {
            // empty catch block
        }
        Boolean rebalancingEnabled = null;
        try {
            LocalTopologyManager localTopologyManager = (LocalTopologyManager)SecurityActions.getComponentRegistry(cache.getAdvancedCache()).getComponent(LocalTopologyManager.class);
            if (localTopologyManager != null) {
                rebalancingEnabled = localTopologyManager.isCacheRebalancingEnabled(cache.getName());
            }
        }
        catch (Exception localTopologyManager) {
            // empty catch block
        }
        Integer size = null;
        if (globalConfiguration.metrics().accurateSize()) {
            try {
                size = cache.size();
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        SearchStatistics searchStatistics = Search.getSearchStatistics(cache);
        IndexStatistics indexStatistics = searchStatistics.getIndexStatistics();
        indexingInProgress = indexStatistics.reindexing();
        queryable = this.invocationHelper.getRestCacheManager().isCacheQueryable(cache);
        boolean statistics = configuration.statistics().enabled();
        boolean indexed = configuration.indexing().enabled();
        CacheFullDetail fullDetail = new CacheFullDetail();
        fullDetail.stats = stats;
        StringBuilderWriter sw = new StringBuilderWriter();
        try (ConfigurationWriter w = ConfigurationWriter.to((Writer)sw).withType(MediaType.APPLICATION_JSON).build();){
            this.invocationHelper.getParserRegistry().serialize(w, cache.getName(), configuration);
        }
        fullDetail.configuration = sw.toString();
        fullDetail.size = size;
        fullDetail.rehashInProgress = rehashInProgress;
        fullDetail.indexingInProgress = indexingInProgress;
        fullDetail.persistent = persistenceManager.isEnabled();
        fullDetail.bounded = configuration.memory().whenFull().isEnabled();
        fullDetail.indexed = indexed;
        fullDetail.hasRemoteBackup = configuration.sites().hasBackups();
        fullDetail.secured = configuration.security().authorization().enabled();
        fullDetail.transactional = configuration.transaction().transactionMode().isTransactional();
        fullDetail.statistics = statistics;
        fullDetail.queryable = queryable;
        fullDetail.rebalancingEnabled = rebalancingEnabled;
        fullDetail.keyStorage = cache.getAdvancedCache().getKeyDataConversion().getStorageMediaType();
        fullDetail.valueStorage = cache.getAdvancedCache().getValueDataConversion().getStorageMediaType();
        return ResourceUtil.addEntityAsJson(fullDetail.toJson(), new NettyRestResponse.Builder()).build();
    }

    private CompletionStage<RestResponse> getCacheConfig(RestRequest request) {
        AdvancedCache<Object, Object> cache;
        NettyRestResponse.Builder responseBuilder = new NettyRestResponse.Builder();
        String cacheName = request.variables().get("cacheName");
        MediaType accept = MediaTypeUtils.negotiateMediaType(request, MediaType.APPLICATION_JSON, MediaType.APPLICATION_XML, MediaType.APPLICATION_YAML);
        responseBuilder.contentType(accept);
        if (!this.invocationHelper.getRestCacheManager().getInstance().getCacheConfigurationNames().contains(cacheName)) {
            responseBuilder.status(HttpResponseStatus.NOT_FOUND).build();
        }
        if ((cache = this.invocationHelper.getRestCacheManager().getCache(cacheName, request)) == null) {
            return ResourceUtil.notFoundResponseFuture();
        }
        Configuration cacheConfiguration = SecurityActions.getCacheConfiguration(cache.getAdvancedCache());
        ByteArrayOutputStream entity = new ByteArrayOutputStream();
        try (ConfigurationWriter writer = ConfigurationWriter.to((OutputStream)entity).withType(accept).prettyPrint(false).build();){
            this.parserRegistry.serialize(writer, cacheName, cacheConfiguration);
        }
        catch (Exception e) {
            return CompletableFuture.completedFuture(responseBuilder.status(HttpResponseStatus.INTERNAL_SERVER_ERROR).entity(Util.getRootCause((Throwable)e)).build());
        }
        responseBuilder.entity(entity);
        return CompletableFuture.completedFuture(responseBuilder.status(HttpResponseStatus.OK).build());
    }

    private CompletionStage<RestResponse> getCacheAvailability(RestRequest request) {
        String cacheName = request.variables().get("cacheName");
        if (!this.invocationHelper.getRestCacheManager().getInstance().isRunning(cacheName)) {
            return ResourceUtil.notFoundResponseFuture();
        }
        AdvancedCache cache = this.invocationHelper.getRestCacheManager().getInstance().getCache(cacheName).getAdvancedCache();
        if (cache == null) {
            return ResourceUtil.notFoundResponseFuture();
        }
        AvailabilityMode availability = cache.getAvailability();
        return CompletableFuture.completedFuture(new NettyRestResponse.Builder().entity(availability).contentType(MediaType.TEXT_PLAIN).status(HttpResponseStatus.OK).build());
    }

    private CompletionStage<RestResponse> setCacheAvailability(RestRequest request) {
        String cacheName = request.variables().get("cacheName");
        String availability = request.getParameter("availability");
        if (!this.invocationHelper.getRestCacheManager().getInstance().isRunning(cacheName)) {
            return ResourceUtil.notFoundResponseFuture();
        }
        AdvancedCache cache = this.invocationHelper.getRestCacheManager().getInstance().getCache(cacheName).getAdvancedCache();
        if (cache == null) {
            return ResourceUtil.notFoundResponseFuture();
        }
        try {
            AvailabilityMode availabilityMode = AvailabilityMode.valueOf((String)availability.toUpperCase());
            cache.setAvailability(availabilityMode);
            return CompletableFuture.completedFuture(new NettyRestResponse.Builder().status(HttpResponseStatus.NO_CONTENT).build());
        }
        catch (IllegalArgumentException e) {
            return ResourceUtil.badRequestResponseFuture(String.format("Unknown AvailabilityMode '%s'", availability));
        }
    }

    private CompletionStage<RestResponse> getCacheConfigMutableAttributes(RestRequest request) {
        AdvancedCache<Object, Object> cache;
        NettyRestResponse.Builder responseBuilder = new NettyRestResponse.Builder();
        String cacheName = request.variables().get("cacheName");
        boolean full = Boolean.parseBoolean(request.getParameter("full"));
        responseBuilder.contentType(MediaType.APPLICATION_JSON);
        if (!this.invocationHelper.getRestCacheManager().getInstance().getCacheConfigurationNames().contains(cacheName)) {
            responseBuilder.status(HttpResponseStatus.NOT_FOUND).build();
        }
        if ((cache = this.invocationHelper.getRestCacheManager().getCache(cacheName, request)) == null) {
            return ResourceUtil.notFoundResponseFuture();
        }
        Configuration cacheConfiguration = SecurityActions.getCacheConfiguration(cache.getAdvancedCache());
        LinkedHashMap<String, Attribute> attributes = new LinkedHashMap<String, Attribute>();
        CacheResourceV2.mutableAttributes(cacheConfiguration, attributes, null);
        if (full) {
            Json all = Json.object();
            for (Map.Entry entry : attributes.entrySet()) {
                Attribute attribute = (Attribute)entry.getValue();
                Class type = attribute.getAttributeDefinition().getType();
                Json object = Json.object((Object[])new Object[]{"value", attribute.get(), "type", type.getSimpleName().toLowerCase()});
                if (type.isEnum()) {
                    object.set("universe", Arrays.stream(type.getEnumConstants()).map(Object::toString).collect(Collectors.toList()));
                }
                all.set((String)entry.getKey(), object);
            }
            return ResourceUtil.asJsonResponseFuture(all);
        }
        return ResourceUtil.asJsonResponseFuture(Json.make(attributes.keySet()));
    }

    private static void mutableAttributes(ConfigurationElement<?> element, Map<String, Attribute> attributes, String prefix) {
        prefix = prefix == null ? "" : element.elementName();
        for (Attribute attribute : element.attributes().attributes()) {
            if (attribute.isImmutable()) continue;
            attributes.put(prefix + "." + attribute.getAttributeDefinition().name(), attribute);
        }
        for (ConfigurationElement child : element.children()) {
            CacheResourceV2.mutableAttributes(child, attributes, prefix);
        }
    }

    private CompletionStage<RestResponse> getCacheConfigMutableAttribute(RestRequest request) {
        String attributeName = request.getParameter("attribute-name");
        String cacheName = request.variables().get("cacheName");
        AdvancedCache<Object, Object> cache = this.invocationHelper.getRestCacheManager().getCache(cacheName, request);
        if (cache == null) {
            return ResourceUtil.notFoundResponseFuture();
        }
        Configuration cacheConfiguration = SecurityActions.getCacheConfiguration(cache.getAdvancedCache());
        Attribute attribute = cacheConfiguration.findAttribute(attributeName);
        if (attribute.isImmutable()) {
            return ResourceUtil.responseFuture(HttpResponseStatus.BAD_REQUEST);
        }
        return ResourceUtil.asJsonResponseFuture(Json.make((Object)String.valueOf(attribute.get())));
    }

    private CompletionStage<RestResponse> setCacheConfigMutableAttribute(RestRequest request) {
        NettyRestResponse.Builder responseBuilder = new NettyRestResponse.Builder();
        String attributeName = request.getParameter("attribute-name");
        String attributeValue = request.getParameter("attribute-value");
        String cacheName = request.variables().get("cacheName");
        AdvancedCache<Object, Object> cache = this.invocationHelper.getRestCacheManager().getCache(cacheName, request);
        if (cache == null) {
            return ResourceUtil.notFoundResponseFuture();
        }
        Configuration configuration = new ConfigurationBuilder().read(SecurityActions.getCacheConfiguration(cache.getAdvancedCache())).build();
        Attribute attribute = configuration.findAttribute(attributeName);
        this.invocationHelper.getRestCacheManager().getCacheManagerAdmin(request);
        EmbeddedCacheManagerAdmin administration = (EmbeddedCacheManagerAdmin)this.invocationHelper.getRestCacheManager().getCacheManagerAdmin(request).withFlags(new CacheContainerAdmin.AdminFlag[]{CacheContainerAdmin.AdminFlag.UPDATE});
        return CompletableFuture.supplyAsync(() -> {
            try {
                attribute.fromString(attributeValue);
                administration.getOrCreateCache(cacheName, configuration);
                responseBuilder.status(HttpResponseStatus.OK);
            }
            catch (Throwable t) {
                responseBuilder.status(HttpResponseStatus.BAD_REQUEST).entity(Util.getRootCause((Throwable)t).getMessage());
            }
            return responseBuilder.build();
        }, this.invocationHelper.getExecutor());
    }

    private CompletionStage<RestResponse> getSize(RestRequest request) {
        String cacheName = request.variables().get("cacheName");
        AdvancedCache<Object, Object> cache = this.invocationHelper.getRestCacheManager().getCache(cacheName, request);
        return cache.sizeAsync().thenApply(size -> ResourceUtil.asJsonResponse(Json.make((Object)size)));
    }

    private CompletionStage<RestResponse> getCacheNames(RestRequest request) throws RestResponseException {
        Collection<String> cacheNames = this.invocationHelper.getRestCacheManager().getCacheNames();
        return ResourceUtil.asJsonResponseFuture(Json.make(cacheNames));
    }

    private CompletionStage<RestResponse> setRebalancing(boolean enable, RestRequest request) {
        String cacheName = request.variables().get("cacheName");
        RestCacheManager<Object> restCacheManager = this.invocationHelper.getRestCacheManager();
        if (!restCacheManager.cacheExists(cacheName)) {
            return ResourceUtil.notFoundResponseFuture();
        }
        return CompletableFuture.supplyAsync(() -> {
            NettyRestResponse.Builder builder = new NettyRestResponse.Builder();
            LocalTopologyManager ltm = SecurityActions.getGlobalComponentRegistry(restCacheManager.getInstance()).getLocalTopologyManager();
            try {
                ltm.setCacheRebalancingEnabled(cacheName, enable);
                builder.status(HttpResponseStatus.NO_CONTENT);
            }
            catch (Exception e) {
                builder.status(HttpResponseStatus.INTERNAL_SERVER_ERROR).entity(e.getMessage());
            }
            return builder.build();
        }, this.invocationHelper.getExecutor());
    }

    @Listener(clustered=true)
    public static class StatelessCacheListener
    extends BaseCacheListener {
        public StatelessCacheListener(Cache<?, ?> cache) {
            super(cache);
        }
    }

    @Listener(clustered=true, includeCurrentState=true)
    public static class StatefulCacheListener
    extends BaseCacheListener {
        public StatefulCacheListener(Cache<?, ?> cache) {
            super(cache);
        }
    }

    public static abstract class BaseCacheListener {
        protected final Cache<?, ?> cache;
        protected final EventStream eventStream;

        protected BaseCacheListener(Cache<?, ?> cache) {
            this.cache = cache;
            this.eventStream = new EventStream(null, () -> cache.removeListenerAsync((Object)this));
        }

        public EventStream getEventStream() {
            return this.eventStream;
        }

        @CacheEntryCreated
        @CacheEntryModified
        @CacheEntryRemoved
        @CacheEntryExpired
        public CompletionStage<Void> onCacheEvent(CacheEntryEvent<?, ?> event) {
            ServerSentEvent sse = new ServerSentEvent(event.getType().name().toLowerCase().replace('_', '-'), new String((byte[])event.getKey()));
            return this.eventStream.sendEvent(sse);
        }
    }

    private static class CacheFullDetail
    implements JsonSerialization {
        public Stats stats;
        public Integer size;
        public String configuration;
        public Boolean rehashInProgress;
        public boolean bounded;
        public boolean indexed;
        public boolean persistent;
        public boolean transactional;
        public boolean secured;
        public boolean hasRemoteBackup;
        public Boolean indexingInProgress;
        public boolean statistics;
        public Boolean queryable;
        public Boolean rebalancingEnabled;
        public MediaType keyStorage;
        public MediaType valueStorage;

        private CacheFullDetail() {
        }

        public Json toJson() {
            Json json = Json.object();
            if (this.stats != null) {
                json.set("stats", this.stats.toJson());
            }
            if (this.size != null) {
                json.set("size", (Object)this.size);
            }
            if (this.rehashInProgress != null) {
                json.set("rehash_in_progress", (Object)this.rehashInProgress);
            }
            if (this.indexingInProgress != null) {
                json.set("indexing_in_progress", (Object)this.indexingInProgress);
            }
            if (this.queryable != null) {
                json.set("queryable", (Object)this.queryable);
            }
            if (this.rebalancingEnabled != null) {
                json.set("rebalancing_enabled", (Object)this.rebalancingEnabled);
            }
            return json.set("configuration", Json.factory().raw(this.configuration)).set("bounded", (Object)this.bounded).set("indexed", (Object)this.indexed).set("persistent", (Object)this.persistent).set("transactional", (Object)this.transactional).set("secured", (Object)this.secured).set("has_remote_backup", (Object)this.hasRemoteBackup).set("statistics", (Object)this.statistics).set("key_storage", (Object)this.keyStorage).set("value_storage", (Object)this.valueStorage);
        }
    }
}

