/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.resources;

import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import javax.security.auth.Subject;
import org.hibernate.search.util.common.function.TriFunction;
import org.infinispan.commons.dataconversion.internal.Json;
import org.infinispan.commons.util.Immutables;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.rest.InvocationHelper;
import org.infinispan.rest.NettyRestResponse;
import org.infinispan.rest.distribution.NodeDistributionInfo;
import org.infinispan.rest.framework.Method;
import org.infinispan.rest.framework.ResourceHandler;
import org.infinispan.rest.framework.RestRequest;
import org.infinispan.rest.framework.RestResponse;
import org.infinispan.rest.framework.impl.Invocations;
import org.infinispan.rest.resources.BackupManagerResource;
import org.infinispan.rest.resources.ResourceUtil;
import org.infinispan.rest.resources.SecurityActions;
import org.infinispan.security.AuditContext;
import org.infinispan.security.AuthorizationPermission;
import org.infinispan.security.Security;
import org.infinispan.server.core.BackupManager;
import org.infinispan.util.function.SerializableFunction;
import org.infinispan.util.function.TriConsumer;

public class ClusterResource
implements ResourceHandler {
    private final InvocationHelper invocationHelper;
    private final BackupManager backupManager;

    public ClusterResource(InvocationHelper invocationHelper) {
        this.invocationHelper = invocationHelper;
        this.backupManager = invocationHelper.getServer().getBackupManager();
    }

    @Override
    public Invocations getInvocations() {
        return new Invocations.Builder().invocation().methods(Method.POST).path("/v2/cluster").withAction("stop").permission(AuthorizationPermission.LIFECYCLE).name("CLUSTER STOP").auditContext(AuditContext.SERVER).handleWith(this::stop).invocation().method(Method.GET).path("/v2/cluster").withAction("distribution").permission(AuthorizationPermission.MONITOR).name("CLUSTER DISTRIBUTION").auditContext(AuditContext.SERVER).handleWith(this::distribution).invocation().methods(Method.GET, Method.HEAD).path("/v2/cluster/backups").permission(AuthorizationPermission.ADMIN).name("BACKUP NAMES").auditContext(AuditContext.SERVER).handleWith(this::getAllBackupNames).invocation().methods(Method.DELETE, Method.GET, Method.HEAD, Method.POST).path("/v2/cluster/backups/{backupName}").permission(AuthorizationPermission.ADMIN).name("BACKUP").auditContext(AuditContext.SERVER).handleWith(this::backup).invocation().methods(Method.GET).path("/v2/cluster/restores").permission(AuthorizationPermission.ADMIN).name("RESTORE NAMES").auditContext(AuditContext.SERVER).handleWith(this::getAllRestoreNames).invocation().methods(Method.DELETE, Method.HEAD, Method.POST).path("/v2/cluster/restores/{restoreName}").permission(AuthorizationPermission.ADMIN).name("RESTORE").auditContext(AuditContext.SERVER).handleWith(this::restore).create();
    }

    private CompletionStage<RestResponse> stop(RestRequest restRequest) {
        return CompletableFuture.supplyAsync(() -> {
            List<String> servers = restRequest.parameters().get("server");
            if (servers != null && !servers.isEmpty()) {
                Security.doAs((Subject)restRequest.getSubject(), () -> this.invocationHelper.getServer().serverStop(servers));
            } else {
                Security.doAs((Subject)restRequest.getSubject(), () -> this.invocationHelper.getServer().clusterStop());
            }
            return new NettyRestResponse.Builder().status(HttpResponseStatus.NO_CONTENT).build();
        }, this.invocationHelper.getExecutor());
    }

    private CompletionStage<RestResponse> getAllBackupNames(RestRequest request) {
        BackupManager backupManager = this.invocationHelper.getServer().getBackupManager();
        Set names = (Set)Security.doAs((Subject)request.getSubject(), () -> ((BackupManager)backupManager).getBackupNames());
        return ResourceUtil.asJsonResponseFuture(Json.make((Object)names));
    }

    private CompletionStage<RestResponse> backup(RestRequest request) {
        return BackupManagerResource.handleBackupRequest(request, this.backupManager, (TriConsumer<String, Path, Json>)((TriConsumer)(name, workingDir, json) -> this.backupManager.create(name, workingDir)));
    }

    private CompletionStage<RestResponse> getAllRestoreNames(RestRequest request) {
        BackupManager backupManager = this.invocationHelper.getServer().getBackupManager();
        Set names = (Set)Security.doAs((Subject)request.getSubject(), () -> ((BackupManager)backupManager).getRestoreNames());
        return ResourceUtil.asJsonResponseFuture(Json.make((Object)names));
    }

    private CompletionStage<RestResponse> restore(RestRequest request) {
        return BackupManagerResource.handleRestoreRequest(request, this.backupManager, (TriFunction<String, Path, Json, CompletionStage<Void>>)((TriFunction)(name, path, json) -> this.backupManager.restore(name, path)));
    }

    private CompletionStage<RestResponse> distribution(RestRequest request) {
        return this.clusterDistribution().thenApply(distributions -> ResourceUtil.asJsonResponse(Json.array((Object[])distributions.stream().map(NodeDistributionInfo::toJson).toArray())));
    }

    private CompletionStage<List<NodeDistributionInfo>> clusterDistribution() {
        EmbeddedCacheManager cacheManager = this.invocationHelper.getProtocolServer().getCacheManager();
        List members = cacheManager.getMembers();
        if (members == null) {
            NodeDistributionInfo info2 = NodeDistributionInfo.resolve(cacheManager.getCacheManagerInfo(), SecurityActions.getGlobalComponentRegistry(cacheManager));
            return CompletableFuture.completedFuture(Collections.singletonList(info2));
        }
        ConcurrentHashMap distributions = new ConcurrentHashMap(members.size());
        return SecurityActions.getClusterExecutor(cacheManager).submitConsumer((SerializableFunction & Serializable)ecm -> NodeDistributionInfo.resolve(ecm.getCacheManagerInfo(), SecurityActions.getGlobalComponentRegistry(ecm)), (address, info, t) -> {
            if (t != null) {
                throw CompletableFutures.asCompletionException((Throwable)t);
            }
            distributions.putIfAbsent(address, info);
        }).thenApply(ignore -> {
            Collection collection = distributions.values();
            return Immutables.immutableListWrap((Object[])collection.toArray(new NodeDistributionInfo[0]));
        });
    }
}

