/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.resources;

import io.netty.handler.codec.http.HttpResponseStatus;
import io.reactivex.rxjava3.core.Flowable;
import java.util.Comparator;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.dataconversion.internal.Json;
import org.infinispan.commons.dataconversion.internal.JsonSerialization;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.query.remote.impl.ProtobufMetadataManagerImpl;
import org.infinispan.rest.InvocationHelper;
import org.infinispan.rest.NettyRestResponse;
import org.infinispan.rest.cachemanager.RestCacheManager;
import org.infinispan.rest.framework.ContentSource;
import org.infinispan.rest.framework.Method;
import org.infinispan.rest.framework.ResourceHandler;
import org.infinispan.rest.framework.RestRequest;
import org.infinispan.rest.framework.RestResponse;
import org.infinispan.rest.framework.impl.Invocations;
import org.infinispan.rest.operations.exceptions.NoDataFoundException;
import org.infinispan.rest.operations.exceptions.NoKeyException;
import org.infinispan.rest.resources.BaseCacheResource;
import org.infinispan.rest.resources.ResourceUtil;
import org.infinispan.rest.tracing.RestTelemetryService;
import org.infinispan.security.AuditContext;
import org.infinispan.security.AuthorizationPermission;

public class ProtobufResource
extends BaseCacheResource
implements ResourceHandler {
    public ProtobufResource(InvocationHelper invocationHelper, RestTelemetryService telemetryService) {
        super(invocationHelper, telemetryService);
    }

    @Override
    public Invocations getInvocations() {
        return new Invocations.Builder().invocation().methods(Method.GET).path("/v2/schemas").handleWith(this::getSchemasNames).invocation().methods(Method.GET).path("/v2/schemas").withAction("types").handleWith(this::getTypes).invocation().methods(Method.POST).path("/v2/schemas/{schemaName}").permission(AuthorizationPermission.CREATE).auditContext(AuditContext.SERVER).name("SCHEMA CREATE").handleWith(r -> this.createOrReplace((RestRequest)r, true)).invocation().methods(Method.PUT).path("/v2/schemas/{schemaName}").permission(AuthorizationPermission.CREATE).auditContext(AuditContext.SERVER).name("SCHEMA CREATE").handleWith(r -> this.createOrReplace((RestRequest)r, false)).invocation().methods(Method.GET).path("/v2/schemas/{schemaName}").handleWith(this::getSchema).invocation().method(Method.DELETE).path("/v2/schemas/{schemaName}").permission(AuthorizationPermission.CREATE).auditContext(AuditContext.SERVER).name("SCHEMA DELETE").handleWith(this::deleteSchema).create();
    }

    private CompletionStage<RestResponse> getSchemasNames(RestRequest request) {
        AdvancedCache<Object, Object> cache = this.invocationHelper.getRestCacheManager().getCache("___protobuf_metadata", request);
        boolean pretty = ResourceUtil.isPretty(request);
        return CompletableFuture.supplyAsync(() -> Flowable.fromIterable((Iterable)cache.keySet()).filter(key -> !((String)key).endsWith(".errors")).map(key -> {
            String error = (String)cache.get((Object)(key + ".errors"));
            ProtoSchema protoSchema = new ProtoSchema();
            protoSchema.name = (String)key;
            if (error != null) {
                protoSchema.error = this.createErrorContent(protoSchema.name, error);
            }
            return protoSchema;
        }).sorted(Comparator.comparing(s -> s.name)).collect(Collectors.toList()).map(protoSchemas -> ResourceUtil.asJsonResponse(this.invocationHelper.newResponse(request), Json.make((Object)protoSchemas), pretty)).toCompletionStage(), this.invocationHelper.getExecutor()).thenCompose(Function.identity());
    }

    private CompletionStage<RestResponse> createOrReplace(RestRequest request, boolean create) {
        String schemaName = this.checkMandatorySchemaName(request);
        ContentSource contents = request.contents();
        if (contents == null || contents.size() == 0) {
            throw new NoDataFoundException("Schema data not sent in the request");
        }
        AdvancedCache<Object, Object> cache = this.invocationHelper.getRestCacheManager().getCache("___protobuf_metadata", request);
        NettyRestResponse.Builder builder = this.invocationHelper.newResponse(request);
        CompletionStage putSchema = create ? cache.putIfAbsentAsync((Object)schemaName, (Object)contents.asString()).thenApply(result -> {
            if (result == null) {
                builder.status(HttpResponseStatus.CREATED);
            } else {
                builder.status(HttpResponseStatus.CONFLICT);
            }
            return result;
        }) : cache.putAsync((Object)schemaName, (Object)contents.asString()).thenApply(result -> builder.status(HttpResponseStatus.OK));
        return ((CompletableFuture)((CompletableFuture)putSchema).thenCompose(r -> {
            if (this.isOkOrCreated(builder)) {
                return cache.getAsync((Object)(schemaName + ".errors"));
            }
            return CompletableFutures.completedNull();
        })).thenApply(validationError -> {
            if (this.isOkOrCreated(builder)) {
                ProtoSchema protoSchema = new ProtoSchema();
                protoSchema.name = schemaName;
                if (validationError != null) {
                    protoSchema.error = this.createErrorContent(schemaName, (String)validationError);
                }
                ResourceUtil.addEntityAsJson(protoSchema, builder);
            }
            return builder.build();
        });
    }

    private boolean isOkOrCreated(NettyRestResponse.Builder builder) {
        return builder.getHttpStatus() == HttpResponseStatus.CREATED || builder.getHttpStatus() == HttpResponseStatus.OK;
    }

    private CompletionStage<RestResponse> getSchema(RestRequest request) {
        String schemaName = this.checkMandatorySchemaName(request);
        AdvancedCache<Object, Object> cache = this.invocationHelper.getRestCacheManager().getCache("___protobuf_metadata", request);
        RestCacheManager<Object> restCacheManager = this.invocationHelper.getRestCacheManager();
        return restCacheManager.getPrivilegedInternalEntry(cache, schemaName, true).thenApply(entry -> {
            NettyRestResponse.Builder responseBuilder = this.invocationHelper.newResponse(request);
            if (entry == null) {
                responseBuilder.status(HttpResponseStatus.NOT_FOUND);
            } else {
                responseBuilder.status(HttpResponseStatus.OK);
                responseBuilder.contentType(MediaType.TEXT_PLAIN);
                responseBuilder.entity(entry.getValue());
            }
            return responseBuilder.build();
        });
    }

    private CompletionStage<RestResponse> getTypes(RestRequest request) {
        ProtobufMetadataManagerImpl protobufMetadataManager = (ProtobufMetadataManagerImpl)this.invocationHelper.protobufMetadataManager();
        Set knownTypes = protobufMetadataManager.getKnownTypes();
        Json protobufTypes = Json.array();
        for (String type : knownTypes) {
            protobufTypes.add((Object)type);
        }
        return ResourceUtil.asJsonResponseFuture(this.invocationHelper.newResponse(request), protobufTypes, ResourceUtil.isPretty(request));
    }

    private CompletionStage<RestResponse> deleteSchema(RestRequest request) {
        String schemaName = this.checkMandatorySchemaName(request);
        RestCacheManager<Object> restCacheManager = this.invocationHelper.getRestCacheManager();
        AdvancedCache<Object, Object> protobufCache = restCacheManager.getCache("___protobuf_metadata", request);
        return restCacheManager.getPrivilegedInternalEntry(protobufCache, schemaName, true).thenCompose(entry -> {
            NettyRestResponse.Builder responseBuilder = this.invocationHelper.newResponse(request);
            responseBuilder.status(HttpResponseStatus.NOT_FOUND);
            if (entry instanceof InternalCacheEntry) {
                responseBuilder.status(HttpResponseStatus.NO_CONTENT);
                return restCacheManager.remove("___protobuf_metadata", schemaName, MediaType.MATCH_ALL, request).thenApply(v -> responseBuilder.build());
            }
            return CompletableFuture.completedFuture(responseBuilder.build());
        });
    }

    private ValidationError createErrorContent(String schemaName, String cause) {
        String message = "Schema " + schemaName + " has errors";
        ValidationError validationError = new ValidationError();
        validationError.message = message;
        validationError.cause = cause;
        return validationError;
    }

    private String checkMandatorySchemaName(RestRequest request) {
        String schemaName = request.variables().get("schemaName");
        if (schemaName == null) {
            throw new NoKeyException("schemaName");
        }
        return schemaName.endsWith(".proto") ? schemaName : schemaName + ".proto";
    }

    static class ValidationError
    implements JsonSerialization {
        public String message;
        public String cause;

        ValidationError() {
        }

        public Json toJson() {
            return Json.object().set("message", (Object)this.message).set("cause", (Object)this.cause);
        }
    }

    static class ProtoSchema
    implements JsonSerialization {
        public String name;
        public ValidationError error;

        ProtoSchema() {
        }

        public Json toJson() {
            return Json.object((Object[])new Object[]{"name", this.name}).set("error", this.error == null ? null : this.error.toJson());
        }
    }
}

