/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.configuration;

import io.netty.handler.codec.http.cors.CorsConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.rest.configuration.CorsConfiguration;
import org.infinispan.rest.configuration.CorsRuleConfiguration;
import org.infinispan.rest.configuration.CorsRuleConfigurationBuilder;

public class CorsConfigurationBuilder
implements Builder<CorsConfiguration> {
    private List<CorsRuleConfigurationBuilder> corsRules = new ArrayList<CorsRuleConfigurationBuilder>();
    private List<CorsConfig> extraConfigs = new ArrayList<CorsConfig>();

    public AttributeSet attributes() {
        return AttributeSet.EMPTY;
    }

    public CorsRuleConfigurationBuilder addNewRule() {
        CorsRuleConfigurationBuilder builder = new CorsRuleConfigurationBuilder();
        this.corsRules.add(builder);
        return builder;
    }

    public CorsConfigurationBuilder add(List<CorsConfig> corsConfig) {
        this.extraConfigs = corsConfig;
        return this;
    }

    public CorsConfiguration create() {
        List<CorsRuleConfiguration> cors = this.corsRules.stream().distinct().map(CorsRuleConfigurationBuilder::create).collect(Collectors.toList());
        return new CorsConfiguration(cors, this.extraConfigs);
    }

    public CorsConfigurationBuilder read(CorsConfiguration template) {
        this.corsRules.clear();
        template.corsRules().forEach(r -> this.addNewRule().read((CorsRuleConfiguration)((Object)r)));
        return this;
    }
}

