/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.resources;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.infinispan.AdvancedCache;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.objectfilter.ParsingException;
import org.infinispan.query.remote.impl.RemoteQueryManager;
import org.infinispan.query.remote.json.JsonQueryErrorResult;
import org.infinispan.query.remote.json.JsonQueryRequest;
import org.infinispan.rest.InvocationHelper;
import org.infinispan.rest.NettyRestResponse;
import org.infinispan.rest.framework.ContentSource;
import org.infinispan.rest.framework.Method;
import org.infinispan.rest.framework.RestRequest;
import org.infinispan.rest.framework.RestResponse;
import org.infinispan.rest.resources.SecurityActions;

class CacheResourceQueryAction {
    private final InvocationHelper invocationHelper;

    CacheResourceQueryAction(InvocationHelper invocationHelper) {
        this.invocationHelper = invocationHelper;
    }

    public CompletionStage<RestResponse> search(RestRequest restRequest) {
        NettyRestResponse.Builder responseBuilder = new NettyRestResponse.Builder();
        JsonQueryRequest query = null;
        if (restRequest.method() == Method.GET) {
            query = this.getQueryFromString(restRequest);
        }
        if (restRequest.method() == Method.POST || restRequest.method() == Method.PUT) {
            try {
                query = this.getQueryFromJSON(restRequest);
            }
            catch (IOException e) {
                return CompletableFuture.completedFuture(this.queryError("Invalid search request", e.getMessage()));
            }
        }
        if (query == null || query.getQuery() == null || query.getQuery().isEmpty()) {
            return CompletableFuture.completedFuture(this.queryError("Invalid search request, missing 'query' parameter", null));
        }
        String cacheName = restRequest.variables().get("cacheName");
        boolean isLocal = Boolean.parseBoolean(restRequest.getParameter("local"));
        MediaType keyContentType = restRequest.keyContentType();
        AdvancedCache<Object, Object> cache = this.invocationHelper.getRestCacheManager().getCache(cacheName, keyContentType, MediaType.APPLICATION_JSON, restRequest);
        String queryString = query.getQuery();
        RemoteQueryManager remoteQueryManager = (RemoteQueryManager)SecurityActions.getComponentRegistry(cache).getComponent(RemoteQueryManager.class);
        JsonQueryRequest finalQuery = query;
        return CompletableFuture.supplyAsync(() -> {
            try {
                byte[] queryResultBytes = remoteQueryManager.executeQuery(queryString, Collections.emptyMap(), finalQuery.getStartOffset(), finalQuery.getMaxResults(), cache, MediaType.APPLICATION_JSON, isLocal);
                responseBuilder.entity(queryResultBytes);
                return responseBuilder.build();
            }
            catch (IllegalArgumentException | IllegalStateException | CacheException | ParsingException e) {
                return this.queryError("Error executing search", e.getMessage());
            }
        }, this.invocationHelper.getExecutor());
    }

    private JsonQueryRequest getQueryFromString(RestRequest restRequest) {
        String queryString = this.getParameterValue(restRequest, "query");
        String strOffset = this.getParameterValue(restRequest, "offset");
        String strMaxResults = this.getParameterValue(restRequest, "max_results");
        Integer offset = strOffset != null ? Integer.valueOf(strOffset) : null;
        Integer maxResults = strMaxResults != null ? Integer.valueOf(strMaxResults) : null;
        return new JsonQueryRequest(queryString, offset, maxResults);
    }

    private JsonQueryRequest getQueryFromJSON(RestRequest restRequest) throws IOException {
        ContentSource contents = restRequest.contents();
        byte[] byteContent = contents.rawContent();
        if (byteContent == null || byteContent.length == 0) {
            throw new IOException();
        }
        return JsonQueryRequest.fromJson((String)new String(byteContent, StandardCharsets.UTF_8));
    }

    private String getParameterValue(RestRequest restRequest, String name) {
        List<String> values = restRequest.parameters().get(name);
        return values == null ? null : values.iterator().next();
    }

    private RestResponse queryError(String message, String cause) {
        NettyRestResponse.Builder builder = new NettyRestResponse.Builder().status(400);
        builder.entity(new JsonQueryErrorResult(message, cause).asBytes());
        return builder.build();
    }
}

