/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.stream;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelHandlerContext;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.TimeUnit;
import org.infinispan.commons.dataconversion.internal.Json;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.versioning.EntryVersion;
import org.infinispan.container.versioning.NumericVersion;
import org.infinispan.container.versioning.SimpleClusteredVersion;
import org.infinispan.metadata.Metadata;
import org.infinispan.rest.stream.CacheChunkedStream;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;

public class CacheEntryStreamProcessor
extends CacheChunkedStream<CacheEntry<?, ?>> {
    private final boolean keysAreJson;
    private final boolean valuesAreJson;
    private static final byte[] KEY_LABEL = "\"key\":".getBytes();
    private static final byte[] VALUE_LABEL = "\"value\":".getBytes();
    private static final byte OPEN_ITEM_CHAR = 123;
    private static final byte SEPARATOR = 44;
    private static final byte CLOSE_ITEM_CHAR = 125;
    private final boolean includeMetadata;

    public CacheEntryStreamProcessor(Publisher<CacheEntry<?, ?>> publisher, boolean keysAreJson, boolean valuesAreJson, boolean includeMetadata) {
        super(publisher);
        this.keysAreJson = keysAreJson;
        this.valuesAreJson = valuesAreJson;
        this.includeMetadata = includeMetadata;
    }

    @Override
    public void subscribe(ChannelHandlerContext ctx) {
        this.publisher.subscribe((Subscriber)new EntrySubscriber(ctx, ctx.alloc()));
    }

    private byte[] escape(Object content, boolean json) {
        byte[] asUTF = CacheEntryStreamProcessor.readContentAsBytes(content);
        if (json) {
            return asUTF;
        }
        return Json.help.escape((String)new String(asUTF)).getBytes(StandardCharsets.UTF_8);
    }

    private static byte[] metadataBytes(CacheEntry<?, ?> currentEntry) {
        long maxIdleInSeconds;
        if (!(currentEntry instanceof InternalCacheEntry)) {
            return null;
        }
        InternalCacheEntry ice = (InternalCacheEntry)currentEntry;
        long lifespanInSeconds = ice.getLifespan();
        if (lifespanInSeconds > -1L) {
            lifespanInSeconds = TimeUnit.MILLISECONDS.toSeconds(lifespanInSeconds);
        }
        if ((maxIdleInSeconds = ice.getMaxIdle()) > -1L) {
            maxIdleInSeconds = TimeUnit.MILLISECONDS.toSeconds(maxIdleInSeconds);
        }
        long created = ice.getCreated();
        long lastUsed = ice.getLastUsed();
        long expiryTime = ice.getExpiryTime();
        Metadata metadata = currentEntry.getMetadata();
        EntryVersion version = metadata == null ? null : metadata.version();
        return CacheEntryStreamProcessor.metadataBytes(lifespanInSeconds, maxIdleInSeconds, created, lastUsed, expiryTime, version);
    }

    private static byte[] metadataBytes(long timeToLiveSeconds, long maxIdleTimeSeconds, long created, long lastUsed, long expireTime, EntryVersion entryVersion) {
        Long version = null;
        Integer topologyId = null;
        if (entryVersion instanceof NumericVersion) {
            version = ((NumericVersion)entryVersion).getVersion();
        } else if (entryVersion instanceof SimpleClusteredVersion) {
            version = ((SimpleClusteredVersion)entryVersion).getVersion();
            topologyId = ((SimpleClusteredVersion)entryVersion).getTopologyId();
        }
        StringBuilder metadata = new StringBuilder();
        metadata.append("\"timeToLiveSeconds\":");
        metadata.append(timeToLiveSeconds);
        metadata.append(",\"maxIdleTimeSeconds\":");
        metadata.append(maxIdleTimeSeconds);
        metadata.append(",\"created\":");
        metadata.append(created);
        metadata.append(",\"lastUsed\":");
        metadata.append(lastUsed);
        metadata.append(",\"expireTime\":");
        metadata.append(expireTime);
        if (version != null) {
            metadata.append(",\"version\":");
            metadata.append(version);
        }
        if (topologyId != null) {
            metadata.append(",\"topologyId\":");
            metadata.append(topologyId);
        }
        return metadata.toString().getBytes();
    }

    class EntrySubscriber
    extends CacheChunkedStream.ByteBufSubscriber<CacheEntry<?, ?>> {
        protected EntrySubscriber(ChannelHandlerContext ctx, ByteBufAllocator allocator) {
            super(ctx, allocator);
        }

        @Override
        void writeItem(CacheEntry<?, ?> item, ByteBuf pending) {
            byte[] keyBytes = CacheEntryStreamProcessor.this.escape(item.getKey(), CacheEntryStreamProcessor.this.keysAreJson);
            byte[] valueBytes = CacheEntryStreamProcessor.this.escape(item.getValue(), CacheEntryStreamProcessor.this.valuesAreJson);
            byte[] metadataBytes = CacheEntryStreamProcessor.this.includeMetadata ? CacheEntryStreamProcessor.metadataBytes(item) : null;
            int bytesRequired = 1 + KEY_LABEL.length + keyBytes.length + (CacheEntryStreamProcessor.this.keysAreJson ? 0 : 2) + 1 + VALUE_LABEL.length + valueBytes.length + (CacheEntryStreamProcessor.this.valuesAreJson ? 0 : 2) + 1;
            if (metadataBytes != null) {
                bytesRequired += 1 + metadataBytes.length;
            }
            pending.ensureWritable(bytesRequired);
            pending.writeByte(123);
            pending.writeBytes(KEY_LABEL);
            if (!CacheEntryStreamProcessor.this.keysAreJson) {
                pending.writeByte(34);
            }
            pending.writeBytes(keyBytes);
            if (!CacheEntryStreamProcessor.this.keysAreJson) {
                pending.writeByte(34);
            }
            pending.writeByte(44);
            pending.writeBytes(VALUE_LABEL);
            if (!CacheEntryStreamProcessor.this.valuesAreJson) {
                pending.writeByte(34);
            }
            pending.writeBytes(valueBytes);
            if (!CacheEntryStreamProcessor.this.valuesAreJson) {
                pending.writeByte(34);
            }
            if (metadataBytes != null) {
                pending.writeByte(44);
                pending.writeBytes(metadataBytes);
            }
            pending.writeByte(125);
        }
    }
}

