/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.stream;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelHandlerContext;
import java.nio.charset.StandardCharsets;
import org.infinispan.rest.stream.CacheChunkedStream;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;

public class CacheKeyStreamProcessor
extends CacheChunkedStream<byte[]> {
    public CacheKeyStreamProcessor(Publisher<byte[]> publisher) {
        super(publisher);
    }

    @Override
    public void subscribe(ChannelHandlerContext ctx) {
        this.publisher.subscribe((Subscriber)new KeySubscriber(ctx, ctx.alloc()));
    }

    static class KeySubscriber
    extends CacheChunkedStream.ByteBufSubscriber<byte[]> {
        protected KeySubscriber(ChannelHandlerContext ctx, ByteBufAllocator allocator) {
            super(ctx, allocator);
        }

        @Override
        void writeItem(byte[] item, ByteBuf pending) {
            String stringified = new String(item, StandardCharsets.UTF_8);
            byte[] bytesToWrite = stringified.replaceAll("\"", "\\\\\"").getBytes(StandardCharsets.UTF_8);
            pending.ensureWritable(bytesToWrite.length + 2);
            pending.writeByte(34);
            pending.writeBytes(bytesToWrite);
            pending.writeByte(34);
        }
    }
}

