/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest;

import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.util.concurrent.Executor;
import org.infinispan.configuration.parsing.ParserRegistry;
import org.infinispan.counter.impl.manager.EmbeddedCounterManager;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.marshall.core.EncoderRegistry;
import org.infinispan.metrics.impl.MetricsRegistry;
import org.infinispan.query.remote.ProtobufMetadataManager;
import org.infinispan.rest.NettyRestResponse;
import org.infinispan.rest.RequestHeader;
import org.infinispan.rest.RestServer;
import org.infinispan.rest.cachemanager.RestCacheManager;
import org.infinispan.rest.configuration.RestServerConfiguration;
import org.infinispan.rest.framework.RestRequest;
import org.infinispan.rest.operations.exceptions.ServiceUnavailableException;
import org.infinispan.server.core.ServerManagement;

public class InvocationHelper {
    private final ParserRegistry parserRegistry = new ParserRegistry();
    private final RestCacheManager<Object> restCacheManager;
    private final EmbeddedCounterManager counterManager;
    private final RestServerConfiguration configuration;
    private final ServerManagement server;
    private final Executor executor;
    private final RestServer protocolServer;
    private final EncoderRegistry encoderRegistry;
    private final MetricsRegistry metricsRegistry;
    private final ProtobufMetadataManager protobufMetadataManager;

    InvocationHelper(RestServer protocolServer, RestCacheManager<Object> restCacheManager, EmbeddedCounterManager counterManager, RestServerConfiguration configuration, ServerManagement server, Executor executor) {
        this.protocolServer = protocolServer;
        this.restCacheManager = restCacheManager;
        this.counterManager = counterManager;
        this.configuration = configuration;
        this.server = server;
        this.executor = executor;
        GlobalComponentRegistry globalComponentRegistry = GlobalComponentRegistry.of((EmbeddedCacheManager)restCacheManager.getInstance());
        this.encoderRegistry = (EncoderRegistry)globalComponentRegistry.getComponent(EncoderRegistry.class);
        this.metricsRegistry = (MetricsRegistry)globalComponentRegistry.getComponent(MetricsRegistry.class);
        this.protobufMetadataManager = (ProtobufMetadataManager)globalComponentRegistry.getComponent(ProtobufMetadataManager.class);
    }

    public ParserRegistry getParserRegistry() {
        return this.parserRegistry;
    }

    public RestCacheManager<Object> getRestCacheManager() {
        this.checkServerStatus();
        return this.restCacheManager;
    }

    public RestServerConfiguration getConfiguration() {
        return this.configuration;
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public ServerManagement getServer() {
        return this.server;
    }

    public EmbeddedCounterManager getCounterManager() {
        this.checkServerStatus();
        return this.counterManager;
    }

    public String getContext() {
        return this.configuration.contextPath();
    }

    public RestServer getProtocolServer() {
        return this.protocolServer;
    }

    public EncoderRegistry getEncoderRegistry() {
        return this.encoderRegistry;
    }

    public MetricsRegistry getMetricsRegistry() {
        return this.metricsRegistry;
    }

    public ProtobufMetadataManager protobufMetadataManager() {
        return this.protobufMetadataManager;
    }

    private void checkServerStatus() {
        ComponentStatus status = this.server.getStatus();
        switch (status) {
            case STOPPING: 
            case TERMINATED: {
                throw new ServiceUnavailableException("Unable to process REST request when Server is " + String.valueOf(status));
            }
        }
    }

    public NettyRestResponse.Builder newResponse(FullHttpRequest request) {
        return this.newResponse(request.headers().get(RequestHeader.USER_AGENT.getValue()), request.uri());
    }

    public NettyRestResponse.Builder newResponse(RestRequest request) {
        return this.newResponse(request.header(RequestHeader.USER_AGENT.getValue()), request.uri());
    }

    private NettyRestResponse.Builder newResponse(String userAgent, String uri) {
        NettyRestResponse.Builder builder = new NettyRestResponse.Builder();
        if (userAgent != null && userAgent.startsWith("Mozilla")) {
            builder.header("X-Frame-Options", "sameorigin").header("X-XSS-Protection", "1; mode=block").header("X-Content-Type-Options", "nosniff").header("Content-Security-Policy", "default-src 'self' data:; style-src 'self' 'unsafe-inline'; base-uri 'self'; form-action 'self'; frame-ancestors 'self'; plugin-types 'none'; report-uri 'self';");
            if (this.configuration.ssl().enabled() || uri.startsWith("https")) {
                builder.header("Strict-Transport-Security", "max-age=31536000 ; includeSubDomains");
            }
        }
        return builder;
    }

    public NettyRestResponse newResponse(RestRequest request, HttpResponseStatus status) {
        return this.newResponse(request, status, null);
    }

    public NettyRestResponse newResponse(RestRequest request, HttpResponseStatus status, Object entity) {
        return this.newResponse(request).status(status).entity(entity).build();
    }

    public NettyRestResponse noContentResponse(RestRequest request) {
        return this.newResponse(request, HttpResponseStatus.NO_CONTENT);
    }

    public NettyRestResponse notFoundResponse(RestRequest request) {
        return this.newResponse(request, HttpResponseStatus.NOT_FOUND);
    }
}

