package org.infinispan.rest.logging;

import java.util.Locale;
import java.lang.IllegalStateException;
import java.io.Serializable;
import org.infinispan.rest.framework.Invocation;
import org.jboss.logging.DelegatingBasicLogger;
import org.infinispan.commons.CacheConfigurationException;
import java.lang.String;
import org.infinispan.rest.operations.exceptions.ServiceUnavailableException;
import org.jboss.logging.Logger;
import java.lang.RuntimeException;
import java.lang.NullPointerException;
import org.jboss.logging.BasicLogger;
import java.lang.IllegalArgumentException;
import java.lang.UnsupportedOperationException;
import org.infinispan.rest.framework.RegistrationException;
import javax.annotation.processing.Generated;
import org.infinispan.rest.operations.exceptions.NoCacheFoundException;
import org.infinispan.rest.framework.Method;
import java.io.IOException;
import org.infinispan.rest.cachemanager.exceptions.CacheUnavailableException;
import org.infinispan.rest.operations.exceptions.UnacceptableDataFormatException;
import java.lang.Throwable;
import java.lang.Object;
import java.util.Arrays;
import java.util.NoSuchElementException;


import static org.jboss.logging.Logger.Level.ERROR;
import static org.jboss.logging.Logger.Level.INFO;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2024-09-26T06:32:28-0400")
public class Log_$logger extends DelegatingBasicLogger implements Log, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Log_$logger.class.getName();
    public Log_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    protected String unsupportedConfigurationOption$str() {
        return "ISPN012004: Unsupported configuration option";
    }
    @Override
    public final UnsupportedOperationException unsupportedConfigurationOption() {
        final UnsupportedOperationException result = new UnsupportedOperationException(String.format(getLoggingLocale(), unsupportedConfigurationOption$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    @Override
    public final void errorWhileResponding(final Throwable t) {
        super.log.logf(FQCN, ERROR, t, errorWhileResponding$str());
    }
    protected String errorWhileResponding$str() {
        return "ISPN012005: An error occurred while responding to the client";
    }
    @Override
    public final void uncaughtExceptionInThePipeline(final Throwable e) {
        super.log.logf(FQCN, ERROR, e, uncaughtExceptionInThePipeline$str());
    }
    protected String uncaughtExceptionInThePipeline$str() {
        return "ISPN012006: Uncaught exception in the pipeline";
    }
    protected String unsupportedDataFormat$str() {
        return "ISPN012007: Cannot convert to %s";
    }
    @Override
    public final UnacceptableDataFormatException unsupportedDataFormat(final String mediaType) {
        final UnacceptableDataFormatException result = new UnacceptableDataFormatException(String.format(getLoggingLocale(), unsupportedDataFormat$str(), mediaType));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cacheUnavailable$str() {
        return "ISPN012008: Cache with name '%s' is temporarily unavailable.";
    }
    @Override
    public final ServiceUnavailableException cacheUnavailable(final String cacheName) {
        final ServiceUnavailableException result = new ServiceUnavailableException(String.format(getLoggingLocale(), cacheUnavailable$str(), cacheName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String missingRequiredMediaType$str() {
        return "ISPN012009: Cannot obtain cache '%s', without required MediaType";
    }
    @Override
    public final NullPointerException missingRequiredMediaType(final String cacheName) {
        final NullPointerException result = new NullPointerException(String.format(getLoggingLocale(), missingRequiredMediaType$str(), cacheName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cacheNotFound$str() {
        return "ISPN012010: Cache with name '%s' not found amongst the configured caches";
    }
    @Override
    public final NoCacheFoundException cacheNotFound(final String cacheName) {
        final NoCacheFoundException result = new NoCacheFoundException(String.format(getLoggingLocale(), cacheNotFound$str(), cacheName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String requestNotAllowedToInternalCaches$str() {
        return "ISPN012011: Remote requests are not allowed to private caches. Do no send remote requests to cache '%s'";
    }
    @Override
    public final CacheUnavailableException requestNotAllowedToInternalCaches(final String cacheName) {
        final CacheUnavailableException result = new CacheUnavailableException(String.format(getLoggingLocale(), requestNotAllowedToInternalCaches$str(), cacheName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String requestNotAllowedToInternalCachesWithoutAuthz$str() {
        return "ISPN012012: Remote requests are not allowed to internal caches when authorization is disabled. Do no send remote requests to cache '%s'";
    }
    @Override
    public final CacheUnavailableException requestNotAllowedToInternalCachesWithoutAuthz(final String cacheName) {
        final CacheUnavailableException result = new CacheUnavailableException(String.format(getLoggingLocale(), requestNotAllowedToInternalCachesWithoutAuthz$str(), cacheName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String illegalCompressionLevel$str() {
        return "ISPN012014: Illegal compression level '%d'. The value must be >= 0 and <= 9";
    }
    @Override
    public final CacheConfigurationException illegalCompressionLevel(final int compressionLevel) {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), illegalCompressionLevel$str(), compressionLevel));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String duplicateResourceMethod$str() {
        return "ISPN012015: Cannot register invocation '%s': resource already registered for method '%s' at the destination path '/%s'";
    }
    @Override
    public final RegistrationException duplicateResourceMethod(final String invocationName, final Method method, final String existingPath) {
        final RegistrationException result = new RegistrationException(String.format(getLoggingLocale(), duplicateResourceMethod$str(), invocationName, method, existingPath));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void warnInvalidNumber(final String header, final String value) {
        super.log.logf(FQCN, WARN, null, warnInvalidNumber$str(), header, value);
    }
    protected String warnInvalidNumber$str() {
        return "ISPN012016: Header '%s' will be ignored, expecting a number but got '%s'";
    }
    protected String authenticationWithoutAuthenticator$str() {
        return "ISPN012017: Cannot enable authentication without an authenticator";
    }
    @Override
    public final CacheConfigurationException authenticationWithoutAuthenticator() {
        final CacheConfigurationException result = new CacheConfigurationException(String.format(getLoggingLocale(), authenticationWithoutAuthenticator$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidPath$str() {
        return "ISPN012018: Cannot register invocation with path '%s': '*' is only allowed at the end";
    }
    @Override
    public final RegistrationException invalidPath(final String path) {
        final RegistrationException result = new RegistrationException(String.format(getLoggingLocale(), invalidPath$str(), path));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String duplicateResource$str() {
        return "ISPN012019: Cannot register path '%s' for invocation '%s', since it conflicts with resource '%s'";
    }
    @Override
    public final RegistrationException duplicateResource(final String candidate, final Invocation invocation, final String existingPath) {
        final RegistrationException result = new RegistrationException(String.format(getLoggingLocale(), duplicateResource$str(), candidate, invocation, existingPath));
        _copyStackTraceMinusOne(result);
        return result;
    }
    @Override
    public final void asyncMassIndexerStarted() {
        super.log.logf(FQCN, INFO, null, asyncMassIndexerStarted$str());
    }
    protected String asyncMassIndexerStarted$str() {
        return "ISPN012020: MassIndexer started";
    }
    @Override
    public final void asyncMassIndexerSuccess() {
        super.log.logf(FQCN, INFO, null, asyncMassIndexerSuccess$str());
    }
    protected String asyncMassIndexerSuccess$str() {
        return "ISPN012021: MassIndexer completed successfully";
    }
    @Override
    public final void errorExecutingMassIndexer(final Throwable e) {
        super.log.logf(FQCN, ERROR, e, errorExecutingMassIndexer$str());
    }
    protected String errorExecutingMassIndexer$str() {
        return "ISPN012022: Error executing MassIndexer";
    }
    protected String illegalArgument$str() {
        return "ISPN012023: Argument '%s' has illegal value '%s'";
    }
    @Override
    public final IllegalArgumentException illegalArgument(final String name, final Object value) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), illegalArgument$str(), name, value));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String synchronizedEntries$str() {
        return "ISPN012024: Synchronized %d entries";
    }
    @Override
    public final String synchronizedEntries(final long hotrod) {
        return String.format(getLoggingLocale(), synchronizedEntries$str(), hotrod);
    }
    @Override
    public final void invalidOrigin(final String origin, final String prop) {
        super.log.logf(FQCN, WARN, null, invalidOrigin$str(), origin, prop);
    }
    protected String invalidOrigin$str() {
        return "ISPN012025: Ignoring invalid origin '%s' when reading '-D%s'";
    }
    @Override
    public final void warnDeprecatedCall(final String invocation) {
        super.log.logf(FQCN, WARN, null, warnDeprecatedCall$str(), invocation);
    }
    protected String warnDeprecatedCall$str() {
        return "ISPN012026: The REST invocation [%s] has been deprecated. Please consult the upgrade guide";
    }
    protected String authorizationNotEnabled$str() {
        return "ISPN012027: Security authorization is not enabled on this server.";
    }
    @Override
    public final IllegalArgumentException authorizationNotEnabled() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), authorizationNotEnabled$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String principalRoleMapperNotMutable$str() {
        return "ISPN012028: The principal-role mapper is not mutable";
    }
    @Override
    public final String principalRoleMapperNotMutable() {
        return String.format(getLoggingLocale(), principalRoleMapperNotMutable$str());
    }
    protected String rolePermissionMapperNotMutable$str() {
        return "ISPN012029: The role-permission mapper is not mutable";
    }
    @Override
    public final String rolePermissionMapperNotMutable() {
        return String.format(getLoggingLocale(), rolePermissionMapperNotMutable$str());
    }
    protected String heapDumpFailed$str() {
        return "ISPN012030: Heap dump generation failed";
    }
    @Override
    public final RuntimeException heapDumpFailed(final IOException e) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), heapDumpFailed$str()), e);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String missingContent$str() {
        return "ISPN012031: Method requires content";
    }
    @Override
    public final IllegalArgumentException missingContent() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), missingContent$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String wrongMediaType$str() {
        return "ISPN012032: Wrong media type '%s'. Expecting '%s'";
    }
    @Override
    public final IllegalArgumentException wrongMediaType(final String mediaType, final String expected) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), wrongMediaType$str(), mediaType, expected));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cacheCompareWrongContent$str() {
        return "ISPN012033: Wrong content: expecting multipart/form-data with two parts";
    }
    @Override
    public final IllegalArgumentException cacheCompareWrongContent() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), cacheCompareWrongContent$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String wrongMethod$str() {
        return "ISPN012034: Wrong method '%s'";
    }
    @Override
    public final IllegalArgumentException wrongMethod(final String method) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), wrongMethod$str(), method));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String immutableAttribute$str() {
        return "ISPN012035: Attribute '%s' is immutable";
    }
    @Override
    public final IllegalArgumentException immutableAttribute(final String attributeName) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), immutableAttribute$str(), attributeName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String multipleRemoteStores$str() {
        return "ISPN012036: More than one remote store detected, rolling upgrades aren't supported";
    }
    @Override
    public final IllegalStateException multipleRemoteStores() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), multipleRemoteStores$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unknownAction$str() {
        return "ISPN012037: Unknown action '%s'";
    }
    @Override
    public final IllegalArgumentException unknownAction(final String action) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), unknownAction$str(), action));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String notADirectory$str() {
        return "ISPN012038: '%s' must be a directory";
    }
    @Override
    public final IllegalArgumentException notADirectory(final String dir) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), notADirectory$str(), dir));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String restoreFailed$str() {
        return "ISPN012039: Restore failed";
    }
    @Override
    public final IllegalStateException restoreFailed() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), restoreFailed$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String missingArgument$str() {
        return "ISPN012040: Missing required argument '%s'";
    }
    @Override
    public final IllegalArgumentException missingArgument(final String arg) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), missingArgument$str(), arg));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String backupDeleteFailed$str() {
        return "ISPN012041: Backup delete failed";
    }
    @Override
    public final IllegalStateException backupDeleteFailed() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), backupDeleteFailed$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String backupFailed$str() {
        return "ISPN012042: Backup failed";
    }
    @Override
    public final IllegalStateException backupFailed() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), backupFailed$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String invalidContent$str() {
        return "ISPN012043: Invalid request content";
    }
    @Override
    public final IllegalArgumentException invalidContent() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidContent$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String missingArguments$str() {
        return "ISPN012044: Missing at least one argument in '%s'";
    }
    @Override
    public final IllegalArgumentException missingArguments(final String... level) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), missingArguments$str(), Arrays.toString(level)));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cacheNotIndexed$str() {
        return "ISPN012045: Cache '%s' is not indexed";
    }
    @Override
    public final IllegalArgumentException cacheNotIndexed(final String cacheName) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), cacheNotIndexed$str(), cacheName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String statisticsNotEnabled$str() {
        return "ISPN012046: Cache '%s' does not have statistics enabled";
    }
    @Override
    public final IllegalArgumentException statisticsNotEnabled(final String name) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), statisticsNotEnabled$str(), name));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String siteOperationFailed$str() {
        return "ISPN012047: Site operation on '%s' failed: '%s'";
    }
    @Override
    public final IllegalStateException siteOperationFailed(final String site, final String status) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), siteOperationFailed$str(), site, status));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noSuchScript$str() {
        return "ISPN012048: No such script '%s'";
    }
    @Override
    public final NoSuchElementException noSuchScript(final String taskName) {
        final NoSuchElementException result = new NoSuchElementException(String.format(getLoggingLocale(), noSuchScript$str(), taskName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String roleAlreadyExists$str() {
        return "ISPN012049: Role already exists";
    }
    @Override
    public final String roleAlreadyExists() {
        return String.format(getLoggingLocale(), roleAlreadyExists$str());
    }
    protected String predefinedRolesAreNotMutable$str() {
        return "ISPN012050: Predefined roles are not mutable";
    }
    @Override
    public final String predefinedRolesAreNotMutable() {
        return String.format(getLoggingLocale(), predefinedRolesAreNotMutable$str());
    }
}
