/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.rmi.RemoteException;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.infinispan.remoting.MIMECacheEntry;
import org.infinispan.rest.Client$;
import org.infinispan.rest.ManagerInstance$;
import org.infinispan.rest.MyNonSer;
import org.infinispan.rest.MySer;
import org.testng.Assert;
import org.testng.annotations.Test;
import scala.Predef$;
import scala.ScalaObject;
import scala.Seq;
import scala.StringBuilder;
import scala.runtime.BoxedByteArray;
import scala.xml.Elem;
import scala.xml.MetaData;
import scala.xml.NamespaceBinding;
import scala.xml.NodeBuffer;
import scala.xml.Null$;
import scala.xml.Text;
import scala.xml.TopScope$;

@Test
public class IntegrationTest
implements ScalaObject {
    private final String HOST;

    public IntegrationTest() {
        this.HOST = "http://localhost:8888/";
    }

    @Test
    public void insertSerializableObjects() {
        PutMethod put = new PutMethod(new StringBuilder().append((Object)this.HOST()).append((Object)"rest/posteee/something").toString());
        put.setRequestHeader("Content-Type", "application/x-java-serialized-object");
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        new ObjectOutputStream(bout).writeObject(new MySer());
        put.setRequestBody((InputStream)new ByteArrayInputStream(bout.toByteArray()));
        Client$.MODULE$.call((HttpMethodBase)put);
        MySer x = (MySer)ManagerInstance$.MODULE$.getCache("posteee").get("something");
        String string = x.name();
        String string2 = "mic";
        Assert.assertTrue((!(string != null ? !string.equals(string2) : string2 != null) ? 1 : 0) != 0);
    }

    @Test
    public void shouldCopeWithSerializable() {
        Client$.MODULE$.call((HttpMethodBase)new GetMethod(new StringBuilder().append((Object)this.HOST()).append((Object)"rest/wang/wangKey").toString()));
        MySer obj = new MySer();
        obj.name_$eq("mic");
        ManagerInstance$.MODULE$.getCache("wang").put("wangKey", obj);
        ManagerInstance$.MODULE$.getCache("wang").put("wangKey2", "hola");
        ManagerInstance$.MODULE$.getCache("wang").put("wangKey3", new MyNonSer());
        GetMethod get = new GetMethod(new StringBuilder().append((Object)this.HOST()).append((Object)"rest/wang/wangKey").toString());
        get.setRequestHeader("Accept", "application/x-java-serialized-object");
        Client$.MODULE$.call((HttpMethodBase)get);
        Assert.assertEquals((int)200, (int)get.getStatusCode());
        ObjectInputStream in = new ObjectInputStream(get.getResponseBodyAsStream());
        MySer res = (MySer)in.readObject();
        Assert.assertNotNull((Object)res);
        Assert.assertEquals((String)"mic", (String)res.name());
        Assert.assertEquals((String)"application/x-java-serialized-object", (String)get.getResponseHeader("Content-Type").getValue());
        HttpMethodBase getStr = Client$.MODULE$.call((HttpMethodBase)new GetMethod(new StringBuilder().append((Object)this.HOST()).append((Object)"rest/wang/wangKey2").toString()));
        Assert.assertEquals((String)"hola", (String)getStr.getResponseBodyAsString());
        Assert.assertEquals((String)"text/plain", (String)getStr.getResponseHeader("Content-Type").getValue());
        get.setRequestHeader("Accept", "application/json");
        Client$.MODULE$.call((HttpMethodBase)get);
        Assert.assertEquals((String)"{\"name\":\"mic\"}", (String)get.getResponseBodyAsString());
        Assert.assertEquals((String)"application/json", (String)get.getResponseHeader("Content-Type").getValue());
        get.setRequestHeader("Accept", "application/xml");
        Client$.MODULE$.call((HttpMethodBase)get);
        Assert.assertEquals((String)"application/xml", (String)get.getResponseHeader("Content-Type").getValue());
        Assert.assertTrue((get.getResponseBodyAsString().indexOf("<org.infinispan.rest.MySer>") > -1 ? 1 : 0) != 0);
        GetMethod get3 = new GetMethod(new StringBuilder().append((Object)this.HOST()).append((Object)"rest/wang/wangKey3").toString());
        get3.setRequestHeader("Accept", "application/json");
        Client$.MODULE$.call((HttpMethodBase)get3);
        Assert.assertEquals((String)"{\"name\":\"mic\"}", (String)get3.getResponseBodyAsString());
        Assert.assertEquals((String)"application/json", (String)get3.getResponseHeader("Content-Type").getValue());
        get3.setRequestHeader("Accept", "*/*");
        Client$.MODULE$.call((HttpMethodBase)get3);
        Assert.assertEquals((int)406, (int)get3.getStatusCode());
    }

    public void testAsyncAddRemove() {
        PostMethod put = new PostMethod(new StringBuilder().append((Object)this.HOST()).append((Object)"rest/posteee/async").toString());
        put.setRequestHeader("Content-Type", "application/text");
        put.setRequestHeader("performAsync", "true");
        put.setRequestBody("data");
        Client$.MODULE$.call((HttpMethodBase)put);
        Thread.sleep(50L);
        Assert.assertEquals((int)200, (int)Client$.MODULE$.call((HttpMethodBase)new HeadMethod(new StringBuilder().append((Object)this.HOST()).append((Object)"rest/posteee/async").toString())).getStatusCode());
        DeleteMethod del = new DeleteMethod(new StringBuilder().append((Object)this.HOST()).append((Object)"rest/posteee/async").toString());
        del.setRequestHeader("performAsync", "true");
        Client$.MODULE$.call((HttpMethodBase)del);
        Thread.sleep(50L);
        Assert.assertEquals((int)404, (int)Client$.MODULE$.call((HttpMethodBase)new HeadMethod(new StringBuilder().append((Object)this.HOST()).append((Object)"rest/posteee/async").toString())).getStatusCode());
    }

    public void testWipeCacheBucket() {
        PostMethod put = new PostMethod(new StringBuilder().append((Object)this.HOST()).append((Object)"rest/posteee/toremove").toString());
        put.setRequestHeader("Content-Type", "application/text");
        put.setRequestBody("data");
        Client$.MODULE$.call((HttpMethodBase)put);
        PostMethod put_ = new PostMethod(new StringBuilder().append((Object)this.HOST()).append((Object)"rest/posteee/toremove2").toString());
        put_.setRequestHeader("Content-Type", "application/text");
        put_.setRequestBody("data");
        Client$.MODULE$.call((HttpMethodBase)put_);
        Assert.assertEquals((int)200, (int)Client$.MODULE$.call((HttpMethodBase)new HeadMethod(new StringBuilder().append((Object)this.HOST()).append((Object)"rest/posteee/toremove").toString())).getStatusCode());
        Client$.MODULE$.call((HttpMethodBase)new DeleteMethod(new StringBuilder().append((Object)this.HOST()).append((Object)"rest/posteee").toString()));
        Assert.assertEquals((int)404, (int)Client$.MODULE$.call((HttpMethodBase)new HeadMethod(new StringBuilder().append((Object)this.HOST()).append((Object)"rest/posteee/toremove").toString())).getStatusCode());
    }

    public void testRemoveEntry() {
        PostMethod put = new PostMethod(new StringBuilder().append((Object)this.HOST()).append((Object)"rest/posteee/toremove").toString());
        put.setRequestHeader("Content-Type", "application/text");
        put.setRequestBody("data");
        Client$.MODULE$.call((HttpMethodBase)put);
        Assert.assertEquals((int)200, (int)Client$.MODULE$.call((HttpMethodBase)new HeadMethod(new StringBuilder().append((Object)this.HOST()).append((Object)"rest/posteee/toremove").toString())).getStatusCode());
        Client$.MODULE$.call((HttpMethodBase)new DeleteMethod(new StringBuilder().append((Object)this.HOST()).append((Object)"rest/posteee/toremove").toString()));
        Assert.assertEquals((int)404, (int)Client$.MODULE$.call((HttpMethodBase)new HeadMethod(new StringBuilder().append((Object)this.HOST()).append((Object)"rest/posteee/toremove").toString())).getStatusCode());
    }

    public void testPutDataWithTimeToLive() {
        PostMethod post = new PostMethod(new StringBuilder().append((Object)this.HOST()).append((Object)"rest/putttl/data").toString());
        post.setRequestHeader("Content-Type", "application/text");
        post.setRequestHeader("timeToLiveSeconds", "2");
        post.setRequestHeader("maxIdleTimeSeconds", "3");
        post.setRequestBody("data");
        Client$.MODULE$.call((HttpMethodBase)post);
        HttpMethodBase get = Client$.MODULE$.call((HttpMethodBase)new GetMethod(new StringBuilder().append((Object)this.HOST()).append((Object)"rest/putttl/data").toString()));
        Assert.assertEquals((String)"data", (String)get.getResponseBodyAsString());
        Thread.sleep(3000L);
        Client$.MODULE$.call(get);
        Assert.assertEquals((int)404, (int)get.getStatusCode());
    }

    public void testPostDuplicate() {
        PostMethod post = new PostMethod(new StringBuilder().append((Object)this.HOST()).append((Object)"rest/posteee/data").toString());
        post.setRequestHeader("Content-Type", "application/text");
        post.setRequestBody("data");
        Client$.MODULE$.call((HttpMethodBase)post);
        Assert.assertEquals((int)409, (int)Client$.MODULE$.call((HttpMethodBase)post).getStatusCode());
        PutMethod put = new PutMethod(new StringBuilder().append((Object)this.HOST()).append((Object)"rest/posteee/data").toString());
        put.setRequestHeader("Content-Type", "application/text");
        put.setRequestBody("data");
        Assert.assertEquals((int)200, (int)Client$.MODULE$.call((HttpMethodBase)put).getStatusCode());
    }

    public void testHead() {
        PostMethod post = new PostMethod(new StringBuilder().append((Object)this.HOST()).append((Object)"rest/more/data").toString());
        post.setRequestHeader("Content-Type", "application/text");
        post.setRequestBody("data");
        Client$.MODULE$.call((HttpMethodBase)post);
        HttpMethodBase get = Client$.MODULE$.call((HttpMethodBase)new HeadMethod(new StringBuilder().append((Object)this.HOST()).append((Object)"rest/more/data").toString()));
        Assert.assertEquals((int)200, (int)get.getStatusCode());
        Assert.assertNotNull((Object)get.getResponseHeader("ETag").getValue());
        Assert.assertNotNull((Object)get.getResponseHeader("Last-Modified").getValue());
        Assert.assertEquals((String)"application/text", (String)get.getResponseHeader("Content-Type").getValue());
        Assert.assertNull((Object)get.getResponseBodyAsString());
    }

    public void testGet() {
        PostMethod post = new PostMethod(new StringBuilder().append((Object)this.HOST()).append((Object)"rest/more2/data").toString());
        post.setRequestHeader("Content-Type", "application/text");
        post.setRequestBody("data");
        Client$.MODULE$.call((HttpMethodBase)post);
        HttpMethodBase get = Client$.MODULE$.call((HttpMethodBase)new GetMethod(new StringBuilder().append((Object)this.HOST()).append((Object)"rest/more2/data").toString()));
        Assert.assertEquals((int)200, (int)get.getStatusCode());
        Assert.assertNotNull((Object)get.getResponseHeader("ETag").getValue());
        Assert.assertNotNull((Object)get.getResponseHeader("Last-Modified").getValue());
        Assert.assertEquals((String)"application/text", (String)get.getResponseHeader("Content-Type").getValue());
        Assert.assertEquals((String)"data", (String)get.getResponseBodyAsString());
    }

    public void testEmptyGet() {
        Assert.assertEquals((int)404, (int)Client$.MODULE$.call((HttpMethodBase)new GetMethod(new StringBuilder().append((Object)this.HOST()).append((Object)"rest/emptycache/nodata").toString())).getStatusCode());
    }

    public void testBasicOperation() {
        HttpClient client = new HttpClient();
        PutMethod insert = new PutMethod(new StringBuilder().append((Object)this.HOST()).append((Object)"rest/mycache/mydata").toString());
        TopScope$ topScope$ = Predef$.MODULE$.$scope();
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("ho"));
        Elem initialXML = new Elem(null, "hey", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$, (Seq)$buf);
        insert.setRequestBody((InputStream)new ByteArrayInputStream(initialXML.toString().getBytes()));
        insert.setRequestHeader("Content-Type", "application/octet-stream");
        Client$.MODULE$.call((HttpMethodBase)insert);
        Assert.assertEquals((String)"", (String)insert.getResponseBodyAsString().trim());
        Assert.assertEquals((int)200, (int)insert.getStatusCode());
        GetMethod get = new GetMethod(new StringBuilder().append((Object)this.HOST()).append((Object)"rest/mycache/mydata").toString());
        Client$.MODULE$.call((HttpMethodBase)get);
        byte[] bytes = get.getResponseBody();
        Assert.assertEquals((int)new BoxedByteArray(bytes).size(), (int)new BoxedByteArray(initialXML.toString().getBytes()).size());
        TopScope$ topScope$2 = Predef$.MODULE$.$scope();
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("ho"));
        Assert.assertEquals((String)new Elem(null, "hey", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$2, (Seq)$buf2).toString(), (String)get.getResponseBodyAsString());
        Header hdr = get.getResponseHeader("Content-Type");
        Assert.assertEquals((String)"application/octet-stream", (String)hdr.getValue());
        DeleteMethod remove = new DeleteMethod(new StringBuilder().append((Object)this.HOST()).append((Object)"rest/mycache/mydata").toString());
        Client$.MODULE$.call((HttpMethodBase)remove);
        Client$.MODULE$.call((HttpMethodBase)get);
        Assert.assertEquals((int)404, (int)get.getStatusCode());
        Client$.MODULE$.call((HttpMethodBase)insert);
        Client$.MODULE$.call((HttpMethodBase)get);
        TopScope$ topScope$3 = Predef$.MODULE$.$scope();
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)new Text("ho"));
        Assert.assertEquals((String)new Elem(null, "hey", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$3, (Seq)$buf3).toString(), (String)get.getResponseBodyAsString());
        DeleteMethod removeAll = new DeleteMethod(new StringBuilder().append((Object)this.HOST()).append((Object)"rest/mycache").toString());
        Client$.MODULE$.call((HttpMethodBase)removeAll);
        Client$.MODULE$.call((HttpMethodBase)get);
        Assert.assertEquals((int)404, (int)get.getStatusCode());
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        ObjectOutputStream oo = new ObjectOutputStream(bout);
        oo.writeObject(new MIMECacheEntry("foo", "hey".getBytes()));
        oo.flush();
        byte[] byteData = bout.toByteArray();
        PutMethod insertMore = new PutMethod(new StringBuilder().append((Object)this.HOST()).append((Object)"rest/mycache/mydata").toString());
        insertMore.setRequestBody((InputStream)new ByteArrayInputStream(byteData));
        insertMore.setRequestHeader("Content-Type", "application/octet-stream");
        Client$.MODULE$.call((HttpMethodBase)insertMore);
        GetMethod getMore = new GetMethod(new StringBuilder().append((Object)this.HOST()).append((Object)"rest/mycache/mydata").toString());
        Client$.MODULE$.call((HttpMethodBase)getMore);
        byte[] bytesBack = getMore.getResponseBody();
        Assert.assertEquals((int)byteData.length, (int)bytesBack.length);
        ObjectInputStream oin = new ObjectInputStream(new ByteArrayInputStream(bytesBack));
        MIMECacheEntry ce = (MIMECacheEntry)oin.readObject();
        Assert.assertEquals((String)"foo", (String)ce.contentType);
    }

    public String HOST() {
        return this.HOST;
    }

    public int $tag() throws RemoteException {
        return ScalaObject.class.$tag((ScalaObject)this);
    }
}

