/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Method;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.infinispan.remoting.MIMECacheEntry;
import org.infinispan.rest.Client$;
import org.infinispan.rest.ManagerInstance$;
import org.infinispan.rest.MyNonSer;
import org.infinispan.rest.MySer;
import org.infinispan.test.TestingUtil;
import org.testng.Assert;
import org.testng.annotations.Test;
import scala.Array$;
import scala.Predef$;
import scala.ScalaObject;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ClassManifest;
import scala.reflect.Manifest$;
import scala.reflect.ScalaSignature;
import scala.xml.Elem;
import scala.xml.MetaData;
import scala.xml.NamespaceBinding;
import scala.xml.NodeBuffer;
import scala.xml.Null$;
import scala.xml.Text;
import scala.xml.TopScope$;

@Test(groups={"functional"}, testName="rest.IntegrationTest")
@ScalaSignature(bytes="\u0006\u0001\u0005%b\u0001C\u0001\u0003\t\u0003\u0005\t\u0011A\u0005\u0003\u001f%sG/Z4sCRLwN\u001c+fgRT!a\u0001\u0003\u0002\tI,7\u000f\u001e\u0006\u0003\u000b\u0019\t!\"\u001b8gS:L7\u000f]1o\u0015\u00059\u0011aA8sO\u000e\u00011c\u0001\u0001\u000b%A\u00111\u0002E\u0007\u0002\u0019)\u0011QBD\u0001\u0005Y\u0006twMC\u0001\u0010\u0003\u0011Q\u0017M^1\n\u0005Ea!AB(cU\u0016\u001cG\u000f\u0005\u0002\u0014-5\tACC\u0001\u0016\u0003\u0015\u00198-\u00197b\u0013\t9BCA\u0006TG\u0006d\u0017m\u00142kK\u000e$\b\"B\r\u0001\t\u0003Q\u0012A\u0002\u001fj]&$h\bF\u0001\u001c!\ta\u0002!D\u0001\u0003\u0011\u001dq\u0002A1A\u0005\u0002}\tA\u0001S(T)V\t\u0001\u0005\u0005\u0002\fC%\u0011!\u0005\u0004\u0002\u0007'R\u0014\u0018N\\4\t\r\u0011\u0002\u0001\u0015!\u0003!\u0003\u0015Auj\u0015+!\u0011\u001d1\u0003A1A\u0005\u0002}\t\u0011bY1dQ\u0016t\u0015-\\3\t\r!\u0002\u0001\u0015!\u0003!\u0003)\u0019\u0017m\u00195f\u001d\u0006lW\r\t\u0005\bU\u0001\u0011\r\u0011\"\u0001 \u0003!1W\u000f\u001c7QCRD\u0007B\u0002\u0017\u0001A\u0003%\u0001%A\u0005gk2d\u0007+\u0019;iA!)a\u0006\u0001C\u0001_\u0005\u0011B/Z:u\u0005\u0006\u001c\u0018nY(qKJ\fG/[8o)\t\u00014\u0007\u0005\u0002\u0014c%\u0011!\u0007\u0006\u0002\u0005+:LG\u000fC\u00035[\u0001\u0007Q'A\u0001n!\t1\u0014(D\u00018\u0015\tAD\"A\u0004sK\u001adWm\u0019;\n\u0005i:$AB'fi\"|G\rC\u0003=\u0001\u0011\u0005Q(\u0001\u0007uKN$X)\u001c9us\u001e+G/F\u00011\u0011\u0015y\u0004\u0001\"\u0001A\u0003\u001d!Xm\u001d;HKR$\"\u0001M!\t\u000bQr\u0004\u0019A\u001b\t\u000b\r\u0003A\u0011\u0001#\u0002\u0011Q,7\u000f\u001e%fC\u0012$\"\u0001M#\t\u000bQ\u0012\u0005\u0019A\u001b\t\u000b\u001d\u0003A\u0011\u0001%\u0002'Q,7\u000f^$fi&3WK\\7pI&4\u0017.\u001a3\u0015\u0005AJ\u0005\"\u0002\u001bG\u0001\u0004)\u0004\"B&\u0001\t\u0003a\u0015!\u0005;fgR\u0004vn\u001d;EkBd\u0017nY1uKR\u0011\u0001'\u0014\u0005\u0006i)\u0003\r!\u000e\u0005\u0006\u001f\u0002!\t\u0001U\u0001\u001ai\u0016\u001cH\u000fU;u\t\u0006$\u0018mV5uQRKW.\u001a+p\u0019&4X\r\u0006\u00021#\")AG\u0014a\u0001k!)1\u000b\u0001C\u0001)\u0006QB/Z:u!V$H)\u0019;b/&$\b.T1y\u0013\u0012dWm\u00148msR\u0011\u0001'\u0016\u0005\u0006iI\u0003\r!\u000e\u0005\u0006/\u0002!\t\u0001W\u0001\u001ei\u0016\u001cH\u000fU;u\t\u0006$\u0018mV5uQRKW.\u001a+p\u0019&4Xm\u00148msR\u0011\u0001'\u0017\u0005\u0006iY\u0003\r!\u000e\u0005\u00067\u0002!I\u0001X\u0001\u001aaV$\u0018I\u001c3BgN,'\u000f^#qQ\u0016lWM]1m\t\u0006$\u0018\r\u0006\u00031;z3\u0007\"\u0002\u001b[\u0001\u0004)\u0004\"B0[\u0001\u0004\u0001\u0017!\u0005;j[\u0016$v\u000eT5wKN+7m\u001c8egB\u0011\u0011\r\u001a\b\u0003'\tL!a\u0019\u000b\u0002\rA\u0013X\rZ3g\u0013\t\u0011SM\u0003\u0002d)!)qM\u0017a\u0001A\u0006\u0011R.\u0019=JI2,G+[7f'\u0016\u001cwN\u001c3t\u0011\u0015I\u0007\u0001\"\u0001k\u0003=!Xm\u001d;SK6|g/Z#oiJLHC\u0001\u0019l\u0011\u0015!\u0004\u000e1\u00016\u0011\u0015i\u0007\u0001\"\u0001o\u0003M!Xm\u001d;XSB,7)Y2iK\n+8m[3u)\t\u0001t\u000eC\u00035Y\u0002\u0007Q\u0007C\u0003r\u0001\u0011\u0005!/\u0001\nuKN$\u0018i]=oG\u0006#GMU3n_Z,GC\u0001\u0019t\u0011\u0015!\u0004\u000f1\u00016\u0011\u0015)\b\u0001\"\u0001w\u0003y!Xm\u001d;TQ>,H\u000eZ\"pa\u0016<\u0016\u000e\u001e5TKJL\u0017\r\\5{C\ndW\r\u0006\u00021o\")A\u0007\u001ea\u0001k!)\u0011\u0010\u0001C\u0001u\u0006iB/Z:u\u0013:\u001cXM\u001d;TKJL\u0017\r\\5{C\ndWm\u00142kK\u000e$8\u000f\u0006\u00021w\")A\u0007\u001fa\u0001k!)Q\u0010\u0001C\u0001}\u0006!B/Z:u\u001d>tW\r_5ti\u0016tGoQ1dQ\u0016$\"\u0001M@\t\u000bQb\b\u0019A\u001b\t\u000f\u0005\r\u0001\u0001\"\u0001\u0002\u0006\u0005)B/Z:u'\u0016\u0014\u0018.\u00197ju\u0016$wJ\u00196fGR\u001cHc\u0001\u0019\u0002\b!1A'!\u0001A\u0002UB3\u0002AA\u0006\u00037\ti\"a\t\u0002&A!\u0011QBA\f\u001b\t\tyA\u0003\u0003\u0002\u0012\u0005M\u0011aC1o]>$\u0018\r^5p]NT1!!\u0006\u0007\u0003\u0019!Xm\u001d;oO&!\u0011\u0011DA\b\u0005\u0011!Vm\u001d;\u0002\r\u001d\u0014x.\u001e9tY\t\ty\"\t\u0002\u0002\"\u0005Qa-\u001e8di&|g.\u00197\u0002\u0011Q,7\u000f\u001e(b[\u0016\f#!a\n\u0002)I,7\u000f\u001e\u0018J]R,wM]1uS>tG+Z:u\u0001")
public class IntegrationTest
implements ScalaObject {
    private final String HOST;
    private final String cacheName;
    private final String fullPath = new StringBuilder().append((Object)this.HOST()).append((Object)"rest/").append((Object)this.cacheName()).toString();

    public String HOST() {
        return this.HOST;
    }

    public String cacheName() {
        return this.cacheName;
    }

    public String fullPath() {
        return this.fullPath;
    }

    public void testBasicOperation(Method m) {
        HttpClient client = new HttpClient();
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PutMethod insert = new PutMethod(fullPathKey);
        TopScope$ topScope$ = scala.package$.MODULE$.$scope();
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("ho"));
        Elem initialXML = new Elem(null, "hey", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$, (Seq)$buf);
        insert.setRequestBody((InputStream)new ByteArrayInputStream(initialXML.toString().getBytes()));
        insert.setRequestHeader("Content-Type", "application/octet-stream");
        Client$.MODULE$.call((HttpMethodBase)insert);
        Assert.assertEquals((String)"", (String)insert.getResponseBodyAsString().trim());
        Assert.assertEquals((int)200, (int)insert.getStatusCode());
        GetMethod get = new GetMethod(fullPathKey);
        Client$.MODULE$.call((HttpMethodBase)get);
        byte[] bytes = get.getResponseBody();
        Assert.assertEquals((int)Predef$.MODULE$.byteArrayOps(bytes).size(), (int)Predef$.MODULE$.byteArrayOps(initialXML.toString().getBytes()).size());
        TopScope$ topScope$2 = scala.package$.MODULE$.$scope();
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("ho"));
        Assert.assertEquals((String)new Elem(null, "hey", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$2, (Seq)$buf2).toString(), (String)get.getResponseBodyAsString());
        Header hdr = get.getResponseHeader("Content-Type");
        Assert.assertEquals((String)"application/octet-stream", (String)hdr.getValue());
        DeleteMethod remove = new DeleteMethod(fullPathKey);
        Client$.MODULE$.call((HttpMethodBase)remove);
        Client$.MODULE$.call((HttpMethodBase)get);
        Assert.assertEquals((int)404, (int)get.getStatusCode());
        Client$.MODULE$.call((HttpMethodBase)insert);
        Client$.MODULE$.call((HttpMethodBase)get);
        TopScope$ topScope$3 = scala.package$.MODULE$.$scope();
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)new Text("ho"));
        Assert.assertEquals((String)new Elem(null, "hey", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$3, (Seq)$buf3).toString(), (String)get.getResponseBodyAsString());
        DeleteMethod removeAll = new DeleteMethod(this.fullPath());
        Client$.MODULE$.call((HttpMethodBase)removeAll);
        Client$.MODULE$.call((HttpMethodBase)get);
        Assert.assertEquals((int)404, (int)get.getStatusCode());
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        ObjectOutputStream oo = new ObjectOutputStream(bout);
        oo.writeObject(new MIMECacheEntry("foo", "hey".getBytes()));
        oo.flush();
        byte[] byteData = bout.toByteArray();
        PutMethod insertMore = new PutMethod(fullPathKey);
        insertMore.setRequestBody((InputStream)new ByteArrayInputStream(byteData));
        insertMore.setRequestHeader("Content-Type", "application/octet-stream");
        Client$.MODULE$.call((HttpMethodBase)insertMore);
        GetMethod getMore = new GetMethod(fullPathKey);
        Client$.MODULE$.call((HttpMethodBase)getMore);
        byte[] bytesBack = getMore.getResponseBody();
        Assert.assertEquals((int)byteData.length, (int)bytesBack.length);
        ObjectInputStream oin = new ObjectInputStream(new ByteArrayInputStream(bytesBack));
        MIMECacheEntry ce = (MIMECacheEntry)oin.readObject();
        Assert.assertEquals((String)"foo", (String)ce.contentType);
    }

    public void testEmptyGet() {
        Assert.assertEquals((int)404, (int)Client$.MODULE$.call((HttpMethodBase)new GetMethod(new StringBuilder().append((Object)this.HOST()).append((Object)"rest/").append((Object)this.cacheName()).append((Object)"/nodata").toString())).getStatusCode());
    }

    public void testGet(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PostMethod post = new PostMethod(fullPathKey);
        post.setRequestHeader("Content-Type", "application/text");
        post.setRequestBody("data");
        Client$.MODULE$.call((HttpMethodBase)post);
        HttpMethodBase get = Client$.MODULE$.call((HttpMethodBase)new GetMethod(fullPathKey));
        Assert.assertEquals((int)200, (int)get.getStatusCode());
        Assert.assertNotNull((Object)get.getResponseHeader("ETag").getValue());
        Assert.assertNotNull((Object)get.getResponseHeader("Last-Modified").getValue());
        Assert.assertEquals((String)"application/text", (String)get.getResponseHeader("Content-Type").getValue());
        Assert.assertEquals((String)"data", (String)get.getResponseBodyAsString());
    }

    public void testHead(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PostMethod post = new PostMethod(fullPathKey);
        post.setRequestHeader("Content-Type", "application/text");
        post.setRequestBody("data");
        Client$.MODULE$.call((HttpMethodBase)post);
        HttpMethodBase get = Client$.MODULE$.call((HttpMethodBase)new HeadMethod(fullPathKey));
        Assert.assertEquals((int)200, (int)get.getStatusCode());
        Assert.assertNotNull((Object)get.getResponseHeader("ETag").getValue());
        Assert.assertNotNull((Object)get.getResponseHeader("Last-Modified").getValue());
        Assert.assertEquals((String)"application/text", (String)get.getResponseHeader("Content-Type").getValue());
        Assert.assertNull((Object)get.getResponseBodyAsString());
    }

    public void testGetIfUnmodified(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PostMethod post = new PostMethod(fullPathKey);
        post.setRequestHeader("Content-Type", "application/text");
        post.setRequestBody("data");
        Client$.MODULE$.call((HttpMethodBase)post);
        HttpMethodBase get = Client$.MODULE$.call((HttpMethodBase)new GetMethod(fullPathKey));
        Assert.assertEquals((int)200, (int)get.getStatusCode());
        Assert.assertNotNull((Object)get.getResponseHeader("ETag").getValue());
        String lastMod = get.getResponseHeader("Last-Modified").getValue();
        Assert.assertNotNull((Object)lastMod);
        Assert.assertEquals((String)"application/text", (String)get.getResponseHeader("Content-Type").getValue());
        Assert.assertEquals((String)"data", (String)get.getResponseBodyAsString());
        GetMethod getAgain = new GetMethod(fullPathKey);
        getAgain.addRequestHeader("If-Unmodified-Since", lastMod);
        get = Client$.MODULE$.call((HttpMethodBase)getAgain);
        Assert.assertEquals((int)200, (int)get.getStatusCode());
        Assert.assertNotNull((Object)get.getResponseHeader("ETag").getValue());
        Assert.assertNotNull((Object)get.getResponseHeader("Last-Modified").getValue());
        Assert.assertEquals((String)"application/text", (String)get.getResponseHeader("Content-Type").getValue());
        Assert.assertEquals((String)"data", (String)get.getResponseBodyAsString());
    }

    public void testPostDuplicate(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PostMethod post = new PostMethod(fullPathKey);
        post.setRequestHeader("Content-Type", "application/text");
        post.setRequestBody("data");
        Client$.MODULE$.call((HttpMethodBase)post);
        Assert.assertEquals((int)409, (int)Client$.MODULE$.call((HttpMethodBase)post).getStatusCode());
        PutMethod put = new PutMethod(fullPathKey);
        put.setRequestHeader("Content-Type", "application/text");
        put.setRequestBody("data");
        Assert.assertEquals((int)200, (int)Client$.MODULE$.call((HttpMethodBase)put).getStatusCode());
    }

    public void testPutDataWithTimeToLive(Method m) {
        this.putAndAssertEphemeralData(m, "2", "3");
    }

    public void testPutDataWithMaxIdleOnly(Method m) {
        this.putAndAssertEphemeralData(m, "", "3");
    }

    public void testPutDataWithTimeToLiveOnly(Method m) {
        this.putAndAssertEphemeralData(m, "3", "");
    }

    private void putAndAssertEphemeralData(Method m, String timeToLiveSeconds, String maxIdleTimeSeconds) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PostMethod post = new PostMethod(fullPathKey);
        post.setRequestHeader("Content-Type", "application/text");
        int maxWaitTime = 0;
        if (!timeToLiveSeconds.isEmpty()) {
            maxWaitTime = package$.MODULE$.max(maxWaitTime, Predef$.MODULE$.augmentString(timeToLiveSeconds).toInt());
            post.setRequestHeader("timeToLiveSeconds", timeToLiveSeconds);
        }
        if (!maxIdleTimeSeconds.isEmpty()) {
            maxWaitTime = package$.MODULE$.max(maxWaitTime, Predef$.MODULE$.augmentString(maxIdleTimeSeconds).toInt());
            post.setRequestHeader("maxIdleTimeSeconds", maxIdleTimeSeconds);
        }
        post.setRequestBody("data");
        Client$.MODULE$.call((HttpMethodBase)post);
        HttpMethodBase get = Client$.MODULE$.call((HttpMethodBase)new GetMethod(fullPathKey));
        Assert.assertEquals((String)"data", (String)get.getResponseBodyAsString());
        TestingUtil.sleepThread((long)((maxWaitTime + 1) * 1000));
        Client$.MODULE$.call(get);
        Assert.assertEquals((int)404, (int)get.getStatusCode());
    }

    public void testRemoveEntry(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PostMethod put = new PostMethod(fullPathKey);
        put.setRequestHeader("Content-Type", "application/text");
        put.setRequestBody("data");
        Client$.MODULE$.call((HttpMethodBase)put);
        Assert.assertEquals((int)200, (int)Client$.MODULE$.call((HttpMethodBase)new HeadMethod(fullPathKey)).getStatusCode());
        Client$.MODULE$.call((HttpMethodBase)new DeleteMethod(fullPathKey));
        Assert.assertEquals((int)404, (int)Client$.MODULE$.call((HttpMethodBase)new HeadMethod(fullPathKey)).getStatusCode());
    }

    public void testWipeCacheBucket(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PostMethod put = new PostMethod(fullPathKey);
        put.setRequestHeader("Content-Type", "application/text");
        put.setRequestBody("data");
        Client$.MODULE$.call((HttpMethodBase)put);
        PostMethod put_ = new PostMethod(new StringBuilder().append((Object)fullPathKey).append((Object)"2").toString());
        put_.setRequestHeader("Content-Type", "application/text");
        put_.setRequestBody("data");
        Client$.MODULE$.call((HttpMethodBase)put_);
        Assert.assertEquals((int)200, (int)Client$.MODULE$.call((HttpMethodBase)new HeadMethod(fullPathKey)).getStatusCode());
        Client$.MODULE$.call((HttpMethodBase)new DeleteMethod(this.fullPath()));
        Assert.assertEquals((int)404, (int)Client$.MODULE$.call((HttpMethodBase)new HeadMethod(fullPathKey)).getStatusCode());
    }

    public void testAsyncAddRemove(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PostMethod put = new PostMethod(fullPathKey);
        put.setRequestHeader("Content-Type", "application/text");
        put.setRequestHeader("performAsync", "true");
        put.setRequestBody("data");
        Client$.MODULE$.call((HttpMethodBase)put);
        Thread.sleep(50L);
        Assert.assertEquals((int)200, (int)Client$.MODULE$.call((HttpMethodBase)new HeadMethod(fullPathKey)).getStatusCode());
        DeleteMethod del = new DeleteMethod(fullPathKey);
        del.setRequestHeader("performAsync", "true");
        Client$.MODULE$.call((HttpMethodBase)del);
        Thread.sleep(50L);
        Assert.assertEquals((int)404, (int)Client$.MODULE$.call((HttpMethodBase)new HeadMethod(fullPathKey)).getStatusCode());
    }

    public void testShouldCopeWithSerializable(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        Client$.MODULE$.call((HttpMethodBase)new GetMethod(fullPathKey));
        MySer obj = new MySer();
        obj.name_$eq("mic");
        ManagerInstance$.MODULE$.getCache("___defaultcache").put(m.getName(), obj);
        ManagerInstance$.MODULE$.getCache("___defaultcache").put(new StringBuilder().append((Object)m.getName()).append((Object)"2").toString(), "hola");
        ManagerInstance$.MODULE$.getCache("___defaultcache").put(new StringBuilder().append((Object)m.getName()).append((Object)"3").toString(), new MyNonSer());
        GetMethod get = new GetMethod(fullPathKey);
        get.setRequestHeader("Accept", "application/x-java-serialized-object");
        Client$.MODULE$.call((HttpMethodBase)get);
        Assert.assertEquals((int)200, (int)get.getStatusCode());
        ObjectInputStream in = new ObjectInputStream(get.getResponseBodyAsStream());
        MySer res = (MySer)in.readObject();
        Assert.assertNotNull((Object)res);
        Assert.assertEquals((String)"mic", (String)res.name());
        Assert.assertEquals((String)"application/x-java-serialized-object", (String)get.getResponseHeader("Content-Type").getValue());
        HttpMethodBase getStr = Client$.MODULE$.call((HttpMethodBase)new GetMethod(new StringBuilder().append((Object)fullPathKey).append((Object)"2").toString()));
        Assert.assertEquals((String)"hola", (String)getStr.getResponseBodyAsString());
        Assert.assertEquals((String)"text/plain", (String)getStr.getResponseHeader("Content-Type").getValue());
        get.setRequestHeader("Accept", "application/json");
        Client$.MODULE$.call((HttpMethodBase)get);
        Assert.assertEquals((String)"{\"name\":\"mic\"}", (String)get.getResponseBodyAsString());
        Assert.assertEquals((String)"application/json", (String)get.getResponseHeader("Content-Type").getValue());
        get.setRequestHeader("Accept", "application/xml");
        Client$.MODULE$.call((HttpMethodBase)get);
        Assert.assertEquals((String)"application/xml", (String)get.getResponseHeader("Content-Type").getValue());
        Assert.assertTrue((get.getResponseBodyAsString().indexOf("<org.infinispan.rest.MySer>") > -1 ? 1 : 0) != 0);
        GetMethod get3 = new GetMethod(new StringBuilder().append((Object)fullPathKey).append((Object)"3").toString());
        get3.setRequestHeader("Accept", "application/json");
        Client$.MODULE$.call((HttpMethodBase)get3);
        Assert.assertEquals((String)"{\"name\":\"mic\"}", (String)get3.getResponseBodyAsString());
        Assert.assertEquals((String)"application/json", (String)get3.getResponseHeader("Content-Type").getValue());
    }

    public void testInsertSerializableObjects(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PutMethod put = new PutMethod(fullPathKey);
        put.setRequestHeader("Content-Type", "application/x-java-serialized-object");
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        new ObjectOutputStream(bout).writeObject(new MySer());
        put.setRequestBody((InputStream)new ByteArrayInputStream(bout.toByteArray()));
        Client$.MODULE$.call((HttpMethodBase)put);
        MySer x = (MySer)ManagerInstance$.MODULE$.getCache("___defaultcache").get(m.getName());
        String string = x.name();
        String string2 = "mic";
        Assert.assertTrue((!(string != null ? !string.equals(string2) : string2 != null) ? 1 : 0) != 0);
    }

    public void testNonexistentCache(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.HOST()).append((Object)"rest/nonexistent/").append((Object)m.getName()).toString();
        GetMethod get = new GetMethod(fullPathKey);
        Client$.MODULE$.call((HttpMethodBase)get);
        Assert.assertEquals((int)404, (int)get.getStatusCode());
        HttpMethodBase head = Client$.MODULE$.call((HttpMethodBase)new HeadMethod(fullPathKey));
        Assert.assertEquals((int)404, (int)head.getStatusCode());
        PostMethod put = new PostMethod(fullPathKey);
        put.setRequestHeader("Content-Type", "application/text");
        put.setRequestBody("data");
        Client$.MODULE$.call((HttpMethodBase)put);
        Assert.assertEquals((int)404, (int)put.getStatusCode());
    }

    public void testSerializedObjects(Method m) {
        byte[] serializedOnClient = (byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{101, 102, 103}), (ClassManifest)Manifest$.MODULE$.Byte());
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PutMethod put = new PutMethod(fullPathKey);
        put.setRequestHeader("Content-Type", "application/x-java-serialized-object");
        put.setRequestBody((InputStream)new ByteArrayInputStream(serializedOnClient));
        Client$.MODULE$.call((HttpMethodBase)put);
        Assert.assertEquals((int)200, (int)put.getStatusCode());
        GetMethod get = new GetMethod(fullPathKey);
        get.setRequestHeader("Accept", "application/x-java-serialized-object");
        Client$.MODULE$.call((HttpMethodBase)get);
        Assert.assertEquals((int)200, (int)get.getStatusCode());
        BufferedInputStream dataRead = new BufferedInputStream(get.getResponseBodyAsStream());
        byte[] bytesRead = new byte[3];
        dataRead.read(bytesRead);
        Assert.assertEquals((byte[])serializedOnClient, (byte[])bytesRead);
    }

    public IntegrationTest() {
        this.HOST = "http://localhost:8888/";
        this.cacheName = "___defaultcache";
    }
}

