/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.infinispan.remoting.MIMECacheEntry;
import org.infinispan.rest.Client$;
import org.infinispan.rest.ManagerInstance$;
import org.infinispan.rest.MyNonSer;
import org.infinispan.rest.MySer;
import org.infinispan.rest.ServerInstance$;
import org.infinispan.test.TestingUtil;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import scala.Array$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Some;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.reflect.ClassManifest;
import scala.reflect.Manifest$;
import scala.reflect.ScalaSignature;
import scala.xml.Elem;
import scala.xml.MetaData;
import scala.xml.NamespaceBinding;
import scala.xml.NodeBuffer;
import scala.xml.Null$;
import scala.xml.Text;
import scala.xml.TopScope$;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Test(groups={"functional"}, testName="rest.IntegrationTest")
@ScalaSignature(bytes="\u0006\u0001\tub\u0001C\u0001\u0003\t\u0003\u0005\t\u0011A\u0005\u0003\u001f%sG/Z4sCRLwN\u001c+fgRT!a\u0001\u0003\u0002\tI,7\u000f\u001e\u0006\u0003\u000b\u0019\t!\"\u001b8gS:L7\u000f]1o\u0015\u00059\u0011aA8sO\u000e\u00011c\u0001\u0001\u000b%A\u00111\u0002E\u0007\u0002\u0019)\u0011QBD\u0001\u0005Y\u0006twMC\u0001\u0010\u0003\u0011Q\u0017M^1\n\u0005Ea!AB(cU\u0016\u001cG\u000f\u0005\u0002\u0014-5\tACC\u0001\u0016\u0003\u0015\u00198-\u00197b\u0013\t9BCA\u0006TG\u0006d\u0017m\u00142kK\u000e$\b\"B\r\u0001\t\u0003Q\u0012A\u0002\u001fj]&$h\bF\u0001\u001c!\ta\u0002!D\u0001\u0003\u0011\u001dq\u0002A1A\u0005\u0002}\tA\u0001S(T)V\t\u0001\u0005\u0005\u0002\fC%\u0011!\u0005\u0004\u0002\u0007'R\u0014\u0018N\\4\t\r\u0011\u0002\u0001\u0015!\u0003!\u0003\u0015Auj\u0015+!\u0011\u001d1\u0003A1A\u0005\u0002}\t\u0011bY1dQ\u0016t\u0015-\\3\t\r!\u0002\u0001\u0015!\u0003!\u0003)\u0019\u0017m\u00195f\u001d\u0006lW\r\t\u0005\bU\u0001\u0011\r\u0011\"\u0001 \u0003!1W\u000f\u001c7QCRD\u0007B\u0002\u0017\u0001A\u0003%\u0001%A\u0005gk2d\u0007+\u0019;iA!9a\u0006\u0001b\u0001\n\u0003y\u0012\u0001\u0006#B)\u0016{\u0006+\u0011+U\u000bJsuL\u0015$DcE\u00124\u0007\u0003\u00041\u0001\u0001\u0006I\u0001I\u0001\u0016\t\u0006#Vi\u0018)B)R+%KT0S\r\u000e\u000b\u0014GM\u001a!\u0011\u0015\u0011\u0004\u0001\"\u00014\u0003\u0015\u0019X\r^+q)\u0005!\u0004CA\n6\u0013\t1DC\u0001\u0003V]&$\bFA\u00199!\tId(D\u0001;\u0015\tYD(A\u0006b]:|G/\u0019;j_:\u001c(BA\u001f\u0007\u0003\u0019!Xm\u001d;oO&\u0011qH\u000f\u0002\f\u0005\u00164wN]3DY\u0006\u001c8\u000fC\u0003B\u0001\u0011\u00051'\u0001\u0005uK\u0006\u0014Hi\\<oQ\t\u00015\t\u0005\u0002:\t&\u0011QI\u000f\u0002\u000b\u0003\u001a$XM]\"mCN\u001c\b\"B$\u0001\t\u0003A\u0015A\u0005;fgR\u0014\u0015m]5d\u001fB,'/\u0019;j_:$\"\u0001N%\t\u000b)3\u0005\u0019A&\u0002\u00035\u0004\"\u0001T(\u000e\u00035S!A\u0014\u0007\u0002\u000fI,g\r\\3di&\u0011\u0001+\u0014\u0002\u0007\u001b\u0016$\bn\u001c3\t\u000bI\u0003A\u0011A*\u0002\u0019Q,7\u000f^#naRLx)\u001a;\u0016\u0003QBQ!\u0016\u0001\u0005\u0002Y\u000bq\u0001^3ti\u001e+G\u000f\u0006\u00025/\")!\n\u0016a\u0001\u0017\")\u0011\f\u0001C\u00015\u0006AA/Z:u\u0011\u0016\fG\r\u0006\u000257\")!\n\u0017a\u0001\u0017\")Q\f\u0001C\u0001=\u0006\u0019B/Z:u\u000f\u0016$\u0018JZ+o[>$\u0017NZ5fIR\u0011Ag\u0018\u0005\u0006\u0015r\u0003\ra\u0013\u0005\u0006C\u0002!\tAY\u0001\u0012i\u0016\u001cH\u000fU8ti\u0012+\b\u000f\\5dCR,GC\u0001\u001bd\u0011\u0015Q\u0005\r1\u0001L\u0011\u0015)\u0007\u0001\"\u0001g\u0003e!Xm\u001d;QkR$\u0015\r^1XSRDG+[7f)>d\u0015N^3\u0015\u0005Q:\u0007\"\u0002&e\u0001\u0004Y\u0005\"B5\u0001\t\u0003Q\u0017A\u0007;fgR\u0004V\u000f\u001e#bi\u0006<\u0016\u000e\u001e5NCbLE\r\\3P]2LHC\u0001\u001bl\u0011\u0015Q\u0005\u000e1\u0001L\u0011\u0015i\u0007\u0001\"\u0001o\u0003u!Xm\u001d;QkR$\u0015\r^1XSRDG+[7f)>d\u0015N^3P]2LHC\u0001\u001bp\u0011\u0015QE\u000e1\u0001L\u0011\u0015\t\b\u0001\"\u0003s\u0003e\u0001X\u000f^!oI\u0006\u001b8/\u001a:u\u000bBDW-\\3sC2$\u0015\r^1\u0015\tQ\u001aH\u000f \u0005\u0006\u0015B\u0004\ra\u0013\u0005\u0006kB\u0004\rA^\u0001\u0012i&lW\rV8MSZ,7+Z2p]\u0012\u001c\bCA<{\u001d\t\u0019\u00020\u0003\u0002z)\u00051\u0001K]3eK\u001aL!AI>\u000b\u0005e$\u0002\"B?q\u0001\u00041\u0018AE7bq&#G.\u001a+j[\u0016\u001cVmY8oINDaa \u0001\u0005\u0002\u0005\u0005\u0011\u0001\t;fgR\u0004V\u000f\u001e)sK\u000e|g\u000eZ5uS>tWK\\5na2,W.\u001a8uK\u0012$2\u0001NA\u0002\u0011\u0015Qe\u00101\u0001L\u0011\u0019y\b\u0001\"\u0003\u0002\bQ)A'!\u0003\u0002\f!1!*!\u0002A\u0002-Cq!!\u0004\u0002\u0006\u0001\u0007a/\u0001\rqe\u0016\u001cwN\u001c3ji&|g.\u00197IK\u0006$WM\u001d(b[\u0016Dq!!\u0005\u0001\t\u0003\t\u0019\"\u0001\u0015uKN$H)\u001a7fi\u0016,e\u000e\u001e:z!J,7m\u001c8eSRLwN\\+oS6\u0004H.Z7f]R,G\rF\u00025\u0003+AaASA\b\u0001\u0004Y\u0005bBA\r\u0001\u0011\u0005\u00111D\u0001)i\u0016\u001cH\u000fR3mKR,7)Y2iKB\u0013XmY8oI&$\u0018n\u001c8V]&l\u0007\u000f\\3nK:$X\r\u001a\u000b\u0004i\u0005u\u0001B\u0002&\u0002\u0018\u0001\u00071\nC\u0004\u0002\"\u0001!I!a\t\u0002KQ,7\u000f\u001e#fY\u0016$X\r\u0015:fG>tG-\u001b;j_:\fG.\u00168j[BdW-\\3oi\u0016$Gc\u0001\u001b\u0002&!9\u0011qEA\u0010\u0001\u00041\u0018a\u00034vY2\u0004\u0016\r\u001e5LKfDq!!\t\u0001\t\u0013\tY\u0003F\u00035\u0003[\ty\u0003C\u0004\u0002(\u0005%\u0002\u0019\u0001<\t\u000f\u00055\u0011\u0011\u0006a\u0001m\"9\u00111\u0007\u0001\u0005\n\u0005U\u0012\u0001F1tg\u0016\u0014HOT8u\u00136\u0004H.Z7f]R,G\rF\u00025\u0003oA\u0001\"!\u000f\u00022\u0001\u0007\u00111H\u0001\u0007[\u0016$\bn\u001c3\u0011\t\u0005u\u00121J\u0007\u0003\u0003\u007fQA!!\u0011\u0002D\u0005Q\u0001\u000e\u001e;qG2LWM\u001c;\u000b\t\u0005\u0015\u0013qI\u0001\bG>lWn\u001c8t\u0015\r\tIEB\u0001\u0007CB\f7\r[3\n\t\u00055\u0013q\b\u0002\u000b\u0011R$\b/T3uQ>$\u0007bBA)\u0001\u0011\u0005\u00111K\u0001\u0010i\u0016\u001cHOU3n_Z,WI\u001c;ssR\u0019A'!\u0016\t\r)\u000by\u00051\u0001L\u0011\u001d\tI\u0006\u0001C\u0001\u00037\n1\u0003^3ti^K\u0007/Z\"bG\",')^2lKR$2\u0001NA/\u0011\u0019Q\u0015q\u000ba\u0001\u0017\"9\u0011\u0011\r\u0001\u0005\u0002\u0005\r\u0014A\u0005;fgR\f5/\u001f8d\u0003\u0012$'+Z7pm\u0016$2\u0001NA3\u0011\u0019Q\u0015q\fa\u0001\u0017\"9\u0011\u0011\u000e\u0001\u0005\u0002\u0005-\u0014A\b;fgR\u001c\u0006n\\;mI\u000e{\u0007/Z,ji\"\u001cVM]5bY&T\u0018M\u00197f)\r!\u0014Q\u000e\u0005\u0007\u0015\u0006\u001d\u0004\u0019A&\t\u000f\u0005E\u0004\u0001\"\u0001\u0002t\u0005iB/Z:u\u0013:\u001cXM\u001d;TKJL\u0017\r\\5{C\ndWm\u00142kK\u000e$8\u000fF\u00025\u0003kBaASA8\u0001\u0004Y\u0005bBA=\u0001\u0011\u0005\u00111P\u0001\u0015i\u0016\u001cHOT8oKbL7\u000f^3oi\u000e\u000b7\r[3\u0015\u0007Q\ni\b\u0003\u0004K\u0003o\u0002\ra\u0013\u0005\b\u0003\u0003\u0003A\u0011AAB\u0003\u0001\"Xm\u001d;CsR,\u0017I\u001d:bs\u0006\u001b8+\u001a:jC2L'0\u001a3PE*,7\r^:\u0015\u0007Q\n)\t\u0003\u0004K\u0003\u007f\u0002\ra\u0013\u0005\b\u0003\u0013\u0003A\u0011AAF\u0003\u0005\"Xm\u001d;CsR,\u0017I\u001d:bs\u0006\u001bxj\u0019;fGN#(/Z1n\u001f\nTWm\u0019;t)\r!\u0014Q\u0012\u0005\u0007\u0015\u0006\u001d\u0005\u0019A&\t\u000f\u0005E\u0005\u0001\"\u0003\u0002\u0014\u0006y1/\u001a8e\u0005f$X-\u0011:sCf\f5\u000fF\u00035\u0003+\u000b9\n\u0003\u0004K\u0003\u001f\u0003\ra\u0013\u0005\b\u00033\u000by\t1\u0001w\u0003-\u0019wN\u001c;f]R$\u0016\u0010]3\t\u000f\u0005u\u0005\u0001\"\u0001\u0002 \u0006)B/Z:u\u0013\u001a,f.\\8eS\u001aLW\rZ*j]\u000e,Gc\u0001\u001b\u0002\"\"1!*a'A\u0002-Cq!!*\u0001\t\u0003\t9+A\buKN$X\tV1h\u0007\"\fgnZ3t)\r!\u0014\u0011\u0016\u0005\u0007\u0015\u0006\r\u0006\u0019A&\t\u000f\u00055\u0006\u0001\"\u0001\u00020\u0006aB/Z:u'\u0016\u0014\u0018.\u00197ju\u0016$7\u000b\u001e:j]\u001e<U\r\u001e\"zi\u0016\u001cHc\u0001\u001b\u00022\"1!*a+A\u0002-Cq!!.\u0001\t\u0013\t9,A\u0002qkR$B!!/\u0002@B!\u0011QHA^\u0013\u0011\ti,a\u0010\u0003\u001d!#H\u000f]'fi\"|GMQ1tK\"1!*a-A\u0002-Cq!!.\u0001\t\u0013\t\u0019\r\u0006\u0004\u0002:\u0006\u0015\u0017q\u0019\u0005\u0007\u0015\u0006\u0005\u0007\u0019A&\t\u0011\u0005%\u0017\u0011\u0019a\u0001\u0003\u0017\fA\u0001Z1uCB\u00191#!4\n\u0007\u0005=GCA\u0002B]fDq!!.\u0001\t\u0013\t\u0019\u000e\u0006\u0005\u0002:\u0006U\u0017q[Am\u0011\u0019Q\u0015\u0011\u001ba\u0001\u0017\"A\u0011\u0011ZAi\u0001\u0004\tY\rC\u0004\u0002\u001a\u0006E\u0007\u0019\u0001<\t\u000f\u0005u\u0007\u0001\"\u0003\u0002`\u0006\u0019q-\u001a;\u0015\t\u0005e\u0016\u0011\u001d\u0005\u0007\u0015\u0006m\u0007\u0019A&\t\u000f\u0005u\u0007\u0001\"\u0003\u0002fR1\u0011\u0011XAt\u0003SDaASAr\u0001\u0004Y\u0005\u0002CAv\u0003G\u0004\r!!<\u0002\u0015UtWn\u001c3TS:\u001cW\r\u0005\u0003\u0014\u0003_4\u0018bAAy)\t1q\n\u001d;j_:Dq!!8\u0001\t\u0013\t)\u0010\u0006\u0005\u0002:\u0006]\u0018\u0011`A~\u0011\u0019Q\u00151\u001fa\u0001\u0017\"A\u00111^Az\u0001\u0004\ti\u000f\u0003\u0005\u0002~\u0006M\b\u0019AAw\u0003)\t7mY3qiRK\b/\u001a\u0005\b\u0003;\u0004A\u0011\u0002B\u0001))\tILa\u0001\u0003\u0006\t\u001d!\u0011\u0002\u0005\u0007\u0015\u0006}\b\u0019A&\t\u0011\u0005-\u0018q a\u0001\u0003[D\u0001\"!@\u0002\u0000\u0002\u0007\u0011Q\u001e\u0005\t\u0005\u0017\ty\u00101\u0001\u0003\u000e\u00059Q\r\u001f9D_\u0012,\u0007cA\n\u0003\u0010%\u0019!\u0011\u0003\u000b\u0003\u0007%sG\u000fC\u0004\u0002(\u0001!IA!\u0006\u0015\u0007Y\u00149\u0002\u0003\u0004K\u0005'\u0001\ra\u0013\u0005\b\u00057\u0001A\u0011\u0001B\u000f\u0003\u0019\tG\r\u001a#bsR)aOa\b\u0003$!9!\u0011\u0005B\r\u0001\u00041\u0018!B1ECR,\u0007\u0002\u0003B\u0013\u00053\u0001\rA!\u0004\u0002\t\u0011\f\u0017p\u001d\u0015\f\u0001\t%\"q\u0006B\u0019\u0005o\u0011I\u0004E\u0002:\u0005WI1A!\f;\u0005\u0011!Vm\u001d;\u0002\r\u001d\u0014x.\u001e9tY\t\u0011\u0019$\t\u0002\u00036\u0005Qa-\u001e8di&|g.\u00197\u0002\u0011Q,7\u000f\u001e(b[\u0016\f#Aa\u000f\u0002)I,7\u000f\u001e\u0018J]R,wM]1uS>tG+Z:u\u0001")
public class IntegrationTest
implements ScalaObject {
    private final String HOST;
    private final String cacheName;
    private final String fullPath = new StringBuilder().append((Object)this.HOST()).append((Object)"rest/").append((Object)this.cacheName()).toString();
    private final String DATE_PATTERN_RFC1123;

    public String HOST() {
        return this.HOST;
    }

    public String cacheName() {
        return this.cacheName;
    }

    public String fullPath() {
        return this.fullPath;
    }

    public String DATE_PATTERN_RFC1123() {
        return this.DATE_PATTERN_RFC1123;
    }

    @BeforeClass
    public void setUp() {
        ServerInstance$.MODULE$.start();
    }

    @AfterClass
    public void tearDown() {
        ServerInstance$.MODULE$.stop();
    }

    public void testBasicOperation(Method m) {
        HttpClient client = new HttpClient();
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PutMethod insert = new PutMethod(fullPathKey);
        TopScope$ topScope$ = package$.MODULE$.$scope();
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("ho"));
        Elem initialXML = new Elem(null, "hey", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$, (Seq)$buf);
        insert.setRequestBody((InputStream)new ByteArrayInputStream(initialXML.toString().getBytes()));
        insert.setRequestHeader("Content-Type", "application/octet-stream");
        Client$.MODULE$.call((HttpMethodBase)insert);
        Assert.assertEquals((String)"", (String)insert.getResponseBodyAsString().trim());
        Assert.assertEquals((int)200, (int)insert.getStatusCode());
        GetMethod get = new GetMethod(fullPathKey);
        Client$.MODULE$.call((HttpMethodBase)get);
        byte[] bytes = get.getResponseBody();
        Assert.assertEquals((int)Predef$.MODULE$.byteArrayOps(bytes).size(), (int)Predef$.MODULE$.byteArrayOps(initialXML.toString().getBytes()).size());
        TopScope$ topScope$2 = package$.MODULE$.$scope();
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("ho"));
        Assert.assertEquals((String)new Elem(null, "hey", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$2, (Seq)$buf2).toString(), (String)get.getResponseBodyAsString());
        Header hdr = get.getResponseHeader("Content-Type");
        Assert.assertEquals((String)"application/octet-stream", (String)hdr.getValue());
        DeleteMethod remove = new DeleteMethod(fullPathKey);
        Client$.MODULE$.call((HttpMethodBase)remove);
        Client$.MODULE$.call((HttpMethodBase)get);
        Assert.assertEquals((int)404, (int)get.getStatusCode());
        Client$.MODULE$.call((HttpMethodBase)insert);
        Client$.MODULE$.call((HttpMethodBase)get);
        TopScope$ topScope$3 = package$.MODULE$.$scope();
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)new Text("ho"));
        Assert.assertEquals((String)new Elem(null, "hey", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$3, (Seq)$buf3).toString(), (String)get.getResponseBodyAsString());
        DeleteMethod removeAll = new DeleteMethod(this.fullPath());
        Assert.assertEquals((int)200, (int)Client$.MODULE$.call((HttpMethodBase)removeAll).getStatusCode());
        Client$.MODULE$.call((HttpMethodBase)get);
        Assert.assertEquals((int)404, (int)get.getStatusCode());
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        ObjectOutputStream oo = new ObjectOutputStream(bout);
        oo.writeObject(new MIMECacheEntry("foo", "hey".getBytes()));
        oo.flush();
        byte[] byteData = bout.toByteArray();
        PutMethod insertMore = new PutMethod(fullPathKey);
        insertMore.setRequestBody((InputStream)new ByteArrayInputStream(byteData));
        insertMore.setRequestHeader("Content-Type", "application/octet-stream");
        Client$.MODULE$.call((HttpMethodBase)insertMore);
        GetMethod getMore = new GetMethod(fullPathKey);
        Client$.MODULE$.call((HttpMethodBase)getMore);
        byte[] bytesBack = getMore.getResponseBody();
        Assert.assertEquals((int)byteData.length, (int)bytesBack.length);
        ObjectInputStream oin = new ObjectInputStream(new ByteArrayInputStream(bytesBack));
        MIMECacheEntry ce = (MIMECacheEntry)oin.readObject();
        Assert.assertEquals((String)"foo", (String)ce.contentType);
    }

    public void testEmptyGet() {
        Assert.assertEquals((int)404, (int)Client$.MODULE$.call((HttpMethodBase)new GetMethod(new StringBuilder().append((Object)this.HOST()).append((Object)"rest/").append((Object)this.cacheName()).append((Object)"/nodata").toString())).getStatusCode());
    }

    public void testGet(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PostMethod post = new PostMethod(fullPathKey);
        post.setRequestHeader("Content-Type", "application/text");
        post.setRequestBody("data");
        Client$.MODULE$.call((HttpMethodBase)post);
        HttpMethodBase get = Client$.MODULE$.call((HttpMethodBase)new GetMethod(fullPathKey));
        Assert.assertEquals((int)200, (int)get.getStatusCode());
        Assert.assertNotNull((Object)get.getResponseHeader("ETag").getValue());
        Assert.assertNotNull((Object)get.getResponseHeader("Last-Modified").getValue());
        Assert.assertEquals((String)"application/text", (String)get.getResponseHeader("Content-Type").getValue());
        Assert.assertEquals((String)"data", (String)get.getResponseBodyAsString());
    }

    public void testHead(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PostMethod post = new PostMethod(fullPathKey);
        post.setRequestHeader("Content-Type", "application/text");
        post.setRequestBody("data");
        Client$.MODULE$.call((HttpMethodBase)post);
        HttpMethodBase get = Client$.MODULE$.call((HttpMethodBase)new HeadMethod(fullPathKey));
        Assert.assertEquals((int)200, (int)get.getStatusCode());
        Assert.assertNotNull((Object)get.getResponseHeader("ETag").getValue());
        Assert.assertNotNull((Object)get.getResponseHeader("Last-Modified").getValue());
        Assert.assertEquals((String)"application/text", (String)get.getResponseHeader("Content-Type").getValue());
        Assert.assertNull((Object)get.getResponseBodyAsString());
    }

    public void testGetIfUnmodified(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PostMethod post = new PostMethod(fullPathKey);
        post.setRequestHeader("Content-Type", "application/text");
        post.setRequestBody("data");
        Client$.MODULE$.call((HttpMethodBase)post);
        HttpMethodBase get = Client$.MODULE$.call((HttpMethodBase)new GetMethod(fullPathKey));
        Assert.assertEquals((int)200, (int)get.getStatusCode());
        Assert.assertNotNull((Object)get.getResponseHeader("ETag").getValue());
        String lastMod = get.getResponseHeader("Last-Modified").getValue();
        Assert.assertNotNull((Object)lastMod);
        Assert.assertEquals((String)"application/text", (String)get.getResponseHeader("Content-Type").getValue());
        Assert.assertEquals((String)"data", (String)get.getResponseBodyAsString());
        GetMethod getAgain = new GetMethod(fullPathKey);
        getAgain.addRequestHeader("If-Unmodified-Since", lastMod);
        get = Client$.MODULE$.call((HttpMethodBase)getAgain);
        Assert.assertEquals((int)200, (int)get.getStatusCode());
        Assert.assertNotNull((Object)get.getResponseHeader("ETag").getValue());
        Assert.assertNotNull((Object)get.getResponseHeader("Last-Modified").getValue());
        Assert.assertEquals((String)"application/text", (String)get.getResponseHeader("Content-Type").getValue());
        Assert.assertEquals((String)"data", (String)get.getResponseBodyAsString());
    }

    public void testPostDuplicate(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PostMethod post = new PostMethod(fullPathKey);
        post.setRequestHeader("Content-Type", "application/text");
        post.setRequestBody("data");
        Client$.MODULE$.call((HttpMethodBase)post);
        Assert.assertEquals((int)409, (int)Client$.MODULE$.call((HttpMethodBase)post).getStatusCode());
        PutMethod put = new PutMethod(fullPathKey);
        put.setRequestHeader("Content-Type", "application/text");
        put.setRequestBody("data");
        Assert.assertEquals((int)200, (int)Client$.MODULE$.call((HttpMethodBase)put).getStatusCode());
    }

    public void testPutDataWithTimeToLive(Method m) {
        this.putAndAssertEphemeralData(m, "2", "3");
    }

    public void testPutDataWithMaxIdleOnly(Method m) {
        this.putAndAssertEphemeralData(m, "", "3");
    }

    public void testPutDataWithTimeToLiveOnly(Method m) {
        this.putAndAssertEphemeralData(m, "3", "");
    }

    private void putAndAssertEphemeralData(Method m, String timeToLiveSeconds, String maxIdleTimeSeconds) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PostMethod post = new PostMethod(fullPathKey);
        post.setRequestHeader("Content-Type", "application/text");
        int maxWaitTime = 0;
        if (!timeToLiveSeconds.isEmpty()) {
            maxWaitTime = scala.math.package$.MODULE$.max(maxWaitTime, Predef$.MODULE$.augmentString(timeToLiveSeconds).toInt());
            post.setRequestHeader("timeToLiveSeconds", timeToLiveSeconds);
        }
        if (!maxIdleTimeSeconds.isEmpty()) {
            maxWaitTime = scala.math.package$.MODULE$.max(maxWaitTime, Predef$.MODULE$.augmentString(maxIdleTimeSeconds).toInt());
            post.setRequestHeader("maxIdleTimeSeconds", maxIdleTimeSeconds);
        }
        post.setRequestBody("data");
        Client$.MODULE$.call((HttpMethodBase)post);
        HttpMethodBase get = Client$.MODULE$.call((HttpMethodBase)new GetMethod(fullPathKey));
        Assert.assertEquals((String)"data", (String)get.getResponseBodyAsString());
        TestingUtil.sleepThread((long)((maxWaitTime + 1) * 1000));
        Client$.MODULE$.call(get);
        Assert.assertEquals((int)404, (int)get.getStatusCode());
    }

    public void testPutPreconditionUnimplemented(Method m) {
        this.testPutPreconditionUnimplemented(m, "If-Match");
        this.testPutPreconditionUnimplemented(m, "If-None-Match");
        this.testPutPreconditionUnimplemented(m, "If-Modified-Since");
        this.testPutPreconditionUnimplemented(m, "If-Unmodified-Since");
    }

    private void testPutPreconditionUnimplemented(Method m, String preconditionalHeaderName) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PostMethod post = new PostMethod(fullPathKey);
        post.setRequestHeader("Content-Type", "application/text");
        post.setRequestHeader(preconditionalHeaderName, "*");
        post.setRequestEntity((RequestEntity)new StringRequestEntity("data", "text/plain", "UTF-8"));
        Client$.MODULE$.call((HttpMethodBase)post);
        this.assertNotImplemented((HttpMethod)post);
    }

    public void testDeleteEntryPreconditionUnimplemented(Method m) {
        this.testDeletePreconditionalUnimplemented(new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString());
    }

    public void testDeleteCachePreconditionUnimplemented(Method m) {
        this.testDeletePreconditionalUnimplemented(this.fullPath());
    }

    private void testDeletePreconditionalUnimplemented(String fullPathKey) {
        this.testDeletePreconditionalUnimplemented(fullPathKey, "If-Match");
        this.testDeletePreconditionalUnimplemented(fullPathKey, "If-None-Match");
        this.testDeletePreconditionalUnimplemented(fullPathKey, "If-Modified-Since");
        this.testDeletePreconditionalUnimplemented(fullPathKey, "If-Unmodified-Since");
    }

    private void testDeletePreconditionalUnimplemented(String fullPathKey, String preconditionalHeaderName) {
        DeleteMethod delete = new DeleteMethod(fullPathKey);
        delete.setRequestHeader(preconditionalHeaderName, "*");
        Client$.MODULE$.call((HttpMethodBase)delete);
        this.assertNotImplemented((HttpMethod)delete);
    }

    private void assertNotImplemented(HttpMethod method) {
        Assert.assertEquals((int)method.getStatusCode(), (int)501);
        Assert.assertEquals((String)method.getStatusText(), (String)"Not Implemented");
        Predef$.MODULE$.assert(method.getResponseBodyAsString().toLowerCase().contains("precondition"));
    }

    public void testRemoveEntry(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PostMethod put = new PostMethod(fullPathKey);
        put.setRequestHeader("Content-Type", "application/text");
        put.setRequestBody("data");
        Client$.MODULE$.call((HttpMethodBase)put);
        Assert.assertEquals((int)200, (int)Client$.MODULE$.call((HttpMethodBase)new HeadMethod(fullPathKey)).getStatusCode());
        Client$.MODULE$.call((HttpMethodBase)new DeleteMethod(fullPathKey));
        Assert.assertEquals((int)404, (int)Client$.MODULE$.call((HttpMethodBase)new HeadMethod(fullPathKey)).getStatusCode());
    }

    public void testWipeCacheBucket(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PostMethod put = new PostMethod(fullPathKey);
        put.setRequestHeader("Content-Type", "application/text");
        put.setRequestBody("data");
        Client$.MODULE$.call((HttpMethodBase)put);
        PostMethod put_ = new PostMethod(new StringBuilder().append((Object)fullPathKey).append((Object)"2").toString());
        put_.setRequestHeader("Content-Type", "application/text");
        put_.setRequestBody("data");
        Client$.MODULE$.call((HttpMethodBase)put_);
        Assert.assertEquals((int)200, (int)Client$.MODULE$.call((HttpMethodBase)new HeadMethod(fullPathKey)).getStatusCode());
        Client$.MODULE$.call((HttpMethodBase)new DeleteMethod(this.fullPath()));
        Assert.assertEquals((int)404, (int)Client$.MODULE$.call((HttpMethodBase)new HeadMethod(fullPathKey)).getStatusCode());
    }

    public void testAsyncAddRemove(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PostMethod put = new PostMethod(fullPathKey);
        put.setRequestHeader("Content-Type", "application/text");
        put.setRequestHeader("performAsync", "true");
        put.setRequestBody("data");
        Client$.MODULE$.call((HttpMethodBase)put);
        Thread.sleep(50L);
        Assert.assertEquals((int)200, (int)Client$.MODULE$.call((HttpMethodBase)new HeadMethod(fullPathKey)).getStatusCode());
        DeleteMethod del = new DeleteMethod(fullPathKey);
        del.setRequestHeader("performAsync", "true");
        Client$.MODULE$.call((HttpMethodBase)del);
        Thread.sleep(50L);
        Assert.assertEquals((int)404, (int)Client$.MODULE$.call((HttpMethodBase)new HeadMethod(fullPathKey)).getStatusCode());
    }

    public void testShouldCopeWithSerializable(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        Client$.MODULE$.call((HttpMethodBase)new GetMethod(fullPathKey));
        MySer obj = new MySer();
        obj.name_$eq("mic");
        ManagerInstance$.MODULE$.getCache("___defaultcache").put(m.getName(), obj);
        ManagerInstance$.MODULE$.getCache("___defaultcache").put(new StringBuilder().append((Object)m.getName()).append((Object)"2").toString(), "hola");
        ManagerInstance$.MODULE$.getCache("___defaultcache").put(new StringBuilder().append((Object)m.getName()).append((Object)"3").toString(), new MyNonSer());
        GetMethod get = new GetMethod(fullPathKey);
        get.setRequestHeader("Accept", "application/x-java-serialized-object");
        Client$.MODULE$.call((HttpMethodBase)get);
        Assert.assertEquals((int)200, (int)get.getStatusCode());
        ObjectInputStream in = new ObjectInputStream(get.getResponseBodyAsStream());
        MySer res = (MySer)in.readObject();
        Assert.assertNotNull((Object)res);
        Assert.assertEquals((String)"mic", (String)res.name());
        Assert.assertEquals((String)"application/x-java-serialized-object", (String)get.getResponseHeader("Content-Type").getValue());
        HttpMethodBase getStr = Client$.MODULE$.call((HttpMethodBase)new GetMethod(new StringBuilder().append((Object)fullPathKey).append((Object)"2").toString()));
        Assert.assertEquals((String)"hola", (String)getStr.getResponseBodyAsString());
        Assert.assertEquals((String)"text/plain", (String)getStr.getResponseHeader("Content-Type").getValue());
        get.setRequestHeader("Accept", "application/json");
        Client$.MODULE$.call((HttpMethodBase)get);
        Assert.assertEquals((String)"{\"name\":\"mic\"}", (String)get.getResponseBodyAsString());
        Assert.assertEquals((String)"application/json", (String)get.getResponseHeader("Content-Type").getValue());
        get.setRequestHeader("Accept", "application/xml");
        Client$.MODULE$.call((HttpMethodBase)get);
        Assert.assertEquals((String)"application/xml", (String)get.getResponseHeader("Content-Type").getValue());
        Assert.assertTrue((get.getResponseBodyAsString().indexOf("<org.infinispan.rest.MySer>") > -1 ? 1 : 0) != 0);
        GetMethod get3 = new GetMethod(new StringBuilder().append((Object)fullPathKey).append((Object)"3").toString());
        get3.setRequestHeader("Accept", "application/json");
        Client$.MODULE$.call((HttpMethodBase)get3);
        Assert.assertEquals((String)"{\"name\":\"mic\"}", (String)get3.getResponseBodyAsString());
        Assert.assertEquals((String)"application/json", (String)get3.getResponseHeader("Content-Type").getValue());
    }

    public void testInsertSerializableObjects(Method m) {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        new ObjectOutputStream(bout).writeObject(new MySer());
        this.put(m, bout.toByteArray(), "application/x-java-serialized-object");
        byte[] cfr_ignored_0 = (byte[])ManagerInstance$.MODULE$.getCache("___defaultcache").get(m.getName());
    }

    public void testNonexistentCache(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.HOST()).append((Object)"rest/nonexistent/").append((Object)m.getName()).toString();
        GetMethod get = new GetMethod(fullPathKey);
        Client$.MODULE$.call((HttpMethodBase)get);
        Assert.assertEquals((int)404, (int)get.getStatusCode());
        HttpMethodBase head = Client$.MODULE$.call((HttpMethodBase)new HeadMethod(fullPathKey));
        Assert.assertEquals((int)404, (int)head.getStatusCode());
        PostMethod put = new PostMethod(fullPathKey);
        put.setRequestHeader("Content-Type", "application/text");
        put.setRequestBody("data");
        Client$.MODULE$.call((HttpMethodBase)put);
        Assert.assertEquals((int)404, (int)put.getStatusCode());
    }

    public void testByteArrayAsSerializedObjects(Method m) {
        this.sendByteArrayAs(m, "application/x-java-serialized-object");
    }

    public void testByteArrayAsOctecStreamObjects(Method m) {
        this.sendByteArrayAs(m, "application/octet-stream");
    }

    private void sendByteArrayAs(Method m, String contentType) {
        byte[] serializedOnClient = (byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{101, 102, 103}), (ClassManifest)Manifest$.MODULE$.Byte());
        this.put(m, serializedOnClient, contentType);
        BufferedInputStream dataRead = new BufferedInputStream(this.get(m, (Option<String>)None$.MODULE$, (Option<String>)new Some((Object)contentType)).getResponseBodyAsStream());
        byte[] bytesRead = new byte[3];
        dataRead.read(bytesRead);
        Assert.assertEquals((byte[])serializedOnClient, (byte[])bytesRead);
    }

    public void testIfUnmodifiedSince(Method m) {
        this.put(m);
        HttpMethodBase result = this.get(m);
        String dateLast = result.getResponseHeader("Last-Modified").getValue();
        String dateMinus = this.addDay(dateLast, -1);
        String datePlus = this.addDay(dateLast, 1);
        Assert.assertNotNull((Object)this.get(m, (Option<String>)new Some((Object)dateLast)).getResponseBodyAsString());
        Assert.assertNotNull((Object)this.get(m, (Option<String>)new Some((Object)datePlus)).getResponseBodyAsString());
        HttpMethodBase httpMethodBase = this.get(m, (Option<String>)new Some((Object)dateMinus), (Option<String>)None$.MODULE$, 412);
    }

    public void testETagChanges(Method m) {
        this.put(m, "data1");
        String eTagFirst = this.get(m).getResponseHeader("ETag").getValue();
        Assert.assertEquals((String)eTagFirst, (String)this.get(m).getResponseHeader("ETag").getValue());
        this.put(m, "data2");
        String eTagSecond = this.get(m).getResponseHeader("ETag").getValue();
        Assert.assertFalse((boolean)eTagFirst.equals(eTagSecond));
    }

    public void testSerializedStringGetBytes(Method m) {
        byte[] data = new StringBuilder().append((Object)"v-").append((Object)m.getName()).toString().getBytes("UTF-8");
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        ObjectOutputStream oo = new ObjectOutputStream(bout);
        oo.writeObject(data);
        oo.flush();
        byte[] bytes = bout.toByteArray();
        this.put(m, bytes, "application/x-java-serialized-object");
        byte[] bytesRead = this.get(m, (Option<String>)None$.MODULE$, (Option<String>)new Some((Object)"application/x-java-serialized-object")).getResponseBody();
        Assert.assertTrue((boolean)Arrays.equals(bytes, bytesRead));
        ObjectInputStream oin = new ObjectInputStream(new ByteArrayInputStream(bytesRead));
        byte[] dataBack = (byte[])oin.readObject();
        Assert.assertTrue((boolean)Arrays.equals(data, dataBack));
    }

    private HttpMethodBase put(Method m) {
        return this.put(m, "data", "application/text");
    }

    private HttpMethodBase put(Method m, Object data) {
        return this.put(m, data, "application/text");
    }

    private HttpMethodBase put(Method m, Object data, String contentType) {
        Object object;
        block4: {
            StringRequestEntity stringRequestEntity;
            PutMethod put;
            block3: {
                block2: {
                    put = new PutMethod(this.fullPathKey(m));
                    put.setRequestHeader("Content-Type", contentType);
                    object = data;
                    if (!(object instanceof String)) break block2;
                    stringRequestEntity = new StringRequestEntity((String)object);
                    break block3;
                }
                if (!(object instanceof byte[])) break block4;
                stringRequestEntity = new InputStreamRequestEntity((InputStream)new ByteArrayInputStream((byte[])object));
            }
            StringRequestEntity reqEntity = stringRequestEntity;
            put.setRequestEntity((RequestEntity)reqEntity);
            Client$.MODULE$.call((HttpMethodBase)put);
            Assert.assertEquals((int)200, (int)put.getStatusCode());
            return put;
        }
        throw new MatchError(object);
    }

    private HttpMethodBase get(Method m) {
        return this.get(m, (Option<String>)None$.MODULE$);
    }

    private HttpMethodBase get(Method m, Option<String> unmodSince) {
        return this.get(m, unmodSince, (Option<String>)None$.MODULE$, 200);
    }

    private HttpMethodBase get(Method m, Option<String> unmodSince, Option<String> acceptType) {
        return this.get(m, unmodSince, acceptType, 200);
    }

    private HttpMethodBase get(Method m, Option<String> unmodSince, Option<String> acceptType, int expCode) {
        GetMethod get = new GetMethod(this.fullPathKey(m));
        Option<String> option = unmodSince;
        None$ none$ = None$.MODULE$;
        if (option == null ? none$ != null : !option.equals((Object)none$)) {
            get.setRequestHeader("If-Unmodified-Since", (String)unmodSince.get());
        }
        Option<String> option2 = acceptType;
        None$ none$2 = None$.MODULE$;
        if (option2 == null ? none$2 != null : !option2.equals((Object)none$2)) {
            get.setRequestHeader("Accept", (String)acceptType.get());
        }
        Client$.MODULE$.call((HttpMethodBase)get);
        Assert.assertEquals((int)expCode, (int)get.getStatusCode());
        return get;
    }

    private String fullPathKey(Method m) {
        return new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
    }

    public String addDay(String aDate, int days) {
        SimpleDateFormat format = new SimpleDateFormat(this.DATE_PATTERN_RFC1123(), Locale.US);
        Date date = format.parse(aDate);
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(5, days);
        return format.format(cal.getTime());
    }

    public IntegrationTest() {
        this.HOST = "http://localhost:8888/";
        this.cacheName = "___defaultcache";
        this.DATE_PATTERN_RFC1123 = "EEE, dd MMM yyyy HH:mm:ss zzz";
    }
}

