/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.ByteArrayRequestEntity;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.infinispan.remoting.MIMECacheEntry;
import org.infinispan.rest.Client$;
import org.infinispan.rest.ManagerInstance$;
import org.infinispan.rest.MyNonSer;
import org.infinispan.rest.MySer;
import org.infinispan.rest.ServerInstance$;
import org.infinispan.test.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import scala.Array$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.ScalaObject;
import scala.Some;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ClassManifest;
import scala.reflect.Manifest$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.xml.Elem;
import scala.xml.MetaData;
import scala.xml.NamespaceBinding;
import scala.xml.NodeBuffer;
import scala.xml.Null$;
import scala.xml.Text;
import scala.xml.TopScope$;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Test(groups={"functional"}, testName="rest.IntegrationTest")
@ScalaSignature(bytes="\u0006\u0001\tMe\u0001B\u0001\u0003\u0001%\u0011q\"\u00138uK\u001e\u0014\u0018\r^5p]R+7\u000f\u001e\u0006\u0003\u0007\u0011\tAA]3ti*\u0011QAB\u0001\u000bS:4\u0017N\\5ta\u0006t'\"A\u0004\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001Q!\u0003\u0005\u0002\f!5\tAB\u0003\u0002\u000e\u001d\u0005!A.\u00198h\u0015\u0005y\u0011\u0001\u00026bm\u0006L!!\u0005\u0007\u0003\r=\u0013'.Z2u!\t\u0019b#D\u0001\u0015\u0015\u0005)\u0012!B:dC2\f\u0017BA\f\u0015\u0005-\u00196-\u00197b\u001f\nTWm\u0019;\t\u000be\u0001A\u0011\u0001\u000e\u0002\rqJg.\u001b;?)\u0005Y\u0002C\u0001\u000f\u0001\u001b\u0005\u0011\u0001b\u0002\u0010\u0001\u0005\u0004%\taH\u0001\u0005\u0011>\u001bF+F\u0001!!\tY\u0011%\u0003\u0002#\u0019\t11\u000b\u001e:j]\u001eDa\u0001\n\u0001!\u0002\u0013\u0001\u0013!\u0002%P'R\u0003\u0003b\u0002\u0014\u0001\u0005\u0004%\taH\u0001\nG\u0006\u001c\u0007.\u001a(b[\u0016Da\u0001\u000b\u0001!\u0002\u0013\u0001\u0013AC2bG\",g*Y7fA!9!\u0006\u0001b\u0001\n\u0003y\u0012\u0001\u00034vY2\u0004\u0016\r\u001e5\t\r1\u0002\u0001\u0015!\u0003!\u0003%1W\u000f\u001c7QCRD\u0007\u0005C\u0004/\u0001\t\u0007I\u0011A\u0010\u0002)\u0011\u000bE+R0Q\u0003R#VI\u0015(`%\u001a\u001b\u0015'\r\u001a4\u0011\u0019\u0001\u0004\u0001)A\u0005A\u0005)B)\u0011+F?B\u000bE\u000bV#S\u001d~\u0013fiQ\u00192eM\u0002\u0003\"\u0002\u001a\u0001\t\u0003\u0019\u0014!B:fiV\u0003H#\u0001\u001b\u0011\u0005M)\u0014B\u0001\u001c\u0015\u0005\u0011)f.\u001b;)\u0005EB\u0004CA\u001d?\u001b\u0005Q$BA\u001e=\u0003-\tgN\\8uCRLwN\\:\u000b\u0005u2\u0011A\u0002;fgRtw-\u0003\u0002@u\tY!)\u001a4pe\u0016\u001cE.Y:t\u0011\u0015\t\u0005\u0001\"\u00014\u0003!!X-\u0019:E_^t\u0007F\u0001!D!\tID)\u0003\u0002Fu\tQ\u0011I\u001a;fe\u000ec\u0017m]:\t\u000b\u001d\u0003A\u0011\u0001%\u0002%Q,7\u000f\u001e\"bg&\u001cw\n]3sCRLwN\u001c\u000b\u0003i%CQA\u0013$A\u0002-\u000b\u0011!\u001c\t\u0003\u0019>k\u0011!\u0014\u0006\u0003\u001d2\tqA]3gY\u0016\u001cG/\u0003\u0002Q\u001b\n1Q*\u001a;i_\u0012DQA\u0015\u0001\u0005\u0002M\u000bA\u0002^3ti\u0016k\u0007\u000f^=HKR,\u0012\u0001\u000e\u0005\u0006+\u0002!\tAV\u0001\bi\u0016\u001cHoR3u)\t!t\u000bC\u0003K)\u0002\u00071\nC\u0003Z\u0001\u0011\u0005!,\u0001\u0005uKN$\b*Z1e)\t!4\fC\u0003K1\u0002\u00071\nC\u0003^\u0001\u0011\u0005a,A\nuKN$x)\u001a;JMVsWn\u001c3jM&,G\r\u0006\u00025?\")!\n\u0018a\u0001\u0017\")\u0011\r\u0001C\u0001E\u0006\tB/Z:u!>\u001cH\u000fR;qY&\u001c\u0017\r^3\u0015\u0005Q\u001a\u0007\"\u0002&a\u0001\u0004Y\u0005\"B3\u0001\t\u00031\u0017!\u0007;fgR\u0004V\u000f\u001e#bi\u0006<\u0016\u000e\u001e5US6,Gk\u001c'jm\u0016$\"\u0001N4\t\u000b)#\u0007\u0019A&\t\u000b%\u0004A\u0011\u00016\u00025Q,7\u000f\u001e)vi\u0012\u000bG/Y,ji\"l\u0015\r_%eY\u0016|e\u000e\\=\u0015\u0005QZ\u0007\"\u0002&i\u0001\u0004Y\u0005\"B7\u0001\t\u0003q\u0017!\b;fgR\u0004V\u000f\u001e#bi\u0006<\u0016\u000e\u001e5US6,Gk\u001c'jm\u0016|e\u000e\\=\u0015\u0005Qz\u0007\"\u0002&m\u0001\u0004Y\u0005\"B9\u0001\t\u0013\u0011\u0018!\u00079vi\u0006sG-Q:tKJ$X\t\u001d5f[\u0016\u0014\u0018\r\u001c#bi\u0006$B\u0001N:uy\")!\n\u001da\u0001\u0017\")Q\u000f\u001da\u0001m\u0006\tB/[7f)>d\u0015N^3TK\u000e|g\u000eZ:\u0011\u0005]ThBA\ny\u0013\tIH#\u0001\u0004Qe\u0016$WMZ\u0005\u0003EmT!!\u001f\u000b\t\u000bu\u0004\b\u0019\u0001<\u0002%5\f\u00070\u00133mKRKW.Z*fG>tGm\u001d\u0005\u0007\u007f\u0002!\t!!\u0001\u0002-Q,7\u000f\u001e)vi\u0012\u000bG/Y,ji\"Le-T1uG\"$2\u0001NA\u0002\u0011\u0015Qe\u00101\u0001L\u0011\u001d\t9\u0001\u0001C\u0001\u0003\u0013\t!\u0004^3tiB+H\u000fR1uC^KG\u000f[%g\u001d>tW-T1uG\"$2\u0001NA\u0006\u0011\u0019Q\u0015Q\u0001a\u0001\u0017\"9\u0011q\u0002\u0001\u0005\u0002\u0005E\u0011A\b;fgR\u0004V\u000f\u001e#bi\u0006<\u0016\u000e\u001e5JM6{G-\u001b4jK\u0012\u001c\u0016N\\2f)\r!\u00141\u0003\u0005\u0007\u0015\u00065\u0001\u0019A&\t\u000f\u0005]\u0001\u0001\"\u0001\u0002\u001a\u0005\u0001C/Z:u!V$H)\u0019;b/&$\b.\u00134V]6{G-\u001b4jK\u0012\u001c\u0016N\\2f)\r!\u00141\u0004\u0005\u0007\u0015\u0006U\u0001\u0019A&\t\u000f\u0005}\u0001\u0001\"\u0001\u0002\"\u0005IB/Z:u\t\u0016dW\r^3ECR\fw+\u001b;i\u0013\u001al\u0015\r^2i)\r!\u00141\u0005\u0005\u0007\u0015\u0006u\u0001\u0019A&\t\u000f\u0005\u001d\u0002\u0001\"\u0001\u0002*\u0005iB/Z:u\t\u0016dW\r^3ECR\fw+\u001b;i\u0013\u001atuN\\3NCR\u001c\u0007\u000eF\u00025\u0003WAaASA\u0013\u0001\u0004Y\u0005bBA\u0018\u0001\u0011\u0005\u0011\u0011G\u0001\"i\u0016\u001cH\u000fR3mKR,G)\u0019;b/&$\b.\u00134N_\u0012Lg-[3e'&t7-\u001a\u000b\u0004i\u0005M\u0002B\u0002&\u0002.\u0001\u00071\nC\u0004\u00028\u0001!\t!!\u000f\u0002GQ,7\u000f\u001e#fY\u0016$X\rR1uC^KG\u000f[%g+:lw\u000eZ5gS\u0016$7+\u001b8dKR\u0019A'a\u000f\t\r)\u000b)\u00041\u0001L\u0011\u001d\ty\u0004\u0001C\u0001\u0003\u0003\n\u0001\u0006^3ti\u0012+G.\u001a;f\u0007\u0006\u001c\u0007.\u001a)sK\u000e|g\u000eZ5uS>tWK\\5na2,W.\u001a8uK\u0012$2\u0001NA\"\u0011\u0019Q\u0015Q\ba\u0001\u0017\"9\u0011q\t\u0001\u0005\n\u0005%\u0013!\n;fgR$U\r\\3uKB\u0013XmY8oI&$\u0018n\u001c8bYVs\u0017.\u001c9mK6,g\u000e^3e)\r!\u00141\n\u0005\b\u0003\u001b\n)\u00051\u0001w\u0003-1W\u000f\u001c7QCRD7*Z=\t\u000f\u0005\u001d\u0003\u0001\"\u0003\u0002RQ)A'a\u0015\u0002V!9\u0011QJA(\u0001\u00041\bbBA,\u0003\u001f\u0002\rA^\u0001\u0019aJ,7m\u001c8eSRLwN\\1m\u0011\u0016\fG-\u001a:OC6,\u0007bBA.\u0001\u0011%\u0011QL\u0001\u0015CN\u001cXM\u001d;O_RLU\u000e\u001d7f[\u0016tG/\u001a3\u0015\u0007Q\ny\u0006\u0003\u0005\u0002b\u0005e\u0003\u0019AA2\u0003\u0019iW\r\u001e5pIB!\u0011QMA:\u001b\t\t9G\u0003\u0003\u0002j\u0005-\u0014A\u00035uiB\u001cG.[3oi*!\u0011QNA8\u0003\u001d\u0019w.\\7p]NT1!!\u001d\u0007\u0003\u0019\t\u0007/Y2iK&!\u0011QOA4\u0005)AE\u000f\u001e9NKRDw\u000e\u001a\u0005\b\u0003s\u0002A\u0011AA>\u0003=!Xm\u001d;SK6|g/Z#oiJLHc\u0001\u001b\u0002~!1!*a\u001eA\u0002-Cq!!!\u0001\t\u0003\t\u0019)A\nuKN$x+\u001b9f\u0007\u0006\u001c\u0007.\u001a\"vG.,G\u000fF\u00025\u0003\u000bCaASA@\u0001\u0004Y\u0005bBAE\u0001\u0011\u0005\u00111R\u0001\u0013i\u0016\u001cH/Q:z]\u000e\fE\r\u001a*f[>4X\rF\u00025\u0003\u001bCaASAD\u0001\u0004Y\u0005bBAI\u0001\u0011\u0005\u00111S\u0001\u001fi\u0016\u001cHo\u00155pk2$7i\u001c9f/&$\bnU3sS\u0006d\u0017N_1cY\u0016$2\u0001NAK\u0011\u0019Q\u0015q\u0012a\u0001\u0017\"9\u0011\u0011\u0014\u0001\u0005\u0002\u0005m\u0015!\b;fgRLen]3siN+'/[1mSj\f'\r\\3PE*,7\r^:\u0015\u0007Q\ni\n\u0003\u0004K\u0003/\u0003\ra\u0013\u0005\b\u0003C\u0003A\u0011AAR\u0003Q!Xm\u001d;O_:,\u00070[:uK:$8)Y2iKR\u0019A'!*\t\r)\u000by\n1\u0001L\u0011\u001d\tI\u000b\u0001C\u0001\u0003W\u000b\u0001\u0005^3ti\nKH/Z!se\u0006L\u0018i]*fe&\fG.\u001b>fI>\u0013'.Z2ugR\u0019A'!,\t\r)\u000b9\u000b1\u0001L\u0011\u001d\t\t\f\u0001C\u0001\u0003g\u000b\u0011\u0005^3ti\nKH/Z!se\u0006L\u0018i](di\u0016\u001c7\u000b\u001e:fC6|%M[3diN$2\u0001NA[\u0011\u0019Q\u0015q\u0016a\u0001\u0017\"9\u0011\u0011\u0018\u0001\u0005\n\u0005m\u0016aD:f]\u0012\u0014\u0015\u0010^3BeJ\f\u00170Q:\u0015\u000bQ\ni,a0\t\r)\u000b9\f1\u0001L\u0011\u001d\t\t-a.A\u0002Y\f1bY8oi\u0016tG\u000fV=qK\"9\u0011Q\u0019\u0001\u0005\u0002\u0005\u001d\u0017!\u0006;fgRLe-\u00168n_\u0012Lg-[3e'&t7-\u001a\u000b\u0004i\u0005%\u0007B\u0002&\u0002D\u0002\u00071\nC\u0004\u0002N\u0002!\t!a4\u0002\u001fQ,7\u000f^#UC\u001e\u001c\u0005.\u00198hKN$2\u0001NAi\u0011\u0019Q\u00151\u001aa\u0001\u0017\"9\u0011Q\u001b\u0001\u0005\u0002\u0005]\u0017\u0001\b;fgR\u001cVM]5bY&TX\rZ*ue&twmR3u\u0005f$Xm\u001d\u000b\u0004i\u0005e\u0007B\u0002&\u0002T\u0002\u00071\nC\u0004\u0002^\u0002!\t!a8\u0002CQ,7\u000f\u001e#fM\u0006,H\u000e^\"p]\u001aLw-\u001e:fI\u0016C\b/\u001b:z-\u0006dW/Z:\u0015\u0007Q\n\t\u000f\u0003\u0004K\u00037\u0004\ra\u0013\u0005\b\u0003K\u0004A\u0011AAt\u0003U!Xm\u001d;QkR\u0014\u0015\u0010^3BeJ\f\u0017\u0010V<jG\u0016$2\u0001NAu\u0011\u0019Q\u00151\u001da\u0001\u0017\"9\u0011Q\u001e\u0001\u0005\u0002\u0005=\u0018A\u0007;fgR$U\r\\3uKN+'/[1mSj,Gm\u00142kK\u000e$Hc\u0001\u001b\u0002r\"1!*a;A\u0002-Cq!!>\u0001\t\u0013\t90\u0001\u0007xC&$hj\u001c;G_VtG\rF\u00045\u0003s\u0014\u0019A!\u0004\t\u0011\u0005m\u00181\u001fa\u0001\u0003{\f\u0011b\u001d;beR$\u0016.\\3\u0011\u0007M\ty0C\u0002\u0003\u0002Q\u0011A\u0001T8oO\"A!QAAz\u0001\u0004\u00119!\u0001\u0005mS\u001a,7\u000f]1o!\r\u0019\"\u0011B\u0005\u0004\u0005\u0017!\"aA%oi\"9\u0011QJAz\u0001\u00041\bb\u0002B\t\u0001\u0011%!1C\u0001\u0004aV$H\u0003\u0002B\u000b\u00057\u0001B!!\u001a\u0003\u0018%!!\u0011DA4\u00059AE\u000f\u001e9NKRDw\u000e\u001a\"bg\u0016DaA\u0013B\b\u0001\u0004Y\u0005b\u0002B\t\u0001\u0011%!q\u0004\u000b\u0007\u0005+\u0011\tCa\t\t\r)\u0013i\u00021\u0001L\u0011!\u0011)C!\bA\u0002\t\u001d\u0012\u0001\u00023bi\u0006\u00042a\u0005B\u0015\u0013\r\u0011Y\u0003\u0006\u0002\u0004\u0003:L\bb\u0002B\t\u0001\u0011%!q\u0006\u000b\t\u0005+\u0011\tDa\r\u00036!1!J!\fA\u0002-C\u0001B!\n\u0003.\u0001\u0007!q\u0005\u0005\b\u0003\u0003\u0014i\u00031\u0001w\u0011\u001d\u0011I\u0004\u0001C\u0005\u0005w\t1aZ3u)\u0011\u0011)B!\u0010\t\r)\u00139\u00041\u0001L\u0011\u001d\u0011I\u0004\u0001C\u0005\u0005\u0003\"bA!\u0006\u0003D\t\u0015\u0003B\u0002&\u0003@\u0001\u00071\n\u0003\u0005\u0003H\t}\u0002\u0019\u0001B%\u0003))h.\\8e'&t7-\u001a\t\u0005'\t-c/C\u0002\u0003NQ\u0011aa\u00149uS>t\u0007b\u0002B\u001d\u0001\u0011%!\u0011\u000b\u000b\t\u0005+\u0011\u0019F!\u0016\u0003X!1!Ja\u0014A\u0002-C\u0001Ba\u0012\u0003P\u0001\u0007!\u0011\n\u0005\t\u00053\u0012y\u00051\u0001\u0003J\u0005Q\u0011mY2faR$\u0016\u0010]3\t\u000f\te\u0002\u0001\"\u0003\u0003^QQ!Q\u0003B0\u0005C\u0012\u0019G!\u001a\t\r)\u0013Y\u00061\u0001L\u0011!\u00119Ea\u0017A\u0002\t%\u0003\u0002\u0003B-\u00057\u0002\rA!\u0013\t\u0011\t\u001d$1\fa\u0001\u0005\u000f\tq!\u001a=q\u0007>$W\rC\u0004\u0002N\u0001!IAa\u001b\u0015\u0007Y\u0014i\u0007\u0003\u0004K\u0005S\u0002\ra\u0013\u0005\b\u0005c\u0002A\u0011\u0001B:\u0003\u0019\tG\r\u001a#bsR)aO!\u001e\u0003z!9!q\u000fB8\u0001\u00041\u0018!B1ECR,\u0007\u0002\u0003B>\u0005_\u0002\rAa\u0002\u0002\t\u0011\f\u0017p\u001d\u0015\f\u0001\t}$Q\u0011BD\u0005\u001b\u0013y\tE\u0002:\u0005\u0003K1Aa!;\u0005\u0011!Vm\u001d;\u0002\r\u001d\u0014x.\u001e9tY\t\u0011I)\t\u0002\u0003\f\u0006Qa-\u001e8di&|g.\u00197\u0002\u0011Q,7\u000f\u001e(b[\u0016\f#A!%\u0002)I,7\u000f\u001e\u0018J]R,wM]1uS>tG+Z:u\u0001")
public class IntegrationTest
implements ScalaObject {
    private final String HOST;
    private final String cacheName;
    private final String fullPath = new StringBuilder().append((Object)this.HOST()).append((Object)"/rest/").append((Object)this.cacheName()).toString();
    private final String DATE_PATTERN_RFC1123;

    public String HOST() {
        return this.HOST;
    }

    public String cacheName() {
        return this.cacheName;
    }

    public String fullPath() {
        return this.fullPath;
    }

    public String DATE_PATTERN_RFC1123() {
        return this.DATE_PATTERN_RFC1123;
    }

    @BeforeClass
    public void setUp() {
        ServerInstance$.MODULE$.start();
    }

    @AfterClass
    public void tearDown() {
        ServerInstance$.MODULE$.stop();
    }

    public void testBasicOperation(Method m) {
        HttpClient client = new HttpClient();
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PutMethod insert = new PutMethod(fullPathKey);
        TopScope$ topScope$ = Predef$.MODULE$.$scope();
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("ho"));
        Elem initialXML = new Elem(null, "hey", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$, (Seq)$buf);
        insert.setRequestEntity((RequestEntity)new ByteArrayRequestEntity(initialXML.toString().getBytes(), "application/octet-stream"));
        Client$.MODULE$.call((HttpMethodBase)insert);
        AssertJUnit.assertEquals((String)"", (String)insert.getResponseBodyAsString().trim());
        AssertJUnit.assertEquals((int)200, (int)insert.getStatusCode());
        GetMethod get = new GetMethod(fullPathKey);
        Client$.MODULE$.call((HttpMethodBase)get);
        byte[] bytes = get.getResponseBody();
        AssertJUnit.assertEquals((int)Predef$.MODULE$.byteArrayOps(bytes).size(), (int)Predef$.MODULE$.byteArrayOps(initialXML.toString().getBytes()).size());
        TopScope$ topScope$2 = Predef$.MODULE$.$scope();
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("ho"));
        AssertJUnit.assertEquals((String)new Elem(null, "hey", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$2, (Seq)$buf2).toString(), (String)get.getResponseBodyAsString());
        Header hdr = get.getResponseHeader("Content-Type");
        AssertJUnit.assertEquals((String)"application/octet-stream", (String)hdr.getValue());
        DeleteMethod remove = new DeleteMethod(fullPathKey);
        Client$.MODULE$.call((HttpMethodBase)remove);
        Client$.MODULE$.call((HttpMethodBase)get);
        AssertJUnit.assertEquals((int)404, (int)get.getStatusCode());
        Client$.MODULE$.call((HttpMethodBase)insert);
        Client$.MODULE$.call((HttpMethodBase)get);
        TopScope$ topScope$3 = Predef$.MODULE$.$scope();
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)new Text("ho"));
        AssertJUnit.assertEquals((String)new Elem(null, "hey", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$3, (Seq)$buf3).toString(), (String)get.getResponseBodyAsString());
        DeleteMethod removeAll = new DeleteMethod(this.fullPath());
        AssertJUnit.assertEquals((int)200, (int)Client$.MODULE$.call((HttpMethodBase)removeAll).getStatusCode());
        Client$.MODULE$.call((HttpMethodBase)get);
        AssertJUnit.assertEquals((int)404, (int)get.getStatusCode());
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        ObjectOutputStream oo = new ObjectOutputStream(bout);
        oo.writeObject(new MIMECacheEntry("foo", "hey".getBytes()));
        oo.flush();
        byte[] byteData = bout.toByteArray();
        PutMethod insertMore = new PutMethod(fullPathKey);
        insertMore.setRequestEntity((RequestEntity)new ByteArrayRequestEntity(byteData, "application/octet-stream"));
        Client$.MODULE$.call((HttpMethodBase)insertMore);
        GetMethod getMore = new GetMethod(fullPathKey);
        Client$.MODULE$.call((HttpMethodBase)getMore);
        byte[] bytesBack = getMore.getResponseBody();
        AssertJUnit.assertEquals((int)byteData.length, (int)bytesBack.length);
        ObjectInputStream oin = new ObjectInputStream(new ByteArrayInputStream(bytesBack));
        MIMECacheEntry ce = (MIMECacheEntry)oin.readObject();
        AssertJUnit.assertEquals((String)"foo", (String)ce.contentType);
    }

    public void testEmptyGet() {
        AssertJUnit.assertEquals((int)404, (int)Client$.MODULE$.call((HttpMethodBase)new GetMethod(new StringBuilder().append((Object)this.HOST()).append((Object)"/rest/").append((Object)this.cacheName()).append((Object)"/nodata").toString())).getStatusCode());
    }

    public void testGet(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PostMethod post = new PostMethod(fullPathKey);
        post.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", null));
        Client$.MODULE$.call((HttpMethodBase)post);
        HttpMethodBase get = Client$.MODULE$.call((HttpMethodBase)new GetMethod(fullPathKey));
        AssertJUnit.assertEquals((int)200, (int)get.getStatusCode());
        AssertJUnit.assertNotNull((Object)get.getResponseHeader("ETag").getValue());
        AssertJUnit.assertNotNull((Object)get.getResponseHeader("Last-Modified").getValue());
        AssertJUnit.assertEquals((String)"application/text", (String)get.getResponseHeader("Content-Type").getValue());
        AssertJUnit.assertEquals((String)"data", (String)get.getResponseBodyAsString());
    }

    public void testHead(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PostMethod post = new PostMethod(fullPathKey);
        post.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", null));
        Client$.MODULE$.call((HttpMethodBase)post);
        HttpMethodBase get = Client$.MODULE$.call((HttpMethodBase)new HeadMethod(fullPathKey));
        AssertJUnit.assertEquals((int)200, (int)get.getStatusCode());
        AssertJUnit.assertNotNull((Object)get.getResponseHeader("ETag").getValue());
        AssertJUnit.assertNotNull((Object)get.getResponseHeader("Last-Modified").getValue());
        AssertJUnit.assertEquals((String)"application/text", (String)get.getResponseHeader("Content-Type").getValue());
        AssertJUnit.assertNull((Object)get.getResponseBodyAsString());
    }

    public void testGetIfUnmodified(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PostMethod post = new PostMethod(fullPathKey);
        post.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", null));
        Client$.MODULE$.call((HttpMethodBase)post);
        HttpMethodBase get = Client$.MODULE$.call((HttpMethodBase)new GetMethod(fullPathKey));
        AssertJUnit.assertEquals((int)200, (int)get.getStatusCode());
        AssertJUnit.assertNotNull((Object)get.getResponseHeader("ETag").getValue());
        String lastMod = get.getResponseHeader("Last-Modified").getValue();
        AssertJUnit.assertNotNull((Object)lastMod);
        AssertJUnit.assertEquals((String)"application/text", (String)get.getResponseHeader("Content-Type").getValue());
        AssertJUnit.assertEquals((String)"data", (String)get.getResponseBodyAsString());
        GetMethod getAgain = new GetMethod(fullPathKey);
        getAgain.addRequestHeader("If-Unmodified-Since", lastMod);
        get = Client$.MODULE$.call((HttpMethodBase)getAgain);
        AssertJUnit.assertEquals((int)200, (int)get.getStatusCode());
        AssertJUnit.assertNotNull((Object)get.getResponseHeader("ETag").getValue());
        AssertJUnit.assertNotNull((Object)get.getResponseHeader("Last-Modified").getValue());
        AssertJUnit.assertEquals((String)"application/text", (String)get.getResponseHeader("Content-Type").getValue());
        AssertJUnit.assertEquals((String)"data", (String)get.getResponseBodyAsString());
    }

    public void testPostDuplicate(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PostMethod post = new PostMethod(fullPathKey);
        post.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        Client$.MODULE$.call((HttpMethodBase)post);
        AssertJUnit.assertEquals((int)409, (int)Client$.MODULE$.call((HttpMethodBase)post).getStatusCode());
        PutMethod put = new PutMethod(fullPathKey);
        put.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        AssertJUnit.assertEquals((int)200, (int)Client$.MODULE$.call((HttpMethodBase)put).getStatusCode());
    }

    public void testPutDataWithTimeToLive(Method m) {
        this.putAndAssertEphemeralData(m, "2", "3");
    }

    public void testPutDataWithMaxIdleOnly(Method m) {
        this.putAndAssertEphemeralData(m, "", "3");
    }

    public void testPutDataWithTimeToLiveOnly(Method m) {
        this.putAndAssertEphemeralData(m, "3", "");
    }

    private void putAndAssertEphemeralData(Method m, String timeToLiveSeconds, String maxIdleTimeSeconds) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PostMethod post = new PostMethod(fullPathKey);
        int maxWaitTime = 0;
        if (!timeToLiveSeconds.isEmpty()) {
            maxWaitTime = package$.MODULE$.max(maxWaitTime, Predef$.MODULE$.augmentString(timeToLiveSeconds).toInt());
            post.setRequestHeader("timeToLiveSeconds", timeToLiveSeconds);
        }
        if (!maxIdleTimeSeconds.isEmpty()) {
            maxWaitTime = package$.MODULE$.max(maxWaitTime, Predef$.MODULE$.augmentString(maxIdleTimeSeconds).toInt());
            post.setRequestHeader("maxIdleTimeSeconds", maxIdleTimeSeconds);
        }
        post.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        Client$.MODULE$.call((HttpMethodBase)post);
        HttpMethodBase get = Client$.MODULE$.call((HttpMethodBase)new GetMethod(fullPathKey));
        AssertJUnit.assertEquals((String)"data", (String)get.getResponseBodyAsString());
        TestingUtil.sleepThread((long)((maxWaitTime + 1) * 1000));
        Client$.MODULE$.call(get);
        AssertJUnit.assertEquals((int)404, (int)get.getStatusCode());
    }

    public void testPutDataWithIfMatch(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PutMethod put = new PutMethod(fullPathKey);
        put.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        Client$.MODULE$.call((HttpMethodBase)put);
        HttpMethodBase get = Client$.MODULE$.call((HttpMethodBase)new GetMethod(fullPathKey));
        AssertJUnit.assertEquals((int)200, (int)get.getStatusCode());
        String etag = get.getResponseHeader("ETag").getValue();
        PutMethod reput = new PutMethod(fullPathKey);
        reput.setRequestHeader("If-Match", etag);
        reput.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        AssertJUnit.assertEquals((int)200, (int)Client$.MODULE$.call((HttpMethodBase)reput).getStatusCode());
        PutMethod reputAgain = new PutMethod(fullPathKey);
        reputAgain.setRequestHeader("If-Match", "x");
        reputAgain.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        AssertJUnit.assertEquals((int)412, (int)Client$.MODULE$.call((HttpMethodBase)reputAgain).getStatusCode());
    }

    public void testPutDataWithIfNoneMatch(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PutMethod put = new PutMethod(fullPathKey);
        put.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        Client$.MODULE$.call((HttpMethodBase)put);
        HttpMethodBase get = Client$.MODULE$.call((HttpMethodBase)new GetMethod(fullPathKey));
        AssertJUnit.assertEquals((int)200, (int)get.getStatusCode());
        String etag = get.getResponseHeader("ETag").getValue();
        PutMethod reput = new PutMethod(fullPathKey);
        reput.setRequestHeader("If-None-Match", "x");
        reput.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        AssertJUnit.assertEquals((int)200, (int)Client$.MODULE$.call((HttpMethodBase)reput).getStatusCode());
        PutMethod reputAgain = new PutMethod(fullPathKey);
        reputAgain.setRequestHeader("If-None-Match", etag);
        reputAgain.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        AssertJUnit.assertEquals((int)412, (int)Client$.MODULE$.call((HttpMethodBase)reputAgain).getStatusCode());
    }

    public void testPutDataWithIfModifiedSince(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PutMethod put = new PutMethod(fullPathKey);
        put.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        Client$.MODULE$.call((HttpMethodBase)put);
        HttpMethodBase get = Client$.MODULE$.call((HttpMethodBase)new GetMethod(fullPathKey));
        AssertJUnit.assertEquals((int)200, (int)get.getStatusCode());
        String lastMod = get.getResponseHeader("Last-Modified").getValue();
        PutMethod reput = new PutMethod(fullPathKey);
        reput.setRequestHeader("If-Modified-Since", lastMod);
        reput.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        AssertJUnit.assertEquals((int)304, (int)Client$.MODULE$.call((HttpMethodBase)reput).getStatusCode());
        PutMethod reputAgain = new PutMethod(fullPathKey);
        String dateMinus = this.addDay(lastMod, -1);
        reputAgain.setRequestHeader("If-Modified-Since", dateMinus);
        reputAgain.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        AssertJUnit.assertEquals((int)200, (int)Client$.MODULE$.call((HttpMethodBase)reputAgain).getStatusCode());
    }

    public void testPutDataWithIfUnModifiedSince(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PutMethod put = new PutMethod(fullPathKey);
        put.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        Client$.MODULE$.call((HttpMethodBase)put);
        HttpMethodBase get = Client$.MODULE$.call((HttpMethodBase)new GetMethod(fullPathKey));
        AssertJUnit.assertEquals((int)200, (int)get.getStatusCode());
        String lastMod = get.getResponseHeader("Last-Modified").getValue();
        PutMethod reput = new PutMethod(fullPathKey);
        String dateMinus = this.addDay(lastMod, -1);
        reput.setRequestHeader("If-Unmodified-Since", dateMinus);
        reput.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        AssertJUnit.assertEquals((int)412, (int)Client$.MODULE$.call((HttpMethodBase)reput).getStatusCode());
        PutMethod reputAgain = new PutMethod(fullPathKey);
        reputAgain.setRequestHeader("If-Unmodified-Since", lastMod);
        reputAgain.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        AssertJUnit.assertEquals((int)200, (int)Client$.MODULE$.call((HttpMethodBase)reputAgain).getStatusCode());
    }

    public void testDeleteDataWithIfMatch(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PutMethod put = new PutMethod(fullPathKey);
        put.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        Client$.MODULE$.call((HttpMethodBase)put);
        HttpMethodBase get = Client$.MODULE$.call((HttpMethodBase)new GetMethod(fullPathKey));
        AssertJUnit.assertEquals((int)200, (int)get.getStatusCode());
        String etag = get.getResponseHeader("ETag").getValue();
        DeleteMethod delete = new DeleteMethod(fullPathKey);
        delete.setRequestHeader("If-Match", "x");
        AssertJUnit.assertEquals((int)412, (int)Client$.MODULE$.call((HttpMethodBase)delete).getStatusCode());
        DeleteMethod deleteAgain = new DeleteMethod(fullPathKey);
        deleteAgain.setRequestHeader("If-Match", etag);
        AssertJUnit.assertEquals((int)200, (int)Client$.MODULE$.call((HttpMethodBase)deleteAgain).getStatusCode());
    }

    public void testDeleteDataWithIfNoneMatch(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PutMethod put = new PutMethod(fullPathKey);
        put.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        Client$.MODULE$.call((HttpMethodBase)put);
        HttpMethodBase get = Client$.MODULE$.call((HttpMethodBase)new GetMethod(fullPathKey));
        AssertJUnit.assertEquals((int)200, (int)get.getStatusCode());
        String etag = get.getResponseHeader("ETag").getValue();
        DeleteMethod delete = new DeleteMethod(fullPathKey);
        delete.setRequestHeader("If-None-Match", etag);
        AssertJUnit.assertEquals((int)412, (int)Client$.MODULE$.call((HttpMethodBase)delete).getStatusCode());
        DeleteMethod deleteAgain = new DeleteMethod(fullPathKey);
        deleteAgain.setRequestHeader("If-None-Match", "x");
        AssertJUnit.assertEquals((int)200, (int)Client$.MODULE$.call((HttpMethodBase)deleteAgain).getStatusCode());
    }

    public void testDeleteDataWithIfModifiedSince(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PutMethod put = new PutMethod(fullPathKey);
        put.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        Client$.MODULE$.call((HttpMethodBase)put);
        HttpMethodBase get = Client$.MODULE$.call((HttpMethodBase)new GetMethod(fullPathKey));
        AssertJUnit.assertEquals((int)200, (int)get.getStatusCode());
        String lastMod = get.getResponseHeader("Last-Modified").getValue();
        DeleteMethod delete = new DeleteMethod(fullPathKey);
        delete.setRequestHeader("If-Modified-Since", lastMod);
        AssertJUnit.assertEquals((int)304, (int)Client$.MODULE$.call((HttpMethodBase)delete).getStatusCode());
        DeleteMethod deleteAgain = new DeleteMethod(fullPathKey);
        String dateMinus = this.addDay(lastMod, -1);
        deleteAgain.setRequestHeader("If-Modified-Since", dateMinus);
        AssertJUnit.assertEquals((int)200, (int)Client$.MODULE$.call((HttpMethodBase)deleteAgain).getStatusCode());
    }

    public void testDeleteDataWithIfUnmodifiedSince(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PutMethod put = new PutMethod(fullPathKey);
        put.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        Client$.MODULE$.call((HttpMethodBase)put);
        HttpMethodBase get = Client$.MODULE$.call((HttpMethodBase)new GetMethod(fullPathKey));
        AssertJUnit.assertEquals((int)200, (int)get.getStatusCode());
        String lastMod = get.getResponseHeader("Last-Modified").getValue();
        DeleteMethod delete = new DeleteMethod(fullPathKey);
        String dateMinus = this.addDay(lastMod, -1);
        delete.setRequestHeader("If-Unmodified-Since", dateMinus);
        AssertJUnit.assertEquals((int)412, (int)Client$.MODULE$.call((HttpMethodBase)delete).getStatusCode());
        DeleteMethod deleteAgain = new DeleteMethod(fullPathKey);
        deleteAgain.setRequestHeader("If-Unmodified-Since", lastMod);
        AssertJUnit.assertEquals((int)200, (int)Client$.MODULE$.call((HttpMethodBase)deleteAgain).getStatusCode());
    }

    public void testDeleteCachePreconditionUnimplemented(Method m) {
        this.testDeletePreconditionalUnimplemented(this.fullPath());
    }

    private void testDeletePreconditionalUnimplemented(String fullPathKey) {
        this.testDeletePreconditionalUnimplemented(fullPathKey, "If-Match");
        this.testDeletePreconditionalUnimplemented(fullPathKey, "If-None-Match");
        this.testDeletePreconditionalUnimplemented(fullPathKey, "If-Modified-Since");
        this.testDeletePreconditionalUnimplemented(fullPathKey, "If-Unmodified-Since");
    }

    private void testDeletePreconditionalUnimplemented(String fullPathKey, String preconditionalHeaderName) {
        DeleteMethod delete = new DeleteMethod(fullPathKey);
        delete.setRequestHeader(preconditionalHeaderName, "*");
        Client$.MODULE$.call((HttpMethodBase)delete);
        this.assertNotImplemented((HttpMethod)delete);
    }

    private void assertNotImplemented(HttpMethod method) {
        AssertJUnit.assertEquals((int)method.getStatusCode(), (int)501);
        AssertJUnit.assertEquals((String)method.getStatusText(), (String)"Not Implemented");
        Predef$.MODULE$.assert(method.getResponseBodyAsString().toLowerCase().contains("precondition"));
    }

    public void testRemoveEntry(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PostMethod put = new PostMethod(fullPathKey);
        put.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        Client$.MODULE$.call((HttpMethodBase)put);
        AssertJUnit.assertEquals((int)200, (int)Client$.MODULE$.call((HttpMethodBase)new HeadMethod(fullPathKey)).getStatusCode());
        Client$.MODULE$.call((HttpMethodBase)new DeleteMethod(fullPathKey));
        AssertJUnit.assertEquals((int)404, (int)Client$.MODULE$.call((HttpMethodBase)new HeadMethod(fullPathKey)).getStatusCode());
    }

    public void testWipeCacheBucket(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PostMethod put = new PostMethod(fullPathKey);
        put.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        Client$.MODULE$.call((HttpMethodBase)put);
        PostMethod put_ = new PostMethod(new StringBuilder().append((Object)fullPathKey).append((Object)"2").toString());
        put_.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        Client$.MODULE$.call((HttpMethodBase)put_);
        AssertJUnit.assertEquals((int)200, (int)Client$.MODULE$.call((HttpMethodBase)new HeadMethod(fullPathKey)).getStatusCode());
        Client$.MODULE$.call((HttpMethodBase)new DeleteMethod(this.fullPath()));
        AssertJUnit.assertEquals((int)404, (int)Client$.MODULE$.call((HttpMethodBase)new HeadMethod(fullPathKey)).getStatusCode());
    }

    public void testAsyncAddRemove(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PostMethod put = new PostMethod(fullPathKey);
        put.setRequestHeader("performAsync", "true");
        put.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        Client$.MODULE$.call((HttpMethodBase)put);
        Thread.sleep(50L);
        AssertJUnit.assertEquals((int)200, (int)Client$.MODULE$.call((HttpMethodBase)new HeadMethod(fullPathKey)).getStatusCode());
        DeleteMethod del = new DeleteMethod(fullPathKey);
        del.setRequestHeader("performAsync", "true");
        Client$.MODULE$.call((HttpMethodBase)del);
        Thread.sleep(50L);
        AssertJUnit.assertEquals((int)404, (int)Client$.MODULE$.call((HttpMethodBase)new HeadMethod(fullPathKey)).getStatusCode());
    }

    public void testShouldCopeWithSerializable(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        Client$.MODULE$.call((HttpMethodBase)new GetMethod(fullPathKey));
        MySer obj = new MySer();
        obj.name_$eq("mic");
        ManagerInstance$.MODULE$.getCache("___defaultcache").put(m.getName(), obj);
        ManagerInstance$.MODULE$.getCache("___defaultcache").put(new StringBuilder().append((Object)m.getName()).append((Object)"2").toString(), "hola");
        ManagerInstance$.MODULE$.getCache("___defaultcache").put(new StringBuilder().append((Object)m.getName()).append((Object)"3").toString(), new MyNonSer());
        GetMethod get = new GetMethod(fullPathKey);
        get.setRequestHeader("Accept", "application/x-java-serialized-object");
        Client$.MODULE$.call((HttpMethodBase)get);
        AssertJUnit.assertEquals((int)200, (int)get.getStatusCode());
        ObjectInputStream in = new ObjectInputStream(get.getResponseBodyAsStream());
        MySer res = (MySer)in.readObject();
        AssertJUnit.assertNotNull((Object)res);
        AssertJUnit.assertEquals((String)"mic", (String)res.name());
        AssertJUnit.assertEquals((String)"application/x-java-serialized-object", (String)get.getResponseHeader("Content-Type").getValue());
        HttpMethodBase getStr = Client$.MODULE$.call((HttpMethodBase)new GetMethod(new StringBuilder().append((Object)fullPathKey).append((Object)"2").toString()));
        AssertJUnit.assertEquals((String)"hola", (String)getStr.getResponseBodyAsString());
        AssertJUnit.assertEquals((String)"text/plain", (String)getStr.getResponseHeader("Content-Type").getValue());
        get.setRequestHeader("Accept", "application/json");
        Client$.MODULE$.call((HttpMethodBase)get);
        AssertJUnit.assertEquals((String)"{\"name\":\"mic\"}", (String)get.getResponseBodyAsString());
        AssertJUnit.assertEquals((String)"application/json", (String)get.getResponseHeader("Content-Type").getValue());
        get.setRequestHeader("Accept", "application/xml");
        Client$.MODULE$.call((HttpMethodBase)get);
        AssertJUnit.assertEquals((String)"application/xml", (String)get.getResponseHeader("Content-Type").getValue());
        AssertJUnit.assertTrue((get.getResponseBodyAsString().indexOf("<org.infinispan.rest.MySer>") > -1 ? 1 : 0) != 0);
        GetMethod get3 = new GetMethod(new StringBuilder().append((Object)fullPathKey).append((Object)"3").toString());
        get3.setRequestHeader("Accept", "application/json");
        Client$.MODULE$.call((HttpMethodBase)get3);
        AssertJUnit.assertEquals((String)"{\"name\":\"mic\"}", (String)get3.getResponseBodyAsString());
        AssertJUnit.assertEquals((String)"application/json", (String)get3.getResponseHeader("Content-Type").getValue());
    }

    public void testInsertSerializableObjects(Method m) {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        new ObjectOutputStream(bout).writeObject(new MySer());
        this.put(m, bout.toByteArray(), "application/x-java-serialized-object");
        byte[] cfr_ignored_0 = (byte[])ManagerInstance$.MODULE$.getCache("___defaultcache").get(m.getName());
    }

    public void testNonexistentCache(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.HOST()).append((Object)"/rest/nonexistent/").append((Object)m.getName()).toString();
        GetMethod get = new GetMethod(fullPathKey);
        Client$.MODULE$.call((HttpMethodBase)get);
        AssertJUnit.assertEquals((int)404, (int)get.getStatusCode());
        HttpMethodBase head = Client$.MODULE$.call((HttpMethodBase)new HeadMethod(fullPathKey));
        AssertJUnit.assertEquals((int)404, (int)head.getStatusCode());
        PostMethod put = new PostMethod(fullPathKey);
        put.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        Client$.MODULE$.call((HttpMethodBase)put);
        AssertJUnit.assertEquals((int)404, (int)put.getStatusCode());
    }

    public void testByteArrayAsSerializedObjects(Method m) {
        this.sendByteArrayAs(m, "application/x-java-serialized-object");
    }

    public void testByteArrayAsOctecStreamObjects(Method m) {
        this.sendByteArrayAs(m, "application/octet-stream");
    }

    private void sendByteArrayAs(Method m, String contentType) {
        byte[] serializedOnClient = (byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{101, 102, 103}), (ClassManifest)Manifest$.MODULE$.Byte());
        this.put(m, serializedOnClient, contentType);
        BufferedInputStream dataRead = new BufferedInputStream(this.get(m, (Option<String>)None$.MODULE$, (Option<String>)new Some((Object)contentType)).getResponseBodyAsStream());
        byte[] bytesRead = new byte[3];
        dataRead.read(bytesRead);
        AssertJUnit.assertEquals((byte[])serializedOnClient, (byte[])bytesRead);
    }

    public void testIfUnmodifiedSince(Method m) {
        this.put(m);
        HttpMethodBase result = this.get(m);
        String dateLast = result.getResponseHeader("Last-Modified").getValue();
        String dateMinus = this.addDay(dateLast, -1);
        String datePlus = this.addDay(dateLast, 1);
        AssertJUnit.assertNotNull((Object)this.get(m, (Option<String>)new Some((Object)dateLast)).getResponseBodyAsString());
        AssertJUnit.assertNotNull((Object)this.get(m, (Option<String>)new Some((Object)datePlus)).getResponseBodyAsString());
        HttpMethodBase httpMethodBase = this.get(m, (Option<String>)new Some((Object)dateMinus), (Option<String>)None$.MODULE$, 412);
    }

    public void testETagChanges(Method m) {
        this.put(m, "data1");
        String eTagFirst = this.get(m).getResponseHeader("ETag").getValue();
        AssertJUnit.assertEquals((String)eTagFirst, (String)this.get(m).getResponseHeader("ETag").getValue());
        this.put(m, "data2");
        String eTagSecond = this.get(m).getResponseHeader("ETag").getValue();
        AssertJUnit.assertFalse((boolean)eTagFirst.equals(eTagSecond));
    }

    public void testSerializedStringGetBytes(Method m) {
        byte[] data = new StringBuilder().append((Object)"v-").append((Object)m.getName()).toString().getBytes("UTF-8");
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        ObjectOutputStream oo = new ObjectOutputStream(bout);
        oo.writeObject(data);
        oo.flush();
        byte[] bytes = bout.toByteArray();
        this.put(m, bytes, "application/x-java-serialized-object");
        byte[] bytesRead = this.get(m, (Option<String>)None$.MODULE$, (Option<String>)new Some((Object)"application/x-java-serialized-object")).getResponseBody();
        AssertJUnit.assertTrue((boolean)Arrays.equals(bytes, bytesRead));
        ObjectInputStream oin = new ObjectInputStream(new ByteArrayInputStream(bytesRead));
        byte[] dataBack = (byte[])oin.readObject();
        AssertJUnit.assertTrue((boolean)Arrays.equals(data, dataBack));
    }

    public void testDefaultConfiguredExpiryValues(Method m) {
        String cacheName = "evictExpiryCache";
        String fullPathKey = Predef$.MODULE$.augmentString("%s/rest/%s/%s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.HOST(), cacheName, m.getName()}));
        PostMethod post = new PostMethod(fullPathKey);
        post.setRequestHeader("timeToLiveSeconds", "-1");
        post.setRequestEntity((RequestEntity)new StringRequestEntity("data", "text/plain", "UTF-8"));
        Client$.MODULE$.call((HttpMethodBase)post);
        Thread.sleep(5000L);
        AssertJUnit.assertEquals((String)"data", (String)Client$.MODULE$.call((HttpMethodBase)new GetMethod(fullPathKey)).getResponseBodyAsString());
        long startTime = System.currentTimeMillis();
        int lifespan = 3000;
        fullPathKey = Predef$.MODULE$.augmentString("%s-2").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fullPathKey}));
        post = new PostMethod(fullPathKey);
        post.setRequestHeader("Content-Type", "application/text");
        post.setRequestHeader("timeToLiveSeconds", "0");
        post.setRequestHeader("maxIdleTimeSeconds", "0");
        post.setRequestEntity((RequestEntity)new StringRequestEntity("data2", "text/plain", "UTF-8"));
        Client$.MODULE$.call((HttpMethodBase)post);
        while (System.currentTimeMillis() < startTime + (long)lifespan) {
            String response = Client$.MODULE$.call((HttpMethodBase)new GetMethod(fullPathKey)).getResponseBodyAsString();
            if (System.currentTimeMillis() >= startTime + (long)lifespan) continue;
            AssertJUnit.assertEquals((String)"data2", (String)response);
            Thread.sleep(100L);
        }
        this.waitNotFound(startTime, lifespan, fullPathKey);
        AssertJUnit.assertEquals((int)404, (int)Client$.MODULE$.call((HttpMethodBase)new GetMethod(fullPathKey)).getStatusCode());
        startTime = System.currentTimeMillis();
        lifespan = 0;
        fullPathKey = Predef$.MODULE$.augmentString("%s-3").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fullPathKey}));
        post = new PostMethod(fullPathKey);
        post.setRequestHeader("timeToLiveSeconds", "0");
        post.setRequestEntity((RequestEntity)new StringRequestEntity("data3", "text/plain", "UTF-8"));
        Client$.MODULE$.call((HttpMethodBase)post);
        this.waitNotFound(startTime, lifespan, fullPathKey);
        fullPathKey = Predef$.MODULE$.augmentString("%s-4").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fullPathKey}));
        post = new PostMethod(fullPathKey);
        post.setRequestHeader("maxIdleTimeSeconds", "0");
        post.setRequestEntity((RequestEntity)new StringRequestEntity("data4", "text/plain", "UTF-8"));
        Client$.MODULE$.call((HttpMethodBase)post);
        Thread.sleep(2500L);
        AssertJUnit.assertEquals((int)404, (int)Client$.MODULE$.call((HttpMethodBase)new GetMethod(fullPathKey)).getStatusCode());
    }

    public void testPutByteArrayTwice(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PutMethod put = new PutMethod(fullPathKey);
        byte[] data = new byte[]{42, 42, 42};
        put.setRequestEntity((RequestEntity)new ByteArrayRequestEntity(data, "application/x-java-serialized-object"));
        AssertJUnit.assertEquals((int)200, (int)Client$.MODULE$.call((HttpMethodBase)put).getStatusCode());
        HttpMethodBase get = Client$.MODULE$.call((HttpMethodBase)new GetMethod(fullPathKey));
        AssertJUnit.assertEquals((int)200, (int)get.getStatusCode());
        PutMethod reput = new PutMethod(fullPathKey);
        reput.setRequestEntity((RequestEntity)new ByteArrayRequestEntity(data, "application/x-java-serialized-object"));
        AssertJUnit.assertEquals((int)200, (int)Client$.MODULE$.call((HttpMethodBase)reput).getStatusCode());
    }

    public void testDeleteSerializedObject(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PutMethod put = new PutMethod(fullPathKey);
        byte[] data = new byte[]{42, 42, 42};
        put.setRequestEntity((RequestEntity)new ByteArrayRequestEntity(data, "application/x-java-serialized-object"));
        AssertJUnit.assertEquals((int)200, (int)Client$.MODULE$.call((HttpMethodBase)put).getStatusCode());
        HttpMethodBase get = Client$.MODULE$.call((HttpMethodBase)new GetMethod(fullPathKey));
        AssertJUnit.assertEquals((int)200, (int)get.getStatusCode());
        HttpMethodBase delete = Client$.MODULE$.call((HttpMethodBase)new DeleteMethod(fullPathKey));
        AssertJUnit.assertEquals((int)200, (int)delete.getStatusCode());
    }

    private void waitNotFound(long startTime, int lifespan, String fullPathKey) {
        while (System.currentTimeMillis() < startTime + (long)lifespan + 20000L && !((Object)BoxesRunTime.boxToInteger((int)404)).equals(BoxesRunTime.boxToInteger((int)Client$.MODULE$.call((HttpMethodBase)new GetMethod(fullPathKey)).getStatusCode()))) {
            Thread.sleep(100L);
        }
    }

    private HttpMethodBase put(Method m) {
        return this.put(m, "data", "application/text");
    }

    private HttpMethodBase put(Method m, Object data) {
        return this.put(m, data, "application/text");
    }

    private HttpMethodBase put(Method m, Object data, String contentType) {
        Object object;
        block4: {
            StringRequestEntity stringRequestEntity;
            PutMethod put;
            block3: {
                block2: {
                    put = new PutMethod(this.fullPathKey(m));
                    put.setRequestHeader("Content-Type", contentType);
                    object = data;
                    if (!(object instanceof String)) break block2;
                    stringRequestEntity = new StringRequestEntity((String)object);
                    break block3;
                }
                if (!(object instanceof byte[])) break block4;
                stringRequestEntity = new InputStreamRequestEntity((InputStream)new ByteArrayInputStream((byte[])object));
            }
            StringRequestEntity reqEntity = stringRequestEntity;
            put.setRequestEntity((RequestEntity)reqEntity);
            Client$.MODULE$.call((HttpMethodBase)put);
            AssertJUnit.assertEquals((int)200, (int)put.getStatusCode());
            return put;
        }
        throw new MatchError(object);
    }

    private HttpMethodBase get(Method m) {
        return this.get(m, (Option<String>)None$.MODULE$);
    }

    private HttpMethodBase get(Method m, Option<String> unmodSince) {
        return this.get(m, unmodSince, (Option<String>)None$.MODULE$, 200);
    }

    private HttpMethodBase get(Method m, Option<String> unmodSince, Option<String> acceptType) {
        return this.get(m, unmodSince, acceptType, 200);
    }

    private HttpMethodBase get(Method m, Option<String> unmodSince, Option<String> acceptType, int expCode) {
        GetMethod get = new GetMethod(this.fullPathKey(m));
        Option<String> option = unmodSince;
        None$ none$ = None$.MODULE$;
        if (option == null ? none$ != null : !option.equals((Object)none$)) {
            get.setRequestHeader("If-Unmodified-Since", (String)unmodSince.get());
        }
        Option<String> option2 = acceptType;
        None$ none$2 = None$.MODULE$;
        if (option2 == null ? none$2 != null : !option2.equals((Object)none$2)) {
            get.setRequestHeader("Accept", (String)acceptType.get());
        }
        Client$.MODULE$.call((HttpMethodBase)get);
        AssertJUnit.assertEquals((int)expCode, (int)get.getStatusCode());
        return get;
    }

    private String fullPathKey(Method m) {
        return new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
    }

    public String addDay(String aDate, int days) {
        SimpleDateFormat format = new SimpleDateFormat(this.DATE_PATTERN_RFC1123(), Locale.US);
        Date date = format.parse(aDate);
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(5, days);
        return format.format(cal.getTime());
    }

    public IntegrationTest() {
        this.HOST = "http://localhost:8888";
        this.cacheName = "___defaultcache";
        this.DATE_PATTERN_RFC1123 = "EEE, dd MMM yyyy HH:mm:ss zzz";
    }
}

