/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.ByteArrayRequestEntity;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.infinispan.AbstractDelegatingCache;
import org.infinispan.Cache;
import org.infinispan.manager.AbstractDelegatingEmbeddedCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.remoting.MIMECacheEntry;
import org.infinispan.rest.Client$;
import org.infinispan.rest.ManagerInstance$;
import org.infinispan.rest.MyNonSer;
import org.infinispan.rest.MySer;
import org.infinispan.rest.ServerInstance$;
import org.infinispan.server.core.logging.JavaLog;
import org.infinispan.test.TestingUtil;
import org.infinispan.util.logging.LogFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import scala.Array$;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.FutureTaskRunner;
import scala.concurrent.ops$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.xml.Elem;
import scala.xml.MetaData;
import scala.xml.NamespaceBinding;
import scala.xml.NodeBuffer;
import scala.xml.Null$;
import scala.xml.Text;
import scala.xml.TopScope$;

@Test(groups={"functional"}, testName="rest.IntegrationTest")
@ScalaSignature(bytes="\u0006\u0001\r}d\u0001B\u0001\u0003\u0001%\u0011q\"\u00138uK\u001e\u0014\u0018\r^5p]R+7\u000f\u001e\u0006\u0003\u0007\u0011\tAA]3ti*\u0011QAB\u0001\u000bS:4\u0017N\\5ta\u0006t'\"A\u0004\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001Q\u0001CA\u0006\u0011\u001b\u0005a!BA\u0007\u000f\u0003\u0011a\u0017M\\4\u000b\u0003=\tAA[1wC&\u0011\u0011\u0003\u0004\u0002\u0007\u001f\nTWm\u0019;\t\u000bM\u0001A\u0011\u0001\u000b\u0002\rqJg.\u001b;?)\u0005)\u0002C\u0001\f\u0001\u001b\u0005\u0011\u0001\u0002\u0003\r\u0001\u0011\u000b\u0007I\u0011B\r\u0002\u00071|w-F\u0001\u001b!\tY\"%D\u0001\u001d\u0015\tib$A\u0004m_\u001e<\u0017N\\4\u000b\u0005}\u0001\u0013\u0001B2pe\u0016T!!\t\u0003\u0002\rM,'O^3s\u0013\t\u0019CDA\u0004KCZ\fGj\\4\t\u0011\u0015\u0002\u0001\u0012!Q!\ni\tA\u0001\\8hA!9q\u0005\u0001b\u0001\n\u0003A\u0013\u0001\u0002%P'R+\u0012!\u000b\t\u0003\u0017)J!a\u000b\u0007\u0003\rM#(/\u001b8h\u0011\u0019i\u0003\u0001)A\u0005S\u0005)\u0001jT*UA!9q\u0006\u0001b\u0001\n\u0003A\u0013!C2bG\",g*Y7f\u0011\u0019\t\u0004\u0001)A\u0005S\u0005Q1-Y2iK:\u000bW.\u001a\u0011\t\u000fM\u0002!\u0019!C\u0001Q\u0005Aa-\u001e7m!\u0006$\b\u000e\u0003\u00046\u0001\u0001\u0006I!K\u0001\nMVdG\u000eU1uQ\u0002Bqa\u000e\u0001C\u0002\u0013\u0005\u0001&\u0001\u000bE\u0003R+u\fU!U)\u0016\u0013fj\u0018*G\u0007F\n$g\r\u0005\u0007s\u0001\u0001\u000b\u0011B\u0015\u0002+\u0011\u000bE+R0Q\u0003R#VI\u0015(`%\u001a\u001b\u0015'\r\u001a4A!)1\b\u0001C\u0001y\u0005)1/\u001a;VaR\tQ\b\u0005\u0002?\u00036\tqHC\u0001A\u0003\u0015\u00198-\u00197b\u0013\t\u0011uH\u0001\u0003V]&$\bF\u0001\u001eE!\t)%*D\u0001G\u0015\t9\u0005*A\u0006b]:|G/\u0019;j_:\u001c(BA%\u0007\u0003\u0019!Xm\u001d;oO&\u00111J\u0012\u0002\f\u0005\u00164wN]3DY\u0006\u001c8\u000fC\u0003N\u0001\u0011\u0005A(\u0001\u0005uK\u0006\u0014Hi\\<oQ\u0011auJU*\u0011\u0005\u0015\u0003\u0016BA)G\u0005)\te\r^3s\u00072\f7o]\u0001\nC2<\u0018-_:Sk:L\u0012!\u0001\u0005\u0006+\u0002!\tAV\u0001\u0013i\u0016\u001cHOQ1tS\u000e|\u0005/\u001a:bi&|g\u000e\u0006\u0002>/\")\u0001\f\u0016a\u00013\u0006\tQ\u000e\u0005\u0002[;6\t1L\u0003\u0002]\u0019\u00059!/\u001a4mK\u000e$\u0018B\u00010\\\u0005\u0019iU\r\u001e5pI\")\u0001\r\u0001C\u0001y\u0005aA/Z:u\u000b6\u0004H/_$fi\")!\r\u0001C\u0001G\u00069A/Z:u\u000f\u0016$HCA\u001fe\u0011\u0015A\u0016\r1\u0001Z\u0011\u00151\u0007\u0001\"\u0001h\u0003!!Xm\u001d;IK\u0006$GCA\u001fi\u0011\u0015AV\r1\u0001Z\u0011\u0015Q\u0007\u0001\"\u0001l\u0003M!Xm\u001d;HKRLe-\u00168n_\u0012Lg-[3e)\tiD\u000eC\u0003YS\u0002\u0007\u0011\fC\u0003o\u0001\u0011\u0005q.A\tuKN$\bk\\:u\tV\u0004H.[2bi\u0016$\"!\u00109\t\u000bak\u0007\u0019A-\t\u000bI\u0004A\u0011A:\u00023Q,7\u000f\u001e)vi\u0012\u000bG/Y,ji\"$\u0016.\\3U_2Kg/\u001a\u000b\u0003{QDQ\u0001W9A\u0002eCQA\u001e\u0001\u0005\u0002]\f!\u0004^3tiB+H\u000fR1uC^KG\u000f['bq&#G.Z(oYf$\"!\u0010=\t\u000ba+\b\u0019A-\t\u000bi\u0004A\u0011A>\u0002;Q,7\u000f\u001e)vi\u0012\u000bG/Y,ji\"$\u0016.\\3U_2Kg/Z(oYf$\"!\u0010?\t\u000baK\b\u0019A-\t\u000by\u0004A\u0011B@\u00023A,H/\u00118e\u0003N\u001cXM\u001d;Fa\",W.\u001a:bY\u0012\u000bG/\u0019\u000b\b{\u0005\u0005\u00111AA\n\u0011\u0015AV\u00101\u0001Z\u0011\u001d\t)! a\u0001\u0003\u000f\t\u0011\u0003^5nKR{G*\u001b<f'\u0016\u001cwN\u001c3t!\u0011\tI!a\u0004\u000f\u0007y\nY!C\u0002\u0002\u000e}\na\u0001\u0015:fI\u00164\u0017bA\u0016\u0002\u0012)\u0019\u0011QB \t\u000f\u0005UQ\u00101\u0001\u0002\b\u0005\u0011R.\u0019=JI2,G+[7f'\u0016\u001cwN\u001c3t\u0011\u001d\tI\u0002\u0001C\u0001\u00037\ta\u0003^3tiB+H\u000fR1uC^KG\u000f[%g\u001b\u0006$8\r\u001b\u000b\u0004{\u0005u\u0001B\u0002-\u0002\u0018\u0001\u0007\u0011\fC\u0004\u0002\"\u0001!\t!a\t\u00025Q,7\u000f\u001e)vi\u0012\u000bG/Y,ji\"LeMT8oK6\u000bGo\u00195\u0015\u0007u\n)\u0003\u0003\u0004Y\u0003?\u0001\r!\u0017\u0005\b\u0003S\u0001A\u0011AA\u0016\u0003y!Xm\u001d;QkR$\u0015\r^1XSRD\u0017JZ'pI&4\u0017.\u001a3TS:\u001cW\rF\u0002>\u0003[Aa\u0001WA\u0014\u0001\u0004I\u0006bBA\u0019\u0001\u0011\u0005\u00111G\u0001!i\u0016\u001cH\u000fU;u\t\u0006$\u0018mV5uQ&3WK\\'pI&4\u0017.\u001a3TS:\u001cW\rF\u0002>\u0003kAa\u0001WA\u0018\u0001\u0004I\u0006bBA\u001d\u0001\u0011\u0005\u00111H\u0001\u001ai\u0016\u001cH\u000fR3mKR,G)\u0019;b/&$\b.\u00134NCR\u001c\u0007\u000eF\u0002>\u0003{Aa\u0001WA\u001c\u0001\u0004I\u0006bBA!\u0001\u0011\u0005\u00111I\u0001\u001ei\u0016\u001cH\u000fR3mKR,G)\u0019;b/&$\b.\u00134O_:,W*\u0019;dQR\u0019Q(!\u0012\t\ra\u000by\u00041\u0001Z\u0011\u001d\tI\u0005\u0001C\u0001\u0003\u0017\n\u0011\u0005^3ti\u0012+G.\u001a;f\t\u0006$\u0018mV5uQ&3Wj\u001c3jM&,GmU5oG\u0016$2!PA'\u0011\u0019A\u0016q\ta\u00013\"9\u0011\u0011\u000b\u0001\u0005\u0002\u0005M\u0013a\t;fgR$U\r\\3uK\u0012\u000bG/Y,ji\"Le-\u00168n_\u0012Lg-[3e'&t7-\u001a\u000b\u0004{\u0005U\u0003B\u0002-\u0002P\u0001\u0007\u0011\fC\u0004\u0002Z\u0001!\t!a\u0017\u0002QQ,7\u000f\u001e#fY\u0016$XmQ1dQ\u0016\u0004&/Z2p]\u0012LG/[8o+:LW\u000e\u001d7f[\u0016tG/\u001a3\u0015\u0007u\ni\u0006\u0003\u0004Y\u0003/\u0002\r!\u0017\u0005\b\u0003C\u0002A\u0011BA2\u0003\u0015\"Xm\u001d;EK2,G/\u001a)sK\u000e|g\u000eZ5uS>t\u0017\r\\+oS6\u0004H.Z7f]R,G\rF\u0002>\u0003KB\u0001\"a\u001a\u0002`\u0001\u0007\u0011qA\u0001\fMVdG\u000eU1uQ.+\u0017\u0010C\u0004\u0002b\u0001!I!a\u001b\u0015\u000bu\ni'a\u001c\t\u0011\u0005\u001d\u0014\u0011\u000ea\u0001\u0003\u000fA\u0001\"!\u001d\u0002j\u0001\u0007\u0011qA\u0001\u0019aJ,7m\u001c8eSRLwN\\1m\u0011\u0016\fG-\u001a:OC6,\u0007bBA;\u0001\u0011%\u0011qO\u0001\u0015CN\u001cXM\u001d;O_RLU\u000e\u001d7f[\u0016tG/\u001a3\u0015\u0007u\nI\b\u0003\u0005\u0002|\u0005M\u0004\u0019AA?\u0003\u0019iW\r\u001e5pIB!\u0011qPAG\u001b\t\t\tI\u0003\u0003\u0002\u0004\u0006\u0015\u0015A\u00035uiB\u001cG.[3oi*!\u0011qQAE\u0003\u001d\u0019w.\\7p]NT1!a#\u0007\u0003\u0019\t\u0007/Y2iK&!\u0011qRAA\u0005)AE\u000f\u001e9NKRDw\u000e\u001a\u0005\b\u0003'\u0003A\u0011AAK\u0003=!Xm\u001d;SK6|g/Z#oiJLHcA\u001f\u0002\u0018\"1\u0001,!%A\u0002eCq!a'\u0001\t\u0003\ti*A\nuKN$x+\u001b9f\u0007\u0006\u001c\u0007.\u001a\"vG.,G\u000fF\u0002>\u0003?Ca\u0001WAM\u0001\u0004I\u0006bBAR\u0001\u0011\u0005\u0011QU\u0001\u0013i\u0016\u001cH/Q:z]\u000e\fE\r\u001a*f[>4X\rF\u0002>\u0003OCa\u0001WAQ\u0001\u0004I\u0006bBAV\u0001\u0011\u0005\u0011QV\u0001\u001fi\u0016\u001cHo\u00155pk2$7i\u001c9f/&$\bnU3sS\u0006d\u0017N_1cY\u0016$2!PAX\u0011\u0019A\u0016\u0011\u0016a\u00013\"9\u00111\u0017\u0001\u0005\u0002\u0005U\u0016!\b;fgRLen]3siN+'/[1mSj\f'\r\\3PE*,7\r^:\u0015\u0007u\n9\f\u0003\u0004Y\u0003c\u0003\r!\u0017\u0005\b\u0003w\u0003A\u0011AA_\u0003Q!Xm\u001d;O_:,\u00070[:uK:$8)Y2iKR\u0019Q(a0\t\ra\u000bI\f1\u0001Z\u0011\u001d\t\u0019\r\u0001C\u0001\u0003\u000b\f\u0001\u0005^3ti\nKH/Z!se\u0006L\u0018i]*fe&\fG.\u001b>fI>\u0013'.Z2ugR\u0019Q(a2\t\ra\u000b\t\r1\u0001Z\u0011\u001d\tY\r\u0001C\u0001\u0003\u001b\f\u0011\u0005^3ti\nKH/Z!se\u0006L\u0018i](di\u0016\u001c7\u000b\u001e:fC6|%M[3diN$2!PAh\u0011\u0019A\u0016\u0011\u001aa\u00013\"9\u00111\u001b\u0001\u0005\n\u0005U\u0017aD:f]\u0012\u0014\u0015\u0010^3BeJ\f\u00170Q:\u0015\u000bu\n9.!7\t\ra\u000b\t\u000e1\u0001Z\u0011!\tY.!5A\u0002\u0005\u001d\u0011aC2p]R,g\u000e\u001e+za\u0016Dq!a8\u0001\t\u0003\t\t/A\u000buKN$\u0018JZ+o[>$\u0017NZ5fINKgnY3\u0015\u0007u\n\u0019\u000f\u0003\u0004Y\u0003;\u0004\r!\u0017\u0005\b\u0003O\u0004A\u0011AAu\u0003=!Xm\u001d;F)\u0006<7\t[1oO\u0016\u001cHcA\u001f\u0002l\"1\u0001,!:A\u0002eCq!a<\u0001\t\u0003\t\t0A\ruKN$8i\u001c8dkJ\u0014XM\u001c;F)\u0006<7\t[1oO\u0016\u001cHcA\u001f\u0002t\"1\u0001,!<A\u0002eCq!a>\u0001\t\u0003\tI0\u0001\u000fuKN$8+\u001a:jC2L'0\u001a3TiJLgnZ$fi\nKH/Z:\u0015\u0007u\nY\u0010\u0003\u0004Y\u0003k\u0004\r!\u0017\u0005\b\u0003\u007f\u0004A\u0011\u0001B\u0001\u0003\u0005\"Xm\u001d;EK\u001a\fW\u000f\u001c;D_:4\u0017nZ;sK\u0012,\u0005\u0010]5ssZ\u000bG.^3t)\ri$1\u0001\u0005\u00071\u0006u\b\u0019A-\t\u000f\t\u001d\u0001\u0001\"\u0001\u0003\n\u0005)B/Z:u!V$()\u001f;f\u0003J\u0014\u0018-\u001f+xS\u000e,GcA\u001f\u0003\f!1\u0001L!\u0002A\u0002eCqAa\u0004\u0001\t\u0003\u0011\t\"\u0001\u000euKN$H)\u001a7fi\u0016\u001cVM]5bY&TX\rZ(cU\u0016\u001cG\u000fF\u0002>\u0005'Aa\u0001\u0017B\u0007\u0001\u0004I\u0006b\u0002B\f\u0001\u0011%!\u0011D\u0001\ro\u0006LGOT8u\r>,h\u000e\u001a\u000b\b{\tm!Q\u0005B\u0018\u0011!\u0011iB!\u0006A\u0002\t}\u0011!C:uCJ$H+[7f!\rq$\u0011E\u0005\u0004\u0005Gy$\u0001\u0002'p]\u001eD\u0001Ba\n\u0003\u0016\u0001\u0007!\u0011F\u0001\tY&4Wm\u001d9b]B\u0019aHa\u000b\n\u0007\t5rHA\u0002J]RD\u0001\"a\u001a\u0003\u0016\u0001\u0007\u0011q\u0001\u0005\b\u0005g\u0001A\u0011\u0002B\u001b\u0003\r\u0001X\u000f\u001e\u000b\u0005\u0005o\u0011i\u0004\u0005\u0003\u0002\u0000\te\u0012\u0002\u0002B\u001e\u0003\u0003\u0013a\u0002\u0013;ua6+G\u000f[8e\u0005\u0006\u001cX\r\u0003\u0004Y\u0005c\u0001\r!\u0017\u0005\b\u0005g\u0001A\u0011\u0002B!)\u0019\u00119Da\u0011\u0003F!1\u0001La\u0010A\u0002eC\u0001Ba\u0012\u0003@\u0001\u0007!\u0011J\u0001\u0005I\u0006$\u0018\rE\u0002?\u0005\u0017J1A!\u0014@\u0005\r\te.\u001f\u0005\b\u0005g\u0001A\u0011\u0002B))!\u00119Da\u0015\u0003V\t]\u0003B\u0002-\u0003P\u0001\u0007\u0011\f\u0003\u0005\u0003H\t=\u0003\u0019\u0001B%\u0011!\tYNa\u0014A\u0002\u0005\u001d\u0001b\u0002B.\u0001\u0011%!QL\u0001\u0004O\u0016$H\u0003\u0002B\u001c\u0005?Ba\u0001\u0017B-\u0001\u0004I\u0006b\u0002B.\u0001\u0011%!1\r\u000b\u0007\u0005o\u0011)Ga\u001a\t\ra\u0013\t\u00071\u0001Z\u0011!\u0011IG!\u0019A\u0002\t-\u0014AC;o[>$7+\u001b8dKB)aH!\u001c\u0002\b%\u0019!qN \u0003\r=\u0003H/[8o\u0011\u001d\u0011Y\u0006\u0001C\u0005\u0005g\"\u0002Ba\u000e\u0003v\t]$\u0011\u0010\u0005\u00071\nE\u0004\u0019A-\t\u0011\t%$\u0011\u000fa\u0001\u0005WB\u0001Ba\u001f\u0003r\u0001\u0007!1N\u0001\u000bC\u000e\u001cW\r\u001d;UsB,\u0007b\u0002B.\u0001\u0011%!q\u0010\u000b\u000b\u0005o\u0011\tIa!\u0003\u0006\n\u001d\u0005B\u0002-\u0003~\u0001\u0007\u0011\f\u0003\u0005\u0003j\tu\u0004\u0019\u0001B6\u0011!\u0011YH! A\u0002\t-\u0004\u0002\u0003BE\u0005{\u0002\rA!\u000b\u0002\u000f\u0015D\boQ8eK\"9\u0011q\r\u0001\u0005\n\t5E\u0003BA\u0004\u0005\u001fCa\u0001\u0017BF\u0001\u0004I\u0006b\u0002BJ\u0001\u0011\u0005!QS\u0001\u0007C\u0012$G)Y=\u0015\r\u0005\u001d!q\u0013BN\u0011!\u0011IJ!%A\u0002\u0005\u001d\u0011!B1ECR,\u0007\u0002\u0003BO\u0005#\u0003\rA!\u000b\u0002\t\u0011\f\u0017p\u001d\u0004\u0007\u0005C\u0003\u0001Aa)\u0003-\r{g\u000e\u001e:pY2,GmQ1dQ\u0016l\u0015M\\1hKJ\u001cBAa(\u0003&B!!q\u0015BW\u001b\t\u0011IKC\u0002\u0003,\u0012\tq!\\1oC\u001e,'/\u0003\u0003\u00030\n%&AJ!cgR\u0014\u0018m\u0019;EK2,w-\u0019;j]\u001e,UNY3eI\u0016$7)Y2iK6\u000bg.Y4fe\"Y!1\u0017BP\u0005\u0003\u0005\u000b\u0011\u0002B[\u0003\t\u0019W\u000e\u0005\u0003\u0003(\n]\u0016\u0002\u0002B]\u0005S\u0013A#R7cK\u0012$W\rZ\"bG\",W*\u00198bO\u0016\u0014\bb\u0003B_\u0005?\u0013\t\u0011)A\u0005\u0005\u007f\u000b!B\u001e\u001aQkRd\u0015\r^2i!\u0011\u0011\tMa3\u000e\u0005\t\r'\u0002\u0002Bc\u0005\u000f\f!bY8oGV\u0014(/\u001a8u\u0015\r\u0011IMD\u0001\u0005kRLG.\u0003\u0003\u0003N\n\r'AD\"pk:$Hi\\<o\u0019\u0006$8\r\u001b\u0005\f\u0005#\u0014yJ!A!\u0002\u0013\u0011y,\u0001\u0006wgA+H\u000fT1uG\"D1B!6\u0003 \n\u0005\t\u0015!\u0003\u0003@\u0006iaO\r$j]&\u001c\b\u000eT1uG\"Dqa\u0005BP\t\u0003\u0011I\u000e\u0006\u0006\u0003\\\n}'\u0011\u001dBr\u0005K\u0004BA!8\u0003 6\t\u0001\u0001\u0003\u0005\u00034\n]\u0007\u0019\u0001B[\u0011!\u0011iLa6A\u0002\t}\u0006\u0002\u0003Bi\u0005/\u0004\rAa0\t\u0011\tU'q\u001ba\u0001\u0005\u007fC\u0001B!;\u0003 \u0012\u0005#1^\u0001\tO\u0016$8)Y2iKV1!Q\u001eB~\u0007\u0013!\"Aa<\u0011\u0011\tE(1\u001fB|\u0007\u000fi\u0011\u0001B\u0005\u0004\u0005k$!!B\"bG\",\u0007\u0003\u0002B}\u0005wd\u0001\u0001\u0002\u0005\u0003~\n\u001d(\u0019\u0001B\u0000\u0005\u0005Y\u0015\u0003BB\u0001\u0005\u0013\u00022APB\u0002\u0013\r\u0019)a\u0010\u0002\b\u001d>$\b.\u001b8h!\u0011\u0011Ip!\u0003\u0005\u0011\r-!q\u001db\u0001\u0005\u007f\u0014\u0011A\u0016\u0004\u0007\u0007\u001f\u0001\u0001a!\u0005\u0003\u001f\r{g\u000e\u001e:pY2,GmQ1dQ\u0016,baa\u0005\u0004\u001e\r\u00052\u0003BB\u0007\u0007+\u0001\u0002B!=\u0004\u0018\rm1qD\u0005\u0004\u00073!!aF!cgR\u0014\u0018m\u0019;EK2,w-\u0019;j]\u001e\u001c\u0015m\u00195f!\u0011\u0011Ip!\b\u0005\u000f-\u001aiA1\u0001\u0003\u0000B!!\u0011`B\u0011\t!\u0011ie!\u0004C\u0002\t}\bbCB\u0013\u0007\u001b\u0011\t\u0011)A\u0005\u0007O\tQaY1dQ\u0016\u0004\u0002B!=\u0003t\u000em1q\u0004\u0005\f\u0005{\u001biA!A!\u0002\u0013\u0011y\fC\u0006\u0003R\u000e5!\u0011!Q\u0001\n\t}\u0006b\u0003Bk\u0007\u001b\u0011\t\u0011)A\u0005\u0005\u007fCqaEB\u0007\t\u0003\u0019\t\u0004\u0006\u0006\u00044\rU2qGB\u001d\u0007w\u0001\u0002B!8\u0004\u000e\rm1q\u0004\u0005\t\u0007K\u0019y\u00031\u0001\u0004(!A!QXB\u0018\u0001\u0004\u0011y\f\u0003\u0005\u0003R\u000e=\u0002\u0019\u0001B`\u0011!\u0011)na\fA\u0002\t}\u0006\u0002CB \u0007\u001b!\te!\u0011\u0002\u000fI,\u0007\u000f\\1dKR\u000121IB%\u0007\u001b\u001a\tf!\u0016\u0004X\r\u00054Q\r\t\u0004}\r\u0015\u0013bAB$\u007f\t9!i\\8mK\u0006t\u0007\u0002CB&\u0007{\u0001\raa\u0007\u0002\u0007-,\u0017\u0010\u0003\u0005\u0004P\ru\u0002\u0019AB\u0010\u0003!yG\u000e\u001a,bYV,\u0007\u0002CB*\u0007{\u0001\raa\b\u0002\u000bY\fG.^3\t\u0011\t\u001d2Q\ba\u0001\u0005?A\u0001b!\u0017\u0004>\u0001\u000711L\u0001\rY&4Wm\u001d9b]Vs\u0017\u000e\u001e\t\u0005\u0005\u0003\u001ci&\u0003\u0003\u0004`\t\r'\u0001\u0003+j[\u0016,f.\u001b;\t\u0011\r\r4Q\ba\u0001\u0005?\t1\"\\1y\u0013\u0012dW\rV5nK\"A1qMB\u001f\u0001\u0004\u0019Y&A\bnCbLE\r\\3US6,WK\\5uQ-\u000111NB9\u0007g\u001aIha\u001f\u0011\u0007\u0015\u001bi'C\u0002\u0004p\u0019\u0013A\u0001V3ti\u00061qM]8vaNd#a!\u001e\"\u0005\r]\u0014A\u00034v]\u000e$\u0018n\u001c8bY\u0006AA/Z:u\u001d\u0006lW-\t\u0002\u0004~\u0005!\"/Z:u]%sG/Z4sCRLwN\u001c+fgR\u0004")
public class IntegrationTest {
    private JavaLog org$infinispan$rest$IntegrationTest$$log;
    private final String HOST;
    private final String cacheName;
    private final String fullPath = new StringBuilder().append((Object)this.HOST()).append((Object)"/rest/").append((Object)this.cacheName()).toString();
    private final String DATE_PATTERN_RFC1123;
    private volatile boolean bitmap$0;

    private JavaLog org$infinispan$rest$IntegrationTest$$log$lzycompute() {
        IntegrationTest integrationTest = this;
        synchronized (integrationTest) {
            if (!this.bitmap$0) {
                this.org$infinispan$rest$IntegrationTest$$log = (JavaLog)LogFactory.getLog(this.getClass(), JavaLog.class);
                this.bitmap$0 = true;
            }
            return this.org$infinispan$rest$IntegrationTest$$log;
        }
    }

    public JavaLog org$infinispan$rest$IntegrationTest$$log() {
        return this.bitmap$0 ? this.org$infinispan$rest$IntegrationTest$$log : this.org$infinispan$rest$IntegrationTest$$log$lzycompute();
    }

    public String HOST() {
        return this.HOST;
    }

    public String cacheName() {
        return this.cacheName;
    }

    public String fullPath() {
        return this.fullPath;
    }

    public String DATE_PATTERN_RFC1123() {
        return this.DATE_PATTERN_RFC1123;
    }

    @BeforeClass
    public void setUp() {
        ServerInstance$.MODULE$.start();
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        ServerInstance$.MODULE$.stop();
        AssertJUnit.assertNull((Object)ManagerInstance$.MODULE$.instance());
    }

    public void testBasicOperation(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PutMethod insert = new PutMethod(fullPathKey);
        TopScope$ topScope$ = Predef$.MODULE$.$scope();
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("ho"));
        Elem initialXML = new Elem(null, "hey", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$, false, (Seq)$buf);
        insert.setRequestEntity((RequestEntity)new ByteArrayRequestEntity(initialXML.toString().getBytes(), "application/octet-stream"));
        Client$.MODULE$.call((HttpMethodBase)insert);
        AssertJUnit.assertEquals((String)"", (String)insert.getResponseBodyAsString().trim());
        AssertJUnit.assertEquals((int)200, (int)insert.getStatusCode());
        GetMethod get = new GetMethod(fullPathKey);
        Client$.MODULE$.call((HttpMethodBase)get);
        byte[] bytes = get.getResponseBody();
        AssertJUnit.assertEquals((int)Predef$.MODULE$.byteArrayOps(bytes).size(), (int)Predef$.MODULE$.byteArrayOps(initialXML.toString().getBytes()).size());
        TopScope$ topScope$2 = Predef$.MODULE$.$scope();
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("ho"));
        AssertJUnit.assertEquals((String)new Elem(null, "hey", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$2, false, (Seq)$buf2).toString(), (String)get.getResponseBodyAsString());
        Header hdr = get.getResponseHeader("Content-Type");
        AssertJUnit.assertEquals((String)"application/octet-stream", (String)hdr.getValue());
        DeleteMethod remove = new DeleteMethod(fullPathKey);
        Client$.MODULE$.call((HttpMethodBase)remove);
        Client$.MODULE$.call((HttpMethodBase)get);
        AssertJUnit.assertEquals((int)404, (int)get.getStatusCode());
        Client$.MODULE$.call((HttpMethodBase)insert);
        Client$.MODULE$.call((HttpMethodBase)get);
        TopScope$ topScope$3 = Predef$.MODULE$.$scope();
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)new Text("ho"));
        AssertJUnit.assertEquals((String)new Elem(null, "hey", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$3, false, (Seq)$buf3).toString(), (String)get.getResponseBodyAsString());
        DeleteMethod removeAll = new DeleteMethod(this.fullPath());
        AssertJUnit.assertEquals((int)200, (int)Client$.MODULE$.call((HttpMethodBase)removeAll).getStatusCode());
        Client$.MODULE$.call((HttpMethodBase)get);
        AssertJUnit.assertEquals((int)404, (int)get.getStatusCode());
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        ObjectOutputStream oo = new ObjectOutputStream(bout);
        oo.writeObject(new MIMECacheEntry("foo", "hey".getBytes()));
        oo.flush();
        byte[] byteData = bout.toByteArray();
        PutMethod insertMore = new PutMethod(fullPathKey);
        insertMore.setRequestEntity((RequestEntity)new ByteArrayRequestEntity(byteData, "application/octet-stream"));
        Client$.MODULE$.call((HttpMethodBase)insertMore);
        GetMethod getMore = new GetMethod(fullPathKey);
        Client$.MODULE$.call((HttpMethodBase)getMore);
        byte[] bytesBack = getMore.getResponseBody();
        AssertJUnit.assertEquals((int)byteData.length, (int)bytesBack.length);
        ObjectInputStream oin = new ObjectInputStream(new ByteArrayInputStream(bytesBack));
        MIMECacheEntry ce = (MIMECacheEntry)oin.readObject();
        AssertJUnit.assertEquals((String)"foo", (String)ce.contentType);
    }

    public void testEmptyGet() {
        AssertJUnit.assertEquals((int)404, (int)Client$.MODULE$.call((HttpMethodBase)new GetMethod(new StringBuilder().append((Object)this.HOST()).append((Object)"/rest/").append((Object)this.cacheName()).append((Object)"/nodata").toString())).getStatusCode());
    }

    public void testGet(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PostMethod post = new PostMethod(fullPathKey);
        post.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", null));
        Client$.MODULE$.call((HttpMethodBase)post);
        HttpMethodBase get = Client$.MODULE$.call((HttpMethodBase)new GetMethod(fullPathKey));
        AssertJUnit.assertEquals((int)200, (int)get.getStatusCode());
        AssertJUnit.assertNotNull((Object)get.getResponseHeader("ETag").getValue());
        AssertJUnit.assertNotNull((Object)get.getResponseHeader("Last-Modified").getValue());
        AssertJUnit.assertEquals((String)"application/text", (String)get.getResponseHeader("Content-Type").getValue());
        AssertJUnit.assertEquals((String)"data", (String)get.getResponseBodyAsString());
    }

    public void testHead(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PostMethod post = new PostMethod(fullPathKey);
        post.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", null));
        Client$.MODULE$.call((HttpMethodBase)post);
        HttpMethodBase get = Client$.MODULE$.call((HttpMethodBase)new HeadMethod(fullPathKey));
        AssertJUnit.assertEquals((int)200, (int)get.getStatusCode());
        AssertJUnit.assertNotNull((Object)get.getResponseHeader("ETag").getValue());
        AssertJUnit.assertNotNull((Object)get.getResponseHeader("Last-Modified").getValue());
        AssertJUnit.assertEquals((String)"application/text", (String)get.getResponseHeader("Content-Type").getValue());
        AssertJUnit.assertNull((Object)get.getResponseBodyAsString());
    }

    public void testGetIfUnmodified(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PostMethod post = new PostMethod(fullPathKey);
        post.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", null));
        Client$.MODULE$.call((HttpMethodBase)post);
        HttpMethodBase get = Client$.MODULE$.call((HttpMethodBase)new GetMethod(fullPathKey));
        AssertJUnit.assertEquals((int)200, (int)get.getStatusCode());
        AssertJUnit.assertNotNull((Object)get.getResponseHeader("ETag").getValue());
        String lastMod = get.getResponseHeader("Last-Modified").getValue();
        AssertJUnit.assertNotNull((Object)lastMod);
        AssertJUnit.assertEquals((String)"application/text", (String)get.getResponseHeader("Content-Type").getValue());
        AssertJUnit.assertEquals((String)"data", (String)get.getResponseBodyAsString());
        GetMethod getAgain = new GetMethod(fullPathKey);
        getAgain.addRequestHeader("If-Unmodified-Since", lastMod);
        get = Client$.MODULE$.call((HttpMethodBase)getAgain);
        AssertJUnit.assertEquals((int)200, (int)get.getStatusCode());
        AssertJUnit.assertNotNull((Object)get.getResponseHeader("ETag").getValue());
        AssertJUnit.assertNotNull((Object)get.getResponseHeader("Last-Modified").getValue());
        AssertJUnit.assertEquals((String)"application/text", (String)get.getResponseHeader("Content-Type").getValue());
        AssertJUnit.assertEquals((String)"data", (String)get.getResponseBodyAsString());
    }

    public void testPostDuplicate(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PostMethod post = new PostMethod(fullPathKey);
        post.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        Client$.MODULE$.call((HttpMethodBase)post);
        AssertJUnit.assertEquals((int)409, (int)Client$.MODULE$.call((HttpMethodBase)post).getStatusCode());
        PutMethod put = new PutMethod(fullPathKey);
        put.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        AssertJUnit.assertEquals((int)200, (int)Client$.MODULE$.call((HttpMethodBase)put).getStatusCode());
    }

    public void testPutDataWithTimeToLive(Method m) {
        this.putAndAssertEphemeralData(m, "2", "3");
    }

    public void testPutDataWithMaxIdleOnly(Method m) {
        this.putAndAssertEphemeralData(m, "", "3");
    }

    public void testPutDataWithTimeToLiveOnly(Method m) {
        this.putAndAssertEphemeralData(m, "3", "");
    }

    private void putAndAssertEphemeralData(Method m, String timeToLiveSeconds, String maxIdleTimeSeconds) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PostMethod post = new PostMethod(fullPathKey);
        int maxWaitTime = 0;
        if (!timeToLiveSeconds.isEmpty()) {
            maxWaitTime = package$.MODULE$.max(maxWaitTime, new StringOps(Predef$.MODULE$.augmentString(timeToLiveSeconds)).toInt());
            post.setRequestHeader("timeToLiveSeconds", timeToLiveSeconds);
        }
        if (!maxIdleTimeSeconds.isEmpty()) {
            maxWaitTime = package$.MODULE$.max(maxWaitTime, new StringOps(Predef$.MODULE$.augmentString(maxIdleTimeSeconds)).toInt());
            post.setRequestHeader("maxIdleTimeSeconds", maxIdleTimeSeconds);
        }
        post.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        Client$.MODULE$.call((HttpMethodBase)post);
        HttpMethodBase get = Client$.MODULE$.call((HttpMethodBase)new GetMethod(fullPathKey));
        AssertJUnit.assertEquals((String)"data", (String)get.getResponseBodyAsString());
        TestingUtil.sleepThread((long)((maxWaitTime + 1) * 1000));
        Client$.MODULE$.call(get);
        AssertJUnit.assertEquals((int)404, (int)get.getStatusCode());
    }

    public void testPutDataWithIfMatch(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PutMethod put = new PutMethod(fullPathKey);
        put.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        Client$.MODULE$.call((HttpMethodBase)put);
        HttpMethodBase get = Client$.MODULE$.call((HttpMethodBase)new GetMethod(fullPathKey));
        AssertJUnit.assertEquals((int)200, (int)get.getStatusCode());
        String etag = get.getResponseHeader("ETag").getValue();
        PutMethod reput = new PutMethod(fullPathKey);
        reput.setRequestHeader("If-Match", etag);
        reput.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        AssertJUnit.assertEquals((int)200, (int)Client$.MODULE$.call((HttpMethodBase)reput).getStatusCode());
        PutMethod reputAgain = new PutMethod(fullPathKey);
        reputAgain.setRequestHeader("If-Match", "x");
        reputAgain.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        AssertJUnit.assertEquals((int)412, (int)Client$.MODULE$.call((HttpMethodBase)reputAgain).getStatusCode());
    }

    public void testPutDataWithIfNoneMatch(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PutMethod put = new PutMethod(fullPathKey);
        put.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        Client$.MODULE$.call((HttpMethodBase)put);
        HttpMethodBase get = Client$.MODULE$.call((HttpMethodBase)new GetMethod(fullPathKey));
        AssertJUnit.assertEquals((int)200, (int)get.getStatusCode());
        String etag = get.getResponseHeader("ETag").getValue();
        PutMethod reput = new PutMethod(fullPathKey);
        reput.setRequestHeader("If-None-Match", "x");
        reput.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        AssertJUnit.assertEquals((int)200, (int)Client$.MODULE$.call((HttpMethodBase)reput).getStatusCode());
        PutMethod reputAgain = new PutMethod(fullPathKey);
        reputAgain.setRequestHeader("If-None-Match", etag);
        reputAgain.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        AssertJUnit.assertEquals((int)412, (int)Client$.MODULE$.call((HttpMethodBase)reputAgain).getStatusCode());
    }

    public void testPutDataWithIfModifiedSince(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PutMethod put = new PutMethod(fullPathKey);
        put.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        Client$.MODULE$.call((HttpMethodBase)put);
        HttpMethodBase get = Client$.MODULE$.call((HttpMethodBase)new GetMethod(fullPathKey));
        AssertJUnit.assertEquals((int)200, (int)get.getStatusCode());
        String lastMod = get.getResponseHeader("Last-Modified").getValue();
        PutMethod reput = new PutMethod(fullPathKey);
        reput.setRequestHeader("If-Modified-Since", lastMod);
        reput.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        AssertJUnit.assertEquals((int)304, (int)Client$.MODULE$.call((HttpMethodBase)reput).getStatusCode());
        PutMethod reputAgain = new PutMethod(fullPathKey);
        String dateMinus = this.addDay(lastMod, -1);
        reputAgain.setRequestHeader("If-Modified-Since", dateMinus);
        reputAgain.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        AssertJUnit.assertEquals((int)200, (int)Client$.MODULE$.call((HttpMethodBase)reputAgain).getStatusCode());
    }

    public void testPutDataWithIfUnModifiedSince(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PutMethod put = new PutMethod(fullPathKey);
        put.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        Client$.MODULE$.call((HttpMethodBase)put);
        HttpMethodBase get = Client$.MODULE$.call((HttpMethodBase)new GetMethod(fullPathKey));
        AssertJUnit.assertEquals((int)200, (int)get.getStatusCode());
        String lastMod = get.getResponseHeader("Last-Modified").getValue();
        PutMethod reput = new PutMethod(fullPathKey);
        String dateMinus = this.addDay(lastMod, -1);
        reput.setRequestHeader("If-Unmodified-Since", dateMinus);
        reput.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        AssertJUnit.assertEquals((int)412, (int)Client$.MODULE$.call((HttpMethodBase)reput).getStatusCode());
        PutMethod reputAgain = new PutMethod(fullPathKey);
        reputAgain.setRequestHeader("If-Unmodified-Since", lastMod);
        reputAgain.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        AssertJUnit.assertEquals((int)200, (int)Client$.MODULE$.call((HttpMethodBase)reputAgain).getStatusCode());
    }

    public void testDeleteDataWithIfMatch(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PutMethod put = new PutMethod(fullPathKey);
        put.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        Client$.MODULE$.call((HttpMethodBase)put);
        HttpMethodBase get = Client$.MODULE$.call((HttpMethodBase)new GetMethod(fullPathKey));
        AssertJUnit.assertEquals((int)200, (int)get.getStatusCode());
        String etag = get.getResponseHeader("ETag").getValue();
        DeleteMethod delete = new DeleteMethod(fullPathKey);
        delete.setRequestHeader("If-Match", "x");
        AssertJUnit.assertEquals((int)412, (int)Client$.MODULE$.call((HttpMethodBase)delete).getStatusCode());
        DeleteMethod deleteAgain = new DeleteMethod(fullPathKey);
        deleteAgain.setRequestHeader("If-Match", etag);
        AssertJUnit.assertEquals((int)200, (int)Client$.MODULE$.call((HttpMethodBase)deleteAgain).getStatusCode());
    }

    public void testDeleteDataWithIfNoneMatch(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PutMethod put = new PutMethod(fullPathKey);
        put.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        Client$.MODULE$.call((HttpMethodBase)put);
        HttpMethodBase get = Client$.MODULE$.call((HttpMethodBase)new GetMethod(fullPathKey));
        AssertJUnit.assertEquals((int)200, (int)get.getStatusCode());
        String etag = get.getResponseHeader("ETag").getValue();
        DeleteMethod delete = new DeleteMethod(fullPathKey);
        delete.setRequestHeader("If-None-Match", etag);
        AssertJUnit.assertEquals((int)412, (int)Client$.MODULE$.call((HttpMethodBase)delete).getStatusCode());
        DeleteMethod deleteAgain = new DeleteMethod(fullPathKey);
        deleteAgain.setRequestHeader("If-None-Match", "x");
        AssertJUnit.assertEquals((int)200, (int)Client$.MODULE$.call((HttpMethodBase)deleteAgain).getStatusCode());
    }

    public void testDeleteDataWithIfModifiedSince(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PutMethod put = new PutMethod(fullPathKey);
        put.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        Client$.MODULE$.call((HttpMethodBase)put);
        HttpMethodBase get = Client$.MODULE$.call((HttpMethodBase)new GetMethod(fullPathKey));
        AssertJUnit.assertEquals((int)200, (int)get.getStatusCode());
        String lastMod = get.getResponseHeader("Last-Modified").getValue();
        DeleteMethod delete = new DeleteMethod(fullPathKey);
        delete.setRequestHeader("If-Modified-Since", lastMod);
        AssertJUnit.assertEquals((int)304, (int)Client$.MODULE$.call((HttpMethodBase)delete).getStatusCode());
        DeleteMethod deleteAgain = new DeleteMethod(fullPathKey);
        String dateMinus = this.addDay(lastMod, -1);
        deleteAgain.setRequestHeader("If-Modified-Since", dateMinus);
        AssertJUnit.assertEquals((int)200, (int)Client$.MODULE$.call((HttpMethodBase)deleteAgain).getStatusCode());
    }

    public void testDeleteDataWithIfUnmodifiedSince(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PutMethod put = new PutMethod(fullPathKey);
        put.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        Client$.MODULE$.call((HttpMethodBase)put);
        HttpMethodBase get = Client$.MODULE$.call((HttpMethodBase)new GetMethod(fullPathKey));
        AssertJUnit.assertEquals((int)200, (int)get.getStatusCode());
        String lastMod = get.getResponseHeader("Last-Modified").getValue();
        DeleteMethod delete = new DeleteMethod(fullPathKey);
        String dateMinus = this.addDay(lastMod, -1);
        delete.setRequestHeader("If-Unmodified-Since", dateMinus);
        AssertJUnit.assertEquals((int)412, (int)Client$.MODULE$.call((HttpMethodBase)delete).getStatusCode());
        DeleteMethod deleteAgain = new DeleteMethod(fullPathKey);
        deleteAgain.setRequestHeader("If-Unmodified-Since", lastMod);
        AssertJUnit.assertEquals((int)200, (int)Client$.MODULE$.call((HttpMethodBase)deleteAgain).getStatusCode());
    }

    public void testDeleteCachePreconditionUnimplemented(Method m) {
        this.testDeletePreconditionalUnimplemented(this.fullPath());
    }

    private void testDeletePreconditionalUnimplemented(String fullPathKey) {
        this.testDeletePreconditionalUnimplemented(fullPathKey, "If-Match");
        this.testDeletePreconditionalUnimplemented(fullPathKey, "If-None-Match");
        this.testDeletePreconditionalUnimplemented(fullPathKey, "If-Modified-Since");
        this.testDeletePreconditionalUnimplemented(fullPathKey, "If-Unmodified-Since");
    }

    private void testDeletePreconditionalUnimplemented(String fullPathKey, String preconditionalHeaderName) {
        DeleteMethod delete = new DeleteMethod(fullPathKey);
        delete.setRequestHeader(preconditionalHeaderName, "*");
        Client$.MODULE$.call((HttpMethodBase)delete);
        this.assertNotImplemented((HttpMethod)delete);
    }

    private void assertNotImplemented(HttpMethod method) {
        AssertJUnit.assertEquals((int)method.getStatusCode(), (int)501);
        AssertJUnit.assertEquals((String)method.getStatusText(), (String)"Not Implemented");
        Predef$.MODULE$.assert(method.getResponseBodyAsString().toLowerCase().contains("precondition"));
    }

    public void testRemoveEntry(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PostMethod put = new PostMethod(fullPathKey);
        put.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        Client$.MODULE$.call((HttpMethodBase)put);
        AssertJUnit.assertEquals((int)200, (int)Client$.MODULE$.call((HttpMethodBase)new HeadMethod(fullPathKey)).getStatusCode());
        Client$.MODULE$.call((HttpMethodBase)new DeleteMethod(fullPathKey));
        AssertJUnit.assertEquals((int)404, (int)Client$.MODULE$.call((HttpMethodBase)new HeadMethod(fullPathKey)).getStatusCode());
    }

    public void testWipeCacheBucket(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PostMethod put = new PostMethod(fullPathKey);
        put.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        Client$.MODULE$.call((HttpMethodBase)put);
        PostMethod put_ = new PostMethod(new StringBuilder().append((Object)fullPathKey).append((Object)"2").toString());
        put_.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        Client$.MODULE$.call((HttpMethodBase)put_);
        AssertJUnit.assertEquals((int)200, (int)Client$.MODULE$.call((HttpMethodBase)new HeadMethod(fullPathKey)).getStatusCode());
        Client$.MODULE$.call((HttpMethodBase)new DeleteMethod(this.fullPath()));
        AssertJUnit.assertEquals((int)404, (int)Client$.MODULE$.call((HttpMethodBase)new HeadMethod(fullPathKey)).getStatusCode());
    }

    public void testAsyncAddRemove(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PostMethod put = new PostMethod(fullPathKey);
        put.setRequestHeader("performAsync", "true");
        put.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        Client$.MODULE$.call((HttpMethodBase)put);
        Thread.sleep(50L);
        AssertJUnit.assertEquals((int)200, (int)Client$.MODULE$.call((HttpMethodBase)new HeadMethod(fullPathKey)).getStatusCode());
        DeleteMethod del = new DeleteMethod(fullPathKey);
        del.setRequestHeader("performAsync", "true");
        Client$.MODULE$.call((HttpMethodBase)del);
        Thread.sleep(50L);
        AssertJUnit.assertEquals((int)404, (int)Client$.MODULE$.call((HttpMethodBase)new HeadMethod(fullPathKey)).getStatusCode());
    }

    public void testShouldCopeWithSerializable(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        Client$.MODULE$.call((HttpMethodBase)new GetMethod(fullPathKey));
        MySer obj = new MySer();
        obj.name_$eq("mic");
        ManagerInstance$.MODULE$.getCache("___defaultcache").put((Object)m.getName(), (Object)obj);
        ManagerInstance$.MODULE$.getCache("___defaultcache").put((Object)new StringBuilder().append((Object)m.getName()).append((Object)"2").toString(), (Object)"hola");
        ManagerInstance$.MODULE$.getCache("___defaultcache").put((Object)new StringBuilder().append((Object)m.getName()).append((Object)"3").toString(), (Object)new MyNonSer());
        GetMethod get = new GetMethod(fullPathKey);
        get.setRequestHeader("Accept", "application/x-java-serialized-object");
        Client$.MODULE$.call((HttpMethodBase)get);
        AssertJUnit.assertEquals((int)200, (int)get.getStatusCode());
        ObjectInputStream in = new ObjectInputStream(get.getResponseBodyAsStream());
        MySer res = (MySer)in.readObject();
        AssertJUnit.assertNotNull((Object)res);
        AssertJUnit.assertEquals((String)"mic", (String)res.name());
        AssertJUnit.assertEquals((String)"application/x-java-serialized-object", (String)get.getResponseHeader("Content-Type").getValue());
        HttpMethodBase getStr = Client$.MODULE$.call((HttpMethodBase)new GetMethod(new StringBuilder().append((Object)fullPathKey).append((Object)"2").toString()));
        AssertJUnit.assertEquals((String)"hola", (String)getStr.getResponseBodyAsString());
        AssertJUnit.assertEquals((String)"text/plain", (String)getStr.getResponseHeader("Content-Type").getValue());
        get.setRequestHeader("Accept", "application/json");
        Client$.MODULE$.call((HttpMethodBase)get);
        AssertJUnit.assertEquals((String)"{\"name\":\"mic\"}", (String)get.getResponseBodyAsString());
        AssertJUnit.assertEquals((String)"application/json", (String)get.getResponseHeader("Content-Type").getValue());
        get.setRequestHeader("Accept", "application/xml");
        Client$.MODULE$.call((HttpMethodBase)get);
        AssertJUnit.assertEquals((String)"application/xml", (String)get.getResponseHeader("Content-Type").getValue());
        AssertJUnit.assertTrue((get.getResponseBodyAsString().indexOf("<org.infinispan.rest.MySer>") > -1 ? 1 : 0) != 0);
        GetMethod get3 = new GetMethod(new StringBuilder().append((Object)fullPathKey).append((Object)"3").toString());
        get3.setRequestHeader("Accept", "application/json");
        Client$.MODULE$.call((HttpMethodBase)get3);
        AssertJUnit.assertEquals((String)"{\"name\":\"mic\"}", (String)get3.getResponseBodyAsString());
        AssertJUnit.assertEquals((String)"application/json", (String)get3.getResponseHeader("Content-Type").getValue());
    }

    public void testInsertSerializableObjects(Method m) {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        new ObjectOutputStream(bout).writeObject(new MySer());
        this.put(m, bout.toByteArray(), "application/x-java-serialized-object");
        byte[] cfr_ignored_0 = (byte[])ManagerInstance$.MODULE$.getCache("___defaultcache").get((Object)m.getName());
    }

    public void testNonexistentCache(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.HOST()).append((Object)"/rest/nonexistent/").append((Object)m.getName()).toString();
        GetMethod get = new GetMethod(fullPathKey);
        Client$.MODULE$.call((HttpMethodBase)get);
        AssertJUnit.assertEquals((int)404, (int)get.getStatusCode());
        HttpMethodBase head = Client$.MODULE$.call((HttpMethodBase)new HeadMethod(fullPathKey));
        AssertJUnit.assertEquals((int)404, (int)head.getStatusCode());
        PostMethod put = new PostMethod(fullPathKey);
        put.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        Client$.MODULE$.call((HttpMethodBase)put);
        AssertJUnit.assertEquals((int)404, (int)put.getStatusCode());
    }

    public void testByteArrayAsSerializedObjects(Method m) {
        this.sendByteArrayAs(m, "application/x-java-serialized-object");
    }

    public void testByteArrayAsOctecStreamObjects(Method m) {
        this.sendByteArrayAs(m, "application/octet-stream");
    }

    private void sendByteArrayAs(Method m, String contentType) {
        byte[] serializedOnClient = (byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{101, 102, 103}), ClassTag$.MODULE$.Byte());
        this.put(m, serializedOnClient, contentType);
        BufferedInputStream dataRead = new BufferedInputStream(this.get(m, (Option<String>)None$.MODULE$, (Option<String>)new Some((Object)contentType)).getResponseBodyAsStream());
        byte[] bytesRead = new byte[3];
        dataRead.read(bytesRead);
        AssertJUnit.assertEquals((byte[])serializedOnClient, (byte[])bytesRead);
    }

    public void testIfUnmodifiedSince(Method m) {
        this.put(m);
        HttpMethodBase result = this.get(m);
        String dateLast = result.getResponseHeader("Last-Modified").getValue();
        String dateMinus = this.addDay(dateLast, -1);
        String datePlus = this.addDay(dateLast, 1);
        AssertJUnit.assertNotNull((Object)this.get(m, (Option<String>)new Some((Object)dateLast)).getResponseBodyAsString());
        AssertJUnit.assertNotNull((Object)this.get(m, (Option<String>)new Some((Object)datePlus)).getResponseBodyAsString());
        HttpMethodBase httpMethodBase = this.get(m, (Option<String>)new Some((Object)dateMinus), (Option<String>)None$.MODULE$, 412);
    }

    public void testETagChanges(Method m) {
        this.put(m, "data1");
        String eTagFirst = this.get(m).getResponseHeader("ETag").getValue();
        AssertJUnit.assertEquals((String)eTagFirst, (String)this.get(m).getResponseHeader("ETag").getValue());
        this.put(m, "data2");
        String eTagSecond = this.get(m).getResponseHeader("ETag").getValue();
        AssertJUnit.assertFalse((String)new StringOps(Predef$.MODULE$.augmentString("etag1 %s; etag2 %s; equals? %b")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{eTagFirst, eTagSecond, BoxesRunTime.boxToBoolean((boolean)eTagFirst.equals(eTagSecond))})), (boolean)eTagFirst.equals(eTagSecond));
    }

    public void testConcurrentETagChanges(Method m) {
        this.put(m, "data1");
        CountDownLatch v2PutLatch = new CountDownLatch(1);
        CountDownLatch v3PutLatch = new CountDownLatch(1);
        CountDownLatch v2FinishLatch = new CountDownLatch(1);
        ControlledCacheManager mockCacheManager = new ControlledCacheManager(this, ManagerInstance$.MODULE$.instance(), v2PutLatch, v3PutLatch, v2FinishLatch);
        try {
            ManagerInstance$.MODULE$.knownCaches().put("___defaultcache", mockCacheManager.getCache());
            Serializable x$1 = new Serializable(this, m, v2FinishLatch){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ IntegrationTest $outer;
                private final Method m$1;
                private final CountDownLatch v2FinishLatch$1;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    HttpClient newClient = new HttpClient();
                    PutMethod put = new PutMethod(this.$outer.org$infinispan$rest$IntegrationTest$$fullPathKey(this.m$1));
                    put.setRequestHeader("Content-Type", "application/text");
                    put.setRequestEntity((RequestEntity)new StringRequestEntity("data2", null, null));
                    newClient.executeMethod((HttpMethod)put);
                    AssertJUnit.assertEquals((int)200, (int)put.getStatusCode());
                    this.v2FinishLatch$1.countDown();
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.m$1 = m$1;
                    this.v2FinishLatch$1 = v2FinishLatch$1;
                }
            };
            FutureTaskRunner x$2 = ops$.MODULE$.future$default$2((Function0)x$1);
            Function0 replaceFuture = ops$.MODULE$.future((Function0)x$1, x$2);
            boolean bl = v3PutLatch.await(10L, TimeUnit.SECONDS);
            AssertJUnit.assertTrue((String)"Timed out waiting for concurrent put", (boolean)bl);
            PutMethod put = new PutMethod(this.org$infinispan$rest$IntegrationTest$$fullPathKey(m));
            put.setRequestHeader("Content-Type", "application/text");
            put.setRequestEntity((RequestEntity)new StringRequestEntity("data3", null, null));
            Client$.MODULE$.call((HttpMethodBase)put);
            AssertJUnit.assertEquals((int)412, (int)put.getStatusCode());
            replaceFuture.apply$mcV$sp();
            AssertJUnit.assertEquals((String)"data2", (String)this.get(m).getResponseBodyAsString());
            return;
        }
        finally {
            ManagerInstance$.MODULE$.knownCaches().put("___defaultcache", ManagerInstance$.MODULE$.instance().getCache());
        }
    }

    public void testSerializedStringGetBytes(Method m) {
        byte[] data = new StringBuilder().append((Object)"v-").append((Object)m.getName()).toString().getBytes("UTF-8");
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        ObjectOutputStream oo = new ObjectOutputStream(bout);
        oo.writeObject(data);
        oo.flush();
        byte[] bytes = bout.toByteArray();
        this.put(m, bytes, "application/x-java-serialized-object");
        byte[] bytesRead = this.get(m, (Option<String>)None$.MODULE$, (Option<String>)new Some((Object)"application/x-java-serialized-object")).getResponseBody();
        AssertJUnit.assertTrue((boolean)Arrays.equals(bytes, bytesRead));
        ObjectInputStream oin = new ObjectInputStream(new ByteArrayInputStream(bytesRead));
        byte[] dataBack = (byte[])oin.readObject();
        AssertJUnit.assertTrue((boolean)Arrays.equals(data, dataBack));
    }

    public void testDefaultConfiguredExpiryValues(Method m) {
        String cacheName = "evictExpiryCache";
        String fullPathKey = new StringOps(Predef$.MODULE$.augmentString("%s/rest/%s/%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.HOST(), cacheName, m.getName()}));
        PostMethod post = new PostMethod(fullPathKey);
        post.setRequestHeader("timeToLiveSeconds", "-1");
        post.setRequestEntity((RequestEntity)new StringRequestEntity("data", "text/plain", "UTF-8"));
        Client$.MODULE$.call((HttpMethodBase)post);
        Thread.sleep(5000L);
        AssertJUnit.assertEquals((String)"data", (String)Client$.MODULE$.call((HttpMethodBase)new GetMethod(fullPathKey)).getResponseBodyAsString());
        long startTime = System.currentTimeMillis();
        int lifespan = 3000;
        fullPathKey = new StringOps(Predef$.MODULE$.augmentString("%s-2")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fullPathKey}));
        post = new PostMethod(fullPathKey);
        post.setRequestHeader("Content-Type", "application/text");
        post.setRequestHeader("timeToLiveSeconds", "0");
        post.setRequestHeader("maxIdleTimeSeconds", "0");
        post.setRequestEntity((RequestEntity)new StringRequestEntity("data2", "text/plain", "UTF-8"));
        Client$.MODULE$.call((HttpMethodBase)post);
        while (System.currentTimeMillis() < startTime + (long)lifespan) {
            String response = Client$.MODULE$.call((HttpMethodBase)new GetMethod(fullPathKey)).getResponseBodyAsString();
            if (System.currentTimeMillis() >= startTime + (long)lifespan) continue;
            AssertJUnit.assertEquals((String)"data2", (String)response);
            Thread.sleep(100L);
        }
        this.waitNotFound(startTime, lifespan, fullPathKey);
        AssertJUnit.assertEquals((int)404, (int)Client$.MODULE$.call((HttpMethodBase)new GetMethod(fullPathKey)).getStatusCode());
        startTime = System.currentTimeMillis();
        lifespan = 0;
        fullPathKey = new StringOps(Predef$.MODULE$.augmentString("%s-3")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fullPathKey}));
        post = new PostMethod(fullPathKey);
        post.setRequestHeader("timeToLiveSeconds", "0");
        post.setRequestEntity((RequestEntity)new StringRequestEntity("data3", "text/plain", "UTF-8"));
        Client$.MODULE$.call((HttpMethodBase)post);
        this.waitNotFound(startTime, lifespan, fullPathKey);
        fullPathKey = new StringOps(Predef$.MODULE$.augmentString("%s-4")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fullPathKey}));
        post = new PostMethod(fullPathKey);
        post.setRequestHeader("maxIdleTimeSeconds", "0");
        post.setRequestEntity((RequestEntity)new StringRequestEntity("data4", "text/plain", "UTF-8"));
        Client$.MODULE$.call((HttpMethodBase)post);
        Thread.sleep(2500L);
        AssertJUnit.assertEquals((int)404, (int)Client$.MODULE$.call((HttpMethodBase)new GetMethod(fullPathKey)).getStatusCode());
    }

    public void testPutByteArrayTwice(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PutMethod put = new PutMethod(fullPathKey);
        byte[] data = new byte[]{42, 42, 42};
        put.setRequestEntity((RequestEntity)new ByteArrayRequestEntity(data, "application/x-java-serialized-object"));
        AssertJUnit.assertEquals((int)200, (int)Client$.MODULE$.call((HttpMethodBase)put).getStatusCode());
        HttpMethodBase get = Client$.MODULE$.call((HttpMethodBase)new GetMethod(fullPathKey));
        AssertJUnit.assertEquals((int)200, (int)get.getStatusCode());
        PutMethod reput = new PutMethod(fullPathKey);
        reput.setRequestEntity((RequestEntity)new ByteArrayRequestEntity(data, "application/x-java-serialized-object"));
        AssertJUnit.assertEquals((int)200, (int)Client$.MODULE$.call((HttpMethodBase)reput).getStatusCode());
    }

    public void testDeleteSerializedObject(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PutMethod put = new PutMethod(fullPathKey);
        byte[] data = new byte[]{42, 42, 42};
        put.setRequestEntity((RequestEntity)new ByteArrayRequestEntity(data, "application/x-java-serialized-object"));
        AssertJUnit.assertEquals((int)200, (int)Client$.MODULE$.call((HttpMethodBase)put).getStatusCode());
        HttpMethodBase get = Client$.MODULE$.call((HttpMethodBase)new GetMethod(fullPathKey));
        AssertJUnit.assertEquals((int)200, (int)get.getStatusCode());
        HttpMethodBase delete = Client$.MODULE$.call((HttpMethodBase)new DeleteMethod(fullPathKey));
        AssertJUnit.assertEquals((int)200, (int)delete.getStatusCode());
    }

    private void waitNotFound(long startTime, int lifespan, String fullPathKey) {
        while (System.currentTimeMillis() < startTime + (long)lifespan + 20000L && !((Object)BoxesRunTime.boxToInteger((int)404)).equals(BoxesRunTime.boxToInteger((int)Client$.MODULE$.call((HttpMethodBase)new GetMethod(fullPathKey)).getStatusCode()))) {
            Thread.sleep(100L);
        }
    }

    private HttpMethodBase put(Method m) {
        return this.put(m, "data", "application/text");
    }

    private HttpMethodBase put(Method m, Object data) {
        return this.put(m, data, "application/text");
    }

    private HttpMethodBase put(Method m, Object data, String contentType) {
        Object object;
        block4: {
            StringRequestEntity stringRequestEntity;
            PutMethod put;
            block3: {
                block2: {
                    put = new PutMethod(this.org$infinispan$rest$IntegrationTest$$fullPathKey(m));
                    put.setRequestHeader("Content-Type", contentType);
                    object = data;
                    if (!(object instanceof String)) break block2;
                    String x2 = (String)object;
                    stringRequestEntity = new StringRequestEntity(x2, null, null);
                    break block3;
                }
                if (!(object instanceof byte[])) break block4;
                byte[] x3 = (byte[])object;
                stringRequestEntity = new InputStreamRequestEntity((InputStream)new ByteArrayInputStream(x3));
            }
            StringRequestEntity reqEntity = stringRequestEntity;
            put.setRequestEntity((RequestEntity)reqEntity);
            Client$.MODULE$.call((HttpMethodBase)put);
            AssertJUnit.assertEquals((int)200, (int)put.getStatusCode());
            return put;
        }
        throw new MatchError(object);
    }

    private HttpMethodBase get(Method m) {
        return this.get(m, (Option<String>)None$.MODULE$);
    }

    private HttpMethodBase get(Method m, Option<String> unmodSince) {
        return this.get(m, unmodSince, (Option<String>)None$.MODULE$, 200);
    }

    private HttpMethodBase get(Method m, Option<String> unmodSince, Option<String> acceptType) {
        return this.get(m, unmodSince, acceptType, 200);
    }

    private HttpMethodBase get(Method m, Option<String> unmodSince, Option<String> acceptType, int expCode) {
        GetMethod get = new GetMethod(this.org$infinispan$rest$IntegrationTest$$fullPathKey(m));
        Option<String> option = unmodSince;
        None$ none$ = None$.MODULE$;
        if (option == null ? none$ != null : !option.equals((Object)none$)) {
            get.setRequestHeader("If-Unmodified-Since", (String)unmodSince.get());
        }
        Option<String> option2 = acceptType;
        None$ none$2 = None$.MODULE$;
        if (option2 == null ? none$2 != null : !option2.equals((Object)none$2)) {
            get.setRequestHeader("Accept", (String)acceptType.get());
        }
        Client$.MODULE$.call((HttpMethodBase)get);
        AssertJUnit.assertEquals((int)expCode, (int)get.getStatusCode());
        return get;
    }

    public String org$infinispan$rest$IntegrationTest$$fullPathKey(Method m) {
        return new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
    }

    public String addDay(String aDate, int days) {
        SimpleDateFormat format = new SimpleDateFormat(this.DATE_PATTERN_RFC1123(), Locale.US);
        Date date = format.parse(aDate);
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(5, days);
        return format.format(cal.getTime());
    }

    public IntegrationTest() {
        this.HOST = "http://localhost:8888";
        this.cacheName = "___defaultcache";
        this.DATE_PATTERN_RFC1123 = "EEE, dd MMM yyyy HH:mm:ss zzz";
    }

    public class ControlledCache<String, Any>
    extends AbstractDelegatingCache<String, Any> {
        private final CountDownLatch v2PutLatch;
        private final CountDownLatch v3PutLatch;
        private final CountDownLatch v2FinishLatch;
        public final /* synthetic */ IntegrationTest $outer;

        public boolean replace(String key, Any oldValue, Any value, long lifespan, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
            Object object;
            MIMECacheEntry newMime = (MIMECacheEntry)value;
            MIMECacheEntry oldMime = (MIMECacheEntry)oldValue;
            String oldMimeAsString = new String(oldMime.data);
            String newMimeAsString = new String(newMime.data);
            if (Arrays.equals(newMime.data, "data2".getBytes())) {
                this.org$infinispan$rest$IntegrationTest$ControlledCache$$$outer().org$infinispan$rest$IntegrationTest$$log().debug((Object)"Let v3 apply...");
                this.v3PutLatch.countDown();
                this.org$infinispan$rest$IntegrationTest$ControlledCache$$$outer().org$infinispan$rest$IntegrationTest$$log().debug((Object)"Wait until v2 can be stored");
                boolean bl = this.v2PutLatch.await(10L, TimeUnit.SECONDS);
                if (!bl) {
                    AssertJUnit.fail((String)"Timed out waiting for v2 to be allowed");
                }
                object = BoxedUnit.UNIT;
            } else if (Arrays.equals(newMime.data, "data3".getBytes())) {
                this.org$infinispan$rest$IntegrationTest$ControlledCache$$$outer().org$infinispan$rest$IntegrationTest$$log().debugf("About to store v3, let v2 apply, oldValue(for v3)=%s", new Object[]{oldMimeAsString});
                this.v2PutLatch.countDown();
                object = BoxesRunTime.boxToBoolean((boolean)this.v2FinishLatch.await(10L, TimeUnit.SECONDS));
            } else {
                object = BoxedUnit.UNIT;
            }
            this.org$infinispan$rest$IntegrationTest$ControlledCache$$$outer().org$infinispan$rest$IntegrationTest$$log().debugf("Replace key=%s, oldValue=%s, value=%s", key, (Object)oldMimeAsString, (Object)newMimeAsString);
            return super.replace(key, oldValue, value, lifespan, lifespanUnit, maxIdleTime, maxIdleTimeUnit);
        }

        public /* synthetic */ IntegrationTest org$infinispan$rest$IntegrationTest$ControlledCache$$$outer() {
            return this.$outer;
        }

        public ControlledCache(IntegrationTest $outer, Cache<String, Any> cache, CountDownLatch v2PutLatch, CountDownLatch v3PutLatch, CountDownLatch v2FinishLatch) {
            this.v2PutLatch = v2PutLatch;
            this.v3PutLatch = v3PutLatch;
            this.v2FinishLatch = v2FinishLatch;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            super(cache);
        }
    }

    public class ControlledCacheManager
    extends AbstractDelegatingEmbeddedCacheManager {
        private final CountDownLatch v2PutLatch;
        private final CountDownLatch v3PutLatch;
        private final CountDownLatch v2FinishLatch;
        public final /* synthetic */ IntegrationTest $outer;

        public <K, V> Cache<K, V> getCache() {
            return new ControlledCache(this.org$infinispan$rest$IntegrationTest$ControlledCacheManager$$$outer(), super.getCache(), this.v2PutLatch, this.v3PutLatch, this.v2FinishLatch);
        }

        public /* synthetic */ IntegrationTest org$infinispan$rest$IntegrationTest$ControlledCacheManager$$$outer() {
            return this.$outer;
        }

        public ControlledCacheManager(IntegrationTest $outer, EmbeddedCacheManager cm, CountDownLatch v2PutLatch, CountDownLatch v3PutLatch, CountDownLatch v2FinishLatch) {
            this.v2PutLatch = v2PutLatch;
            this.v3PutLatch = v3PutLatch;
            this.v2FinishLatch = v2FinishLatch;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            super(cm);
        }
    }
}

