/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.ByteArrayRequestEntity;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.infinispan.AbstractDelegatingAdvancedCache;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.manager.AbstractDelegatingEmbeddedCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.metadata.Metadata;
import org.infinispan.remoting.MIMECacheEntry;
import org.infinispan.rest.MyNonSer;
import org.infinispan.rest.MySer;
import org.infinispan.rest.RESTServerTestBase;
import org.infinispan.server.core.logging.JavaLog;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.util.logging.LogFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import scala.Array$;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.FutureTaskRunner;
import scala.concurrent.ops$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.xml.Elem;
import scala.xml.MetaData;
import scala.xml.NamespaceBinding;
import scala.xml.NodeBuffer;
import scala.xml.Null$;
import scala.xml.Text;
import scala.xml.TopScope$;

@Test(groups={"functional"}, testName="rest.IntegrationTest")
@ScalaSignature(bytes="\u0006\u0001\r=e\u0001B\u0001\u0003\u0001%\u0011q\"\u00138uK\u001e\u0014\u0018\r^5p]R+7\u000f\u001e\u0006\u0003\u0007\u0011\tAA]3ti*\u0011QAB\u0001\u000bS:4\u0017N\\5ta\u0006t'\"A\u0004\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001Q\u0001CA\u0006\r\u001b\u0005\u0011\u0011BA\u0007\u0003\u0005I\u0011Vi\u0015+TKJ4XM\u001d+fgR\u0014\u0015m]3\t\u000b=\u0001A\u0011\u0001\t\u0002\rqJg.\u001b;?)\u0005\t\u0002CA\u0006\u0001\u0011!\u0019\u0002\u0001#b\u0001\n\u0013!\u0012a\u00017pOV\tQ\u0003\u0005\u0002\u0017;5\tqC\u0003\u0002\u00193\u00059An\\4hS:<'B\u0001\u000e\u001c\u0003\u0011\u0019wN]3\u000b\u0005q!\u0011AB:feZ,'/\u0003\u0002\u001f/\t9!*\u0019<b\u0019><\u0007\u0002\u0003\u0011\u0001\u0011\u0003\u0005\u000b\u0015B\u000b\u0002\t1|w\r\t\u0005\bE\u0001\u0011\r\u0011\"\u0001$\u0003\u0011Auj\u0015+\u0016\u0003\u0011\u0002\"!\n\u0016\u000e\u0003\u0019R!a\n\u0015\u0002\t1\fgn\u001a\u0006\u0002S\u0005!!.\u0019<b\u0013\tYcE\u0001\u0004TiJLgn\u001a\u0005\u0007[\u0001\u0001\u000b\u0011\u0002\u0013\u0002\u000b!{5\u000b\u0016\u0011\t\u000f=\u0002!\u0019!C\u0001G\u0005I1-Y2iK:\u000bW.\u001a\u0005\u0007c\u0001\u0001\u000b\u0011\u0002\u0013\u0002\u0015\r\f7\r[3OC6,\u0007\u0005C\u00044\u0001\t\u0007I\u0011A\u0012\u0002\u0011\u0019,H\u000e\u001c)bi\"Da!\u000e\u0001!\u0002\u0013!\u0013!\u00034vY2\u0004\u0016\r\u001e5!\u0011\u001d9\u0004A1A\u0005\u0002\r\nA\u0003R!U\u000b~\u0003\u0016\t\u0016+F%:{&KR\"2cI\u001a\u0004BB\u001d\u0001A\u0003%A%A\u000bE\u0003R+u\fU!U)\u0016\u0013fj\u0018*G\u0007F\n$g\r\u0011\t\u000bm\u0002A\u0011\u0001\u001f\u0002\u000bM,G/\u00169\u0015\u0003u\u0002\"AP!\u000e\u0003}R\u0011\u0001Q\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0005~\u0012A!\u00168ji\"\u0012!\b\u0012\t\u0003\u000b*k\u0011A\u0012\u0006\u0003\u000f\"\u000b1\"\u00198o_R\fG/[8og*\u0011\u0011JB\u0001\u0007i\u0016\u001cHO\\4\n\u0005-3%a\u0003\"fM>\u0014Xm\u00117bgNDQ!\u0014\u0001\u0005\u0002q\n\u0001\u0002^3be\u0012{wO\u001c\u0015\u0005\u0019>\u00136\u000b\u0005\u0002F!&\u0011\u0011K\u0012\u0002\u000b\u0003\u001a$XM]\"mCN\u001c\u0018!C1mo\u0006L8OU;o3\u0005\t\u0001\"B+\u0001\t\u00031\u0016A\u0005;fgR\u0014\u0015m]5d\u001fB,'/\u0019;j_:$\"!P,\t\u000ba#\u0006\u0019A-\u0002\u00035\u0004\"AW/\u000e\u0003mS!\u0001\u0018\u0014\u0002\u000fI,g\r\\3di&\u0011al\u0017\u0002\u0007\u001b\u0016$\bn\u001c3\t\u000b\u0001\u0004A\u0011\u0001\u001f\u0002\u0019Q,7\u000f^#naRLx)\u001a;\t\u000b\t\u0004A\u0011\u0001\u001f\u0002#Q,7\u000f^$fi\u000e{G\u000e\\3di&|g\u000eC\u0003e\u0001\u0011\u0005A(A\fuKN$x)\u001a;D_2dWm\u0019;j_:,5oY1qK\")a\r\u0001C\u0005O\u0006iq-\u001a;D_2dWm\u0019;j_:$\"\u0001\u001b8\u0011\u0005%dgB\u0001 k\u0013\tYw(\u0001\u0004Qe\u0016$WMZ\u0005\u0003W5T!a[ \t\u000b=,\u0007\u0019\u00015\u0002\u000fY\f'/[1oi\")\u0011\u000f\u0001C\u0001e\u00069A/Z:u\u000f\u0016$HCA\u001ft\u0011\u0015A\u0006\u000f1\u0001Z\u0011\u0015)\b\u0001\"\u0001w\u0003!!Xm\u001d;IK\u0006$GCA\u001fx\u0011\u0015AF\u000f1\u0001Z\u0011\u0015I\b\u0001\"\u0001{\u0003M!Xm\u001d;HKRLe-\u00168n_\u0012Lg-[3e)\ti4\u0010C\u0003Yq\u0002\u0007\u0011\fC\u0003~\u0001\u0011\u0005a0A\tuKN$\bk\\:u\tV\u0004H.[2bi\u0016$\"!P@\t\u000bac\b\u0019A-\t\u000f\u0005\r\u0001\u0001\"\u0001\u0002\u0006\u0005IB/Z:u!V$H)\u0019;b/&$\b\u000eV5nKR{G*\u001b<f)\ri\u0014q\u0001\u0005\u00071\u0006\u0005\u0001\u0019A-\t\u000f\u0005-\u0001\u0001\"\u0001\u0002\u000e\u0005QB/Z:u!V$H)\u0019;b/&$\b.T1y\u0013\u0012dWm\u00148msR\u0019Q(a\u0004\t\ra\u000bI\u00011\u0001Z\u0011\u001d\t\u0019\u0002\u0001C\u0001\u0003+\tQ\u0004^3tiB+H\u000fR1uC^KG\u000f\u001b+j[\u0016$v\u000eT5wK>sG.\u001f\u000b\u0004{\u0005]\u0001B\u0002-\u0002\u0012\u0001\u0007\u0011\fC\u0004\u0002\u001c\u0001!I!!\b\u00023A,H/\u00118e\u0003N\u001cXM\u001d;Fa\",W.\u001a:bY\u0012\u000bG/\u0019\u000b\b{\u0005}\u0011\u0011EA\u0013\u0011\u0019A\u0016\u0011\u0004a\u00013\"9\u00111EA\r\u0001\u0004A\u0017!\u0005;j[\u0016$v\u000eT5wKN+7m\u001c8eg\"9\u0011qEA\r\u0001\u0004A\u0017AE7bq&#G.\u001a+j[\u0016\u001cVmY8oINDq!a\u000b\u0001\t\u0003\ti#\u0001\fuKN$\b+\u001e;ECR\fw+\u001b;i\u0013\u001al\u0015\r^2i)\ri\u0014q\u0006\u0005\u00071\u0006%\u0002\u0019A-\t\u000f\u0005M\u0002\u0001\"\u0001\u00026\u0005QB/Z:u!V$H)\u0019;b/&$\b.\u00134O_:,W*\u0019;dQR\u0019Q(a\u000e\t\ra\u000b\t\u00041\u0001Z\u0011\u001d\tY\u0004\u0001C\u0001\u0003{\ta\u0004^3tiB+H\u000fR1uC^KG\u000f[%g\u001b>$\u0017NZ5fINKgnY3\u0015\u0007u\ny\u0004\u0003\u0004Y\u0003s\u0001\r!\u0017\u0005\b\u0003\u0007\u0002A\u0011AA#\u0003\u0001\"Xm\u001d;QkR$\u0015\r^1XSRD\u0017JZ+o\u001b>$\u0017NZ5fINKgnY3\u0015\u0007u\n9\u0005\u0003\u0004Y\u0003\u0003\u0002\r!\u0017\u0005\b\u0003\u0017\u0002A\u0011AA'\u0003e!Xm\u001d;EK2,G/\u001a#bi\u0006<\u0016\u000e\u001e5JM6\u000bGo\u00195\u0015\u0007u\ny\u0005\u0003\u0004Y\u0003\u0013\u0002\r!\u0017\u0005\b\u0003'\u0002A\u0011AA+\u0003u!Xm\u001d;EK2,G/\u001a#bi\u0006<\u0016\u000e\u001e5JM:{g.Z'bi\u000eDGcA\u001f\u0002X!1\u0001,!\u0015A\u0002eCq!a\u0017\u0001\t\u0003\ti&A\u0011uKN$H)\u001a7fi\u0016$\u0015\r^1XSRD\u0017JZ'pI&4\u0017.\u001a3TS:\u001cW\rF\u0002>\u0003?Ba\u0001WA-\u0001\u0004I\u0006bBA2\u0001\u0011\u0005\u0011QM\u0001$i\u0016\u001cH\u000fR3mKR,G)\u0019;b/&$\b.\u00134V]6|G-\u001b4jK\u0012\u001c\u0016N\\2f)\ri\u0014q\r\u0005\u00071\u0006\u0005\u0004\u0019A-\t\u000f\u0005-\u0004\u0001\"\u0001\u0002n\u0005AC/Z:u\t\u0016dW\r^3DC\u000eDW\r\u0015:fG>tG-\u001b;j_:,f.[7qY\u0016lWM\u001c;fIR\u0019Q(a\u001c\t\ra\u000bI\u00071\u0001Z\u0011\u001d\t\u0019\b\u0001C\u0005\u0003k\nQ\u0005^3ti\u0012+G.\u001a;f!J,7m\u001c8eSRLwN\\1m+:LW\u000e\u001d7f[\u0016tG/\u001a3\u0015\u0007u\n9\bC\u0004\u0002z\u0005E\u0004\u0019\u00015\u0002\u0017\u0019,H\u000e\u001c)bi\"\\U-\u001f\u0005\b\u0003g\u0002A\u0011BA?)\u0015i\u0014qPAA\u0011\u001d\tI(a\u001fA\u0002!Dq!a!\u0002|\u0001\u0007\u0001.\u0001\rqe\u0016\u001cwN\u001c3ji&|g.\u00197IK\u0006$WM\u001d(b[\u0016Dq!a\"\u0001\t\u0013\tI)\u0001\u000bbgN,'\u000f\u001e(pi&k\u0007\u000f\\3nK:$X\r\u001a\u000b\u0004{\u0005-\u0005\u0002CAG\u0003\u000b\u0003\r!a$\u0002\r5,G\u000f[8e!\u0011\t\t*a(\u000e\u0005\u0005M%\u0002BAK\u0003/\u000b!\u0002\u001b;ua\u000ed\u0017.\u001a8u\u0015\u0011\tI*a'\u0002\u000f\r|W.\\8og*\u0019\u0011Q\u0014\u0004\u0002\r\u0005\u0004\u0018m\u00195f\u0013\u0011\t\t+a%\u0003\u0015!#H\u000f]'fi\"|G\rC\u0004\u0002&\u0002!\t!a*\u0002\u001fQ,7\u000f\u001e*f[>4X-\u00128uef$2!PAU\u0011\u0019A\u00161\u0015a\u00013\"9\u0011Q\u0016\u0001\u0005\u0002\u0005=\u0016a\u0005;fgR<\u0016\u000e]3DC\u000eDWMQ;dW\u0016$HcA\u001f\u00022\"1\u0001,a+A\u0002eCq!!.\u0001\t\u0003\t9,\u0001\nuKN$\u0018i]=oG\u0006#GMU3n_Z,GcA\u001f\u0002:\"1\u0001,a-A\u0002eCq!!0\u0001\t\u0003\ty,\u0001\u0010uKN$8\u000b[8vY\u0012\u001cu\u000e]3XSRD7+\u001a:jC2L'0\u00192mKR\u0019Q(!1\t\ra\u000bY\f1\u0001Z\u0011\u001d\t)\r\u0001C\u0001\u0003\u000f\fQ\u0004^3ti&s7/\u001a:u'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z(cU\u0016\u001cGo\u001d\u000b\u0004{\u0005%\u0007B\u0002-\u0002D\u0002\u0007\u0011\fC\u0004\u0002N\u0002!\t!a4\u0002)Q,7\u000f\u001e(p]\u0016D\u0018n\u001d;f]R\u001c\u0015m\u00195f)\ri\u0014\u0011\u001b\u0005\u00071\u0006-\u0007\u0019A-\t\u000f\u0005U\u0007\u0001\"\u0001\u0002X\u0006\u0001C/Z:u\u0005f$X-\u0011:sCf\f5oU3sS\u0006d\u0017N_3e\u001f\nTWm\u0019;t)\ri\u0014\u0011\u001c\u0005\u00071\u0006M\u0007\u0019A-\t\u000f\u0005u\u0007\u0001\"\u0001\u0002`\u0006\tC/Z:u\u0005f$X-\u0011:sCf\f5oT2uK\u000e\u001cFO]3b[>\u0013'.Z2ugR\u0019Q(!9\t\ra\u000bY\u000e1\u0001Z\u0011\u001d\t)\u000f\u0001C\u0005\u0003O\fqb]3oI\nKH/Z!se\u0006L\u0018i\u001d\u000b\u0006{\u0005%\u00181\u001e\u0005\u00071\u0006\r\b\u0019A-\t\u000f\u00055\u00181\u001da\u0001Q\u0006Y1m\u001c8uK:$H+\u001f9f\u0011\u001d\t\t\u0010\u0001C\u0001\u0003g\fQ\u0003^3ti&3WK\\7pI&4\u0017.\u001a3TS:\u001cW\rF\u0002>\u0003kDa\u0001WAx\u0001\u0004I\u0006bBA}\u0001\u0011\u0005\u00111`\u0001\u0010i\u0016\u001cH/\u0012+bO\u000eC\u0017M\\4fgR\u0019Q(!@\t\ra\u000b9\u00101\u0001Z\u0011\u001d\u0011\t\u0001\u0001C\u0001\u0005\u0007\t\u0011\u0004^3ti\u000e{gnY;se\u0016tG/\u0012+bO\u000eC\u0017M\\4fgR\u0019QH!\u0002\t\ra\u000by\u00101\u0001Z\u0011\u001d\u0011I\u0001\u0001C\u0001\u0005\u0017\tA\u0004^3tiN+'/[1mSj,Gm\u0015;sS:<w)\u001a;CsR,7\u000fF\u0002>\u0005\u001bAa\u0001\u0017B\u0004\u0001\u0004I\u0006b\u0002B\t\u0001\u0011\u0005!1C\u0001\"i\u0016\u001cH\u000fR3gCVdGoQ8oM&<WO]3e\u000bb\u0004\u0018N]=WC2,Xm\u001d\u000b\u0004{\tU\u0001B\u0002-\u0003\u0010\u0001\u0007\u0011\fC\u0004\u0003\u001a\u0001!\tAa\u0007\u0002+Q,7\u000f\u001e)vi\nKH/Z!se\u0006LHk^5dKR\u0019QH!\b\t\ra\u00139\u00021\u0001Z\u0011\u001d\u0011\t\u0003\u0001C\u0001\u0005G\t!\u0004^3ti\u0012+G.\u001a;f'\u0016\u0014\u0018.\u00197ju\u0016$wJ\u00196fGR$2!\u0010B\u0013\u0011\u0019A&q\u0004a\u00013\"9!\u0011\u0006\u0001\u0005\n\t-\u0012\u0001D<bSRtu\u000e\u001e$pk:$GcB\u001f\u0003.\t]\"\u0011\t\u0005\t\u0005_\u00119\u00031\u0001\u00032\u0005I1\u000f^1siRKW.\u001a\t\u0004}\tM\u0012b\u0001B\u001b\u007f\t!Aj\u001c8h\u0011!\u0011IDa\nA\u0002\tm\u0012\u0001\u00037jM\u0016\u001c\b/\u00198\u0011\u0007y\u0012i$C\u0002\u0003@}\u00121!\u00138u\u0011\u001d\tIHa\nA\u0002!DqA!\u0012\u0001\t\u0013\u00119%A\u0002qkR$BA!\u0013\u0003PA!\u0011\u0011\u0013B&\u0013\u0011\u0011i%a%\u0003\u001d!#H\u000f]'fi\"|GMQ1tK\"1\u0001La\u0011A\u0002eCqA!\u0012\u0001\t\u0013\u0011\u0019\u0006\u0006\u0004\u0003J\tU#q\u000b\u0005\u00071\nE\u0003\u0019A-\t\u0011\te#\u0011\u000ba\u0001\u00057\nA\u0001Z1uCB\u0019aH!\u0018\n\u0007\t}sHA\u0002B]fDqA!\u0012\u0001\t\u0013\u0011\u0019\u0007\u0006\u0005\u0003J\t\u0015$q\rB5\u0011\u0019A&\u0011\ra\u00013\"A!\u0011\fB1\u0001\u0004\u0011Y\u0006C\u0004\u0002n\n\u0005\u0004\u0019\u00015\t\u000f\t5\u0004\u0001\"\u0003\u0003p\u0005\u0019q-\u001a;\u0015\t\t%#\u0011\u000f\u0005\u00071\n-\u0004\u0019A-\t\u000f\t5\u0004\u0001\"\u0003\u0003vQ1!\u0011\nB<\u0005sBa\u0001\u0017B:\u0001\u0004I\u0006\u0002\u0003B>\u0005g\u0002\rA! \u0002\u0015UtWn\u001c3TS:\u001cW\r\u0005\u0003?\u0005\u007fB\u0017b\u0001BA\u007f\t1q\n\u001d;j_:DqA!\u001c\u0001\t\u0013\u0011)\t\u0006\u0005\u0003J\t\u001d%\u0011\u0012BF\u0011\u0019A&1\u0011a\u00013\"A!1\u0010BB\u0001\u0004\u0011i\b\u0003\u0005\u0003\u000e\n\r\u0005\u0019\u0001B?\u0003)\t7mY3qiRK\b/\u001a\u0005\b\u0005[\u0002A\u0011\u0002BI))\u0011IEa%\u0003\u0016\n]%\u0011\u0014\u0005\u00071\n=\u0005\u0019A-\t\u0011\tm$q\u0012a\u0001\u0005{B\u0001B!$\u0003\u0010\u0002\u0007!Q\u0010\u0005\t\u00057\u0013y\t1\u0001\u0003<\u00059Q\r\u001f9D_\u0012,\u0007bBA=\u0001\u0011%!q\u0014\u000b\u0004Q\n\u0005\u0006B\u0002-\u0003\u001e\u0002\u0007\u0011\fC\u0004\u0003&\u0002!\tAa*\u0002\r\u0005$G\rR1z)\u0015A'\u0011\u0016BW\u0011\u001d\u0011YKa)A\u0002!\fQ!\u0019#bi\u0016D\u0001Ba,\u0003$\u0002\u0007!1H\u0001\u0005I\u0006L8O\u0002\u0004\u00034\u0002\u0001!Q\u0017\u0002\u0017\u0007>tGO]8mY\u0016$7)Y2iK6\u000bg.Y4feN!!\u0011\u0017B\\!\u0011\u0011ILa0\u000e\u0005\tm&b\u0001B_\t\u00059Q.\u00198bO\u0016\u0014\u0018\u0002\u0002Ba\u0005w\u0013a%\u00112tiJ\f7\r\u001e#fY\u0016<\u0017\r^5oO\u0016k'-\u001a3eK\u0012\u001c\u0015m\u00195f\u001b\u0006t\u0017mZ3s\u0011-\u0011)M!-\u0003\u0002\u0003\u0006IAa2\u0002\u0005\rl\u0007\u0003\u0002B]\u0005\u0013LAAa3\u0003<\n!R)\u001c2fI\u0012,GmQ1dQ\u0016l\u0015M\\1hKJD1Ba4\u00032\n\u0005\t\u0015!\u0003\u0003R\u0006QaO\r)vi2\u000bGo\u00195\u0011\t\tM'Q\\\u0007\u0003\u0005+TAAa6\u0003Z\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0007\tm\u0007&\u0001\u0003vi&d\u0017\u0002\u0002Bp\u0005+\u0014abQ8v]R$un\u001e8MCR\u001c\u0007\u000eC\u0006\u0003d\nE&\u0011!Q\u0001\n\tE\u0017A\u0003<4!V$H*\u0019;dQ\"Y!q\u001dBY\u0005\u0003\u0005\u000b\u0011\u0002Bi\u000351(GR5oSNDG*\u0019;dQ\"9qB!-\u0005\u0002\t-HC\u0003Bw\u0005c\u0014\u0019P!>\u0003xB!!q\u001eBY\u001b\u0005\u0001\u0001\u0002\u0003Bc\u0005S\u0004\rAa2\t\u0011\t='\u0011\u001ea\u0001\u0005#D\u0001Ba9\u0003j\u0002\u0007!\u0011\u001b\u0005\t\u0005O\u0014I\u000f1\u0001\u0003R\"A!1 BY\t\u0003\u0012i0\u0001\u0005hKR\u001c\u0015m\u00195f+\u0019\u0011yp!\u0004\u0004\u001cQ\u00111\u0011\u0001\t\t\u0007\u0007\u0019)a!\u0003\u0004\u001a5\tA!C\u0002\u0004\b\u0011\u0011Q\"\u00113wC:\u001cW\rZ\"bG\",\u0007\u0003BB\u0006\u0007\u001ba\u0001\u0001\u0002\u0005\u0004\u0010\te(\u0019AB\t\u0005\u0005Y\u0015\u0003BB\n\u00057\u00022APB\u000b\u0013\r\u00199b\u0010\u0002\b\u001d>$\b.\u001b8h!\u0011\u0019Yaa\u0007\u0005\u0011\ru!\u0011 b\u0001\u0007#\u0011\u0011A\u0016\u0004\u0007\u0007C\u0001\u0001aa\t\u0003\u001f\r{g\u000e\u001e:pY2,GmQ1dQ\u0016,ba!\n\u00040\rM2\u0003BB\u0010\u0007O\u0001\u0002ba\u0001\u0004*\r52\u0011G\u0005\u0004\u0007W!!aH!cgR\u0014\u0018m\u0019;EK2,w-\u0019;j]\u001e\fEM^1oG\u0016$7)Y2iKB!11BB\u0018\t\u001dY3q\u0004b\u0001\u0007#\u0001Baa\u0003\u00044\u0011A!qLB\u0010\u0005\u0004\u0019\t\u0002C\u0006\u00048\r}!\u0011!Q\u0001\n\re\u0012!B2bG\",\u0007\u0003CB\u0002\u0007w\u0019ic!\r\n\u0007\ruBAA\u0003DC\u000eDW\rC\u0006\u0003P\u000e}!\u0011!Q\u0001\n\tE\u0007b\u0003Br\u0007?\u0011\t\u0011)A\u0005\u0005#D1Ba:\u0004 \t\u0005\t\u0015!\u0003\u0003R\"9qba\b\u0005\u0002\r\u001dCCCB%\u0007\u0017\u001aiea\u0014\u0004RAA!q^B\u0010\u0007[\u0019\t\u0004\u0003\u0005\u00048\r\u0015\u0003\u0019AB\u001d\u0011!\u0011ym!\u0012A\u0002\tE\u0007\u0002\u0003Br\u0007\u000b\u0002\rA!5\t\u0011\t\u001d8Q\ta\u0001\u0005#D\u0001b!\u0016\u0004 \u0011\u00053qK\u0001\be\u0016\u0004H.Y2f))\u0019Ifa\u0018\u0004d\r\u001d41\u000e\t\u0004}\rm\u0013bAB/\u007f\t9!i\\8mK\u0006t\u0007\u0002CB1\u0007'\u0002\ra!\f\u0002\u0007-,\u0017\u0010\u0003\u0005\u0004f\rM\u0003\u0019AB\u0019\u0003!yG\u000e\u001a,bYV,\u0007\u0002CB5\u0007'\u0002\ra!\r\u0002\u000bY\fG.^3\t\u0011\r541\u000ba\u0001\u0007_\n\u0001\"\\3uC\u0012\fG/\u0019\t\u0005\u0007c\u001a)(\u0004\u0002\u0004t)\u00191Q\u000e\u0003\n\t\r]41\u000f\u0002\t\u001b\u0016$\u0018\rZ1uC\"Z\u0001aa\u001f\u0004\u0002\u000e\r5\u0011RBF!\r)5QP\u0005\u0004\u0007\u007f2%\u0001\u0002+fgR\faa\u001a:pkB\u001cHFABCC\t\u00199)\u0001\u0006gk:\u001cG/[8oC2\f\u0001\u0002^3ti:\u000bW.Z\u0011\u0003\u0007\u001b\u000bAC]3ti:Je\u000e^3he\u0006$\u0018n\u001c8UKN$\b")
public class IntegrationTest
extends RESTServerTestBase {
    private JavaLog org$infinispan$rest$IntegrationTest$$log;
    private final String HOST;
    private final String cacheName;
    private final String fullPath = new StringBuilder().append((Object)this.HOST()).append((Object)"/rest/").append((Object)this.cacheName()).toString();
    private final String DATE_PATTERN_RFC1123;
    private volatile boolean bitmap$0;

    private JavaLog org$infinispan$rest$IntegrationTest$$log$lzycompute() {
        IntegrationTest integrationTest = this;
        synchronized (integrationTest) {
            if (!this.bitmap$0) {
                this.org$infinispan$rest$IntegrationTest$$log = (JavaLog)LogFactory.getLog(this.getClass(), JavaLog.class);
                this.bitmap$0 = true;
            }
            return this.org$infinispan$rest$IntegrationTest$$log;
        }
    }

    public JavaLog org$infinispan$rest$IntegrationTest$$log() {
        return this.bitmap$0 ? this.org$infinispan$rest$IntegrationTest$$log : this.org$infinispan$rest$IntegrationTest$$log$lzycompute();
    }

    public String HOST() {
        return this.HOST;
    }

    public String cacheName() {
        return this.cacheName;
    }

    public String fullPath() {
        return this.fullPath;
    }

    public String DATE_PATTERN_RFC1123() {
        return this.DATE_PATTERN_RFC1123;
    }

    @BeforeClass
    public void setUp() {
        this.addServer("single", 8888, TestCacheManagerFactory.fromXml((String)"test-config.xml"));
        this.startServers();
        this.createClient();
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        this.stopServers();
        this.destroyClient();
    }

    public void testBasicOperation(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PutMethod insert = new PutMethod(fullPathKey);
        TopScope$ topScope$ = Predef$.MODULE$.$scope();
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("ho"));
        Elem initialXML = new Elem(null, "hey", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$, false, (Seq)$buf);
        insert.setRequestEntity((RequestEntity)new ByteArrayRequestEntity(initialXML.toString().getBytes(), "application/octet-stream"));
        this.call((HttpMethodBase)insert);
        AssertJUnit.assertEquals((String)"", (String)insert.getResponseBodyAsString().trim());
        AssertJUnit.assertEquals((int)200, (int)insert.getStatusCode());
        GetMethod get = new GetMethod(fullPathKey);
        this.call((HttpMethodBase)get);
        byte[] bytes = get.getResponseBody();
        AssertJUnit.assertEquals((int)Predef$.MODULE$.byteArrayOps(bytes).size(), (int)Predef$.MODULE$.byteArrayOps(initialXML.toString().getBytes()).size());
        TopScope$ topScope$2 = Predef$.MODULE$.$scope();
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("ho"));
        AssertJUnit.assertEquals((String)new Elem(null, "hey", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$2, false, (Seq)$buf2).toString(), (String)get.getResponseBodyAsString());
        Header hdr = get.getResponseHeader("Content-Type");
        AssertJUnit.assertEquals((String)"application/octet-stream", (String)hdr.getValue());
        DeleteMethod remove = new DeleteMethod(fullPathKey);
        this.call((HttpMethodBase)remove);
        this.call((HttpMethodBase)get);
        AssertJUnit.assertEquals((int)404, (int)get.getStatusCode());
        this.call((HttpMethodBase)insert);
        this.call((HttpMethodBase)get);
        TopScope$ topScope$3 = Predef$.MODULE$.$scope();
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)new Text("ho"));
        AssertJUnit.assertEquals((String)new Elem(null, "hey", (MetaData)Null$.MODULE$, (NamespaceBinding)topScope$3, false, (Seq)$buf3).toString(), (String)get.getResponseBodyAsString());
        DeleteMethod removeAll = new DeleteMethod(this.fullPath());
        AssertJUnit.assertEquals((int)200, (int)this.call((HttpMethodBase)removeAll).getStatusCode());
        this.call((HttpMethodBase)get);
        AssertJUnit.assertEquals((int)404, (int)get.getStatusCode());
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        ObjectOutputStream oo = new ObjectOutputStream(bout);
        oo.writeObject(new MIMECacheEntry("foo", "hey".getBytes()));
        oo.flush();
        byte[] byteData = bout.toByteArray();
        PutMethod insertMore = new PutMethod(fullPathKey);
        insertMore.setRequestEntity((RequestEntity)new ByteArrayRequestEntity(byteData, "application/octet-stream"));
        this.call((HttpMethodBase)insertMore);
        GetMethod getMore = new GetMethod(fullPathKey);
        this.call((HttpMethodBase)getMore);
        byte[] bytesBack = getMore.getResponseBody();
        AssertJUnit.assertEquals((int)byteData.length, (int)bytesBack.length);
        ObjectInputStream oin = new ObjectInputStream(new ByteArrayInputStream(bytesBack));
        MIMECacheEntry ce = (MIMECacheEntry)oin.readObject();
        AssertJUnit.assertEquals((String)"foo", (String)ce.contentType);
    }

    public void testEmptyGet() {
        AssertJUnit.assertEquals((int)404, (int)this.call((HttpMethodBase)new GetMethod(new StringBuilder().append((Object)this.HOST()).append((Object)"/rest/").append((Object)this.cacheName()).append((Object)"/nodata").toString())).getStatusCode());
    }

    public void testGetCollection() {
        PostMethod post_a = new PostMethod(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/a"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.fullPath()})));
        post_a.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", null));
        this.call((HttpMethodBase)post_a);
        PostMethod post_b = new PostMethod(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/b"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.fullPath()})));
        post_b.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", null));
        this.call((HttpMethodBase)post_b);
        String html = this.getCollection("text/html");
        AssertJUnit.assertTrue((boolean)html.contains("<a href=\"a\">a</a>"));
        AssertJUnit.assertTrue((boolean)html.contains("<a href=\"b\">b</a>"));
        String xml = this.getCollection("application/xml");
        AssertJUnit.assertTrue((boolean)xml.contains("<key>a</key>"));
        AssertJUnit.assertTrue((boolean)xml.contains("<key>b</key>"));
        String plain = this.getCollection("text/plain");
        AssertJUnit.assertTrue((boolean)plain.contains("a\n"));
        AssertJUnit.assertTrue((boolean)plain.contains("b\n"));
        String json = this.getCollection("application/json");
        AssertJUnit.assertTrue((boolean)json.contains("\"a\""));
        AssertJUnit.assertTrue((boolean)json.contains("\"b\""));
    }

    public void testGetCollectionEscape() {
        PostMethod post_a = new PostMethod(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/%22a%22"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.fullPath()})));
        post_a.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", null));
        this.call((HttpMethodBase)post_a);
        PostMethod post_b = new PostMethod(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/b%3E"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.fullPath()})));
        post_b.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", null));
        this.call((HttpMethodBase)post_b);
        String html = this.getCollection("text/html");
        AssertJUnit.assertTrue((boolean)html.contains("<a href=\"&quot;a&quot;\">&quot;a&quot;</a>"));
        AssertJUnit.assertTrue((boolean)html.contains("<a href=\"b&gt;\">b&gt;</a>"));
        String xml = this.getCollection("application/xml");
        AssertJUnit.assertTrue((boolean)xml.contains("<key>&quot;a&quot;</key>"));
        AssertJUnit.assertTrue((boolean)xml.contains("<key>b&gt;</key>"));
        String plain = this.getCollection("text/plain");
        AssertJUnit.assertTrue((boolean)plain.contains("\"a\"\n"));
        AssertJUnit.assertTrue((boolean)plain.contains("b>\n"));
        String json = this.getCollection("application/json");
        AssertJUnit.assertTrue((boolean)json.contains("\\\"a\\\""));
        AssertJUnit.assertTrue((boolean)json.contains("\"b>\""));
    }

    private String getCollection(String variant) {
        GetMethod get = new GetMethod(this.fullPath());
        get.addRequestHeader("Accept", variant);
        HttpMethodBase coll = this.call((HttpMethodBase)get);
        AssertJUnit.assertEquals((int)200, (int)coll.getStatusCode());
        AssertJUnit.assertEquals((String)variant, (String)coll.getResponseHeader("Content-Type").getValue());
        return coll.getResponseBodyAsString();
    }

    public void testGet(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PostMethod post = new PostMethod(fullPathKey);
        post.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", null));
        this.call((HttpMethodBase)post);
        HttpMethodBase get = this.call((HttpMethodBase)new GetMethod(fullPathKey));
        AssertJUnit.assertEquals((int)200, (int)get.getStatusCode());
        AssertJUnit.assertNotNull((Object)get.getResponseHeader("ETag").getValue());
        AssertJUnit.assertNotNull((Object)get.getResponseHeader("Last-Modified").getValue());
        AssertJUnit.assertEquals((String)"application/text", (String)get.getResponseHeader("Content-Type").getValue());
        AssertJUnit.assertEquals((String)"data", (String)get.getResponseBodyAsString());
    }

    public void testHead(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PostMethod post = new PostMethod(fullPathKey);
        post.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", null));
        this.call((HttpMethodBase)post);
        HttpMethodBase get = this.call((HttpMethodBase)new HeadMethod(fullPathKey));
        AssertJUnit.assertEquals((int)200, (int)get.getStatusCode());
        AssertJUnit.assertNotNull((Object)get.getResponseHeader("ETag").getValue());
        AssertJUnit.assertNotNull((Object)get.getResponseHeader("Last-Modified").getValue());
        AssertJUnit.assertEquals((String)"application/text", (String)get.getResponseHeader("Content-Type").getValue());
        AssertJUnit.assertNull((Object)get.getResponseBodyAsString());
    }

    public void testGetIfUnmodified(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PostMethod post = new PostMethod(fullPathKey);
        post.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", null));
        this.call((HttpMethodBase)post);
        HttpMethodBase get = this.call((HttpMethodBase)new GetMethod(fullPathKey));
        AssertJUnit.assertEquals((int)200, (int)get.getStatusCode());
        AssertJUnit.assertNotNull((Object)get.getResponseHeader("ETag").getValue());
        String lastMod = get.getResponseHeader("Last-Modified").getValue();
        AssertJUnit.assertNotNull((Object)lastMod);
        AssertJUnit.assertEquals((String)"application/text", (String)get.getResponseHeader("Content-Type").getValue());
        AssertJUnit.assertEquals((String)"data", (String)get.getResponseBodyAsString());
        GetMethod getAgain = new GetMethod(fullPathKey);
        getAgain.addRequestHeader("If-Unmodified-Since", lastMod);
        get = this.call((HttpMethodBase)getAgain);
        AssertJUnit.assertEquals((int)200, (int)get.getStatusCode());
        AssertJUnit.assertNotNull((Object)get.getResponseHeader("ETag").getValue());
        AssertJUnit.assertNotNull((Object)get.getResponseHeader("Last-Modified").getValue());
        AssertJUnit.assertEquals((String)"application/text", (String)get.getResponseHeader("Content-Type").getValue());
        AssertJUnit.assertEquals((String)"data", (String)get.getResponseBodyAsString());
    }

    public void testPostDuplicate(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PostMethod post = new PostMethod(fullPathKey);
        post.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        this.call((HttpMethodBase)post);
        AssertJUnit.assertEquals((int)409, (int)this.call((HttpMethodBase)post).getStatusCode());
        PutMethod put = new PutMethod(fullPathKey);
        put.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        AssertJUnit.assertEquals((int)200, (int)this.call((HttpMethodBase)put).getStatusCode());
    }

    public void testPutDataWithTimeToLive(Method m) {
        this.putAndAssertEphemeralData(m, "2", "3");
    }

    public void testPutDataWithMaxIdleOnly(Method m) {
        this.putAndAssertEphemeralData(m, "", "3");
    }

    public void testPutDataWithTimeToLiveOnly(Method m) {
        this.putAndAssertEphemeralData(m, "3", "");
    }

    private void putAndAssertEphemeralData(Method m, String timeToLiveSeconds, String maxIdleTimeSeconds) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PostMethod post = new PostMethod(fullPathKey);
        int maxWaitTime = 0;
        if (!timeToLiveSeconds.isEmpty()) {
            maxWaitTime = package$.MODULE$.max(maxWaitTime, new StringOps(Predef$.MODULE$.augmentString(timeToLiveSeconds)).toInt());
            post.setRequestHeader("timeToLiveSeconds", timeToLiveSeconds);
        }
        if (!maxIdleTimeSeconds.isEmpty()) {
            maxWaitTime = package$.MODULE$.max(maxWaitTime, new StringOps(Predef$.MODULE$.augmentString(maxIdleTimeSeconds)).toInt());
            post.setRequestHeader("maxIdleTimeSeconds", maxIdleTimeSeconds);
        }
        post.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        this.call((HttpMethodBase)post);
        HttpMethodBase get = this.call((HttpMethodBase)new GetMethod(fullPathKey));
        AssertJUnit.assertEquals((String)"data", (String)get.getResponseBodyAsString());
        TestingUtil.sleepThread((long)((maxWaitTime + 1) * 1000));
        this.call(get);
        AssertJUnit.assertEquals((int)404, (int)get.getStatusCode());
    }

    public void testPutDataWithIfMatch(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PutMethod put = new PutMethod(fullPathKey);
        put.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        this.call((HttpMethodBase)put);
        HttpMethodBase get = this.call((HttpMethodBase)new GetMethod(fullPathKey));
        AssertJUnit.assertEquals((int)200, (int)get.getStatusCode());
        String etag = get.getResponseHeader("ETag").getValue();
        PutMethod reput = new PutMethod(fullPathKey);
        reput.setRequestHeader("If-Match", etag);
        reput.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        AssertJUnit.assertEquals((int)200, (int)this.call((HttpMethodBase)reput).getStatusCode());
        PutMethod reputAgain = new PutMethod(fullPathKey);
        reputAgain.setRequestHeader("If-Match", "x");
        reputAgain.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        AssertJUnit.assertEquals((int)412, (int)this.call((HttpMethodBase)reputAgain).getStatusCode());
    }

    public void testPutDataWithIfNoneMatch(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PutMethod put = new PutMethod(fullPathKey);
        put.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        this.call((HttpMethodBase)put);
        HttpMethodBase get = this.call((HttpMethodBase)new GetMethod(fullPathKey));
        AssertJUnit.assertEquals((int)200, (int)get.getStatusCode());
        String etag = get.getResponseHeader("ETag").getValue();
        PutMethod reput = new PutMethod(fullPathKey);
        reput.setRequestHeader("If-None-Match", "x");
        reput.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        AssertJUnit.assertEquals((int)200, (int)this.call((HttpMethodBase)reput).getStatusCode());
        PutMethod reputAgain = new PutMethod(fullPathKey);
        reputAgain.setRequestHeader("If-None-Match", etag);
        reputAgain.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        AssertJUnit.assertEquals((int)412, (int)this.call((HttpMethodBase)reputAgain).getStatusCode());
    }

    public void testPutDataWithIfModifiedSince(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PutMethod put = new PutMethod(fullPathKey);
        put.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        this.call((HttpMethodBase)put);
        HttpMethodBase get = this.call((HttpMethodBase)new GetMethod(fullPathKey));
        AssertJUnit.assertEquals((int)200, (int)get.getStatusCode());
        String lastMod = get.getResponseHeader("Last-Modified").getValue();
        PutMethod reput = new PutMethod(fullPathKey);
        reput.setRequestHeader("If-Modified-Since", lastMod);
        reput.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        AssertJUnit.assertEquals((int)304, (int)this.call((HttpMethodBase)reput).getStatusCode());
        PutMethod reputAgain = new PutMethod(fullPathKey);
        String dateMinus = this.addDay(lastMod, -1);
        reputAgain.setRequestHeader("If-Modified-Since", dateMinus);
        reputAgain.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        AssertJUnit.assertEquals((int)200, (int)this.call((HttpMethodBase)reputAgain).getStatusCode());
    }

    public void testPutDataWithIfUnModifiedSince(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PutMethod put = new PutMethod(fullPathKey);
        put.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        this.call((HttpMethodBase)put);
        HttpMethodBase get = this.call((HttpMethodBase)new GetMethod(fullPathKey));
        AssertJUnit.assertEquals((int)200, (int)get.getStatusCode());
        String lastMod = get.getResponseHeader("Last-Modified").getValue();
        PutMethod reput = new PutMethod(fullPathKey);
        String dateMinus = this.addDay(lastMod, -1);
        reput.setRequestHeader("If-Unmodified-Since", dateMinus);
        reput.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        AssertJUnit.assertEquals((int)412, (int)this.call((HttpMethodBase)reput).getStatusCode());
        PutMethod reputAgain = new PutMethod(fullPathKey);
        reputAgain.setRequestHeader("If-Unmodified-Since", lastMod);
        reputAgain.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        AssertJUnit.assertEquals((int)200, (int)this.call((HttpMethodBase)reputAgain).getStatusCode());
    }

    public void testDeleteDataWithIfMatch(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PutMethod put = new PutMethod(fullPathKey);
        put.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        this.call((HttpMethodBase)put);
        HttpMethodBase get = this.call((HttpMethodBase)new GetMethod(fullPathKey));
        AssertJUnit.assertEquals((int)200, (int)get.getStatusCode());
        String etag = get.getResponseHeader("ETag").getValue();
        DeleteMethod delete = new DeleteMethod(fullPathKey);
        delete.setRequestHeader("If-Match", "x");
        AssertJUnit.assertEquals((int)412, (int)this.call((HttpMethodBase)delete).getStatusCode());
        DeleteMethod deleteAgain = new DeleteMethod(fullPathKey);
        deleteAgain.setRequestHeader("If-Match", etag);
        AssertJUnit.assertEquals((int)200, (int)this.call((HttpMethodBase)deleteAgain).getStatusCode());
    }

    public void testDeleteDataWithIfNoneMatch(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PutMethod put = new PutMethod(fullPathKey);
        put.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        this.call((HttpMethodBase)put);
        HttpMethodBase get = this.call((HttpMethodBase)new GetMethod(fullPathKey));
        AssertJUnit.assertEquals((int)200, (int)get.getStatusCode());
        String etag = get.getResponseHeader("ETag").getValue();
        DeleteMethod delete = new DeleteMethod(fullPathKey);
        delete.setRequestHeader("If-None-Match", etag);
        AssertJUnit.assertEquals((int)412, (int)this.call((HttpMethodBase)delete).getStatusCode());
        DeleteMethod deleteAgain = new DeleteMethod(fullPathKey);
        deleteAgain.setRequestHeader("If-None-Match", "x");
        AssertJUnit.assertEquals((int)200, (int)this.call((HttpMethodBase)deleteAgain).getStatusCode());
    }

    public void testDeleteDataWithIfModifiedSince(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PutMethod put = new PutMethod(fullPathKey);
        put.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        this.call((HttpMethodBase)put);
        HttpMethodBase get = this.call((HttpMethodBase)new GetMethod(fullPathKey));
        AssertJUnit.assertEquals((int)200, (int)get.getStatusCode());
        String lastMod = get.getResponseHeader("Last-Modified").getValue();
        DeleteMethod delete = new DeleteMethod(fullPathKey);
        delete.setRequestHeader("If-Modified-Since", lastMod);
        AssertJUnit.assertEquals((int)304, (int)this.call((HttpMethodBase)delete).getStatusCode());
        DeleteMethod deleteAgain = new DeleteMethod(fullPathKey);
        String dateMinus = this.addDay(lastMod, -1);
        deleteAgain.setRequestHeader("If-Modified-Since", dateMinus);
        AssertJUnit.assertEquals((int)200, (int)this.call((HttpMethodBase)deleteAgain).getStatusCode());
    }

    public void testDeleteDataWithIfUnmodifiedSince(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PutMethod put = new PutMethod(fullPathKey);
        put.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        this.call((HttpMethodBase)put);
        HttpMethodBase get = this.call((HttpMethodBase)new GetMethod(fullPathKey));
        AssertJUnit.assertEquals((int)200, (int)get.getStatusCode());
        String lastMod = get.getResponseHeader("Last-Modified").getValue();
        DeleteMethod delete = new DeleteMethod(fullPathKey);
        String dateMinus = this.addDay(lastMod, -1);
        delete.setRequestHeader("If-Unmodified-Since", dateMinus);
        AssertJUnit.assertEquals((int)412, (int)this.call((HttpMethodBase)delete).getStatusCode());
        DeleteMethod deleteAgain = new DeleteMethod(fullPathKey);
        deleteAgain.setRequestHeader("If-Unmodified-Since", lastMod);
        AssertJUnit.assertEquals((int)200, (int)this.call((HttpMethodBase)deleteAgain).getStatusCode());
    }

    public void testDeleteCachePreconditionUnimplemented(Method m) {
        this.testDeletePreconditionalUnimplemented(this.fullPath());
    }

    private void testDeletePreconditionalUnimplemented(String fullPathKey) {
        this.testDeletePreconditionalUnimplemented(fullPathKey, "If-Match");
        this.testDeletePreconditionalUnimplemented(fullPathKey, "If-None-Match");
        this.testDeletePreconditionalUnimplemented(fullPathKey, "If-Modified-Since");
        this.testDeletePreconditionalUnimplemented(fullPathKey, "If-Unmodified-Since");
    }

    private void testDeletePreconditionalUnimplemented(String fullPathKey, String preconditionalHeaderName) {
        DeleteMethod delete = new DeleteMethod(fullPathKey);
        delete.setRequestHeader(preconditionalHeaderName, "*");
        this.call((HttpMethodBase)delete);
        this.assertNotImplemented((HttpMethod)delete);
    }

    private void assertNotImplemented(HttpMethod method) {
        AssertJUnit.assertEquals((int)method.getStatusCode(), (int)501);
        AssertJUnit.assertEquals((String)method.getStatusText(), (String)"Not Implemented");
        Predef$.MODULE$.assert(method.getResponseBodyAsString().toLowerCase().contains("precondition"));
    }

    public void testRemoveEntry(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PostMethod put = new PostMethod(fullPathKey);
        put.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        this.call((HttpMethodBase)put);
        AssertJUnit.assertEquals((int)200, (int)this.call((HttpMethodBase)new HeadMethod(fullPathKey)).getStatusCode());
        this.call((HttpMethodBase)new DeleteMethod(fullPathKey));
        AssertJUnit.assertEquals((int)404, (int)this.call((HttpMethodBase)new HeadMethod(fullPathKey)).getStatusCode());
    }

    public void testWipeCacheBucket(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PostMethod put = new PostMethod(fullPathKey);
        put.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        this.call((HttpMethodBase)put);
        PostMethod put_ = new PostMethod(new StringBuilder().append((Object)fullPathKey).append((Object)"2").toString());
        put_.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        this.call((HttpMethodBase)put_);
        AssertJUnit.assertEquals((int)200, (int)this.call((HttpMethodBase)new HeadMethod(fullPathKey)).getStatusCode());
        this.call((HttpMethodBase)new DeleteMethod(this.fullPath()));
        AssertJUnit.assertEquals((int)404, (int)this.call((HttpMethodBase)new HeadMethod(fullPathKey)).getStatusCode());
    }

    public void testAsyncAddRemove(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PostMethod put = new PostMethod(fullPathKey);
        put.setRequestHeader("performAsync", "true");
        put.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        this.call((HttpMethodBase)put);
        Thread.sleep(50L);
        AssertJUnit.assertEquals((int)200, (int)this.call((HttpMethodBase)new HeadMethod(fullPathKey)).getStatusCode());
        DeleteMethod del = new DeleteMethod(fullPathKey);
        del.setRequestHeader("performAsync", "true");
        this.call((HttpMethodBase)del);
        Thread.sleep(50L);
        AssertJUnit.assertEquals((int)404, (int)this.call((HttpMethodBase)new HeadMethod(fullPathKey)).getStatusCode());
    }

    public void testShouldCopeWithSerializable(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        this.call((HttpMethodBase)new GetMethod(fullPathKey));
        MySer obj = new MySer();
        obj.name_$eq("mic");
        this.getCacheManager("single").getCache("___defaultcache").put((Object)m.getName(), (Object)obj);
        this.getCacheManager("single").getCache("___defaultcache").put((Object)new StringBuilder().append((Object)m.getName()).append((Object)"2").toString(), (Object)"hola");
        this.getCacheManager("single").getCache("___defaultcache").put((Object)new StringBuilder().append((Object)m.getName()).append((Object)"3").toString(), (Object)new MyNonSer());
        GetMethod get = new GetMethod(fullPathKey);
        get.setRequestHeader("Accept", "application/x-java-serialized-object");
        this.call((HttpMethodBase)get);
        AssertJUnit.assertEquals((int)200, (int)get.getStatusCode());
        ObjectInputStream in = new ObjectInputStream(get.getResponseBodyAsStream());
        MySer res = (MySer)in.readObject();
        AssertJUnit.assertNotNull((Object)res);
        AssertJUnit.assertEquals((String)"mic", (String)res.name());
        AssertJUnit.assertEquals((String)"application/x-java-serialized-object", (String)get.getResponseHeader("Content-Type").getValue());
        HttpMethodBase getStr = this.call((HttpMethodBase)new GetMethod(new StringBuilder().append((Object)fullPathKey).append((Object)"2").toString()));
        AssertJUnit.assertEquals((String)"hola", (String)getStr.getResponseBodyAsString());
        AssertJUnit.assertEquals((String)"text/plain", (String)getStr.getResponseHeader("Content-Type").getValue());
        get.setRequestHeader("Accept", "application/json");
        this.call((HttpMethodBase)get);
        AssertJUnit.assertEquals((String)"{\"name\":\"mic\"}", (String)get.getResponseBodyAsString());
        AssertJUnit.assertEquals((String)"application/json", (String)get.getResponseHeader("Content-Type").getValue());
        get.setRequestHeader("Accept", "application/xml");
        this.call((HttpMethodBase)get);
        AssertJUnit.assertEquals((String)"application/xml", (String)get.getResponseHeader("Content-Type").getValue());
        AssertJUnit.assertTrue((get.getResponseBodyAsString().indexOf("<org.infinispan.rest.MySer>") > -1 ? 1 : 0) != 0);
        GetMethod get3 = new GetMethod(new StringBuilder().append((Object)fullPathKey).append((Object)"3").toString());
        get3.setRequestHeader("Accept", "application/json");
        this.call((HttpMethodBase)get3);
        AssertJUnit.assertEquals((String)"{\"name\":\"mic\"}", (String)get3.getResponseBodyAsString());
        AssertJUnit.assertEquals((String)"application/json", (String)get3.getResponseHeader("Content-Type").getValue());
    }

    public void testInsertSerializableObjects(Method m) {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        new ObjectOutputStream(bout).writeObject(new MySer());
        this.put(m, bout.toByteArray(), "application/x-java-serialized-object");
        byte[] cfr_ignored_0 = (byte[])this.getCacheManager("single").getCache("___defaultcache").get((Object)m.getName());
    }

    public void testNonexistentCache(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.HOST()).append((Object)"/rest/nonexistent/").append((Object)m.getName()).toString();
        GetMethod get = new GetMethod(fullPathKey);
        this.call((HttpMethodBase)get);
        AssertJUnit.assertEquals((int)404, (int)get.getStatusCode());
        HttpMethodBase head = this.call((HttpMethodBase)new HeadMethod(fullPathKey));
        AssertJUnit.assertEquals((int)404, (int)head.getStatusCode());
        PostMethod put = new PostMethod(fullPathKey);
        put.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        this.call((HttpMethodBase)put);
        AssertJUnit.assertEquals((int)404, (int)put.getStatusCode());
    }

    public void testByteArrayAsSerializedObjects(Method m) {
        this.sendByteArrayAs(m, "application/x-java-serialized-object");
    }

    public void testByteArrayAsOctecStreamObjects(Method m) {
        this.sendByteArrayAs(m, "application/octet-stream");
    }

    private void sendByteArrayAs(Method m, String contentType) {
        byte[] serializedOnClient = (byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{101, 102, 103}), ClassTag$.MODULE$.Byte());
        this.put(m, serializedOnClient, contentType);
        BufferedInputStream dataRead = new BufferedInputStream(this.get(m, (Option<String>)None$.MODULE$, (Option<String>)new Some((Object)contentType)).getResponseBodyAsStream());
        byte[] bytesRead = new byte[3];
        dataRead.read(bytesRead);
        AssertJUnit.assertEquals((byte[])serializedOnClient, (byte[])bytesRead);
    }

    public void testIfUnmodifiedSince(Method m) {
        this.put(m);
        HttpMethodBase result = this.get(m);
        String dateLast = result.getResponseHeader("Last-Modified").getValue();
        String dateMinus = this.addDay(dateLast, -1);
        String datePlus = this.addDay(dateLast, 1);
        AssertJUnit.assertNotNull((Object)this.get(m, (Option<String>)new Some((Object)dateLast)).getResponseBodyAsString());
        AssertJUnit.assertNotNull((Object)this.get(m, (Option<String>)new Some((Object)datePlus)).getResponseBodyAsString());
        HttpMethodBase httpMethodBase = this.get(m, (Option<String>)new Some((Object)dateMinus), (Option<String>)None$.MODULE$, 412);
    }

    public void testETagChanges(Method m) {
        this.put(m, "data1");
        String eTagFirst = this.get(m).getResponseHeader("ETag").getValue();
        AssertJUnit.assertEquals((String)eTagFirst, (String)this.get(m).getResponseHeader("ETag").getValue());
        this.put(m, "data2");
        String eTagSecond = this.get(m).getResponseHeader("ETag").getValue();
        AssertJUnit.assertFalse((String)new StringOps(Predef$.MODULE$.augmentString("etag1 %s; etag2 %s; equals? %b")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{eTagFirst, eTagSecond, BoxesRunTime.boxToBoolean((boolean)eTagFirst.equals(eTagSecond))})), (boolean)eTagFirst.equals(eTagSecond));
    }

    public void testConcurrentETagChanges(Method m) {
        this.put(m, "data1");
        CountDownLatch v2PutLatch = new CountDownLatch(1);
        CountDownLatch v3PutLatch = new CountDownLatch(1);
        CountDownLatch v2FinishLatch = new CountDownLatch(1);
        EmbeddedCacheManager origCacheManager = this.getCacheManager("single");
        ControlledCacheManager mockCacheManager = new ControlledCacheManager(this, origCacheManager, v2PutLatch, v3PutLatch, v2FinishLatch);
        Map knownCaches = this.getManagerInstance("single").knownCaches();
        try {
            knownCaches.put("___defaultcache", mockCacheManager.getCache());
            Serializable x$1 = new Serializable(this, m, v2FinishLatch){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ IntegrationTest $outer;
                private final Method m$1;
                private final CountDownLatch v2FinishLatch$1;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    HttpClient newClient = new HttpClient();
                    PutMethod put = new PutMethod(this.$outer.org$infinispan$rest$IntegrationTest$$fullPathKey(this.m$1));
                    put.setRequestHeader("Content-Type", "application/text");
                    put.setRequestEntity((RequestEntity)new StringRequestEntity("data2", null, null));
                    newClient.executeMethod((HttpMethod)put);
                    AssertJUnit.assertEquals((int)200, (int)put.getStatusCode());
                    this.v2FinishLatch$1.countDown();
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.m$1 = m$1;
                    this.v2FinishLatch$1 = v2FinishLatch$1;
                }
            };
            FutureTaskRunner x$2 = ops$.MODULE$.future$default$2((Function0)x$1);
            Function0 replaceFuture = ops$.MODULE$.future((Function0)x$1, x$2);
            boolean bl = v3PutLatch.await(10L, TimeUnit.SECONDS);
            AssertJUnit.assertTrue((String)"Timed out waiting for concurrent put", (boolean)bl);
            PutMethod put = new PutMethod(this.org$infinispan$rest$IntegrationTest$$fullPathKey(m));
            put.setRequestHeader("Content-Type", "application/text");
            put.setRequestEntity((RequestEntity)new StringRequestEntity("data3", null, null));
            this.call((HttpMethodBase)put);
            AssertJUnit.assertEquals((int)412, (int)put.getStatusCode());
            replaceFuture.apply$mcV$sp();
            AssertJUnit.assertEquals((String)"data2", (String)this.get(m).getResponseBodyAsString());
            return;
        }
        finally {
            knownCaches.put("___defaultcache", origCacheManager.getCache().getAdvancedCache());
        }
    }

    public void testSerializedStringGetBytes(Method m) {
        byte[] data = new StringBuilder().append((Object)"v-").append((Object)m.getName()).toString().getBytes("UTF-8");
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        ObjectOutputStream oo = new ObjectOutputStream(bout);
        oo.writeObject(data);
        oo.flush();
        byte[] bytes = bout.toByteArray();
        this.put(m, bytes, "application/x-java-serialized-object");
        byte[] bytesRead = this.get(m, (Option<String>)None$.MODULE$, (Option<String>)new Some((Object)"application/x-java-serialized-object")).getResponseBody();
        AssertJUnit.assertTrue((boolean)Arrays.equals(bytes, bytesRead));
        ObjectInputStream oin = new ObjectInputStream(new ByteArrayInputStream(bytesRead));
        byte[] dataBack = (byte[])oin.readObject();
        AssertJUnit.assertTrue((boolean)Arrays.equals(data, dataBack));
    }

    public void testDefaultConfiguredExpiryValues(Method m) {
        String cacheName = "evictExpiryCache";
        String fullPathKey = new StringOps(Predef$.MODULE$.augmentString("%s/rest/%s/%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.HOST(), cacheName, m.getName()}));
        PostMethod post = new PostMethod(fullPathKey);
        post.setRequestHeader("timeToLiveSeconds", "-1");
        post.setRequestEntity((RequestEntity)new StringRequestEntity("data", "text/plain", "UTF-8"));
        this.call((HttpMethodBase)post);
        Thread.sleep(5000L);
        HttpMethodBase get = this.call((HttpMethodBase)new GetMethod(fullPathKey));
        AssertJUnit.assertEquals((String)"data", (String)get.getResponseBodyAsString());
        AssertJUnit.assertNull((Object)get.getResponseHeader("Expires"));
        long startTime = System.currentTimeMillis();
        int lifespan = 3000;
        fullPathKey = new StringOps(Predef$.MODULE$.augmentString("%s-2")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fullPathKey}));
        post = new PostMethod(fullPathKey);
        post.setRequestHeader("Content-Type", "application/text");
        post.setRequestHeader("timeToLiveSeconds", "0");
        post.setRequestHeader("maxIdleTimeSeconds", "0");
        post.setRequestEntity((RequestEntity)new StringRequestEntity("data2", "text/plain", "UTF-8"));
        this.call((HttpMethodBase)post);
        while (System.currentTimeMillis() < startTime + (long)lifespan) {
            get = this.call((HttpMethodBase)new GetMethod(fullPathKey));
            String response = get.getResponseBodyAsString();
            if (System.currentTimeMillis() >= startTime + (long)lifespan) continue;
            AssertJUnit.assertEquals((String)"data2", (String)response);
            AssertJUnit.assertNotNull((Object)get.getResponseHeader("Expires"));
            Thread.sleep(100L);
        }
        this.waitNotFound(startTime, lifespan, fullPathKey);
        AssertJUnit.assertEquals((int)404, (int)this.call((HttpMethodBase)new GetMethod(fullPathKey)).getStatusCode());
        startTime = System.currentTimeMillis();
        lifespan = 0;
        fullPathKey = new StringOps(Predef$.MODULE$.augmentString("%s-3")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fullPathKey}));
        post = new PostMethod(fullPathKey);
        post.setRequestHeader("timeToLiveSeconds", "0");
        post.setRequestEntity((RequestEntity)new StringRequestEntity("data3", "text/plain", "UTF-8"));
        this.call((HttpMethodBase)post);
        this.waitNotFound(startTime, lifespan, fullPathKey);
        fullPathKey = new StringOps(Predef$.MODULE$.augmentString("%s-4")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fullPathKey}));
        post = new PostMethod(fullPathKey);
        post.setRequestHeader("maxIdleTimeSeconds", "0");
        post.setRequestEntity((RequestEntity)new StringRequestEntity("data4", "text/plain", "UTF-8"));
        this.call((HttpMethodBase)post);
        Thread.sleep(2500L);
        AssertJUnit.assertEquals((int)404, (int)this.call((HttpMethodBase)new GetMethod(fullPathKey)).getStatusCode());
    }

    public void testPutByteArrayTwice(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PutMethod put = new PutMethod(fullPathKey);
        byte[] data = (byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{42, 42, 42}), ClassTag$.MODULE$.Byte());
        put.setRequestEntity((RequestEntity)new ByteArrayRequestEntity(data, "application/x-java-serialized-object"));
        AssertJUnit.assertEquals((int)200, (int)this.call((HttpMethodBase)put).getStatusCode());
        HttpMethodBase get = this.call((HttpMethodBase)new GetMethod(fullPathKey));
        AssertJUnit.assertEquals((int)200, (int)get.getStatusCode());
        PutMethod reput = new PutMethod(fullPathKey);
        reput.setRequestEntity((RequestEntity)new ByteArrayRequestEntity(data, "application/x-java-serialized-object"));
        AssertJUnit.assertEquals((int)200, (int)this.call((HttpMethodBase)reput).getStatusCode());
    }

    public void testDeleteSerializedObject(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PutMethod put = new PutMethod(fullPathKey);
        byte[] data = (byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{42, 42, 42}), ClassTag$.MODULE$.Byte());
        put.setRequestEntity((RequestEntity)new ByteArrayRequestEntity(data, "application/x-java-serialized-object"));
        AssertJUnit.assertEquals((int)200, (int)this.call((HttpMethodBase)put).getStatusCode());
        HttpMethodBase get = this.call((HttpMethodBase)new GetMethod(fullPathKey));
        AssertJUnit.assertEquals((int)200, (int)get.getStatusCode());
        HttpMethodBase delete = this.call((HttpMethodBase)new DeleteMethod(fullPathKey));
        AssertJUnit.assertEquals((int)200, (int)delete.getStatusCode());
    }

    private void waitNotFound(long startTime, int lifespan, String fullPathKey) {
        while (System.currentTimeMillis() < startTime + (long)lifespan + 20000L && !((Object)BoxesRunTime.boxToInteger((int)404)).equals(BoxesRunTime.boxToInteger((int)this.call((HttpMethodBase)new GetMethod(fullPathKey)).getStatusCode()))) {
            Thread.sleep(100L);
        }
    }

    private HttpMethodBase put(Method m) {
        return this.put(m, "data", "application/text");
    }

    private HttpMethodBase put(Method m, Object data) {
        return this.put(m, data, "application/text");
    }

    private HttpMethodBase put(Method m, Object data, String contentType) {
        Object object;
        block4: {
            StringRequestEntity stringRequestEntity;
            PutMethod put;
            block3: {
                block2: {
                    put = new PutMethod(this.org$infinispan$rest$IntegrationTest$$fullPathKey(m));
                    put.setRequestHeader("Content-Type", contentType);
                    object = data;
                    if (!(object instanceof String)) break block2;
                    String x2 = (String)object;
                    stringRequestEntity = new StringRequestEntity(x2, null, null);
                    break block3;
                }
                if (!(object instanceof byte[])) break block4;
                byte[] x3 = (byte[])object;
                stringRequestEntity = new InputStreamRequestEntity((InputStream)new ByteArrayInputStream(x3));
            }
            StringRequestEntity reqEntity = stringRequestEntity;
            put.setRequestEntity((RequestEntity)reqEntity);
            this.call((HttpMethodBase)put);
            AssertJUnit.assertEquals((int)200, (int)put.getStatusCode());
            return put;
        }
        throw new MatchError(object);
    }

    private HttpMethodBase get(Method m) {
        return this.get(m, (Option<String>)None$.MODULE$);
    }

    private HttpMethodBase get(Method m, Option<String> unmodSince) {
        return this.get(m, unmodSince, (Option<String>)None$.MODULE$, 200);
    }

    private HttpMethodBase get(Method m, Option<String> unmodSince, Option<String> acceptType) {
        return this.get(m, unmodSince, acceptType, 200);
    }

    private HttpMethodBase get(Method m, Option<String> unmodSince, Option<String> acceptType, int expCode) {
        GetMethod get = new GetMethod(this.org$infinispan$rest$IntegrationTest$$fullPathKey(m));
        Option<String> option = unmodSince;
        None$ none$ = None$.MODULE$;
        if (option == null ? none$ != null : !option.equals((Object)none$)) {
            get.setRequestHeader("If-Unmodified-Since", (String)unmodSince.get());
        }
        Option<String> option2 = acceptType;
        None$ none$2 = None$.MODULE$;
        if (option2 == null ? none$2 != null : !option2.equals((Object)none$2)) {
            get.setRequestHeader("Accept", (String)acceptType.get());
        }
        this.call((HttpMethodBase)get);
        AssertJUnit.assertEquals((int)expCode, (int)get.getStatusCode());
        return get;
    }

    public String org$infinispan$rest$IntegrationTest$$fullPathKey(Method m) {
        return new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
    }

    public String addDay(String aDate, int days) {
        SimpleDateFormat format = new SimpleDateFormat(this.DATE_PATTERN_RFC1123(), Locale.US);
        Date date = format.parse(aDate);
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(5, days);
        return format.format(cal.getTime());
    }

    public IntegrationTest() {
        this.HOST = "http://localhost:8888";
        this.cacheName = "___defaultcache";
        this.DATE_PATTERN_RFC1123 = "EEE, dd MMM yyyy HH:mm:ss zzz";
    }

    public class ControlledCache<String, Any>
    extends AbstractDelegatingAdvancedCache<String, Any> {
        private final CountDownLatch v2PutLatch;
        private final CountDownLatch v3PutLatch;
        private final CountDownLatch v2FinishLatch;
        public final /* synthetic */ IntegrationTest $outer;

        public boolean replace(String key, Any oldValue, Any value, Metadata metadata) {
            Object object;
            byte[] newByteArray = (byte[])value;
            byte[] oldByteArray = (byte[])oldValue;
            String oldAsString = new String(oldByteArray);
            String newAsString = new String(newByteArray);
            if (Arrays.equals(newByteArray, "data2".getBytes())) {
                this.org$infinispan$rest$IntegrationTest$ControlledCache$$$outer().org$infinispan$rest$IntegrationTest$$log().debug((Object)"Let v3 apply...");
                this.v3PutLatch.countDown();
                this.org$infinispan$rest$IntegrationTest$ControlledCache$$$outer().org$infinispan$rest$IntegrationTest$$log().debug((Object)"Wait until v2 can be stored");
                boolean bl = this.v2PutLatch.await(10L, TimeUnit.SECONDS);
                if (!bl) {
                    AssertJUnit.fail((String)"Timed out waiting for v2 to be allowed");
                }
                object = BoxedUnit.UNIT;
            } else if (Arrays.equals(newByteArray, "data3".getBytes())) {
                this.org$infinispan$rest$IntegrationTest$ControlledCache$$$outer().org$infinispan$rest$IntegrationTest$$log().debugf("About to store v3, let v2 apply, oldValue(for v3)=%s", new Object[]{oldAsString});
                this.v2PutLatch.countDown();
                object = BoxesRunTime.boxToBoolean((boolean)this.v2FinishLatch.await(10L, TimeUnit.SECONDS));
            } else {
                object = BoxedUnit.UNIT;
            }
            this.org$infinispan$rest$IntegrationTest$ControlledCache$$$outer().org$infinispan$rest$IntegrationTest$$log().debugf("Replace key=%s, oldValue=%s, value=%s", key, (Object)oldAsString, (Object)newAsString);
            return super.replace(key, oldValue, value, metadata);
        }

        public /* synthetic */ IntegrationTest org$infinispan$rest$IntegrationTest$ControlledCache$$$outer() {
            return this.$outer;
        }

        public ControlledCache(IntegrationTest $outer, Cache<String, Any> cache, CountDownLatch v2PutLatch, CountDownLatch v3PutLatch, CountDownLatch v2FinishLatch) {
            this.v2PutLatch = v2PutLatch;
            this.v3PutLatch = v3PutLatch;
            this.v2FinishLatch = v2FinishLatch;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            super(cache.getAdvancedCache());
        }
    }

    public class ControlledCacheManager
    extends AbstractDelegatingEmbeddedCacheManager {
        private final CountDownLatch v2PutLatch;
        private final CountDownLatch v3PutLatch;
        private final CountDownLatch v2FinishLatch;
        public final /* synthetic */ IntegrationTest $outer;

        public <K, V> AdvancedCache<K, V> getCache() {
            return new ControlledCache(this.org$infinispan$rest$IntegrationTest$ControlledCacheManager$$$outer(), super.getCache(), this.v2PutLatch, this.v3PutLatch, this.v2FinishLatch);
        }

        public /* synthetic */ IntegrationTest org$infinispan$rest$IntegrationTest$ControlledCacheManager$$$outer() {
            return this.$outer;
        }

        public ControlledCacheManager(IntegrationTest $outer, EmbeddedCacheManager cm, CountDownLatch v2PutLatch, CountDownLatch v3PutLatch, CountDownLatch v2FinishLatch) {
            this.v2PutLatch = v2PutLatch;
            this.v3PutLatch = v3PutLatch;
            this.v2FinishLatch = v2FinishLatch;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            super(cm);
        }
    }
}

