/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.core.CacheControl;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.ByteArrayRequestEntity;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.cache.impl.AbstractDelegatingAdvancedCache;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.manager.impl.AbstractDelegatingEmbeddedCacheManager;
import org.infinispan.metadata.Metadata;
import org.infinispan.remoting.MIMECacheEntry;
import org.infinispan.rest.MyNonSer;
import org.infinispan.rest.MySer;
import org.infinispan.rest.RestServerTestBase;
import org.infinispan.server.core.logging.JavaLog;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.util.logging.LogFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import scala.Array$;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.xml.Elem;
import scala.xml.MetaData;
import scala.xml.NamespaceBinding;
import scala.xml.NodeBuffer;
import scala.xml.Null$;
import scala.xml.Text;
import scala.xml.TopScope$;

@Test(groups={"unstable"}, testName="rest.IntegrationTest", description="See ISPN-3994, original group: functional")
@ScalaSignature(bytes="\u0006\u0001\ruf\u0001B\u0001\u0003\u0001%\u0011q\"\u00138uK\u001e\u0014\u0018\r^5p]R+7\u000f\u001e\u0006\u0003\u0007\u0011\tAA]3ti*\u0011QAB\u0001\u000bS:4\u0017N\\5ta\u0006t'\"A\u0004\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001Q\u0001CA\u0006\r\u001b\u0005\u0011\u0011BA\u0007\u0003\u0005I\u0011Vm\u001d;TKJ4XM\u001d+fgR\u0014\u0015m]3\t\u000b=\u0001A\u0011\u0001\t\u0002\rqJg.\u001b;?)\u0005\t\u0002CA\u0006\u0001\u0011!\u0019\u0002\u0001#b\u0001\n\u0013!\u0012a\u00017pOV\tQ\u0003\u0005\u0002\u0017;5\tqC\u0003\u0002\u00193\u00059An\\4hS:<'B\u0001\u000e\u001c\u0003\u0011\u0019wN]3\u000b\u0005q!\u0011AB:feZ,'/\u0003\u0002\u001f/\t9!*\u0019<b\u0019><\u0007\u0002\u0003\u0011\u0001\u0011\u0003\u0005\u000b\u0015B\u000b\u0002\t1|w\r\t\u0005\bE\u0001\u0011\r\u0011\"\u0001$\u0003\u0011Auj\u0015+\u0016\u0003\u0011\u0002\"!\n\u0016\u000e\u0003\u0019R!a\n\u0015\u0002\t1\fgn\u001a\u0006\u0002S\u0005!!.\u0019<b\u0013\tYcE\u0001\u0004TiJLgn\u001a\u0005\u0007[\u0001\u0001\u000b\u0011\u0002\u0013\u0002\u000b!{5\u000b\u0016\u0011\t\u000f=\u0002!\u0019!C\u0001G\u0005I1-Y2iK:\u000bW.\u001a\u0005\u0007c\u0001\u0001\u000b\u0011\u0002\u0013\u0002\u0015\r\f7\r[3OC6,\u0007\u0005C\u00044\u0001\t\u0007I\u0011A\u0012\u0002\u0011\u0019,H\u000e\u001c)bi\"Da!\u000e\u0001!\u0002\u0013!\u0013!\u00034vY2\u0004\u0016\r\u001e5!\u0011\u001d9\u0004A1A\u0005\u0002\r\nA\u0003R!U\u000b~\u0003\u0016\t\u0016+F%:{&KR\"2cI\u001a\u0004BB\u001d\u0001A\u0003%A%A\u000bE\u0003R+u\fU!U)\u0016\u0013fj\u0018*G\u0007F\n$g\r\u0011\t\u000bm\u0002A\u0011\u0001\u001f\u0002\u000bM,G/\u00169\u0015\u0003u\u0002\"AP!\u000e\u0003}R\u0011\u0001Q\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0005~\u0012A!\u00168ji\"\"!\b\u0012'N!\t)%*D\u0001G\u0015\t9\u0005*A\u0006b]:|G/\u0019;j_:\u001c(BA%\u0007\u0003\u0019!Xm\u001d;oO&\u00111J\u0012\u0002\f\u0005\u00164wN]3DY\u0006\u001c8/A\u0005bY^\f\u0017p\u001d*v]f\t\u0011\u0001C\u0003P\u0001\u0011\u0005A(\u0001\u0005uK\u0006\u0014Hi\\<oQ\u0011q\u0015\u000bT'\u0011\u0005\u0015\u0013\u0016BA*G\u0005)\te\r^3s\u00072\f7o\u001d\u0005\u0006+\u0002!\tAV\u0001\u0013i\u0016\u001cHOQ1tS\u000e|\u0005/\u001a:bi&|g\u000e\u0006\u0002>/\")\u0001\f\u0016a\u00013\u0006\tQ\u000e\u0005\u0002[;6\t1L\u0003\u0002]M\u00059!/\u001a4mK\u000e$\u0018B\u00010\\\u0005\u0019iU\r\u001e5pI\")\u0001\r\u0001C\u0001y\u0005aA/Z:u\u000b6\u0004H/_$fi\")!\r\u0001C\u0001y\u0005\tB/Z:u\u000f\u0016$8i\u001c7mK\u000e$\u0018n\u001c8\t\u000b\u0011\u0004A\u0011\u0001\u001f\u0002/Q,7\u000f^$fi\u000e{G\u000e\\3di&|g.R:dCB,\u0007\"\u00024\u0001\t\u00139\u0017!D4fi\u000e{G\u000e\\3di&|g\u000e\u0006\u0002i]B\u0011\u0011\u000e\u001c\b\u0003})L!a[ \u0002\rA\u0013X\rZ3g\u0013\tYSN\u0003\u0002l\u007f!)q.\u001aa\u0001Q\u00069a/\u0019:jC:$\b\"B9\u0001\t\u0003\u0011\u0018a\u0002;fgR<U\r\u001e\u000b\u0003{MDQ\u0001\u00179A\u0002eCQ!\u001e\u0001\u0005\u0002Y\f\u0001\u0002^3ti\"+\u0017\r\u001a\u000b\u0003{]DQ\u0001\u0017;A\u0002eCQ!\u001f\u0001\u0005\u0002i\f1\u0003^3ti\u001e+G/\u00134V]6|G-\u001b4jK\u0012$\"!P>\t\u000baC\b\u0019A-\t\u000bu\u0004A\u0011\u0001@\u0002#Q,7\u000f\u001e)pgR$U\u000f\u001d7jG\u0006$X\r\u0006\u0002>\u007f\")\u0001\f a\u00013\"9\u00111\u0001\u0001\u0005\u0002\u0005\u0015\u0011!\u0007;fgR\u0004V\u000f\u001e#bi\u0006<\u0016\u000e\u001e5US6,Gk\u001c'jm\u0016$2!PA\u0004\u0011\u0019A\u0016\u0011\u0001a\u00013\"9\u00111\u0002\u0001\u0005\u0002\u00055\u0011A\u0007;fgR\u0004V\u000f\u001e#bi\u0006<\u0016\u000e\u001e5NCbLE\r\\3P]2LHcA\u001f\u0002\u0010!1\u0001,!\u0003A\u0002eCq!a\u0005\u0001\t\u0003\t)\"A\u000fuKN$\b+\u001e;ECR\fw+\u001b;i)&lW\rV8MSZ,wJ\u001c7z)\ri\u0014q\u0003\u0005\u00071\u0006E\u0001\u0019A-\t\u000f\u0005m\u0001\u0001\"\u0003\u0002\u001e\u0005I\u0002/\u001e;B]\u0012\f5o]3si\u0016\u0003\b.Z7fe\u0006dG)\u0019;b)\u001di\u0014qDA\u0011\u0003KAa\u0001WA\r\u0001\u0004I\u0006bBA\u0012\u00033\u0001\r\u0001[\u0001\u0012i&lW\rV8MSZ,7+Z2p]\u0012\u001c\bbBA\u0014\u00033\u0001\r\u0001[\u0001\u0013[\u0006D\u0018\n\u001a7f)&lWmU3d_:$7\u000fC\u0004\u0002,\u0001!\t!!\f\u0002-Q,7\u000f\u001e)vi\u0012\u000bG/Y,ji\"Le-T1uG\"$2!PA\u0018\u0011\u0019A\u0016\u0011\u0006a\u00013\"9\u00111\u0007\u0001\u0005\u0002\u0005U\u0012A\u0007;fgR\u0004V\u000f\u001e#bi\u0006<\u0016\u000e\u001e5JM:{g.Z'bi\u000eDGcA\u001f\u00028!1\u0001,!\rA\u0002eCq!a\u000f\u0001\t\u0003\ti$\u0001\u0010uKN$\b+\u001e;ECR\fw+\u001b;i\u0013\u001alu\u000eZ5gS\u0016$7+\u001b8dKR\u0019Q(a\u0010\t\ra\u000bI\u00041\u0001Z\u0011\u001d\t\u0019\u0005\u0001C\u0001\u0003\u000b\n\u0001\u0005^3tiB+H\u000fR1uC^KG\u000f[%g+:lu\u000eZ5gS\u0016$7+\u001b8dKR\u0019Q(a\u0012\t\ra\u000b\t\u00051\u0001Z\u0011\u001d\tY\u0005\u0001C\u0001\u0003\u001b\n\u0011\u0004^3ti\u0012+G.\u001a;f\t\u0006$\u0018mV5uQ&3W*\u0019;dQR\u0019Q(a\u0014\t\ra\u000bI\u00051\u0001Z\u0011\u001d\t\u0019\u0006\u0001C\u0001\u0003+\nQ\u0004^3ti\u0012+G.\u001a;f\t\u0006$\u0018mV5uQ&3gj\u001c8f\u001b\u0006$8\r\u001b\u000b\u0004{\u0005]\u0003B\u0002-\u0002R\u0001\u0007\u0011\fC\u0004\u0002\\\u0001!\t!!\u0018\u0002CQ,7\u000f\u001e#fY\u0016$X\rR1uC^KG\u000f[%g\u001b>$\u0017NZ5fINKgnY3\u0015\u0007u\ny\u0006\u0003\u0004Y\u00033\u0002\r!\u0017\u0005\b\u0003G\u0002A\u0011AA3\u0003\r\"Xm\u001d;EK2,G/\u001a#bi\u0006<\u0016\u000e\u001e5JMVsWn\u001c3jM&,GmU5oG\u0016$2!PA4\u0011\u0019A\u0016\u0011\ra\u00013\"9\u00111\u000e\u0001\u0005\u0002\u00055\u0014\u0001\u000b;fgR$U\r\\3uK\u000e\u000b7\r[3Qe\u0016\u001cwN\u001c3ji&|g.\u00168j[BdW-\\3oi\u0016$GcA\u001f\u0002p!1\u0001,!\u001bA\u0002eCq!a\u001d\u0001\t\u0013\t)(A\u0013uKN$H)\u001a7fi\u0016\u0004&/Z2p]\u0012LG/[8oC2,f.[7qY\u0016lWM\u001c;fIR\u0019Q(a\u001e\t\u000f\u0005e\u0014\u0011\u000fa\u0001Q\u0006Ya-\u001e7m!\u0006$\bnS3z\u0011\u001d\t\u0019\b\u0001C\u0005\u0003{\"R!PA@\u0003\u0003Cq!!\u001f\u0002|\u0001\u0007\u0001\u000eC\u0004\u0002\u0004\u0006m\u0004\u0019\u00015\u00021A\u0014XmY8oI&$\u0018n\u001c8bY\"+\u0017\rZ3s\u001d\u0006lW\rC\u0004\u0002\b\u0002!I!!#\u0002)\u0005\u001c8/\u001a:u\u001d>$\u0018*\u001c9mK6,g\u000e^3e)\ri\u00141\u0012\u0005\t\u0003\u001b\u000b)\t1\u0001\u0002\u0010\u00061Q.\u001a;i_\u0012\u0004B!!%\u0002 6\u0011\u00111\u0013\u0006\u0005\u0003+\u000b9*\u0001\u0006iiR\u00048\r\\5f]RTA!!'\u0002\u001c\u000691m\\7n_:\u001c(bAAO\r\u00051\u0011\r]1dQ\u0016LA!!)\u0002\u0014\nQ\u0001\n\u001e;q\u001b\u0016$\bn\u001c3\t\u000f\u0005\u0015\u0006\u0001\"\u0001\u0002(\u0006yA/Z:u%\u0016lwN^3F]R\u0014\u0018\u0010F\u0002>\u0003SCa\u0001WAR\u0001\u0004I\u0006bBAW\u0001\u0011\u0005\u0011qV\u0001\u0014i\u0016\u001cHoV5qK\u000e\u000b7\r[3Ck\u000e\\W\r\u001e\u000b\u0004{\u0005E\u0006B\u0002-\u0002,\u0002\u0007\u0011\fC\u0004\u00026\u0002!\t!a.\u0002%Q,7\u000f^!ts:\u001c\u0017\t\u001a3SK6|g/\u001a\u000b\u0004{\u0005e\u0006B\u0002-\u00024\u0002\u0007\u0011\f\u000b\u0005\u00024\u0006u\u00161YAc!\r)\u0015qX\u0005\u0004\u0003\u00034%\u0001\u0002+fgR\faa\u001a:pkB\u001cHFAAdC\t\tI-\u0001\u0005v]N$\u0018M\u00197f\u0011\u001d\ti\r\u0001C\u0001\u0003\u001f\fa\u0004^3tiNCw.\u001e7e\u0007>\u0004XmV5uQN+'/[1mSj\f'\r\\3\u0015\u0007u\n\t\u000e\u0003\u0004Y\u0003\u0017\u0004\r!\u0017\u0005\b\u0003+\u0004A\u0011AAl\u0003u!Xm\u001d;J]N,'\u000f^*fe&\fG.\u001b>bE2,wJ\u00196fGR\u001cHcA\u001f\u0002Z\"1\u0001,a5A\u0002eCq!!8\u0001\t\u0003\ty.\u0001\u000buKN$hj\u001c8fq&\u001cH/\u001a8u\u0007\u0006\u001c\u0007.\u001a\u000b\u0004{\u0005\u0005\bB\u0002-\u0002\\\u0002\u0007\u0011\fC\u0004\u0002f\u0002!\t!a:\u0002AQ,7\u000f\u001e\"zi\u0016\f%O]1z\u0003N\u001cVM]5bY&TX\rZ(cU\u0016\u001cGo\u001d\u000b\u0004{\u0005%\bB\u0002-\u0002d\u0002\u0007\u0011\fC\u0004\u0002n\u0002!\t!a<\u0002CQ,7\u000f\u001e\"zi\u0016\f%O]1z\u0003N|5\r^3d'R\u0014X-Y7PE*,7\r^:\u0015\u0007u\n\t\u0010\u0003\u0004Y\u0003W\u0004\r!\u0017\u0005\b\u0003k\u0004A\u0011BA|\u0003=\u0019XM\u001c3CsR,\u0017I\u001d:bs\u0006\u001bH#B\u001f\u0002z\u0006m\bB\u0002-\u0002t\u0002\u0007\u0011\fC\u0004\u0002~\u0006M\b\u0019\u00015\u0002\u0017\r|g\u000e^3oiRK\b/\u001a\u0005\b\u0005\u0003\u0001A\u0011\u0001B\u0002\u0003U!Xm\u001d;JMVsWn\u001c3jM&,GmU5oG\u0016$2!\u0010B\u0003\u0011\u0019A\u0016q a\u00013\"9!\u0011\u0002\u0001\u0005\u0002\t-\u0011a\u0004;fgR,E+Y4DQ\u0006tw-Z:\u0015\u0007u\u0012i\u0001\u0003\u0004Y\u0005\u000f\u0001\r!\u0017\u0005\b\u0005#\u0001A\u0011\u0001B\n\u0003e!Xm\u001d;D_:\u001cWO\u001d:f]R,E+Y4DQ\u0006tw-Z:\u0015\u0007u\u0012)\u0002\u0003\u0004Y\u0005\u001f\u0001\r!\u0017\u0005\b\u00053\u0001A\u0011\u0001B\u000e\u0003q!Xm\u001d;TKJL\u0017\r\\5{K\u0012\u001cFO]5oO\u001e+GOQ=uKN$2!\u0010B\u000f\u0011\u0019A&q\u0003a\u00013\"9!\u0011\u0005\u0001\u0005\u0002\t\r\u0012!\t;fgR$UMZ1vYR\u001cuN\u001c4jOV\u0014X\rZ#ya&\u0014\u0018PV1mk\u0016\u001cHcA\u001f\u0003&!1\u0001La\bA\u0002eCqA!\u000b\u0001\t\u0003\u0011Y#\u0001\u0010uKN$8)Y2iK\u000e{g\u000e\u001e:pYJ+7\u000f]8og\u0016DU-\u00193feR\u0019QH!\f\t\ra\u00139\u00031\u0001Z\u0011\u001d\u0011\t\u0004\u0001C\u0001\u0005g\t\u0001\u0006^3ti\u001e+GoQ1dQ\u0016\u001cuN\u001c;s_2l\u0015N\u001c$sKND'+Z9vKN$\b*Z1eKJ$2!\u0010B\u001b\u0011\u0019A&q\u0006a\u00013\"9!\u0011\b\u0001\u0005\u0002\tm\u0012!\u000b;fgRDU-\u00193DC\u000eDWmQ8oiJ|G.T5o\rJ,7\u000f\u001b*fcV,7\u000f\u001e%fC\u0012,'\u000fF\u0002>\u0005{Aa\u0001\u0017B\u001c\u0001\u0004I\u0006b\u0002B!\u0001\u0011\u0005!1I\u0001\u0016i\u0016\u001cH\u000fU;u\u0005f$X-\u0011:sCf$v/[2f)\ri$Q\t\u0005\u00071\n}\u0002\u0019A-\t\u000f\t%\u0003\u0001\"\u0001\u0003L\u0005QB/Z:u\t\u0016dW\r^3TKJL\u0017\r\\5{K\u0012|%M[3diR\u0019QH!\u0014\t\ra\u00139\u00051\u0001Z\u0011\u001d\u0011\t\u0006\u0001C\u0005\u0005'\nAb^1ji:{GOR8v]\u0012$r!\u0010B+\u0005?\u0012I\u0007\u0003\u0005\u0003X\t=\u0003\u0019\u0001B-\u0003%\u0019H/\u0019:u)&lW\rE\u0002?\u00057J1A!\u0018@\u0005\u0011auN\\4\t\u0011\t\u0005$q\na\u0001\u0005G\n\u0001\u0002\\5gKN\u0004\u0018M\u001c\t\u0004}\t\u0015\u0014b\u0001B4\u007f\t\u0019\u0011J\u001c;\t\u000f\u0005e$q\na\u0001Q\"9!Q\u000e\u0001\u0005\n\t=\u0014a\u00019viR!!\u0011\u000fB<!\u0011\t\tJa\u001d\n\t\tU\u00141\u0013\u0002\u000f\u0011R$\b/T3uQ>$')Y:f\u0011\u0019A&1\u000ea\u00013\"9!Q\u000e\u0001\u0005\n\tmDC\u0002B9\u0005{\u0012y\b\u0003\u0004Y\u0005s\u0002\r!\u0017\u0005\t\u0005\u0003\u0013I\b1\u0001\u0003\u0004\u0006!A-\u0019;b!\rq$QQ\u0005\u0004\u0005\u000f{$aA!os\"9!Q\u000e\u0001\u0005\n\t-E\u0003\u0003B9\u0005\u001b\u0013yI!%\t\ra\u0013I\t1\u0001Z\u0011!\u0011\tI!#A\u0002\t\r\u0005bBA\u007f\u0005\u0013\u0003\r\u0001\u001b\u0005\b\u0005+\u0003A\u0011\u0002BL\u0003\r9W\r\u001e\u000b\u0005\u0005c\u0012I\n\u0003\u0004Y\u0005'\u0003\r!\u0017\u0005\b\u0005+\u0003A\u0011\u0002BO)\u0019\u0011\tHa(\u0003\"\"1\u0001La'A\u0002eC\u0001Ba)\u0003\u001c\u0002\u0007!QU\u0001\u000bk:lw\u000eZ*j]\u000e,\u0007\u0003\u0002 \u0003(\"L1A!+@\u0005\u0019y\u0005\u000f^5p]\"9!Q\u0013\u0001\u0005\n\t5F\u0003\u0003B9\u0005_\u0013\tLa-\t\ra\u0013Y\u000b1\u0001Z\u0011!\u0011\u0019Ka+A\u0002\t\u0015\u0006\u0002\u0003B[\u0005W\u0003\rA!*\u0002\u0015\u0005\u001c7-\u001a9u)f\u0004X\rC\u0004\u0003\u0016\u0002!IA!/\u0015\u0015\tE$1\u0018B_\u0005\u007f\u0013\t\r\u0003\u0004Y\u0005o\u0003\r!\u0017\u0005\t\u0005G\u00139\f1\u0001\u0003&\"A!Q\u0017B\\\u0001\u0004\u0011)\u000b\u0003\u0005\u0003D\n]\u0006\u0019\u0001B2\u0003\u001d)\u0007\u0010]\"pI\u0016Dq!!\u001f\u0001\t\u0013\u00119\rF\u0002i\u0005\u0013Da\u0001\u0017Bc\u0001\u0004I\u0006b\u0002Bg\u0001\u0011\u0005!qZ\u0001\u0007C\u0012$G)Y=\u0015\u000b!\u0014\tN!6\t\u000f\tM'1\u001aa\u0001Q\u0006)\u0011\rR1uK\"A!q\u001bBf\u0001\u0004\u0011\u0019'\u0001\u0003eCf\u001chA\u0002Bn\u0001\u0001\u0011iN\u0001\fD_:$(o\u001c7mK\u0012\u001c\u0015m\u00195f\u001b\u0006t\u0017mZ3s'\u0011\u0011INa8\u0011\t\t\u0005(1^\u0007\u0003\u0005GTAA!:\u0003h\u0006!\u0011.\u001c9m\u0015\r\u0011I\u000fB\u0001\b[\u0006t\u0017mZ3s\u0013\u0011\u0011iOa9\u0003M\u0005\u00137\u000f\u001e:bGR$U\r\\3hCRLgnZ#nE\u0016$G-\u001a3DC\u000eDW-T1oC\u001e,'\u000fC\u0006\u0003r\ne'\u0011!Q\u0001\n\tM\u0018AA2n!\u0011\u0011)Pa>\u000e\u0005\t\u001d\u0018\u0002\u0002B}\u0005O\u0014A#R7cK\u0012$W\rZ\"bG\",W*\u00198bO\u0016\u0014\bb\u0003B\u007f\u00053\u0014\t\u0011)A\u0005\u0005\u007f\f!B\u001e\u001aQkRd\u0015\r^2i!\u0011\u0019\taa\u0003\u000e\u0005\r\r!\u0002BB\u0003\u0007\u000f\t!bY8oGV\u0014(/\u001a8u\u0015\r\u0019I\u0001K\u0001\u0005kRLG.\u0003\u0003\u0004\u000e\r\r!AD\"pk:$Hi\\<o\u0019\u0006$8\r\u001b\u0005\f\u0007#\u0011IN!A!\u0002\u0013\u0011y0\u0001\u0006wgA+H\u000fT1uG\"D1b!\u0006\u0003Z\n\u0005\t\u0015!\u0003\u0003\u0000\u0006iaO\r$j]&\u001c\b\u000eT1uG\"Dqa\u0004Bm\t\u0003\u0019I\u0002\u0006\u0006\u0004\u001c\r}1\u0011EB\u0012\u0007K\u0001Ba!\b\u0003Z6\t\u0001\u0001\u0003\u0005\u0003r\u000e]\u0001\u0019\u0001Bz\u0011!\u0011ipa\u0006A\u0002\t}\b\u0002CB\t\u0007/\u0001\rAa@\t\u0011\rU1q\u0003a\u0001\u0005\u007fD\u0001b!\u000b\u0003Z\u0012\u000531F\u0001\tO\u0016$8)Y2iKV11QFB\u001e\u0007\u0013\"\"aa\f\u0011\u0011\rE21GB\u001c\u0007\u000fj\u0011\u0001B\u0005\u0004\u0007k!!!D!em\u0006t7-\u001a3DC\u000eDW\r\u0005\u0003\u0004:\rmB\u0002\u0001\u0003\t\u0007{\u00199C1\u0001\u0004@\t\t1*\u0005\u0003\u0004B\t\r\u0005c\u0001 \u0004D%\u00191QI \u0003\u000f9{G\u000f[5oOB!1\u0011HB%\t!\u0019Yea\nC\u0002\r}\"!\u0001,\u0007\r\r=\u0003\u0001AB)\u0005=\u0019uN\u001c;s_2dW\rZ\"bG\",WCBB*\u0007K\u001aIg\u0005\u0003\u0004N\rU\u0003\u0003CB,\u0007?\u001a\u0019ga\u001a\u000e\u0005\re#\u0002\u0002Bs\u00077R1a!\u0018\u0005\u0003\u0015\u0019\u0017m\u00195f\u0013\u0011\u0019\tg!\u0017\u0003?\u0005\u00137\u000f\u001e:bGR$U\r\\3hCRLgnZ!em\u0006t7-\u001a3DC\u000eDW\r\u0005\u0003\u0004:\r\u0015DaB\u0016\u0004N\t\u00071q\b\t\u0005\u0007s\u0019I\u0007\u0002\u0005\u0003\b\u000e5#\u0019AB \u0011-\u0019if!\u0014\u0003\u0002\u0003\u0006Ia!\u001c\u0011\u0011\rE2qNB2\u0007OJ1a!\u001d\u0005\u0005\u0015\u0019\u0015m\u00195f\u0011-\u0011ip!\u0014\u0003\u0002\u0003\u0006IAa@\t\u0017\rE1Q\nB\u0001B\u0003%!q \u0005\f\u0007+\u0019iE!A!\u0002\u0013\u0011y\u0010C\u0004\u0010\u0007\u001b\"\taa\u001f\u0015\u0015\ru4qPBA\u0007\u0007\u001b)\t\u0005\u0005\u0004\u001e\r531MB4\u0011!\u0019if!\u001fA\u0002\r5\u0004\u0002\u0003B\u007f\u0007s\u0002\rAa@\t\u0011\rE1\u0011\u0010a\u0001\u0005\u007fD\u0001b!\u0006\u0004z\u0001\u0007!q \u0005\t\u0007\u0013\u001bi\u0005\"\u0011\u0004\f\u00069!/\u001a9mC\u000e,GCCBG\u0007'\u001b9ja'\u0004 B\u0019aha$\n\u0007\rEuHA\u0004C_>dW-\u00198\t\u0011\rU5q\u0011a\u0001\u0007G\n1a[3z\u0011!\u0019Ija\"A\u0002\r\u001d\u0014\u0001C8mIZ\u000bG.^3\t\u0011\ru5q\u0011a\u0001\u0007O\nQA^1mk\u0016D\u0001b!)\u0004\b\u0002\u000711U\u0001\t[\u0016$\u0018\rZ1uCB!1QUBU\u001b\t\u00199KC\u0002\u0004\"\u0012IAaa+\u0004(\nAQ*\u001a;bI\u0006$\u0018\rK\b\u0001\u0003{\u000b\u0019ma,\u00042\u000eM6qWB]Y\t\t9-\u0001\u0005uKN$h*Y7fC\t\u0019),\u0001\u000bsKN$h&\u00138uK\u001e\u0014\u0018\r^5p]R+7\u000f^\u0001\fI\u0016\u001c8M]5qi&|g.\t\u0002\u0004<\u0006I3+Z3!\u0013N\u0003f*L\u001a:sQb\u0003e\u001c:jO&t\u0017\r\u001c\u0011he>,\bO\u000f\u0011gk:\u001cG/[8oC2\u0004")
public class IntegrationTest
extends RestServerTestBase {
    private JavaLog org$infinispan$rest$IntegrationTest$$log;
    private final String HOST;
    private final String cacheName;
    private final String fullPath = new StringBuilder().append((Object)this.HOST()).append((Object)"/rest/").append((Object)this.cacheName()).toString();
    private final String DATE_PATTERN_RFC1123;
    private volatile boolean bitmap$0;

    private JavaLog org$infinispan$rest$IntegrationTest$$log$lzycompute() {
        IntegrationTest integrationTest = this;
        synchronized (integrationTest) {
            if (!this.bitmap$0) {
                this.org$infinispan$rest$IntegrationTest$$log = (JavaLog)LogFactory.getLog(this.getClass(), JavaLog.class);
                this.bitmap$0 = true;
            }
            return this.org$infinispan$rest$IntegrationTest$$log;
        }
    }

    public JavaLog org$infinispan$rest$IntegrationTest$$log() {
        return this.bitmap$0 ? this.org$infinispan$rest$IntegrationTest$$log : this.org$infinispan$rest$IntegrationTest$$log$lzycompute();
    }

    public String HOST() {
        return this.HOST;
    }

    public String cacheName() {
        return this.cacheName;
    }

    public String fullPath() {
        return this.fullPath;
    }

    public String DATE_PATTERN_RFC1123() {
        return this.DATE_PATTERN_RFC1123;
    }

    @BeforeClass(alwaysRun=true)
    public void setUp() {
        this.addServer("single", 8888, TestCacheManagerFactory.fromXml((String)"test-config.xml"));
        this.startServers();
        this.createClient();
    }

    @AfterClass(alwaysRun=true)
    public void tearDown() {
        this.stopServers();
        this.destroyClient();
    }

    public void testBasicOperation(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PutMethod insert = new PutMethod(fullPathKey);
        NodeBuffer $buf = new NodeBuffer();
        $buf.$amp$plus((Object)new Text("ho"));
        Elem initialXML = new Elem(null, "hey", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf);
        insert.setRequestEntity((RequestEntity)new ByteArrayRequestEntity(initialXML.toString().getBytes(), "application/octet-stream"));
        this.call((HttpMethodBase)insert);
        AssertJUnit.assertEquals((String)"", (String)insert.getResponseBodyAsString().trim());
        AssertJUnit.assertEquals((int)200, (int)insert.getStatusCode());
        GetMethod get = new GetMethod(fullPathKey);
        this.call((HttpMethodBase)get);
        byte[] bytes = get.getResponseBody();
        AssertJUnit.assertEquals((int)Predef$.MODULE$.byteArrayOps(bytes).size(), (int)Predef$.MODULE$.byteArrayOps(initialXML.toString().getBytes()).size());
        NodeBuffer $buf2 = new NodeBuffer();
        $buf2.$amp$plus((Object)new Text("ho"));
        AssertJUnit.assertEquals((String)new Elem(null, "hey", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf2).toString(), (String)get.getResponseBodyAsString());
        Header hdr = get.getResponseHeader("Content-Type");
        AssertJUnit.assertEquals((String)"application/octet-stream", (String)hdr.getValue());
        DeleteMethod remove = new DeleteMethod(fullPathKey);
        this.call((HttpMethodBase)remove);
        this.call((HttpMethodBase)get);
        AssertJUnit.assertEquals((int)404, (int)get.getStatusCode());
        this.call((HttpMethodBase)insert);
        this.call((HttpMethodBase)get);
        NodeBuffer $buf3 = new NodeBuffer();
        $buf3.$amp$plus((Object)new Text("ho"));
        AssertJUnit.assertEquals((String)new Elem(null, "hey", (MetaData)Null$.MODULE$, (NamespaceBinding)TopScope$.MODULE$, false, (Seq)$buf3).toString(), (String)get.getResponseBodyAsString());
        DeleteMethod removeAll = new DeleteMethod(this.fullPath());
        AssertJUnit.assertEquals((int)200, (int)this.call((HttpMethodBase)removeAll).getStatusCode());
        this.call((HttpMethodBase)get);
        AssertJUnit.assertEquals((int)404, (int)get.getStatusCode());
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        ObjectOutputStream oo = new ObjectOutputStream(bout);
        oo.writeObject(new MIMECacheEntry("foo", "hey".getBytes()));
        oo.flush();
        byte[] byteData = bout.toByteArray();
        PutMethod insertMore = new PutMethod(fullPathKey);
        insertMore.setRequestEntity((RequestEntity)new ByteArrayRequestEntity(byteData, "application/octet-stream"));
        this.call((HttpMethodBase)insertMore);
        GetMethod getMore = new GetMethod(fullPathKey);
        this.call((HttpMethodBase)getMore);
        byte[] bytesBack = getMore.getResponseBody();
        AssertJUnit.assertEquals((int)byteData.length, (int)bytesBack.length);
        ObjectInputStream oin = new ObjectInputStream(new ByteArrayInputStream(bytesBack));
        MIMECacheEntry ce = (MIMECacheEntry)oin.readObject();
        AssertJUnit.assertEquals((String)"foo", (String)ce.contentType);
    }

    public void testEmptyGet() {
        AssertJUnit.assertEquals((int)404, (int)this.call((HttpMethodBase)new GetMethod(new StringBuilder().append((Object)this.HOST()).append((Object)"/rest/").append((Object)this.cacheName()).append((Object)"/nodata").toString())).getStatusCode());
    }

    public void testGetCollection() {
        PostMethod post_a = new PostMethod(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/a"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.fullPath()})));
        post_a.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", null));
        this.call((HttpMethodBase)post_a);
        PostMethod post_b = new PostMethod(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/b"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.fullPath()})));
        post_b.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", null));
        this.call((HttpMethodBase)post_b);
        String html = this.getCollection("text/html");
        AssertJUnit.assertTrue((boolean)html.contains("<a href=\"a\">a</a>"));
        AssertJUnit.assertTrue((boolean)html.contains("<a href=\"b\">b</a>"));
        String xml = this.getCollection("application/xml");
        AssertJUnit.assertTrue((boolean)xml.contains("<key>a</key>"));
        AssertJUnit.assertTrue((boolean)xml.contains("<key>b</key>"));
        String plain = this.getCollection("text/plain");
        AssertJUnit.assertTrue((boolean)plain.contains("a\n"));
        AssertJUnit.assertTrue((boolean)plain.contains("b\n"));
        String json = this.getCollection("application/json");
        AssertJUnit.assertTrue((boolean)json.contains("\"a\""));
        AssertJUnit.assertTrue((boolean)json.contains("\"b\""));
    }

    public void testGetCollectionEscape() {
        PostMethod post_a = new PostMethod(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/%22a%22"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.fullPath()})));
        post_a.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", null));
        this.call((HttpMethodBase)post_a);
        PostMethod post_b = new PostMethod(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/b%3E"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.fullPath()})));
        post_b.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", null));
        this.call((HttpMethodBase)post_b);
        String html = this.getCollection("text/html");
        AssertJUnit.assertTrue((boolean)html.contains("<a href=\"&quot;a&quot;\">&quot;a&quot;</a>"));
        AssertJUnit.assertTrue((boolean)html.contains("<a href=\"b&gt;\">b&gt;</a>"));
        String xml = this.getCollection("application/xml");
        AssertJUnit.assertTrue((boolean)xml.contains("<key>&quot;a&quot;</key>"));
        AssertJUnit.assertTrue((boolean)xml.contains("<key>b&gt;</key>"));
        String plain = this.getCollection("text/plain");
        AssertJUnit.assertTrue((boolean)plain.contains("\"a\"\n"));
        AssertJUnit.assertTrue((boolean)plain.contains("b>\n"));
        String json = this.getCollection("application/json");
        AssertJUnit.assertTrue((boolean)json.contains("\\\"a\\\""));
        AssertJUnit.assertTrue((boolean)json.contains("\"b>\""));
    }

    private String getCollection(String variant) {
        GetMethod get = new GetMethod(this.fullPath());
        get.addRequestHeader("Accept", variant);
        HttpMethodBase coll = this.call((HttpMethodBase)get);
        AssertJUnit.assertEquals((int)200, (int)coll.getStatusCode());
        AssertJUnit.assertEquals((String)variant, (String)coll.getResponseHeader("Content-Type").getValue());
        return coll.getResponseBodyAsString();
    }

    public void testGet(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PostMethod post = new PostMethod(fullPathKey);
        post.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", null));
        this.call((HttpMethodBase)post);
        HttpMethodBase get = this.call((HttpMethodBase)new GetMethod(fullPathKey));
        AssertJUnit.assertEquals((int)200, (int)get.getStatusCode());
        AssertJUnit.assertNotNull((Object)get.getResponseHeader("ETag").getValue());
        AssertJUnit.assertNotNull((Object)get.getResponseHeader("Last-Modified").getValue());
        AssertJUnit.assertEquals((String)"application/text", (String)get.getResponseHeader("Content-Type").getValue());
        AssertJUnit.assertEquals((String)"data", (String)get.getResponseBodyAsString());
    }

    public void testHead(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PostMethod post = new PostMethod(fullPathKey);
        post.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", null));
        this.call((HttpMethodBase)post);
        HttpMethodBase get = this.call((HttpMethodBase)new HeadMethod(fullPathKey));
        AssertJUnit.assertEquals((int)200, (int)get.getStatusCode());
        AssertJUnit.assertNotNull((Object)get.getResponseHeader("ETag").getValue());
        AssertJUnit.assertNotNull((Object)get.getResponseHeader("Last-Modified").getValue());
        AssertJUnit.assertEquals((String)"application/text", (String)get.getResponseHeader("Content-Type").getValue());
        AssertJUnit.assertNull((Object)get.getResponseBodyAsString());
    }

    public void testGetIfUnmodified(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PostMethod post = new PostMethod(fullPathKey);
        post.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", null));
        this.call((HttpMethodBase)post);
        HttpMethodBase get = this.call((HttpMethodBase)new GetMethod(fullPathKey));
        AssertJUnit.assertEquals((int)200, (int)get.getStatusCode());
        AssertJUnit.assertNotNull((Object)get.getResponseHeader("ETag").getValue());
        String lastMod = get.getResponseHeader("Last-Modified").getValue();
        AssertJUnit.assertNotNull((Object)lastMod);
        AssertJUnit.assertEquals((String)"application/text", (String)get.getResponseHeader("Content-Type").getValue());
        AssertJUnit.assertEquals((String)"data", (String)get.getResponseBodyAsString());
        GetMethod getAgain = new GetMethod(fullPathKey);
        getAgain.addRequestHeader("If-Unmodified-Since", lastMod);
        get = this.call((HttpMethodBase)getAgain);
        AssertJUnit.assertEquals((int)200, (int)get.getStatusCode());
        AssertJUnit.assertNotNull((Object)get.getResponseHeader("ETag").getValue());
        AssertJUnit.assertNotNull((Object)get.getResponseHeader("Last-Modified").getValue());
        AssertJUnit.assertEquals((String)"application/text", (String)get.getResponseHeader("Content-Type").getValue());
        AssertJUnit.assertEquals((String)"data", (String)get.getResponseBodyAsString());
    }

    public void testPostDuplicate(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PostMethod post = new PostMethod(fullPathKey);
        post.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        this.call((HttpMethodBase)post);
        AssertJUnit.assertEquals((int)409, (int)this.call((HttpMethodBase)post).getStatusCode());
        PutMethod put = new PutMethod(fullPathKey);
        put.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        AssertJUnit.assertEquals((int)200, (int)this.call((HttpMethodBase)put).getStatusCode());
    }

    public void testPutDataWithTimeToLive(Method m) {
        this.putAndAssertEphemeralData(m, "2", "3");
    }

    public void testPutDataWithMaxIdleOnly(Method m) {
        this.putAndAssertEphemeralData(m, "", "3");
    }

    public void testPutDataWithTimeToLiveOnly(Method m) {
        this.putAndAssertEphemeralData(m, "3", "");
    }

    private void putAndAssertEphemeralData(Method m, String timeToLiveSeconds, String maxIdleTimeSeconds) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PostMethod post = new PostMethod(fullPathKey);
        int maxWaitTime = 0;
        if (!timeToLiveSeconds.isEmpty()) {
            maxWaitTime = package$.MODULE$.max(maxWaitTime, new StringOps(Predef$.MODULE$.augmentString(timeToLiveSeconds)).toInt());
            post.setRequestHeader("timeToLiveSeconds", timeToLiveSeconds);
        }
        if (!maxIdleTimeSeconds.isEmpty()) {
            maxWaitTime = package$.MODULE$.max(maxWaitTime, new StringOps(Predef$.MODULE$.augmentString(maxIdleTimeSeconds)).toInt());
            post.setRequestHeader("maxIdleTimeSeconds", maxIdleTimeSeconds);
        }
        post.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        this.call((HttpMethodBase)post);
        HttpMethodBase get = this.call((HttpMethodBase)new GetMethod(fullPathKey));
        AssertJUnit.assertEquals((String)"data", (String)get.getResponseBodyAsString());
        TestingUtil.sleepThread((long)((maxWaitTime + 1) * 1000));
        this.call(get);
        AssertJUnit.assertEquals((int)404, (int)get.getStatusCode());
    }

    public void testPutDataWithIfMatch(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PutMethod put = new PutMethod(fullPathKey);
        put.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        this.call((HttpMethodBase)put);
        HttpMethodBase get = this.call((HttpMethodBase)new GetMethod(fullPathKey));
        AssertJUnit.assertEquals((int)200, (int)get.getStatusCode());
        String etag = get.getResponseHeader("ETag").getValue();
        PutMethod reput = new PutMethod(fullPathKey);
        reput.setRequestHeader("If-Match", etag);
        reput.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        AssertJUnit.assertEquals((int)200, (int)this.call((HttpMethodBase)reput).getStatusCode());
        PutMethod reputAgain = new PutMethod(fullPathKey);
        reputAgain.setRequestHeader("If-Match", "x");
        reputAgain.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        AssertJUnit.assertEquals((int)412, (int)this.call((HttpMethodBase)reputAgain).getStatusCode());
    }

    public void testPutDataWithIfNoneMatch(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PutMethod put = new PutMethod(fullPathKey);
        put.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        this.call((HttpMethodBase)put);
        HttpMethodBase get = this.call((HttpMethodBase)new GetMethod(fullPathKey));
        AssertJUnit.assertEquals((int)200, (int)get.getStatusCode());
        String etag = get.getResponseHeader("ETag").getValue();
        PutMethod reput = new PutMethod(fullPathKey);
        reput.setRequestHeader("If-None-Match", "x");
        reput.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        AssertJUnit.assertEquals((int)200, (int)this.call((HttpMethodBase)reput).getStatusCode());
        PutMethod reputAgain = new PutMethod(fullPathKey);
        reputAgain.setRequestHeader("If-None-Match", etag);
        reputAgain.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        AssertJUnit.assertEquals((int)412, (int)this.call((HttpMethodBase)reputAgain).getStatusCode());
    }

    public void testPutDataWithIfModifiedSince(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PutMethod put = new PutMethod(fullPathKey);
        put.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        this.call((HttpMethodBase)put);
        HttpMethodBase get = this.call((HttpMethodBase)new GetMethod(fullPathKey));
        AssertJUnit.assertEquals((int)200, (int)get.getStatusCode());
        String lastMod = get.getResponseHeader("Last-Modified").getValue();
        PutMethod reput = new PutMethod(fullPathKey);
        reput.setRequestHeader("If-Modified-Since", lastMod);
        reput.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        AssertJUnit.assertEquals((int)304, (int)this.call((HttpMethodBase)reput).getStatusCode());
        PutMethod reputAgain = new PutMethod(fullPathKey);
        String dateMinus = this.addDay(lastMod, -1);
        reputAgain.setRequestHeader("If-Modified-Since", dateMinus);
        reputAgain.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        AssertJUnit.assertEquals((int)200, (int)this.call((HttpMethodBase)reputAgain).getStatusCode());
    }

    public void testPutDataWithIfUnModifiedSince(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PutMethod put = new PutMethod(fullPathKey);
        put.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        this.call((HttpMethodBase)put);
        HttpMethodBase get = this.call((HttpMethodBase)new GetMethod(fullPathKey));
        AssertJUnit.assertEquals((int)200, (int)get.getStatusCode());
        String lastMod = get.getResponseHeader("Last-Modified").getValue();
        PutMethod reput = new PutMethod(fullPathKey);
        String dateMinus = this.addDay(lastMod, -1);
        reput.setRequestHeader("If-Unmodified-Since", dateMinus);
        reput.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        AssertJUnit.assertEquals((int)412, (int)this.call((HttpMethodBase)reput).getStatusCode());
        PutMethod reputAgain = new PutMethod(fullPathKey);
        reputAgain.setRequestHeader("If-Unmodified-Since", lastMod);
        reputAgain.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        AssertJUnit.assertEquals((int)200, (int)this.call((HttpMethodBase)reputAgain).getStatusCode());
    }

    public void testDeleteDataWithIfMatch(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PutMethod put = new PutMethod(fullPathKey);
        put.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        this.call((HttpMethodBase)put);
        HttpMethodBase get = this.call((HttpMethodBase)new GetMethod(fullPathKey));
        AssertJUnit.assertEquals((int)200, (int)get.getStatusCode());
        String etag = get.getResponseHeader("ETag").getValue();
        DeleteMethod delete = new DeleteMethod(fullPathKey);
        delete.setRequestHeader("If-Match", "x");
        AssertJUnit.assertEquals((int)412, (int)this.call((HttpMethodBase)delete).getStatusCode());
        DeleteMethod deleteAgain = new DeleteMethod(fullPathKey);
        deleteAgain.setRequestHeader("If-Match", etag);
        AssertJUnit.assertEquals((int)200, (int)this.call((HttpMethodBase)deleteAgain).getStatusCode());
    }

    public void testDeleteDataWithIfNoneMatch(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PutMethod put = new PutMethod(fullPathKey);
        put.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        this.call((HttpMethodBase)put);
        HttpMethodBase get = this.call((HttpMethodBase)new GetMethod(fullPathKey));
        AssertJUnit.assertEquals((int)200, (int)get.getStatusCode());
        String etag = get.getResponseHeader("ETag").getValue();
        DeleteMethod delete = new DeleteMethod(fullPathKey);
        delete.setRequestHeader("If-None-Match", etag);
        AssertJUnit.assertEquals((int)412, (int)this.call((HttpMethodBase)delete).getStatusCode());
        DeleteMethod deleteAgain = new DeleteMethod(fullPathKey);
        deleteAgain.setRequestHeader("If-None-Match", "x");
        AssertJUnit.assertEquals((int)200, (int)this.call((HttpMethodBase)deleteAgain).getStatusCode());
    }

    public void testDeleteDataWithIfModifiedSince(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PutMethod put = new PutMethod(fullPathKey);
        put.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        this.call((HttpMethodBase)put);
        HttpMethodBase get = this.call((HttpMethodBase)new GetMethod(fullPathKey));
        AssertJUnit.assertEquals((int)200, (int)get.getStatusCode());
        String lastMod = get.getResponseHeader("Last-Modified").getValue();
        DeleteMethod delete = new DeleteMethod(fullPathKey);
        delete.setRequestHeader("If-Modified-Since", lastMod);
        AssertJUnit.assertEquals((int)304, (int)this.call((HttpMethodBase)delete).getStatusCode());
        DeleteMethod deleteAgain = new DeleteMethod(fullPathKey);
        String dateMinus = this.addDay(lastMod, -1);
        deleteAgain.setRequestHeader("If-Modified-Since", dateMinus);
        AssertJUnit.assertEquals((int)200, (int)this.call((HttpMethodBase)deleteAgain).getStatusCode());
    }

    public void testDeleteDataWithIfUnmodifiedSince(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PutMethod put = new PutMethod(fullPathKey);
        put.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        this.call((HttpMethodBase)put);
        HttpMethodBase get = this.call((HttpMethodBase)new GetMethod(fullPathKey));
        AssertJUnit.assertEquals((int)200, (int)get.getStatusCode());
        String lastMod = get.getResponseHeader("Last-Modified").getValue();
        DeleteMethod delete = new DeleteMethod(fullPathKey);
        String dateMinus = this.addDay(lastMod, -1);
        delete.setRequestHeader("If-Unmodified-Since", dateMinus);
        AssertJUnit.assertEquals((int)412, (int)this.call((HttpMethodBase)delete).getStatusCode());
        DeleteMethod deleteAgain = new DeleteMethod(fullPathKey);
        deleteAgain.setRequestHeader("If-Unmodified-Since", lastMod);
        AssertJUnit.assertEquals((int)200, (int)this.call((HttpMethodBase)deleteAgain).getStatusCode());
    }

    public void testDeleteCachePreconditionUnimplemented(Method m) {
        this.testDeletePreconditionalUnimplemented(this.fullPath());
    }

    private void testDeletePreconditionalUnimplemented(String fullPathKey) {
        this.testDeletePreconditionalUnimplemented(fullPathKey, "If-Match");
        this.testDeletePreconditionalUnimplemented(fullPathKey, "If-None-Match");
        this.testDeletePreconditionalUnimplemented(fullPathKey, "If-Modified-Since");
        this.testDeletePreconditionalUnimplemented(fullPathKey, "If-Unmodified-Since");
    }

    private void testDeletePreconditionalUnimplemented(String fullPathKey, String preconditionalHeaderName) {
        DeleteMethod delete = new DeleteMethod(fullPathKey);
        delete.setRequestHeader(preconditionalHeaderName, "*");
        this.call((HttpMethodBase)delete);
        this.assertNotImplemented((HttpMethod)delete);
    }

    private void assertNotImplemented(HttpMethod method) {
        AssertJUnit.assertEquals((int)method.getStatusCode(), (int)501);
        AssertJUnit.assertEquals((String)method.getStatusText(), (String)"Not Implemented");
        Predef$.MODULE$.assert(method.getResponseBodyAsString().toLowerCase().contains("precondition"));
    }

    public void testRemoveEntry(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PostMethod put = new PostMethod(fullPathKey);
        put.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        this.call((HttpMethodBase)put);
        AssertJUnit.assertEquals((int)200, (int)this.call((HttpMethodBase)new HeadMethod(fullPathKey)).getStatusCode());
        this.call((HttpMethodBase)new DeleteMethod(fullPathKey));
        AssertJUnit.assertEquals((int)404, (int)this.call((HttpMethodBase)new HeadMethod(fullPathKey)).getStatusCode());
    }

    public void testWipeCacheBucket(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PostMethod put = new PostMethod(fullPathKey);
        put.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        this.call((HttpMethodBase)put);
        PostMethod put_ = new PostMethod(new StringBuilder().append((Object)fullPathKey).append((Object)"2").toString());
        put_.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        this.call((HttpMethodBase)put_);
        AssertJUnit.assertEquals((int)200, (int)this.call((HttpMethodBase)new HeadMethod(fullPathKey)).getStatusCode());
        this.call((HttpMethodBase)new DeleteMethod(this.fullPath()));
        AssertJUnit.assertEquals((int)404, (int)this.call((HttpMethodBase)new HeadMethod(fullPathKey)).getStatusCode());
    }

    @Test(groups={"unstable"})
    public void testAsyncAddRemove(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PostMethod put = new PostMethod(fullPathKey);
        put.setRequestHeader("performAsync", "true");
        put.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        this.call((HttpMethodBase)put);
        Thread.sleep(50L);
        AssertJUnit.assertEquals((int)200, (int)this.call((HttpMethodBase)new HeadMethod(fullPathKey)).getStatusCode());
        DeleteMethod del = new DeleteMethod(fullPathKey);
        del.setRequestHeader("performAsync", "true");
        this.call((HttpMethodBase)del);
        Thread.sleep(50L);
        AssertJUnit.assertEquals((int)404, (int)this.call((HttpMethodBase)new HeadMethod(fullPathKey)).getStatusCode());
    }

    public void testShouldCopeWithSerializable(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        this.call((HttpMethodBase)new GetMethod(fullPathKey));
        MySer obj = new MySer();
        obj.name_$eq("mic");
        this.getCacheManager("single").getCache("___defaultcache").put((Object)m.getName(), (Object)obj);
        this.getCacheManager("single").getCache("___defaultcache").put((Object)new StringBuilder().append((Object)m.getName()).append((Object)"2").toString(), (Object)"hola");
        this.getCacheManager("single").getCache("___defaultcache").put((Object)new StringBuilder().append((Object)m.getName()).append((Object)"3").toString(), (Object)new MyNonSer());
        GetMethod get = new GetMethod(fullPathKey);
        get.setRequestHeader("Accept", "application/x-java-serialized-object");
        this.call((HttpMethodBase)get);
        AssertJUnit.assertEquals((int)200, (int)get.getStatusCode());
        ObjectInputStream in = new ObjectInputStream(get.getResponseBodyAsStream());
        MySer res = (MySer)in.readObject();
        AssertJUnit.assertNotNull((Object)res);
        AssertJUnit.assertEquals((String)"mic", (String)res.name());
        AssertJUnit.assertEquals((String)"application/x-java-serialized-object", (String)get.getResponseHeader("Content-Type").getValue());
        HttpMethodBase getStr = this.call((HttpMethodBase)new GetMethod(new StringBuilder().append((Object)fullPathKey).append((Object)"2").toString()));
        AssertJUnit.assertEquals((String)"hola", (String)getStr.getResponseBodyAsString());
        AssertJUnit.assertEquals((String)"text/plain", (String)getStr.getResponseHeader("Content-Type").getValue());
        get.setRequestHeader("Accept", "application/json");
        this.call((HttpMethodBase)get);
        AssertJUnit.assertEquals((String)"{\"name\":\"mic\"}", (String)get.getResponseBodyAsString());
        AssertJUnit.assertEquals((String)"application/json", (String)get.getResponseHeader("Content-Type").getValue());
        get.setRequestHeader("Accept", "application/xml");
        this.call((HttpMethodBase)get);
        AssertJUnit.assertEquals((String)"application/xml", (String)get.getResponseHeader("Content-Type").getValue());
        AssertJUnit.assertTrue((get.getResponseBodyAsString().indexOf("<org.infinispan.rest.MySer>") > -1 ? 1 : 0) != 0);
        GetMethod get3 = new GetMethod(new StringBuilder().append((Object)fullPathKey).append((Object)"3").toString());
        get3.setRequestHeader("Accept", "application/json");
        this.call((HttpMethodBase)get3);
        AssertJUnit.assertEquals((String)"{\"name\":\"mic\"}", (String)get3.getResponseBodyAsString());
        AssertJUnit.assertEquals((String)"application/json", (String)get3.getResponseHeader("Content-Type").getValue());
    }

    public void testInsertSerializableObjects(Method m) {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        new ObjectOutputStream(bout).writeObject(new MySer());
        this.put(m, bout.toByteArray(), "application/x-java-serialized-object");
        byte[] cfr_ignored_0 = (byte[])this.getCacheManager("single").getCache("___defaultcache").get((Object)m.getName());
    }

    public void testNonexistentCache(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.HOST()).append((Object)"/rest/nonexistent/").append((Object)m.getName()).toString();
        GetMethod get = new GetMethod(fullPathKey);
        this.call((HttpMethodBase)get);
        AssertJUnit.assertEquals((int)404, (int)get.getStatusCode());
        HttpMethodBase head = this.call((HttpMethodBase)new HeadMethod(fullPathKey));
        AssertJUnit.assertEquals((int)404, (int)head.getStatusCode());
        PostMethod put = new PostMethod(fullPathKey);
        put.setRequestEntity((RequestEntity)new StringRequestEntity("data", "application/text", "UTF-8"));
        this.call((HttpMethodBase)put);
        AssertJUnit.assertEquals((int)404, (int)put.getStatusCode());
    }

    public void testByteArrayAsSerializedObjects(Method m) {
        this.sendByteArrayAs(m, "application/x-java-serialized-object");
    }

    public void testByteArrayAsOctecStreamObjects(Method m) {
        this.sendByteArrayAs(m, "application/octet-stream");
    }

    private void sendByteArrayAs(Method m, String contentType) {
        byte[] serializedOnClient = (byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{101, 102, 103}), ClassTag$.MODULE$.Byte());
        this.put(m, serializedOnClient, contentType);
        BufferedInputStream dataRead = new BufferedInputStream(this.get(m, (Option<String>)None$.MODULE$, (Option<String>)new Some((Object)contentType)).getResponseBodyAsStream());
        byte[] bytesRead = new byte[3];
        dataRead.read(bytesRead);
        AssertJUnit.assertEquals((byte[])serializedOnClient, (byte[])bytesRead);
    }

    public void testIfUnmodifiedSince(Method m) {
        this.put(m);
        HttpMethodBase result = this.get(m);
        String dateLast = result.getResponseHeader("Last-Modified").getValue();
        String dateMinus = this.addDay(dateLast, -1);
        String datePlus = this.addDay(dateLast, 1);
        AssertJUnit.assertNotNull((Object)this.get(m, (Option<String>)new Some((Object)dateLast)).getResponseBodyAsString());
        AssertJUnit.assertNotNull((Object)this.get(m, (Option<String>)new Some((Object)datePlus)).getResponseBodyAsString());
        HttpMethodBase httpMethodBase = this.get(m, (Option<String>)new Some((Object)dateMinus), (Option<String>)None$.MODULE$, 412);
    }

    public void testETagChanges(Method m) {
        this.put(m, "data1");
        String eTagFirst = this.get(m).getResponseHeader("ETag").getValue();
        AssertJUnit.assertEquals((String)eTagFirst, (String)this.get(m).getResponseHeader("ETag").getValue());
        this.put(m, "data2");
        String eTagSecond = this.get(m).getResponseHeader("ETag").getValue();
        AssertJUnit.assertFalse((String)new StringOps(Predef$.MODULE$.augmentString("etag1 %s; etag2 %s; equals? %b")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{eTagFirst, eTagSecond, BoxesRunTime.boxToBoolean((boolean)eTagFirst.equals(eTagSecond))})), (boolean)eTagFirst.equals(eTagSecond));
    }

    /*
     * WARNING - void declaration
     */
    public void testConcurrentETagChanges(Method m) {
        this.put(m, "data1");
        CountDownLatch v2PutLatch = new CountDownLatch(1);
        CountDownLatch v3PutLatch = new CountDownLatch(1);
        CountDownLatch v2FinishLatch = new CountDownLatch(1);
        EmbeddedCacheManager origCacheManager = this.getCacheManager("single");
        ControlledCacheManager mockCacheManager = new ControlledCacheManager(this, origCacheManager, v2PutLatch, v3PutLatch, v2FinishLatch);
        Map knownCaches = this.getManagerInstance("single").knownCaches();
        try {
            knownCaches.put("___defaultcache", mockCacheManager.getCache());
            Future replaceFuture = Future$.MODULE$.apply((Function0)new Serializable(this, m, v2FinishLatch){
                private final /* synthetic */ IntegrationTest $outer;
                private final Method m$1;
                private final CountDownLatch v2FinishLatch$1;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    HttpClient newClient = new HttpClient();
                    PutMethod put = new PutMethod(this.$outer.org$infinispan$rest$IntegrationTest$$fullPathKey(this.m$1));
                    put.setRequestHeader("Content-Type", "application/text");
                    put.setRequestEntity((RequestEntity)new StringRequestEntity("data2", null, null));
                    newClient.executeMethod((HttpMethod)put);
                    AssertJUnit.assertEquals((int)200, (int)put.getStatusCode());
                    this.v2FinishLatch$1.countDown();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.m$1 = m$1;
                    this.v2FinishLatch$1 = v2FinishLatch$1;
                }
            }, (ExecutionContext)ExecutionContext.Implicits$.MODULE$.global());
            boolean bl = v3PutLatch.await(10L, TimeUnit.SECONDS);
            AssertJUnit.assertTrue((String)"Timed out waiting for concurrent put", (boolean)bl);
            PutMethod put = new PutMethod(this.org$infinispan$rest$IntegrationTest$$fullPathKey(m));
            put.setRequestHeader("Content-Type", "application/text");
            put.setRequestEntity((RequestEntity)new StringRequestEntity("data3", null, null));
            this.call((HttpMethodBase)put);
            AssertJUnit.assertEquals((int)412, (int)put.getStatusCode());
            Await$.MODULE$.result((Awaitable)replaceFuture, (Duration)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(5)).seconds());
            AssertJUnit.assertEquals((String)"data2", (String)this.get(m).getResponseBodyAsString());
            knownCaches.put("___defaultcache", origCacheManager.getCache().getAdvancedCache());
        }
        catch (Throwable throwable) {
            void var5_5;
            void var7_7;
            var7_7.put("___defaultcache", var5_5.getCache().getAdvancedCache());
            throw throwable;
        }
    }

    public void testSerializedStringGetBytes(Method m) {
        byte[] data = new StringBuilder().append((Object)"v-").append((Object)m.getName()).toString().getBytes("UTF-8");
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        ObjectOutputStream oo = new ObjectOutputStream(bout);
        oo.writeObject(data);
        oo.flush();
        byte[] bytes = bout.toByteArray();
        this.put(m, bytes, "application/x-java-serialized-object");
        byte[] bytesRead = this.get(m, (Option<String>)None$.MODULE$, (Option<String>)new Some((Object)"application/x-java-serialized-object")).getResponseBody();
        AssertJUnit.assertTrue((boolean)Arrays.equals(bytes, bytesRead));
        ObjectInputStream oin = new ObjectInputStream(new ByteArrayInputStream(bytesRead));
        byte[] dataBack = (byte[])oin.readObject();
        AssertJUnit.assertTrue((boolean)Arrays.equals(data, dataBack));
    }

    public void testDefaultConfiguredExpiryValues(Method m) {
        String cacheName = "evictExpiryCache";
        String fullPathKey = new StringOps(Predef$.MODULE$.augmentString("%s/rest/%s/%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.HOST(), cacheName, m.getName()}));
        PostMethod post = new PostMethod(fullPathKey);
        post.setRequestHeader("timeToLiveSeconds", "-1");
        post.setRequestEntity((RequestEntity)new StringRequestEntity("data", "text/plain", "UTF-8"));
        this.call((HttpMethodBase)post);
        Thread.sleep(5000L);
        HttpMethodBase get = this.call((HttpMethodBase)new GetMethod(fullPathKey));
        AssertJUnit.assertEquals((String)"data", (String)get.getResponseBodyAsString());
        AssertJUnit.assertNull((Object)get.getResponseHeader("Expires"));
        long startTime = System.currentTimeMillis();
        int lifespan = 3000;
        fullPathKey = new StringOps(Predef$.MODULE$.augmentString("%s-2")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fullPathKey}));
        post = new PostMethod(fullPathKey);
        post.setRequestHeader("Content-Type", "application/text");
        post.setRequestHeader("timeToLiveSeconds", "0");
        post.setRequestHeader("maxIdleTimeSeconds", "0");
        post.setRequestEntity((RequestEntity)new StringRequestEntity("data2", "text/plain", "UTF-8"));
        this.call((HttpMethodBase)post);
        while (System.currentTimeMillis() < startTime + (long)lifespan) {
            get = this.call((HttpMethodBase)new GetMethod(fullPathKey));
            String response = get.getResponseBodyAsString();
            if (System.currentTimeMillis() >= startTime + (long)lifespan) continue;
            AssertJUnit.assertEquals((String)"data2", (String)response);
            AssertJUnit.assertNotNull((Object)get.getResponseHeader("Expires"));
            Thread.sleep(100L);
        }
        this.waitNotFound(startTime, lifespan, fullPathKey);
        AssertJUnit.assertEquals((int)404, (int)this.call((HttpMethodBase)new GetMethod(fullPathKey)).getStatusCode());
        startTime = System.currentTimeMillis();
        lifespan = 0;
        fullPathKey = new StringOps(Predef$.MODULE$.augmentString("%s-3")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fullPathKey}));
        post = new PostMethod(fullPathKey);
        post.setRequestHeader("timeToLiveSeconds", "0");
        post.setRequestEntity((RequestEntity)new StringRequestEntity("data3", "text/plain", "UTF-8"));
        this.call((HttpMethodBase)post);
        Thread.sleep(1000L);
        get = this.call((HttpMethodBase)new GetMethod(fullPathKey));
        String response = get.getResponseBodyAsString();
        AssertJUnit.assertEquals((String)"data3", (String)response);
        Thread.sleep(2000L);
        AssertJUnit.assertEquals((int)404, (int)this.call((HttpMethodBase)new GetMethod(fullPathKey)).getStatusCode());
        fullPathKey = new StringOps(Predef$.MODULE$.augmentString("%s-4")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fullPathKey}));
        post = new PostMethod(fullPathKey);
        post.setRequestHeader("maxIdleTimeSeconds", "0");
        post.setRequestEntity((RequestEntity)new StringRequestEntity("data4", "text/plain", "UTF-8"));
        this.call((HttpMethodBase)post);
        Thread.sleep(2500L);
        AssertJUnit.assertEquals((int)404, (int)this.call((HttpMethodBase)new GetMethod(fullPathKey)).getStatusCode());
    }

    public void testCacheControlResponseHeader(Method m) {
        String cacheName = "evictExpiryCache";
        String fullPathKey = new StringOps(Predef$.MODULE$.augmentString("%s/rest/%s/%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.HOST(), cacheName, m.getName()}));
        PostMethod post = new PostMethod(fullPathKey);
        post.setRequestHeader("timeToLiveSeconds", "10");
        post.setRequestEntity((RequestEntity)new StringRequestEntity("data", "text/plain", "UTF-8"));
        this.call((HttpMethodBase)post);
        Thread.sleep(2000L);
        HttpMethodBase get = this.call((HttpMethodBase)new GetMethod(fullPathKey));
        AssertJUnit.assertEquals((String)"data", (String)get.getResponseBodyAsString());
        AssertJUnit.assertNotNull((Object)get.getResponseHeader("Cache-Control"));
        int retrievedMaxAge = CacheControl.valueOf((String)get.getResponseHeader("Cache-Control").getValue()).getMaxAge();
        AssertJUnit.assertTrue((retrievedMaxAge > 0 ? 1 : 0) != 0);
    }

    public void testGetCacheControlMinFreshRequestHeader(Method m) {
        String cacheName = "evictExpiryCache";
        String fullPathKey = new StringOps(Predef$.MODULE$.augmentString("%s/rest/%s/%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.HOST(), cacheName, m.getName()}));
        PostMethod post = new PostMethod(fullPathKey);
        post.setRequestHeader("timeToLiveSeconds", "10");
        post.setRequestEntity((RequestEntity)new StringRequestEntity("data", "text/plain", "UTF-8"));
        this.call((HttpMethodBase)post);
        Thread.sleep(2000L);
        GetMethod getLongMinFresh = new GetMethod(fullPathKey);
        getLongMinFresh.addRequestHeader("Cache-Control", "no-transform, min-fresh=20");
        HttpMethodBase getResp = this.call((HttpMethodBase)getLongMinFresh);
        AssertJUnit.assertEquals((int)404, (int)getResp.getStatusCode());
        GetMethod getShortMinFresh = new GetMethod(fullPathKey);
        getShortMinFresh.addRequestHeader("Cache-Control", "no-transform, min-fresh=2");
        getResp = this.call((HttpMethodBase)getShortMinFresh);
        AssertJUnit.assertNotNull((Object)getResp.getResponseHeader("Cache-Control"));
        AssertJUnit.assertEquals((String)"data", (String)getResp.getResponseBodyAsString());
        GetMethod getNoMinFresh = new GetMethod(fullPathKey);
        getResp = this.call((HttpMethodBase)getNoMinFresh);
        AssertJUnit.assertNotNull((Object)getResp.getResponseHeader("Cache-Control"));
        AssertJUnit.assertEquals((String)"data", (String)getResp.getResponseBodyAsString());
    }

    public void testHeadCacheControlMinFreshRequestHeader(Method m) {
        String cacheName = "evictExpiryCache";
        String fullPathKey = new StringOps(Predef$.MODULE$.augmentString("%s/rest/%s/%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.HOST(), cacheName, m.getName()}));
        PostMethod post = new PostMethod(fullPathKey);
        post.setRequestHeader("timeToLiveSeconds", "10");
        post.setRequestEntity((RequestEntity)new StringRequestEntity("data", "text/plain", "UTF-8"));
        this.call((HttpMethodBase)post);
        Thread.sleep(2000L);
        HeadMethod headLongMinFresh = new HeadMethod(fullPathKey);
        headLongMinFresh.addRequestHeader("Cache-Control", "no-transform, min-fresh=20");
        HttpMethodBase headResp = this.call((HttpMethodBase)headLongMinFresh);
        AssertJUnit.assertEquals((int)404, (int)headResp.getStatusCode());
        HeadMethod headShortMinFresh = new HeadMethod(fullPathKey);
        headShortMinFresh.addRequestHeader("Cache-Control", "no-transform, min-fresh=2");
        headResp = this.call((HttpMethodBase)headShortMinFresh);
        int retrievedMaxAge = CacheControl.valueOf((String)headResp.getResponseHeader("Cache-Control").getValue()).getMaxAge();
        AssertJUnit.assertTrue((retrievedMaxAge > 0 ? 1 : 0) != 0);
        HeadMethod headNoMinFresh = new HeadMethod(fullPathKey);
        headResp = this.call((HttpMethodBase)headNoMinFresh);
        AssertJUnit.assertNotNull((Object)headResp.getResponseHeader("Cache-Control"));
    }

    public void testPutByteArrayTwice(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PutMethod put = new PutMethod(fullPathKey);
        byte[] data = (byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{42, 42, 42}), ClassTag$.MODULE$.Byte());
        put.setRequestEntity((RequestEntity)new ByteArrayRequestEntity(data, "application/x-java-serialized-object"));
        AssertJUnit.assertEquals((int)200, (int)this.call((HttpMethodBase)put).getStatusCode());
        HttpMethodBase get = this.call((HttpMethodBase)new GetMethod(fullPathKey));
        AssertJUnit.assertEquals((int)200, (int)get.getStatusCode());
        PutMethod reput = new PutMethod(fullPathKey);
        reput.setRequestEntity((RequestEntity)new ByteArrayRequestEntity(data, "application/x-java-serialized-object"));
        AssertJUnit.assertEquals((int)200, (int)this.call((HttpMethodBase)reput).getStatusCode());
    }

    public void testDeleteSerializedObject(Method m) {
        String fullPathKey = new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
        PutMethod put = new PutMethod(fullPathKey);
        byte[] data = (byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{42, 42, 42}), ClassTag$.MODULE$.Byte());
        put.setRequestEntity((RequestEntity)new ByteArrayRequestEntity(data, "application/x-java-serialized-object"));
        AssertJUnit.assertEquals((int)200, (int)this.call((HttpMethodBase)put).getStatusCode());
        HttpMethodBase get = this.call((HttpMethodBase)new GetMethod(fullPathKey));
        AssertJUnit.assertEquals((int)200, (int)get.getStatusCode());
        HttpMethodBase delete = this.call((HttpMethodBase)new DeleteMethod(fullPathKey));
        AssertJUnit.assertEquals((int)200, (int)delete.getStatusCode());
    }

    private void waitNotFound(long startTime, int lifespan, String fullPathKey) {
        block2: {
            BoxedUnit boxedUnit;
            while (System.currentTimeMillis() < startTime + (long)lifespan + 20000L) {
                if (((Object)BoxesRunTime.boxToInteger((int)404)).equals(BoxesRunTime.boxToInteger((int)this.call((HttpMethodBase)new GetMethod(fullPathKey)).getStatusCode()))) {
                    boxedUnit = BoxedUnit.UNIT;
                    break block2;
                }
                Thread.sleep(100L);
            }
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    private HttpMethodBase put(Method m) {
        return this.put(m, "data", "application/text");
    }

    private HttpMethodBase put(Method m, Object data) {
        return this.put(m, data, "application/text");
    }

    private HttpMethodBase put(Method m, Object data, String contentType) {
        Object object;
        block4: {
            StringRequestEntity stringRequestEntity;
            PutMethod put;
            block3: {
                block2: {
                    put = new PutMethod(this.org$infinispan$rest$IntegrationTest$$fullPathKey(m));
                    put.setRequestHeader("Content-Type", contentType);
                    object = data;
                    if (!(object instanceof String)) break block2;
                    String string = (String)object;
                    stringRequestEntity = new StringRequestEntity(string, null, null);
                    break block3;
                }
                if (!(object instanceof byte[])) break block4;
                byte[] byArray = (byte[])object;
                stringRequestEntity = new InputStreamRequestEntity((InputStream)new ByteArrayInputStream(byArray));
            }
            StringRequestEntity reqEntity = stringRequestEntity;
            put.setRequestEntity((RequestEntity)reqEntity);
            this.call((HttpMethodBase)put);
            AssertJUnit.assertEquals((int)200, (int)put.getStatusCode());
            return put;
        }
        throw new MatchError(object);
    }

    private HttpMethodBase get(Method m) {
        return this.get(m, (Option<String>)None$.MODULE$);
    }

    private HttpMethodBase get(Method m, Option<String> unmodSince) {
        return this.get(m, unmodSince, (Option<String>)None$.MODULE$, 200);
    }

    private HttpMethodBase get(Method m, Option<String> unmodSince, Option<String> acceptType) {
        return this.get(m, unmodSince, acceptType, 200);
    }

    private HttpMethodBase get(Method m, Option<String> unmodSince, Option<String> acceptType, int expCode) {
        GetMethod get = new GetMethod(this.org$infinispan$rest$IntegrationTest$$fullPathKey(m));
        Option<String> option = unmodSince;
        None$ none$ = None$.MODULE$;
        if (option == null ? none$ != null : !option.equals((Object)none$)) {
            get.setRequestHeader("If-Unmodified-Since", (String)unmodSince.get());
        }
        Option<String> option2 = acceptType;
        None$ none$2 = None$.MODULE$;
        if (option2 == null ? none$2 != null : !option2.equals((Object)none$2)) {
            get.setRequestHeader("Accept", (String)acceptType.get());
        }
        this.call((HttpMethodBase)get);
        AssertJUnit.assertEquals((int)expCode, (int)get.getStatusCode());
        return get;
    }

    public String org$infinispan$rest$IntegrationTest$$fullPathKey(Method m) {
        return new StringBuilder().append((Object)this.fullPath()).append((Object)"/").append((Object)m.getName()).toString();
    }

    public String addDay(String aDate, int days) {
        SimpleDateFormat format = new SimpleDateFormat(this.DATE_PATTERN_RFC1123(), Locale.US);
        Date date = format.parse(aDate);
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(5, days);
        return format.format(cal.getTime());
    }

    public IntegrationTest() {
        this.HOST = "http://localhost:8888";
        this.cacheName = "___defaultcache";
        this.DATE_PATTERN_RFC1123 = "EEE, dd MMM yyyy HH:mm:ss zzz";
    }

    public class ControlledCache<String, Any>
    extends AbstractDelegatingAdvancedCache<String, Any> {
        private final CountDownLatch v2PutLatch;
        private final CountDownLatch v3PutLatch;
        private final CountDownLatch v2FinishLatch;
        public final /* synthetic */ IntegrationTest $outer;

        public boolean replace(String key, Any oldValue, Any value, Metadata metadata) {
            Object object;
            byte[] newByteArray = (byte[])value;
            byte[] oldByteArray = (byte[])oldValue;
            String oldAsString = new String(oldByteArray);
            String newAsString = new String(newByteArray);
            if (Arrays.equals(newByteArray, "data2".getBytes())) {
                this.org$infinispan$rest$IntegrationTest$ControlledCache$$$outer().org$infinispan$rest$IntegrationTest$$log().debug((Object)"Let v3 apply...");
                this.v3PutLatch.countDown();
                this.org$infinispan$rest$IntegrationTest$ControlledCache$$$outer().org$infinispan$rest$IntegrationTest$$log().debug((Object)"Wait until v2 can be stored");
                boolean bl = this.v2PutLatch.await(10L, TimeUnit.SECONDS);
                if (!bl) {
                    AssertJUnit.fail((String)"Timed out waiting for v2 to be allowed");
                }
                object = BoxedUnit.UNIT;
            } else if (Arrays.equals(newByteArray, "data3".getBytes())) {
                this.org$infinispan$rest$IntegrationTest$ControlledCache$$$outer().org$infinispan$rest$IntegrationTest$$log().debugf("About to store v3, let v2 apply, oldValue(for v3)=%s", new Object[]{oldAsString});
                this.v2PutLatch.countDown();
                object = BoxesRunTime.boxToBoolean((boolean)this.v2FinishLatch.await(10L, TimeUnit.SECONDS));
            } else {
                object = BoxedUnit.UNIT;
            }
            this.org$infinispan$rest$IntegrationTest$ControlledCache$$$outer().org$infinispan$rest$IntegrationTest$$log().debugf("Replace key=%s, oldValue=%s, value=%s", key, (Object)oldAsString, (Object)newAsString);
            return super.replace(key, oldValue, value, metadata);
        }

        public /* synthetic */ IntegrationTest org$infinispan$rest$IntegrationTest$ControlledCache$$$outer() {
            return this.$outer;
        }

        public ControlledCache(IntegrationTest $outer, Cache<String, Any> cache, CountDownLatch v2PutLatch, CountDownLatch v3PutLatch, CountDownLatch v2FinishLatch) {
            this.v2PutLatch = v2PutLatch;
            this.v3PutLatch = v3PutLatch;
            this.v2FinishLatch = v2FinishLatch;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            super(cache.getAdvancedCache());
        }
    }

    public class ControlledCacheManager
    extends AbstractDelegatingEmbeddedCacheManager {
        private final CountDownLatch v2PutLatch;
        private final CountDownLatch v3PutLatch;
        private final CountDownLatch v2FinishLatch;
        public final /* synthetic */ IntegrationTest $outer;

        public <K, V> AdvancedCache<K, V> getCache() {
            return new ControlledCache(this.org$infinispan$rest$IntegrationTest$ControlledCacheManager$$$outer(), super.getCache(), this.v2PutLatch, this.v3PutLatch, this.v2FinishLatch);
        }

        public /* synthetic */ IntegrationTest org$infinispan$rest$IntegrationTest$ControlledCacheManager$$$outer() {
            return this.$outer;
        }

        public ControlledCacheManager(IntegrationTest $outer, EmbeddedCacheManager cm, CountDownLatch v2PutLatch, CountDownLatch v3PutLatch, CountDownLatch v2FinishLatch) {
            this.v2PutLatch = v2PutLatch;
            this.v3PutLatch = v3PutLatch;
            this.v2FinishLatch = v2FinishLatch;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            super(cm);
        }
    }
}

