/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest;

import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.commons.logging.Log;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.rest.EmbeddedRestServer;
import org.infinispan.rest.configuration.RestServerConfigurationBuilder;

public class RestTestingUtil {
    static final Log log = LogFactory.getLog(RestTestingUtil.class);
    static ThreadLocal<Integer> UniquePortThreadLocal = new ThreadLocal<Integer>(){
        private AtomicInteger uniquePort = new AtomicInteger(18080);

        @Override
        public Integer initialValue() {
            return this.uniquePort.getAndAdd(100);
        }
    };

    public static EmbeddedRestServer startRestServer(EmbeddedCacheManager manager) {
        return RestTestingUtil.startRestServer(manager, UniquePortThreadLocal.get());
    }

    public static EmbeddedRestServer startRestServer(EmbeddedCacheManager manager, int port) {
        RestServerConfigurationBuilder builder = new RestServerConfigurationBuilder();
        builder.port(port);
        return RestTestingUtil.startRestServer(manager, builder);
    }

    public static EmbeddedRestServer startRestServer(EmbeddedCacheManager manager, RestServerConfigurationBuilder builder) {
        EmbeddedRestServer server = new EmbeddedRestServer(manager, builder.build());
        try {
            server.start();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return server;
    }

    public static void killServers(EmbeddedRestServer ... servers) {
        if (servers != null) {
            for (EmbeddedRestServer server : servers) {
                try {
                    if (server == null) continue;
                    server.stop();
                }
                catch (Throwable t) {
                    log.warn((Object)"Error stopping Rest server", t);
                }
            }
        }
    }
}

