/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.configuration;

import java.util.HashSet;
import java.util.Set;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.rest.configuration.ExtendedHeaders;
import org.infinispan.rest.configuration.RestServerConfiguration;

public class RestServerConfigurationBuilder
implements Builder<RestServerConfiguration> {
    private ExtendedHeaders extendedHeaders = ExtendedHeaders.ON_DEMAND;
    private int port = 8080;
    private String host = "localhost";
    private Set<String> ignoredCaches = new HashSet();

    public RestServerConfigurationBuilder extendedHeaders(ExtendedHeaders extendedHeaders) {
        this.extendedHeaders = extendedHeaders;
        return this;
    }

    public RestServerConfigurationBuilder port(int port) {
        this.port = port;
        return this;
    }

    public RestServerConfigurationBuilder host(String host) {
        this.host = host;
        return this;
    }

    public RestServerConfigurationBuilder ignoredCaches(Set<String> ignoredCaches) {
        this.ignoredCaches = ignoredCaches;
        return this;
    }

    public void validate() {
    }

    public RestServerConfiguration create() {
        return new RestServerConfiguration(this.extendedHeaders, this.host, this.port, this.ignoredCaches);
    }

    public Builder<?> read(RestServerConfiguration template) {
        this.extendedHeaders = template.extendedHeaders();
        this.host = template.host();
        this.port = template.port();
        return this;
    }

    public RestServerConfiguration build() {
        return this.build(true);
    }

    public RestServerConfiguration build(boolean validate) {
        if (validate) {
            this.validate();
        }
        return this.create();
    }
}

