/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.SimpleHttpConnectionManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.rest.NettyRestServer;
import org.infinispan.rest.configuration.RestServerConfiguration;
import org.infinispan.rest.configuration.RestServerConfigurationBuilder;
import org.infinispan.test.AbstractInfinispanTest;

public class RestServerTestBase
extends AbstractInfinispanTest {
    private Map<String, NettyRestServer> servers = new HashMap<String, NettyRestServer>();
    private HttpClient client;

    protected void createClient() {
        this.client = new HttpClient();
    }

    protected void destroyClient() {
        ((SimpleHttpConnectionManager)this.client.getHttpConnectionManager()).shutdown();
        this.client = null;
    }

    public void addServer(String name, int port, EmbeddedCacheManager cacheManager) {
        RestServerConfigurationBuilder builder = new RestServerConfigurationBuilder();
        builder.port(port);
        this.servers.put(name, NettyRestServer.createServer((RestServerConfiguration)builder.build(), (EmbeddedCacheManager)cacheManager));
    }

    public void addServer(String name, EmbeddedCacheManager cacheManager, RestServerConfiguration configuration) {
        this.servers.put(name, NettyRestServer.createServer((RestServerConfiguration)configuration, (EmbeddedCacheManager)cacheManager));
    }

    protected void ignoreCache(String cacheName) {
        this.servers.values().forEach(s -> s.ignoreCache(cacheName));
    }

    protected void enableCache(String cacheName) {
        this.servers.values().forEach(s -> s.unignore(cacheName));
    }

    protected void removeServers() {
        this.servers.clear();
    }

    protected EmbeddedCacheManager getCacheManager(String name) {
        NettyRestServer ctx = this.servers.get(name);
        if (ctx == null) {
            return null;
        }
        return ctx.getCacheManager();
    }

    public void startServers() throws Exception {
        if (!this.servers.isEmpty()) {
            for (NettyRestServer s : this.servers.values()) {
                s.start();
            }
        } else {
            throw new IllegalStateException("No servers defined!");
        }
    }

    public void stopServers() throws Exception {
        if (!this.servers.isEmpty()) {
            for (NettyRestServer s : this.servers.values()) {
                s.stop();
            }
        } else {
            throw new IllegalStateException("No servers defined!");
        }
    }

    protected HttpMethodBase call(HttpMethodBase method) throws Exception {
        this.client.executeMethod((HttpMethod)method);
        return method;
    }
}

