/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.embedded.netty4.security;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.ssl.SslHandler;
import java.io.IOException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.ws.rs.core.SecurityContext;
import org.infinispan.rest.embedded.netty4.NettySecurityContext;
import org.infinispan.rest.embedded.netty4.security.Authenticator;
import org.jboss.resteasy.plugins.server.embedded.SecurityDomain;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;

public class ClientCertAuthenticator
implements Authenticator {
    private final SecurityDomain domain;

    public ClientCertAuthenticator(SecurityDomain domain) {
        this.domain = domain;
    }

    public SecurityContext authenticate(ChannelHandlerContext ctx, HttpRequest request, HttpResponse response) throws IOException {
        SslHandler sslHandler = (SslHandler)ctx.pipeline().get(SslHandler.class);
        try {
            SSLSession session = sslHandler.engine().getSession();
            return new NettySecurityContext(session.getPeerPrincipal(), this.domain, "ClientCert", true);
        }
        catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
            response.sendError(401);
            return null;
        }
    }
}

