/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest;

import com.thoughtworks.xstream.XStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import javax.ws.rs.core.Variant;
import org.codehaus.jackson.map.ObjectMapper;
import org.infinispan.AdvancedCache;
import org.infinispan.CacheSet;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.hash.MurmurHash3;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.metadata.Metadata;
import org.infinispan.rest.CacheNotFoundException;
import org.infinispan.rest.Escaper;
import org.infinispan.rest.MimeMetadata;
import org.infinispan.rest.MimeMetadataBuilder;
import org.infinispan.rest.RestCacheManager;
import org.infinispan.rest.configuration.RestServerConfiguration;

@Path(value="/")
public class Server {
    public static final String READERS_ROLE = "_infinispan_rest_readers";
    public static final String WRITERS_ROLE = "_infinispan_rest_writers";
    private final RestServerConfiguration configuration;
    private final RestCacheManager manager;
    private final MurmurHash3 hashFunc = MurmurHash3.getInstance();
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.RFC_1123_DATE_TIME.withZone(ZoneId.systemDefault());
    private static final MediaType TextPlainUtf8Type = new MediaType("text", "plain", "UTF-8");
    private static final String TextPlainUtf8 = TextPlainUtf8Type.toString();
    private static final MediaType ApplicationXJavaSerializedObjectType = new MediaType("application", "x-java-serialized-object");
    private static final String ApplicationXJavaSerializedObject = ApplicationXJavaSerializedObjectType.toString();
    private static final String TimeToLiveHeader = "timeToLiveSeconds";
    private static final String MaxIdleTimeHeader = "maxIdleTimeSeconds";

    public Server(RestServerConfiguration configuration, RestCacheManager manager) {
        this.configuration = configuration;
        this.manager = manager;
    }

    @GET
    @Path(value="/{cacheName}")
    @RolesAllowed(value={"_infinispan_rest_readers", "_infinispan_rest_writers"})
    public Response getKeys(@Context Request request, @HeaderParam(value="performAsync") boolean useAsync, @PathParam(value="cacheName") String cacheName, @QueryParam(value="global") String globalKeySet) {
        return this.protectCacheNotFound(() -> {
            String selectedMediaType;
            AdvancedCache<String, byte[]> cache = this.manager.getCache(cacheName);
            CacheSet keys = cache.keySet();
            Variant variant = request.selectVariant(CollectionVariantListHelper.collectionVariantList);
            String string = selectedMediaType = variant != null ? variant.getMediaType().toString() : null;
            if ("text/html".equals(selectedMediaType)) {
                return Response.ok().type("text/html").entity((Object)this.printIt(pw -> {
                    pw.print("<html><body>");
                    keys.forEach(key -> {
                        String hkey = Escaper.escapeHtml(key);
                        pw.printf("<a href=\"%s/%s\">%s</a><br/>", cacheName, hkey, hkey);
                    });
                    pw.print("</body></html>");
                })).build();
            }
            if ("application/xml".equals(selectedMediaType)) {
                return Response.ok().type("application/xml").entity((Object)this.printIt(pw -> {
                    pw.print("<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + System.lineSeparator() + System.lineSeparator() + "<keys>");
                    keys.forEach(key -> pw.printf("<key>%s</key>", Escaper.escapeXml(key)));
                    pw.print("</keys>");
                })).build();
            }
            if ("application/json".equals(selectedMediaType)) {
                return Response.ok().type("application/json").entity((Object)this.printIt(pw -> {
                    pw.print("keys=[");
                    CloseableIterator it = keys.iterator();
                    while (it.hasNext()) {
                        pw.printf("\"%s\"", Escaper.escapeJson((String)it.next()));
                        if (!it.hasNext()) continue;
                        pw.print(",");
                    }
                    pw.print("]");
                })).build();
            }
            if ("text/plain".equals(selectedMediaType)) {
                return Response.ok().type("text/plain").entity((Object)this.printIt(pw -> keys.forEach(pw::println))).build();
            }
            if (TextPlainUtf8.equals(selectedMediaType)) {
                return Response.ok().type(TextPlainUtf8Type).entity((Object)this.printItUTF8(writer -> keys.forEach(key -> {
                    try {
                        writer.write((String)key);
                        writer.write(System.lineSeparator());
                    }
                    catch (IOException e) {
                        throw new CacheException((Throwable)e);
                    }
                }))).build();
            }
            return Response.notAcceptable(CollectionVariantListHelper.collectionVariantList).build();
        });
    }

    @GET
    @Path(value="/{cacheName}/{cacheKey}")
    @RolesAllowed(value={"_infinispan_rest_readers", "_infinispan_rest_writers"})
    public <V> Response getEntry(@Context Request request, @HeaderParam(value="performAsync") boolean useAsync, @PathParam(value="cacheName") String cacheName, @PathParam(value="cacheKey") String key, @QueryParam(value="extended") String extended, @DefaultValue(value="") @HeaderParam(value="Cache-Control") String cacheControl) {
        return this.protectCacheNotFound(() -> {
            CacheEntry entry = this.manager.getInternalEntry(cacheName, key);
            if (entry instanceof InternalCacheEntry) {
                InternalCacheEntry ice = (InternalCacheEntry)entry;
                Date lastMod = this.lastModified(ice);
                Date expires = ice.canExpire() ? new Date(ice.getExpiryTime()) : null;
                OptionalInt minFreshSeconds = this.minFresh(cacheControl);
                return this.ensureFreshEnoughEntry(expires, minFreshSeconds, () -> {
                    Metadata meta = ice.getMetadata();
                    if (meta instanceof MimeMetadata) {
                        return this.getMimeEntry(request, ice, (MimeMetadata)meta, lastMod, expires, cacheName, extended);
                    }
                    return this.getAnyEntry(request, ice, meta, lastMod, expires, cacheName, extended);
                });
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        });
    }

    private Response ensureFreshEnoughEntry(Date expires, OptionalInt minFreshSeconds, Supplier<Response> supplier) {
        if (this.entryFreshEnough(expires, minFreshSeconds)) {
            return supplier.get();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    private OptionalInt minFresh(String cacheControl) {
        Optional<String> minFreshDirective = Arrays.stream(cacheControl.split(",")).filter(s -> s.contains("min-fresh")).findFirst();
        return minFreshDirective.map(s -> {
            String[] equals = s.split("=");
            return OptionalInt.of(Integer.parseInt(equals[equals.length - 1].trim()));
        }).orElse(OptionalInt.empty());
    }

    private boolean entryFreshEnough(Date entryExpires, OptionalInt minFresh) {
        return !minFresh.isPresent() || minFresh.getAsInt() < this.calcFreshness(entryExpires);
    }

    private int calcFreshness(Date expires) {
        if (expires == null) {
            return Integer.MAX_VALUE;
        }
        return (int)(expires.getTime() - new Date().getTime()) / 1000;
    }

    private <V> Response getMimeEntry(Request request, InternalCacheEntry<String, V> ice, MimeMetadata meta, Date lastMod, Date expires, String cacheName, String extended) {
        String key = (String)ice.getKey();
        Response.ResponseBuilder bldr = request.evaluatePreconditions(lastMod, this.calcETAG(ice, meta));
        if (bldr == null) {
            bldr = this.extended(Server.mortality(Response.ok((Object)ice.getValue(), (String)meta.contentType).header("Last-Modified", (Object)this.formatDate(lastMod)).header("Expires", (Object)this.formatDate(expires)).cacheControl(this.calcCacheControl(expires)), meta).tag(this.calcETAG(ice, meta)), cacheName, key, this.wantExtendedHeaders(extended));
        }
        return bldr.build();
    }

    private <V> Response getAnyEntry(Request request, InternalCacheEntry<String, V> ice, Metadata meta, Date lastMod, Date expires, String cacheName, String extended) {
        String selectedMediaType;
        String key = (String)ice.getKey();
        Object value = ice.getValue();
        if (value instanceof String) {
            return Server.mortality(Response.ok((Object)((String)value), (String)"text/plain").header("Last-Modified", (Object)this.formatDate(lastMod)).cacheControl(this.calcCacheControl(expires)).header("Expires", (Object)this.formatDate(expires)), meta).build();
        }
        if (value instanceof byte[]) {
            return this.extended(Server.mortality(Response.ok().type("application/octet-stream").header("Last-Modified", (Object)this.formatDate(lastMod)).header("Expires", (Object)this.formatDate(expires)).cacheControl(this.calcCacheControl(expires)), meta), cacheName, key, this.wantExtendedHeaders(extended)).entity((Object)this.streamIt(b -> {
                try {
                    b.write((byte[])value);
                }
                catch (IOException e) {
                    throw new CacheException((Throwable)e);
                }
            })).build();
        }
        Variant variant = request.selectVariant(VariantListHelper.variantList);
        String string = selectedMediaType = variant != null ? variant.getMediaType().toString() : null;
        if ("application/json".equals(selectedMediaType)) {
            return this.extended(Server.mortality(Response.ok().type(selectedMediaType).header("Last-Modified", (Object)this.formatDate(lastMod)).header("Expires", (Object)this.formatDate(expires)).cacheControl(this.calcCacheControl(expires)), meta), cacheName, key, this.wantExtendedHeaders(extended)).entity((Object)this.streamIt(b -> {
                try {
                    JsonMapperHolder.jsonMapper.writeValue(b, value);
                }
                catch (IOException e) {
                    throw new CacheException((Throwable)e);
                }
            })).build();
        }
        if ("application/xml".equals(selectedMediaType)) {
            return this.extended(Server.mortality(Response.ok().type(selectedMediaType).header("Last-Modified", (Object)this.formatDate(lastMod)).header("Expires", (Object)this.formatDate(expires)).cacheControl(this.calcCacheControl(expires)), meta), cacheName, key, this.wantExtendedHeaders(extended)).entity((Object)this.streamIt(b -> XStreamholder.XStream.toXML(value, b))).build();
        }
        if (ApplicationXJavaSerializedObject.equals(selectedMediaType) && value instanceof Serializable) {
            return this.extended(Server.mortality(Response.ok().type(selectedMediaType).header("Last-Modified", (Object)this.formatDate(lastMod)).header("Expires", (Object)this.formatDate(expires)).cacheControl(this.calcCacheControl(expires)), meta), cacheName, key, this.wantExtendedHeaders(extended)).entity((Object)this.streamIt(b -> {
                try {
                    new ObjectOutputStream((OutputStream)b).writeObject(value);
                }
                catch (IOException e) {
                    throw new CacheException((Throwable)e);
                }
            })).build();
        }
        return Response.notAcceptable(VariantListHelper.variantList).build();
    }

    private String formatDate(Date date) {
        if (date == null) {
            return null;
        }
        return DATE_TIME_FORMATTER.format(date.toInstant());
    }

    private CacheControl calcCacheControl(Date expires) {
        if (expires == null) {
            return null;
        }
        CacheControl cacheControl = new CacheControl();
        int maxAgeSeconds = this.calcFreshness(expires);
        if (maxAgeSeconds > 0) {
            cacheControl.setMaxAge(maxAgeSeconds);
        } else {
            cacheControl.setNoCache(true);
        }
        return cacheControl;
    }

    static Response.ResponseBuilder mortality(Response.ResponseBuilder bld, Metadata meta) {
        if (meta.lifespan() > -1L) {
            bld.header(TimeToLiveHeader, (Object)TimeUnit.MILLISECONDS.toSeconds(meta.lifespan()));
        }
        if (meta.maxIdle() > -1L) {
            bld.header(MaxIdleTimeHeader, (Object)TimeUnit.MILLISECONDS.toSeconds(meta.maxIdle()));
        }
        return bld;
    }

    Response.ResponseBuilder extended(Response.ResponseBuilder bld, String cacheName, String key, boolean b) {
        return b ? bld.header("Cluster-Primary-Owner", (Object)this.manager.getPrimaryOwner(cacheName, key)).header("Cluster-Node-Name", (Object)this.manager.getNodeName()).header("Cluster-Server-Address", (Object)this.manager.getServerAddress()) : bld;
    }

    private boolean wantExtendedHeaders(String extended) {
        switch (this.configuration.extendedHeaders()) {
            case NEVER: {
                return false;
            }
            case ON_DEMAND: {
                return extended != null;
            }
        }
        throw new IllegalArgumentException("Unsupported header:" + (Object)((Object)this.configuration.extendedHeaders()));
    }

    StreamingOutput streamIt(final Consumer<? super OutputStream> action) {
        return new StreamingOutput(){

            public void write(OutputStream o) {
                action.accept(o);
            }
        };
    }

    StreamingOutput printIt(final Consumer<? super PrintWriter> consumer) {
        return new StreamingOutput(){

            public void write(OutputStream o) throws IOException, WebApplicationException {
                PrintWriter pw = new PrintWriter(o);
                try {
                    consumer.accept(pw);
                }
                finally {
                    pw.flush();
                }
            }
        };
    }

    StreamingOutput printItUTF8(final Consumer<? super Writer> action) {
        return new StreamingOutput(){

            public void write(OutputStream outputStream) throws IOException, WebApplicationException {
                OutputStreamWriter writer = new OutputStreamWriter(outputStream, "UTF-8");
                try {
                    action.accept(writer);
                }
                finally {
                    ((Writer)writer).flush();
                }
            }
        };
    }

    @HEAD
    @Path(value="/{cacheName}/{cacheKey}")
    @RolesAllowed(value={"_infinispan_rest_readers", "_infinispan_rest_writers"})
    public <V> Response headEntry(@Context Request request, @HeaderParam(value="performAsync") boolean useAsync, @PathParam(value="cacheName") String cacheName, @PathParam(value="cacheKey") String key, @QueryParam(value="extended") String extended, @DefaultValue(value="") @HeaderParam(value="Cache-Control") String cacheControl) {
        return this.protectCacheNotFound(() -> {
            CacheEntry entry = this.manager.getInternalEntry(cacheName, key);
            if (entry instanceof InternalCacheEntry) {
                InternalCacheEntry ice = (InternalCacheEntry)entry;
                Date lastMod = this.lastModified(ice);
                Date expires = ice.canExpire() ? new Date(ice.getExpiryTime()) : null;
                OptionalInt minFreshSeconds = this.minFresh(cacheControl);
                return this.ensureFreshEnoughEntry(expires, minFreshSeconds, () -> {
                    Metadata meta = ice.getMetadata();
                    if (meta instanceof MimeMetadata) {
                        MimeMetadata mime = (MimeMetadata)meta;
                        Response.ResponseBuilder bldr = request.evaluatePreconditions(lastMod, this.calcETAG(ice, mime));
                        if (bldr == null) {
                            return this.extended(Server.mortality(Response.ok().type(mime.contentType).header("Last-Modified", (Object)this.formatDate(lastMod)).header("Expires", (Object)this.formatDate(expires)).cacheControl(this.calcCacheControl(expires)), mime).tag(this.calcETAG(ice, mime)), cacheName, key, this.wantExtendedHeaders(extended)).build();
                        }
                        return bldr.build();
                    }
                    return this.extended(Server.mortality(Response.ok().header("Last-Modified", (Object)this.formatDate(lastMod)).header("Expires", (Object)this.formatDate(expires)).cacheControl(this.calcCacheControl(expires)), meta), cacheName, key, this.wantExtendedHeaders(extended)).build();
                });
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        });
    }

    @PUT
    @POST
    @Path(value="/{cacheName}/{cacheKey}")
    @RolesAllowed(value={"_infinispan_rest_writers"})
    public <V> Response putEntry(@Context Request request, @HeaderParam(value="performAsync") boolean useAsync, @PathParam(value="cacheName") String cacheName, @PathParam(value="cacheKey") String key, @HeaderParam(value="Content-Type") String mediaType, byte[] data, @DefaultValue(value="-1") @HeaderParam(value="timeToLiveSeconds") long ttl, @DefaultValue(value="-1") @HeaderParam(value="maxIdleTimeSeconds") long idleTime) {
        return this.protectCacheNotFound(() -> {
            AdvancedCache<String, byte[]> cache = this.manager.getCache(cacheName);
            if ("POST".equals(request.getMethod()) && cache.containsKey((Object)key)) {
                return Response.status((Response.Status)Response.Status.CONFLICT).build();
            }
            CacheEntry entry = this.manager.getInternalEntry(cacheName, key, true);
            if (entry instanceof InternalCacheEntry) {
                InternalCacheEntry ice = (InternalCacheEntry)entry;
                Date lastMod = this.lastModified(ice);
                Metadata meta = ice.getMetadata();
                if (meta instanceof MimeMetadata) {
                    EntityTag etag = this.calcETAG(ice, (MimeMetadata)meta);
                    Response.ResponseBuilder bldr = request.evaluatePreconditions(lastMod, etag);
                    if (bldr == null) {
                        return this.putInCache(useAsync, cache, key, data, mediaType, ttl, idleTime, Optional.of((byte[])ice.getValue()));
                    }
                    return bldr.build();
                }
                return this.putInCache(useAsync, cache, key, data, mediaType, ttl, idleTime, Optional.empty());
            }
            return this.putInCache(useAsync, cache, key, data, mediaType, ttl, idleTime, Optional.empty());
        });
    }

    private Response putInCache(boolean useAsync, AdvancedCache<String, byte[]> cache, String key, byte[] data, String dataType, long ttl, long idleTime, Optional<byte[]> prevCond) {
        if (useAsync) {
            return this.asyncPutInCache(cache, key, data, dataType, ttl, idleTime);
        }
        return this.putOrReplace(cache, key, data, dataType, ttl, idleTime, prevCond);
    }

    Response asyncPutInCache(AdvancedCache<String, byte[]> cache, String key, byte[] data, String dataType, long ttl, long idleTime) {
        Metadata metadata = this.createMetadata(cache.getCacheConfiguration(), dataType, ttl, idleTime);
        cache.putAsync((Object)key, (Object)data, metadata);
        return Response.ok().build();
    }

    Metadata createMetadata(Configuration cfg, String dataType, long ttl, long idleTime) {
        MimeMetadataBuilder metadata = new MimeMetadataBuilder();
        metadata.contentType(dataType);
        if (ttl == 0L) {
            metadata.lifespan(cfg.expiration().lifespan(), TimeUnit.MILLISECONDS);
        } else {
            metadata.lifespan(ttl, TimeUnit.SECONDS);
        }
        if (idleTime == 0L) {
            metadata.maxIdle(cfg.expiration().maxIdle(), TimeUnit.MILLISECONDS);
        } else {
            metadata.maxIdle(idleTime, TimeUnit.SECONDS);
        }
        return metadata.build();
    }

    private Response putOrReplace(AdvancedCache<String, byte[]> cache, String key, byte[] data, String dataType, long ttl, long idleTime, Optional<byte[]> prevCond) {
        Metadata metadata = this.createMetadata(cache.getCacheConfiguration(), dataType, ttl, idleTime);
        if (prevCond.isPresent()) {
            boolean replaced = cache.replace((Object)key, (Object)prevCond.get(), (Object)data, metadata);
            if (replaced) {
                return Response.ok().build();
            }
            return Response.status((int)412).build();
        }
        cache.put((Object)key, (Object)data, metadata);
        return Response.ok().build();
    }

    @DELETE
    @Path(value="/{cacheName}/{cacheKey}")
    @RolesAllowed(value={"_infinispan_rest_writers"})
    public <V> Response removeEntry(@Context Request request, @HeaderParam(value="performAsync") boolean useAsync, @PathParam(value="cacheName") String cacheName, @PathParam(value="cacheKey") String key) {
        return this.protectCacheNotFound(() -> {
            CacheEntry entry = this.manager.getInternalEntry(cacheName, key);
            if (entry instanceof InternalCacheEntry) {
                InternalCacheEntry ice = (InternalCacheEntry)entry;
                Date lastMod = this.lastModified((InternalCacheEntry)entry);
                Metadata meta = entry.getMetadata();
                if (meta instanceof MimeMetadata) {
                    EntityTag etag = this.calcETAG(ice, (MimeMetadata)meta);
                    Response.ResponseBuilder bldr = request.evaluatePreconditions(lastMod, etag);
                    if (bldr == null) {
                        if (useAsync) {
                            this.manager.getCache(cacheName).removeAsync((Object)key);
                        } else {
                            this.manager.getCache(cacheName).remove((Object)key);
                        }
                        return Response.ok().build();
                    }
                    return bldr.build();
                }
                if (useAsync) {
                    this.manager.getCache(cacheName).removeAsync((Object)key);
                } else {
                    this.manager.getCache(cacheName).remove((Object)key);
                }
                return Response.ok().build();
            }
            if (entry == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            throw new IllegalArgumentException("Unsupported entry implementation: " + entry);
        });
    }

    @DELETE
    @Path(value="/{cacheName}")
    @RolesAllowed(value={"_infinispan_rest_writers"})
    public Response killCache(@PathParam(value="cacheName") String cacheName, @DefaultValue(value="") @HeaderParam(value="If-Match") String ifMatch, @DefaultValue(value="") @HeaderParam(value="If-None-Match") String ifNoneMatch, @DefaultValue(value="") @HeaderParam(value="If-Modified-Since") String ifModifiedSince, @DefaultValue(value="") @HeaderParam(value="If-Unmodified-Since") String ifUnmodifiedSince) {
        if (ifMatch.isEmpty() && ifNoneMatch.isEmpty() && ifModifiedSince.isEmpty() && ifUnmodifiedSince.isEmpty()) {
            this.manager.getCache(cacheName).clear();
            return Response.ok().build();
        }
        return this.preconditionNotImplementedResponse();
    }

    private Response preconditionNotImplementedResponse() {
        return Response.status((int)501).entity((Object)"Preconditions were not implemented yet for PUT, POST, and DELETE methods.").build();
    }

    private <K, V> EntityTag calcETAG(InternalCacheEntry<K, V> entry, MimeMetadata meta) {
        return new EntityTag(meta.contentType + this.hashFunc.hash(entry.getValue()));
    }

    private <K, V> Date lastModified(InternalCacheEntry<K, V> ice) {
        return new Date(ice.getCreated() / 1000L * 1000L);
    }

    private Response protectCacheNotFound(Supplier<Response> op) {
        try {
            return op.get();
        }
        catch (CacheNotFoundException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
    }

    static /* synthetic */ MediaType access$000() {
        return ApplicationXJavaSerializedObjectType;
    }

    static /* synthetic */ MediaType access$100() {
        return TextPlainUtf8Type;
    }

    private static class XStreamholder {
        public static final XStream XStream = new XStream();

        private XStreamholder() {
        }
    }

    private static class JsonMapperHolder {
        public static final ObjectMapper jsonMapper = new ObjectMapper();

        private JsonMapperHolder() {
        }
    }

    private static class CollectionVariantListHelper {
        public static final List<Variant> collectionVariantList = Variant.VariantListBuilder.newInstance().mediaTypes(new MediaType[]{MediaType.TEXT_HTML_TYPE, MediaType.APPLICATION_XML_TYPE, MediaType.APPLICATION_JSON_TYPE, MediaType.TEXT_PLAIN_TYPE, Server.access$100()}).build();

        private CollectionVariantListHelper() {
        }
    }

    private static class VariantListHelper {
        public static final List<Variant> variantList = Variant.VariantListBuilder.newInstance().mediaTypes(new MediaType[]{MediaType.APPLICATION_XML_TYPE, Server.access$000(), MediaType.APPLICATION_JSON_TYPE}).build();

        private VariantListHelper() {
        }
    }
}

