/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.embedded.netty4;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageEncoder;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.LastHttpContent;
import java.util.List;
import java.util.Map;
import javax.ws.rs.ext.RuntimeDelegate;
import org.infinispan.rest.embedded.netty4.NettyHttpResponse;
import org.jboss.resteasy.spi.ResteasyProviderFactory;

@ChannelHandler.Sharable
public class RestEasyHttpResponseEncoder
extends MessageToMessageEncoder<NettyHttpResponse> {
    public static void transformHeaders(NettyHttpResponse nettyResponse, HttpResponse response, ResteasyProviderFactory factory) {
        if (nettyResponse.isKeepAlive()) {
            response.headers().set("Connection", (Object)"keep-alive");
        } else {
            response.headers().set("Connection", (Object)"close");
        }
        for (Map.Entry entry : nettyResponse.getOutputHeaders().entrySet()) {
            String key = (String)entry.getKey();
            for (Object value : (List)entry.getValue()) {
                RuntimeDelegate.HeaderDelegate delegate = factory.getHeaderDelegate(value.getClass());
                if (delegate != null) {
                    response.headers().add(key, (Object)delegate.toString(value));
                    continue;
                }
                response.headers().set(key, (Object)value.toString());
            }
        }
    }

    protected void encode(ChannelHandlerContext ctx, NettyHttpResponse nettyResponse, List<Object> out) throws Exception {
        nettyResponse.getOutputStream().flush();
        if (nettyResponse.isCommitted()) {
            out.add(LastHttpContent.EMPTY_LAST_CONTENT);
        } else {
            DefaultHttpResponse response = nettyResponse.getDefaultHttpResponse();
            out.add(response);
        }
    }
}

