/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest;

import java.util.Map;
import java.util.function.Predicate;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.commons.util.CollectionFactory;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.registry.InternalCacheRegistry;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.remoting.transport.jgroups.JGroupsTransport;
import org.infinispan.rest.CacheNotFoundException;
import org.infinispan.rest.CacheUnavailableException;
import org.infinispan.rest.RestSourceMigrator;
import org.infinispan.upgrade.RollingUpgradeManager;
import org.infinispan.upgrade.SourceMigrator;

public class RestCacheManager {
    private final EmbeddedCacheManager instance;
    private final Predicate<? super String> isCacheIgnored;
    private final boolean allowInternalCacheAccess;
    private Map<String, AdvancedCache<String, byte[]>> knownCaches = CollectionFactory.makeConcurrentMap((int)4, (float)0.9f, (int)16);

    public RestCacheManager(EmbeddedCacheManager instance) {
        this(instance, s -> Boolean.FALSE);
    }

    public RestCacheManager(EmbeddedCacheManager instance, Predicate<? super String> isCacheIgnored) {
        this.instance = instance;
        this.isCacheIgnored = isCacheIgnored;
        this.allowInternalCacheAccess = instance.getCacheManagerConfiguration().security().authorization().enabled();
    }

    AdvancedCache<String, byte[]> getCache(String name) {
        if (this.isCacheIgnored.test(name)) {
            throw new CacheUnavailableException("Cache with name '" + name + "' is temporarily unavailable.");
        }
        boolean isKnownCache = this.knownCaches.containsKey(name);
        if (!("___defaultcache".equals(name) || isKnownCache || this.instance.getCacheNames().contains(name))) {
            throw new CacheNotFoundException("Cache with name '" + name + "' not found amongst the configured caches");
        }
        if (isKnownCache) {
            return (AdvancedCache)this.knownCaches.get(name);
        }
        InternalCacheRegistry icr = (InternalCacheRegistry)this.instance.getGlobalComponentRegistry().getComponent(InternalCacheRegistry.class);
        if (icr.isPrivateCache(name)) {
            throw new CacheUnavailableException(String.format("Remote requests are not allowed to private caches. Do no send remote requests to cache '%s'", name));
        }
        if (!this.allowInternalCacheAccess && icr.isInternalCache(name)) {
            throw new CacheUnavailableException(String.format("Remote requests are not allowed to internal caches when authorization is disabled. Do no send remote requests to cache '%s'", name));
        }
        Cache cache = name.equals("___defaultcache") ? this.instance.getCache() : this.instance.getCache(name);
        this.tryRegisterMigrationManager(cache);
        this.knownCaches.put(name, cache.getAdvancedCache());
        return cache.getAdvancedCache();
    }

    byte[] getEntry(String cacheName, String key) {
        return (byte[])this.getCache(cacheName).get((Object)key);
    }

    <V> CacheEntry<String, V> getInternalEntry(String cacheName, String key) {
        return this.getInternalEntry(cacheName, key, false);
    }

    <V> CacheEntry<String, V> getInternalEntry(String cacheName, String key, boolean skipListener) {
        AdvancedCache cache = skipListener ? this.getCache(cacheName).withFlags(new Flag[]{Flag.SKIP_LISTENER_NOTIFICATION}) : this.getCache(cacheName);
        return cache.getCacheEntry((Object)key);
    }

    public Address getNodeName() {
        return this.instance.getAddress();
    }

    String getServerAddress() {
        Transport transport = this.instance.getTransport();
        if (transport instanceof JGroupsTransport) {
            return transport.getPhysicalAddresses().toString();
        }
        return null;
    }

    String getPrimaryOwner(String cacheName, String key) {
        DistributionManager dm = this.getCache(cacheName).getDistributionManager();
        return dm.getCacheTopology().getDistribution((Object)key).primary().toString();
    }

    EmbeddedCacheManager getInstance() {
        return this.instance;
    }

    void tryRegisterMigrationManager(Cache<String, byte[]> cache) {
        ComponentRegistry cr = cache.getAdvancedCache().getComponentRegistry();
        RollingUpgradeManager migrationManager = (RollingUpgradeManager)cr.getComponent(RollingUpgradeManager.class);
        if (migrationManager != null) {
            migrationManager.addSourceMigrator((SourceMigrator)new RestSourceMigrator(cache));
        }
    }
}

