/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.embedded.netty4;

import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.io.OutputStream;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.NewCookie;
import org.infinispan.rest.embedded.netty4.ChunkOutputStream;
import org.infinispan.rest.embedded.netty4.RestEasyHttpResponseEncoder;
import org.infinispan.rest.embedded.netty4.i18n.Messages;
import org.jboss.resteasy.specimpl.MultivaluedMapImpl;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.ResteasyProviderFactory;

public class NettyHttpResponse
implements HttpResponse {
    private static final int EMPTY_CONTENT_LENGTH = 0;
    private final ChannelHandlerContext ctx;
    private int status = 200;
    private OutputStream os;
    private MultivaluedMap<String, Object> outputHeaders = new MultivaluedMapImpl();
    private boolean committed;
    private boolean keepAlive;
    private ResteasyProviderFactory providerFactory;

    public NettyHttpResponse(ChannelHandlerContext ctx, boolean keepAlive, ResteasyProviderFactory providerFactory) {
        this.os = new ChunkOutputStream(this, ctx, 1000);
        this.ctx = ctx;
        this.keepAlive = keepAlive;
        this.providerFactory = providerFactory;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public MultivaluedMap<String, Object> getOutputHeaders() {
        return this.outputHeaders;
    }

    public OutputStream getOutputStream() throws IOException {
        return this.os;
    }

    public void setOutputStream(OutputStream os) {
        this.os = os;
    }

    public void addNewCookie(NewCookie cookie) {
        this.outputHeaders.add((Object)"Set-Cookie", (Object)cookie);
    }

    public void sendError(int status) throws IOException {
        this.sendError(status, null);
    }

    public void sendError(int status, String message) throws IOException {
        HttpResponseStatus responseStatus;
        if (this.committed) {
            throw new IllegalStateException();
        }
        if (message != null) {
            responseStatus = new HttpResponseStatus(status, message);
            this.setStatus(status);
        } else {
            responseStatus = HttpResponseStatus.valueOf((int)status);
            this.setStatus(status);
        }
        DefaultFullHttpResponse response = message != null ? new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, responseStatus, Unpooled.wrappedBuffer((byte[])message.getBytes())) : new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, responseStatus);
        HttpHeaders headers = response.headers();
        this.outputHeaders.entrySet().forEach(header -> headers.add((String)header.getKey(), (Iterable)header.getValue()));
        if (this.keepAlive) {
            headers.add((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE);
        }
        if (message == null) {
            headers.add((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)0);
        } else {
            headers.add((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)message.getBytes().length);
            headers.add((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)HttpHeaderValues.TEXT_PLAIN);
        }
        this.ctx.writeAndFlush((Object)response);
        this.committed = true;
    }

    public boolean isCommitted() {
        return this.committed;
    }

    public void reset() {
        if (this.committed) {
            throw new IllegalStateException(Messages.MESSAGES.alreadyCommitted());
        }
        this.outputHeaders.clear();
    }

    public boolean isKeepAlive() {
        return this.keepAlive;
    }

    public DefaultHttpResponse getDefaultHttpResponse() {
        DefaultHttpResponse res = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.valueOf((int)this.getStatus()));
        this.transformResponseHeaders((io.netty.handler.codec.http.HttpResponse)res);
        return res;
    }

    public DefaultHttpResponse getEmptyHttpResponse() {
        DefaultFullHttpResponse res = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.valueOf((int)this.getStatus()));
        res.headers().add((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)0);
        this.transformResponseHeaders((io.netty.handler.codec.http.HttpResponse)res);
        return res;
    }

    private void transformResponseHeaders(io.netty.handler.codec.http.HttpResponse res) {
        RestEasyHttpResponseEncoder.transformHeaders(this, res, this.providerFactory);
    }

    public void prepareChunkStream() {
        this.committed = true;
        DefaultHttpResponse response = this.getDefaultHttpResponse();
        HttpUtil.setTransferEncodingChunked((HttpMessage)response, (boolean)true);
        this.ctx.write((Object)response);
    }

    public void finish() throws IOException {
        this.os.flush();
        ChannelFuture future = this.isCommitted() ? this.ctx.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT) : this.ctx.writeAndFlush((Object)this.getEmptyHttpResponse());
        if (!this.isKeepAlive()) {
            future.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }
}

