/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest;

import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.infinispan.metadata.Metadata;
import org.infinispan.rest.MimeMetadata;
import org.infinispan.rest.MimeMetadataBuilder;

class MimeExpirableMetadata
extends MimeMetadata {
    private final long lifespanTime;
    private final TimeUnit lifespanUnit;
    private final long maxIdleTime;
    private final TimeUnit maxIdleUnit;

    public MimeExpirableMetadata(String contentType, long lifespanTime, TimeUnit lifespanUnit, long maxIdleTime, TimeUnit maxIdleUnit) {
        super(contentType);
        this.lifespanTime = lifespanTime;
        this.lifespanUnit = Objects.requireNonNull(lifespanUnit);
        this.maxIdleTime = maxIdleTime;
        this.maxIdleUnit = Objects.requireNonNull(maxIdleUnit);
    }

    public long lifespan() {
        return this.lifespanUnit.toMillis(this.lifespanTime);
    }

    public long maxIdle() {
        return this.maxIdleUnit.toMillis(this.maxIdleTime);
    }

    public Metadata.Builder builder() {
        return new MimeMetadataBuilder().contentType(this.contentType).lifespan(this.lifespanTime, this.lifespanUnit).maxIdle(this.maxIdleTime, this.maxIdleUnit);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MimeExpirableMetadata that = (MimeExpirableMetadata)o;
        if (this.lifespanTime != that.lifespanTime) {
            return false;
        }
        if (this.maxIdleTime != that.maxIdleTime) {
            return false;
        }
        if (this.lifespanUnit != that.lifespanUnit) {
            return false;
        }
        return this.maxIdleUnit == that.maxIdleUnit;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (int)(this.lifespanTime ^ this.lifespanTime >>> 32);
        result = 31 * result + this.lifespanUnit.hashCode();
        result = 31 * result + (int)(this.maxIdleTime ^ this.maxIdleTime >>> 32);
        result = 31 * result + this.maxIdleUnit.hashCode();
        return result;
    }

    public String toString() {
        return "MimeExpirableMetadata{lifespanTime=" + this.lifespanTime + ", lifespanUnit=" + (Object)((Object)this.lifespanUnit) + ", maxIdleTime=" + this.maxIdleTime + ", maxIdleUnit=" + (Object)((Object)this.maxIdleUnit) + '}';
    }
}

