/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest;

import java.security.Principal;
import java.util.Base64;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.api.ContentResponse;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpMethod;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.rest.RestServer;
import org.infinispan.rest.assertion.ResponseAssertion;
import org.infinispan.rest.authentication.Authenticator;
import org.infinispan.rest.authentication.SecurityDomain;
import org.infinispan.rest.authentication.impl.BasicAuthenticator;
import org.infinispan.rest.configuration.RestServerConfigurationBuilder;
import org.infinispan.server.core.configuration.ProtocolServerConfiguration;
import org.infinispan.test.AbstractInfinispanTest;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.internal.stubbing.answers.ThrowsExceptionClass;
import org.mockito.stubbing.Answer;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.AfterSuite;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeSuite;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="rest.AuthenticationTest")
public class AuthenticationTest
extends AbstractInfinispanTest {
    private EmbeddedCacheManager cacheManager;
    private HttpClient client;
    private RestServer restServer;
    private RestServerConfigurationBuilder restServerConfiguration;

    @BeforeSuite
    public void beforeSuite() throws Exception {
        GlobalConfigurationBuilder gcb = new GlobalConfigurationBuilder().nonClusteredDefault();
        gcb.globalJmxStatistics().allowDuplicateDomains(Boolean.valueOf(true));
        ConfigurationBuilder cb = new ConfigurationBuilder();
        this.cacheManager = new DefaultCacheManager(gcb.build(), cb.build());
        this.restServerConfiguration = new RestServerConfigurationBuilder();
        ((RestServerConfigurationBuilder)this.restServerConfiguration.host("localhost")).port(0);
    }

    @AfterSuite
    public void afterSuite() throws Exception {
        this.cacheManager.stop();
    }

    @BeforeMethod
    public void beforeMethod() throws Exception {
        this.client = new HttpClient();
        this.client.start();
    }

    @AfterMethod
    public void afterMethod() throws Exception {
        this.cacheManager.getCache("default").clear();
        if (this.restServer != null) {
            this.restServer.stop();
        }
        this.client.stop();
    }

    @Test
    public void shouldAuthenticateWhenProvidingProperCredentials() throws Exception {
        SecurityDomain securityDomainMock = (SecurityDomain)Mockito.mock(SecurityDomain.class, (Answer)new ThrowsExceptionClass(SecurityException.class));
        ((SecurityDomain)Mockito.doReturn((Object)Mockito.mock(Principal.class)).when((Object)securityDomainMock)).authenticate((String)Matchers.eq((Object)"test"), (String)Matchers.eq((Object)"test"));
        BasicAuthenticator basicAuthenticator = new BasicAuthenticator(securityDomainMock, "ApplicationRealm");
        this.startRestWithAuthenticator((Authenticator)basicAuthenticator);
        ContentResponse response = this.client.newRequest(String.format("http://localhost:%d/rest/%s/%s", this.restServer.getPort(), "default", "test")).method(HttpMethod.HEAD).header(HttpHeader.AUTHORIZATION, "Basic " + Base64.getEncoder().encodeToString("test:test".getBytes())).send();
        ResponseAssertion.assertThat(response).isNotFound();
    }

    private void startRestWithAuthenticator(Authenticator basicAuthenticator) {
        this.restServer = new RestServer();
        this.restServer.setAuthenticator(basicAuthenticator);
        this.restServer.start((ProtocolServerConfiguration)this.restServerConfiguration.build(), this.cacheManager);
    }

    @Test
    public void shouldRejectNotValidAuthorizationString() throws Exception {
        SecurityDomain securityDomainMock = (SecurityDomain)Mockito.mock(SecurityDomain.class);
        BasicAuthenticator basicAuthenticator = new BasicAuthenticator(securityDomainMock, "ApplicationRealm");
        this.startRestWithAuthenticator((Authenticator)basicAuthenticator);
        ContentResponse response = this.client.newRequest(String.format("http://localhost:%d/rest/%s/%s", this.restServer.getPort(), "default", "test")).method(HttpMethod.GET).header(HttpHeader.AUTHORIZATION, "Invalid string").send();
        ResponseAssertion.assertThat(response).isUnauthorized();
    }

    @Test
    public void shouldRejectNoAuthentication() throws Exception {
        SecurityDomain securityDomainMock = (SecurityDomain)Mockito.mock(SecurityDomain.class);
        BasicAuthenticator basicAuthenticator = new BasicAuthenticator(securityDomainMock, "ApplicationRealm");
        this.startRestWithAuthenticator((Authenticator)basicAuthenticator);
        ContentResponse response = this.client.newRequest(String.format("http://localhost:%d/rest/%s/%s", this.restServer.getPort(), "default", "test")).method(HttpMethod.GET).send();
        ResponseAssertion.assertThat(response).isUnauthorized();
    }
}

