/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http2.HttpConversionUtil;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.infinispan.rest.CacheControl;
import org.infinispan.rest.InfinispanRequest;
import org.infinispan.rest.operations.mediatypes.Charset;
import org.infinispan.rest.operations.mediatypes.MediaType;

public class InfinispanResponse {
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.RFC_1123_DATE_TIME.withZone(ZoneId.systemDefault());
    private static final String TIME_TO_LIVE_HEADER = "timeToLiveSeconds";
    private static final String MAX_IDLE_TIME_HEADER = "maxIdleTimeSeconds";
    private static final String CLUSTER_PRIMARY_OWNER_HEADER = "Cluster-Primary-Owner";
    private static final String CLUSTER_NODE_NAME_HEADER = "Cluster-Node-Name";
    private static final String CLUSTER_SERVER_ADDRESS_HEADER = "Cluster-Server-Address";
    private Optional<InfinispanRequest> request;
    private ByteBuf content = Unpooled.buffer();
    private String contentType = MediaType.TEXT_PLAIN.toString();
    private HttpVersion httpVersion = HttpVersion.HTTP_1_1;
    private HttpResponseStatus httpStatus = HttpResponseStatus.OK;
    private Optional<String> etag = Optional.empty();
    private Optional<CacheControl> cacheControl = Optional.empty();
    private Optional<Date> lastModified = Optional.empty();
    private Optional<Date> expires = Optional.empty();
    private Optional<Long> timeToLive = Optional.empty();
    private Optional<Long> maxIdle = Optional.empty();
    private Optional<String> clusterPrimaryOwner = Optional.empty();
    private Optional<String> clusterNodeName = Optional.empty();
    private Optional<String> clusterServerAddress = Optional.empty();
    private Optional<String> authenticate = Optional.empty();
    private Optional<Charset> charset = Optional.empty();

    private InfinispanResponse(Optional<InfinispanRequest> request) {
        this.request = request;
    }

    public static final InfinispanResponse inReplyTo(InfinispanRequest request) {
        return new InfinispanResponse(Optional.of(request));
    }

    public static final InfinispanResponse asError(InfinispanRequest request, HttpResponseStatus status, String description) {
        InfinispanResponse infinispanResponse = new InfinispanResponse(Optional.of(request));
        infinispanResponse.status(status);
        if (description != null) {
            infinispanResponse.contentAsText(description);
        }
        return infinispanResponse;
    }

    public void contentAsText(String content) {
        ByteBufUtil.writeUtf8((ByteBuf)this.content, (CharSequence)content);
    }

    public void contentAsBytes(byte[] content) {
        this.content.writeBytes(content);
    }

    public void contentType(String contentType) {
        this.contentType = contentType;
    }

    public void httpVersion(HttpVersion httpVersion) {
        this.httpVersion = httpVersion;
    }

    public void status(HttpResponseStatus httpStatus) {
        this.httpStatus = httpStatus;
    }

    public boolean isKeepAlive() {
        boolean isKeepAlive = this.request.map(r -> HttpUtil.isKeepAlive((HttpMessage)r.getRawRequest())).orElse(false);
        return (this.httpVersion == HttpVersion.HTTP_1_1 || this.httpVersion == HttpVersion.HTTP_1_0) && isKeepAlive;
    }

    public FullHttpResponse toNettyHttpResponse() {
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(this.httpVersion, this.httpStatus, this.content);
        this.request.flatMap(InfinispanRequest::getStreamId).ifPresent(arg_0 -> InfinispanResponse.lambda$toNettyHttpResponse$1((FullHttpResponse)response, arg_0));
        if (this.isKeepAlive()) {
            response.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE);
        }
        this.etag.ifPresent(arg_0 -> InfinispanResponse.lambda$toNettyHttpResponse$2((FullHttpResponse)response, arg_0));
        this.cacheControl.ifPresent(arg_0 -> InfinispanResponse.lambda$toNettyHttpResponse$3((FullHttpResponse)response, arg_0));
        this.lastModified.ifPresent(arg_0 -> InfinispanResponse.lambda$toNettyHttpResponse$4((FullHttpResponse)response, arg_0));
        this.expires.ifPresent(arg_0 -> InfinispanResponse.lambda$toNettyHttpResponse$5((FullHttpResponse)response, arg_0));
        this.timeToLive.ifPresent(arg_0 -> InfinispanResponse.lambda$toNettyHttpResponse$6((FullHttpResponse)response, arg_0));
        this.maxIdle.ifPresent(arg_0 -> InfinispanResponse.lambda$toNettyHttpResponse$7((FullHttpResponse)response, arg_0));
        this.clusterPrimaryOwner.ifPresent(arg_0 -> InfinispanResponse.lambda$toNettyHttpResponse$8((FullHttpResponse)response, arg_0));
        this.clusterNodeName.ifPresent(arg_0 -> InfinispanResponse.lambda$toNettyHttpResponse$9((FullHttpResponse)response, arg_0));
        this.clusterServerAddress.ifPresent(arg_0 -> InfinispanResponse.lambda$toNettyHttpResponse$10((FullHttpResponse)response, arg_0));
        this.authenticate.ifPresent(arg_0 -> InfinispanResponse.lambda$toNettyHttpResponse$11((FullHttpResponse)response, arg_0));
        StringBuilder contentTypeWithCharset = new StringBuilder(this.contentType);
        if (this.charset.isPresent()) {
            contentTypeWithCharset.append(';').append(this.charset.get());
        }
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)contentTypeWithCharset.toString());
        HttpUtil.setContentLength((HttpMessage)response, (long)response.content().readableBytes());
        return response;
    }

    public void etag(String etag) {
        this.etag = Optional.of(etag);
    }

    public void cacheControl(CacheControl cacheControl) {
        this.cacheControl = Optional.ofNullable(cacheControl);
    }

    public void lastModified(Date lastModified) {
        this.lastModified = Optional.ofNullable(lastModified);
    }

    public void expires(Date expires) {
        this.expires = Optional.ofNullable(expires);
    }

    public void timeToLive(long lifespan) {
        if (lifespan > -1L) {
            this.timeToLive = Optional.of(lifespan);
        }
    }

    public void maxIdle(long maxIdle) {
        if (maxIdle > -1L) {
            this.maxIdle = Optional.of(maxIdle);
        }
    }

    public void clusterPrimaryOwner(String primaryOwner) {
        this.clusterPrimaryOwner = Optional.of(primaryOwner);
    }

    public void clusterNodeName(String nodeName) {
        this.clusterNodeName = Optional.of(nodeName);
    }

    public void clusterServerAddress(String serverAddress) {
        this.clusterServerAddress = Optional.of(serverAddress);
    }

    public void authenticate(String authenticateHeader) {
        this.authenticate = Optional.of(authenticateHeader);
    }

    public void charset(Charset charset) {
        this.charset = Optional.ofNullable(charset);
    }

    private static /* synthetic */ void lambda$toNettyHttpResponse$11(FullHttpResponse response, String e) {
        response.headers().set((CharSequence)HttpHeaderNames.WWW_AUTHENTICATE, (Object)e);
    }

    private static /* synthetic */ void lambda$toNettyHttpResponse$10(FullHttpResponse response, String e) {
        response.headers().set(CLUSTER_SERVER_ADDRESS_HEADER, (Object)e);
    }

    private static /* synthetic */ void lambda$toNettyHttpResponse$9(FullHttpResponse response, String e) {
        response.headers().set(CLUSTER_NODE_NAME_HEADER, (Object)e);
    }

    private static /* synthetic */ void lambda$toNettyHttpResponse$8(FullHttpResponse response, String e) {
        response.headers().set(CLUSTER_PRIMARY_OWNER_HEADER, (Object)e);
    }

    private static /* synthetic */ void lambda$toNettyHttpResponse$7(FullHttpResponse response, Long e) {
        response.headers().set(MAX_IDLE_TIME_HEADER, (Object)TimeUnit.MILLISECONDS.toSeconds(e));
    }

    private static /* synthetic */ void lambda$toNettyHttpResponse$6(FullHttpResponse response, Long e) {
        response.headers().set(TIME_TO_LIVE_HEADER, (Object)TimeUnit.MILLISECONDS.toSeconds(e));
    }

    private static /* synthetic */ void lambda$toNettyHttpResponse$5(FullHttpResponse response, Date e) {
        response.headers().set((CharSequence)HttpHeaderNames.EXPIRES, (Object)DATE_TIME_FORMATTER.format(e.toInstant()));
    }

    private static /* synthetic */ void lambda$toNettyHttpResponse$4(FullHttpResponse response, Date e) {
        response.headers().set((CharSequence)HttpHeaderNames.LAST_MODIFIED, (Object)DATE_TIME_FORMATTER.format(e.toInstant()));
    }

    private static /* synthetic */ void lambda$toNettyHttpResponse$3(FullHttpResponse response, CacheControl e) {
        response.headers().set((CharSequence)HttpHeaderNames.CACHE_CONTROL, (Object)e);
    }

    private static /* synthetic */ void lambda$toNettyHttpResponse$2(FullHttpResponse response, String e) {
        response.headers().set((CharSequence)HttpHeaderNames.ETAG, (Object)e);
    }

    private static /* synthetic */ void lambda$toNettyHttpResponse$1(FullHttpResponse response, String streamId) {
        response.headers().set((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_ID.text(), (Object)streamId);
    }
}

