/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.QueryStringDecoder;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.infinispan.rest.InfinispanCacheAPIRequest;
import org.infinispan.rest.InfinispanRequest;
import org.infinispan.rest.RestServer;
import org.infinispan.rest.operations.exceptions.MalformedRequest;
import org.infinispan.rest.search.InfinispanSearchRequest;

class InfinispanRequestFactory {
    private static final String SEARCH_ACTION = "search";
    private static final String ACTION_PARAMETER = "action";

    private InfinispanRequestFactory() {
    }

    static InfinispanRequest createRequest(RestServer restServer, FullHttpRequest request, ChannelHandlerContext ctx) {
        String action;
        QueryStringDecoder queryStringDecoder = new QueryStringDecoder(request.uri());
        Map parameters = queryStringDecoder.parameters();
        String[] components = queryStringDecoder.path().substring(1).split("/");
        Optional<String> key = Optional.empty();
        Optional<String> cacheName = Optional.empty();
        List actionParameter = (List)parameters.get(ACTION_PARAMETER);
        if (components.length > 3 || components.length == 0) {
            throw new MalformedRequest("Invalid request path");
        }
        Iterator pathElements = Arrays.stream(components).iterator();
        String context = (String)pathElements.next();
        if (pathElements.hasNext()) {
            cacheName = Optional.of(pathElements.next());
        }
        if (pathElements.hasNext()) {
            key = Optional.of(pathElements.next());
        }
        if (actionParameter == null || actionParameter.isEmpty()) {
            return new InfinispanCacheAPIRequest(restServer.getCacheOperations(), request, ctx, cacheName, key, context, parameters);
        }
        if (actionParameter.size() > 1) {
            throw new MalformedRequest("The 'action' parameter must contain only one value");
        }
        switch (action = (String)actionParameter.iterator().next()) {
            case "search": {
                if (!cacheName.isPresent()) {
                    throw new MalformedRequest("Missing cacheName");
                }
                return new InfinispanSearchRequest(restServer.getSearchOperations(), request, ctx, cacheName.get(), context, parameters);
            }
        }
        throw new MalformedRequest("Invalid action");
    }
}

