/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.dataconversion;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.codehaus.jackson.annotate.JsonTypeInfo;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.jsontype.TypeResolverBuilder;
import org.codehaus.jackson.type.JavaType;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.dataconversion.Transcoder;
import org.infinispan.rest.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class JsonObjectTranscoder
implements Transcoder {
    protected static final Log logger = (Log)LogFactory.getLog(JsonObjectTranscoder.class, Log.class);
    private final ObjectMapper jsonMapper = new ObjectMapper().setDefaultTyping((TypeResolverBuilder)new ObjectMapper.DefaultTypeResolverBuilder(ObjectMapper.DefaultTyping.NON_FINAL){
        {
            this.init(JsonTypeInfo.Id.CLASS, null);
            this.inclusion(JsonTypeInfo.As.PROPERTY);
            this.typeProperty("_type");
        }

        public boolean useForType(JavaType t) {
            return !t.isContainerType() && super.useForType(t);
        }
    });
    private static final Set<MediaType> supportedTypes = new HashSet<MediaType>();

    public JsonObjectTranscoder() {
        supportedTypes.add(MediaType.APPLICATION_JSON);
        supportedTypes.add(MediaType.APPLICATION_OBJECT);
    }

    public Object transcode(Object content, MediaType contentType, MediaType destinationType) {
        if (destinationType.match(MediaType.APPLICATION_JSON)) {
            try {
                return this.jsonMapper.writeValueAsString(content);
            }
            catch (IOException e) {
                throw new CacheException((Throwable)e);
            }
        }
        if (destinationType.match(MediaType.APPLICATION_OBJECT)) {
            try {
                if (content instanceof byte[]) {
                    return this.jsonMapper.readValue((byte[])content, Object.class);
                }
                return this.jsonMapper.readValue((String)content, Object.class);
            }
            catch (IOException e) {
                throw new CacheException((Throwable)e);
            }
        }
        return null;
    }

    public Set<MediaType> getSupportedMediaTypes() {
        return supportedTypes;
    }
}

