/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.operations;

import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.util.Date;
import java.util.Optional;
import java.util.OptionalInt;
import org.infinispan.AdvancedCache;
import org.infinispan.CacheSet;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.metadata.Metadata;
import org.infinispan.rest.CacheControl;
import org.infinispan.rest.InfinispanCacheAPIRequest;
import org.infinispan.rest.InfinispanCacheResponse;
import org.infinispan.rest.InfinispanErrorResponse;
import org.infinispan.rest.InfinispanResponse;
import org.infinispan.rest.RestResponseException;
import org.infinispan.rest.cachemanager.RestCacheManager;
import org.infinispan.rest.configuration.RestServerConfiguration;
import org.infinispan.rest.operations.AbstractOperations;
import org.infinispan.rest.operations.CacheOperationsHelper;
import org.infinispan.rest.operations.exceptions.NoDataFoundException;
import org.infinispan.rest.operations.exceptions.NoKeyException;
import org.infinispan.rest.operations.mediatypes.Charset;
import org.infinispan.rest.operations.mediatypes.EntrySetFormatter;
import org.infinispan.rest.operations.mediatypes.OutputPrinter;

public class CacheOperations
extends AbstractOperations {
    public CacheOperations(RestServerConfiguration configuration, RestCacheManager<Object> cacheManager) {
        super(configuration, cacheManager);
    }

    public InfinispanResponse getCacheValues(InfinispanCacheAPIRequest request) throws RestResponseException {
        try {
            String cacheName = request.getCacheName().get();
            MediaType contentType = this.getMediaType(request);
            AdvancedCache cache = this.restCacheManager.getCache(cacheName, contentType);
            CacheSet keys = cache.keySet();
            MediaType mediaType = this.getMediaType(request);
            Charset charset = request.getAcceptContentType().map(Charset::fromMediaType).orElse(Charset.UTF8);
            if (mediaType == null) {
                mediaType = MediaType.TEXT_PLAIN;
            }
            InfinispanCacheResponse response = InfinispanCacheResponse.inReplyTo(request);
            response.contentType(mediaType.toString());
            response.charset(charset);
            response.cacheControl(CacheControl.noCache());
            OutputPrinter outputPrinter = EntrySetFormatter.forMediaType(mediaType);
            response.contentAsBytes(outputPrinter.print(cacheName, keys, charset));
            return response;
        }
        catch (CacheException cacheException) {
            throw this.createResponseException(cacheException);
        }
    }

    public InfinispanResponse getCacheValue(InfinispanCacheAPIRequest request) throws RestResponseException {
        try {
            String cacheName = request.getCacheName().get();
            MediaType mediaType = this.getMediaType(request);
            String key = request.getKey().orElseThrow(NoKeyException::new);
            String cacheControl = request.getCacheControl().orElse("");
            boolean returnBody = request.getRawRequest().method() == HttpMethod.GET;
            CacheEntry entry = this.restCacheManager.getInternalEntry(cacheName, key, mediaType);
            InfinispanCacheResponse response = InfinispanCacheResponse.inReplyTo(request);
            response.status(HttpResponseStatus.NOT_FOUND);
            if (entry instanceof InternalCacheEntry) {
                OptionalInt minFreshSeconds;
                InternalCacheEntry ice = (InternalCacheEntry)entry;
                Date lastMod = CacheOperationsHelper.lastModified(ice);
                Date expires = ice.canExpire() ? new Date(ice.getExpiryTime()) : null;
                if (CacheOperationsHelper.entryFreshEnough(expires, minFreshSeconds = CacheOperationsHelper.minFresh(cacheControl))) {
                    Metadata meta = ice.getMetadata();
                    String etag = this.calcETAG(ice.getValue());
                    if (CacheOperationsHelper.ifNoneMatchMathesEtag(request.getEtagIfNoneMatch(), etag)) {
                        response.status(HttpResponseStatus.NOT_MODIFIED);
                        return response;
                    }
                    if (CacheOperationsHelper.ifMatchDoesntMatchEtag(request.getEtagIfMatch(), etag)) {
                        response.status(HttpResponseStatus.PRECONDITION_FAILED);
                        return response;
                    }
                    if (CacheOperationsHelper.ifUnmodifiedIsBeforeEntryModificationDate(request.getEtagIfUnmodifiedSince(), lastMod)) {
                        response.status(HttpResponseStatus.PRECONDITION_FAILED);
                        return response;
                    }
                    if (CacheOperationsHelper.ifModifiedIsAfterEntryModificationDate(request.getEtagIfModifiedSince(), lastMod)) {
                        response.status(HttpResponseStatus.NOT_MODIFIED);
                        return response;
                    }
                    Object value = ice.getValue();
                    MediaType configuredMediaType = this.restCacheManager.getConfiguredMediaType(cacheName);
                    this.writeValue(value, mediaType, configuredMediaType, response, returnBody);
                    response.status(HttpResponseStatus.OK);
                    response.lastModified(lastMod);
                    response.etag(etag);
                    response.cacheControl(CacheOperationsHelper.calcCacheControl(expires));
                    response.expires(expires);
                    response.timeToLive(meta.lifespan());
                    response.maxIdle(meta.maxIdle());
                    if (request.getExtended().isPresent() && CacheOperationsHelper.supportsExtendedHeaders(this.restServerConfiguration, request.getExtended().get())) {
                        response.clusterPrimaryOwner(this.restCacheManager.getPrimaryOwner(cacheName, key, mediaType));
                        response.clusterNodeName(this.restCacheManager.getNodeName());
                        response.clusterServerAddress(this.restCacheManager.getServerAddress());
                    }
                }
            }
            return response;
        }
        catch (CacheException cacheException) {
            throw this.createResponseException(cacheException);
        }
    }

    private void writeValue(Object value, MediaType requested, MediaType configuredMediaType, InfinispanResponse response, boolean returnBody) {
        String returnType;
        if (value instanceof byte[]) {
            if (returnBody) {
                response.contentAsBytes((byte[])value);
            }
            returnType = "application/octet-stream";
        } else {
            if (returnBody) {
                response.contentAsText(value.toString());
            }
            returnType = "text/plain";
        }
        if (requested != null) {
            response.contentType(requested.toString());
        } else if (configuredMediaType == null) {
            response.contentType(returnType);
        } else {
            response.contentType(configuredMediaType.toString());
        }
    }

    public InfinispanResponse deleteCacheValue(InfinispanCacheAPIRequest request) throws RestResponseException {
        try {
            String cacheName = request.getCacheName().get();
            String key = request.getKey().orElseThrow(NoKeyException::new);
            Optional<Boolean> useAsync = request.getUseAsync();
            MediaType contentType = request.getContentType().map(MediaType::fromString).orElse(null);
            CacheEntry entry = this.restCacheManager.getInternalEntry(cacheName, key, null);
            InfinispanCacheResponse response = InfinispanCacheResponse.inReplyTo(request);
            response.status(HttpResponseStatus.NOT_FOUND);
            if (entry instanceof InternalCacheEntry) {
                InternalCacheEntry ice = (InternalCacheEntry)entry;
                String etag = this.calcETAG(ice.getValue());
                Optional<String> clientEtag = request.getEtagIfNoneMatch();
                if (clientEtag.map(t -> t.equals(etag)).orElse(true).booleanValue()) {
                    response.status(HttpResponseStatus.OK);
                    if (useAsync.isPresent() && useAsync.get().booleanValue()) {
                        this.restCacheManager.getCache(cacheName, contentType).removeAsync((Object)key);
                    } else {
                        this.restCacheManager.getCache(cacheName, null).remove((Object)key);
                    }
                } else {
                    response.status(HttpResponseStatus.PRECONDITION_FAILED);
                }
            }
            return response;
        }
        catch (CacheException cacheException) {
            throw this.createResponseException(cacheException);
        }
    }

    public InfinispanResponse clearEntireCache(InfinispanCacheAPIRequest request) throws RestResponseException {
        try {
            String cacheName = request.getCacheName().get();
            Optional<Boolean> useAsync = request.getUseAsync();
            InfinispanCacheResponse response = InfinispanCacheResponse.inReplyTo(request);
            response.status(HttpResponseStatus.OK);
            if (useAsync.isPresent() && useAsync.get().booleanValue()) {
                this.restCacheManager.getCache(cacheName, null).clearAsync();
            } else {
                this.restCacheManager.getCache(cacheName, null).clear();
            }
            return response;
        }
        catch (CacheException cacheException) {
            throw this.createResponseException(cacheException);
        }
    }

    public InfinispanResponse putValueToCache(InfinispanCacheAPIRequest request) throws RestResponseException {
        try {
            String cacheName = request.getCacheName().get();
            MediaType contentType = request.getContentType().map(MediaType::fromString).orElse(null);
            AdvancedCache cache = this.restCacheManager.getCache(cacheName, contentType);
            String key = request.getKey().orElseThrow(NoKeyException::new);
            if (HttpMethod.POST.equals((Object)request.getRawRequest().method()) && cache.containsKey((Object)key)) {
                return InfinispanErrorResponse.asError(request, HttpResponseStatus.CONFLICT, "An entry already exists");
            }
            InfinispanCacheResponse response = InfinispanCacheResponse.inReplyTo(request);
            Optional<Object> oldData = Optional.empty();
            byte[] data = request.data().orElseThrow(NoDataFoundException::new);
            CacheEntry entry = this.restCacheManager.getInternalEntry(cacheName, key, true, contentType);
            if (entry instanceof InternalCacheEntry) {
                InternalCacheEntry ice = (InternalCacheEntry)entry;
                oldData = Optional.of(entry.getValue());
                Optional<String> clientEtag = request.getEtagIfNoneMatch();
                if (clientEtag.isPresent()) {
                    String etag = this.calcETAG(ice.getValue());
                    if (clientEtag.get().equals(etag)) {
                        response.status(HttpResponseStatus.NOT_MODIFIED);
                        return response;
                    }
                }
            }
            boolean useAsync = request.getUseAsync().orElse(false);
            Optional<Long> ttl = request.getTimeToLiveSeconds();
            Optional<Long> idle = request.getMaxIdleTimeSeconds();
            return this.putInCache(response, useAsync, cache, key, data, ttl, idle, oldData);
        }
        catch (IllegalStateException | CacheException e) {
            throw this.createResponseException(e);
        }
    }

    private <V> String calcETAG(V value) {
        return String.valueOf(hashFunc.hash(value));
    }

    private InfinispanResponse putInCache(InfinispanCacheResponse response, boolean useAsync, AdvancedCache<String, Object> cache, String key, byte[] data, Optional<Long> ttl, Optional<Long> idleTime, Optional<Object> prevCond) {
        Metadata metadata = CacheOperationsHelper.createMetadata(cache.getCacheConfiguration(), ttl, idleTime);
        if (prevCond.isPresent()) {
            boolean replaced = cache.replace((Object)key, prevCond.get(), (Object)data, metadata);
            if (!replaced) {
                response.status(HttpResponseStatus.PRECONDITION_FAILED);
            }
        } else if (useAsync) {
            cache.putAsync((Object)key, (Object)data, metadata);
        } else {
            cache.put((Object)key, (Object)data, metadata);
        }
        response.etag(this.calcETAG(data));
        return response;
    }
}

