/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest;

import java.util.Base64;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.api.ContentResponse;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpMethod;
import org.infinispan.rest.assertion.ResponseAssertion;
import org.infinispan.rest.authentication.Authenticator;
import org.infinispan.rest.authentication.SecurityDomain;
import org.infinispan.rest.authentication.impl.BasicAuthenticator;
import org.infinispan.rest.helper.RestServerHelper;
import org.infinispan.server.core.security.simple.SimpleUserPrincipal;
import org.infinispan.test.AbstractInfinispanTest;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.internal.stubbing.answers.ThrowsExceptionClass;
import org.mockito.stubbing.Answer;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.AfterSuite;
import org.testng.annotations.BeforeSuite;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="rest.AuthenticationTest")
public class AuthenticationTest
extends AbstractInfinispanTest {
    private HttpClient client;
    private RestServerHelper restServer;

    @BeforeSuite
    public void beforeSuite() throws Exception {
        this.client = new HttpClient();
        this.client.start();
    }

    @AfterSuite
    public void afterSuite() throws Exception {
        this.restServer.stop();
        this.client.stop();
    }

    @AfterMethod
    public void afterMethod() throws Exception {
        this.restServer.clear();
        if (this.restServer != null) {
            this.restServer.stop();
        }
    }

    @Test
    public void shouldAuthenticateWhenProvidingProperCredentials() throws Exception {
        SecurityDomain securityDomainMock = (SecurityDomain)Mockito.mock(SecurityDomain.class, (Answer)new ThrowsExceptionClass(SecurityException.class));
        SimpleUserPrincipal userPrincipal = new SimpleUserPrincipal("test");
        ((SecurityDomain)Mockito.doReturn((Object)userPrincipal).when((Object)securityDomainMock)).authenticate((String)Matchers.eq((Object)"test"), (String)Matchers.eq((Object)"test"));
        BasicAuthenticator basicAuthenticator = new BasicAuthenticator(securityDomainMock, "ApplicationRealm");
        this.restServer = RestServerHelper.defaultRestServer(new String[0]).withAuthenticator((Authenticator)basicAuthenticator).start();
        ContentResponse response = this.client.newRequest(String.format("http://localhost:%d/rest/%s/%s", this.restServer.getPort(), "default", "test")).method(HttpMethod.HEAD).header(HttpHeader.AUTHORIZATION, "Basic " + Base64.getEncoder().encodeToString("test:test".getBytes())).send();
        ResponseAssertion.assertThat(response).isNotFound();
    }

    @Test
    public void shouldRejectNotValidAuthorizationString() throws Exception {
        SecurityDomain securityDomainMock = (SecurityDomain)Mockito.mock(SecurityDomain.class);
        BasicAuthenticator basicAuthenticator = new BasicAuthenticator(securityDomainMock, "ApplicationRealm");
        this.restServer = RestServerHelper.defaultRestServer(new String[0]).withAuthenticator((Authenticator)basicAuthenticator).start();
        ContentResponse response = this.client.newRequest(String.format("http://localhost:%d/rest/%s/%s", this.restServer.getPort(), "default", "test")).method(HttpMethod.GET).header(HttpHeader.AUTHORIZATION, "Invalid string").send();
        ResponseAssertion.assertThat(response).isUnauthorized();
    }

    @Test
    public void shouldRejectNoAuthentication() throws Exception {
        SecurityDomain securityDomainMock = (SecurityDomain)Mockito.mock(SecurityDomain.class);
        BasicAuthenticator basicAuthenticator = new BasicAuthenticator(securityDomainMock, "ApplicationRealm");
        this.restServer = RestServerHelper.defaultRestServer(new String[0]).withAuthenticator((Authenticator)basicAuthenticator).start();
        ContentResponse response = this.client.newRequest(String.format("http://localhost:%d/rest/%s/%s", this.restServer.getPort(), "default", "test")).method(HttpMethod.GET).send();
        ResponseAssertion.assertThat(response).isUnauthorized();
    }
}

