/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.dataconversion;

import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.rest.dataconversion.JsonTranscoder;
import org.infinispan.test.data.Address;
import org.infinispan.test.data.Person;
import org.infinispan.test.dataconversion.AbstractTranscoderTest;
import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="rest.JsonObjectTranscoderTest")
public class JsonObjectTranscoderTest
extends AbstractTranscoderTest {
    protected Person dataSrc;

    @BeforeTest
    public void setUp() {
        this.dataSrc = new Person("joe");
        Address address = new Address();
        address.setCity("London");
        this.dataSrc.setAddress(address);
        this.transcoder = new JsonTranscoder();
        this.supportedMediaTypes = this.transcoder.getSupportedMediaTypes();
    }

    public void testTranscoderTranscode() throws Exception {
        MediaType jsonMediaType = MediaType.APPLICATION_JSON;
        MediaType personMediaType = MediaType.fromString((String)"application/x-java-object;type=org.infinispan.test.data.Person");
        Object result = this.transcoder.transcode((Object)this.dataSrc, personMediaType, jsonMediaType);
        Assert.assertEquals((Object)result, (Object)String.format("{\"_type\":\"%s\",\"name\":\"%s\",\"address\":{\"_type\":\"%s\",\"street\":null,\"city\":\"%s\",\"zip\":0}}", Person.class.getName(), "joe", Address.class.getName(), "London"));
        Object fromJson = this.transcoder.transcode(result, jsonMediaType, personMediaType);
        Assert.assertEquals((Object)fromJson, (Object)this.dataSrc);
    }
}

