/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.dataconversion;

import org.infinispan.commons.dataconversion.Encoder;
import org.infinispan.commons.dataconversion.GenericJbossMarshallerEncoder;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.dataconversion.OneToManyTranscoder;
import org.infinispan.commons.dataconversion.StandardConversions;
import org.infinispan.marshall.core.EncoderRegistry;
import org.infinispan.rest.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class JBossMarshallingTranscoder
extends OneToManyTranscoder {
    protected static final Log logger = (Log)LogFactory.getLog(JBossMarshallingTranscoder.class, Log.class);
    private final Encoder encoder;

    public JBossMarshallingTranscoder(EncoderRegistry encoderRegistry) {
        super(MediaType.APPLICATION_JBOSS_MARSHALLING, new MediaType[]{MediaType.APPLICATION_OCTET_STREAM, MediaType.TEXT_PLAIN, MediaType.APPLICATION_OBJECT});
        this.encoder = encoderRegistry.getEncoder(GenericJbossMarshallerEncoder.class, null);
    }

    public Object transcode(Object content, MediaType contentType, MediaType destinationType) {
        if (destinationType.match(MediaType.APPLICATION_JBOSS_MARSHALLING)) {
            Object decoded = content;
            if (contentType.match(MediaType.APPLICATION_OBJECT)) {
                decoded = StandardConversions.decodeObjectContent((Object)content, (MediaType)contentType);
            }
            if (contentType.match(MediaType.APPLICATION_OCTET_STREAM)) {
                decoded = StandardConversions.decodeOctetStream((Object)content, (MediaType)destinationType);
            }
            return this.encoder.toStorage(decoded);
        }
        if (destinationType.match(MediaType.APPLICATION_OCTET_STREAM)) {
            return this.encoder.fromStorage(content);
        }
        if (destinationType.match(MediaType.TEXT_PLAIN)) {
            String fromStorage = this.encoder.fromStorage(content).toString();
            return fromStorage.getBytes(destinationType.getCharset());
        }
        throw logger.unsupportedContent(content);
    }
}

