/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.configuration;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.cors.CorsConfig;
import io.netty.handler.codec.http.cors.CorsConfigBuilder;
import java.util.ArrayList;
import java.util.List;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.rest.configuration.ExtendedHeaders;
import org.infinispan.rest.configuration.RestServerConfiguration;
import org.infinispan.rest.logging.Log;
import org.infinispan.server.core.configuration.ProtocolServerConfigurationBuilder;
import org.infinispan.util.logging.LogFactory;

public class RestServerConfigurationBuilder
extends ProtocolServerConfigurationBuilder<RestServerConfiguration, RestServerConfigurationBuilder>
implements Builder<RestServerConfiguration> {
    private static final Log logger = (Log)LogFactory.getLog(RestServerConfigurationBuilder.class, Log.class);
    public static final String DEFAULT_CONTEXT_PATH = "rest";
    public static final int DEFAULT_PORT = 8080;
    public static final String DEFAULT_NAME = "rest";
    public static final int DEFAULT_MAX_CONTENT_LENGTH = 0xA00000;
    public static final int DEFAULT_COMPRESS_LEVEL = 6;
    private ExtendedHeaders extendedHeaders = ExtendedHeaders.ON_DEMAND;
    private List<CorsConfig> corsRules = new ArrayList<CorsConfig>(3);
    private String contextPath = "rest";
    private int maxContentLength = 0xA00000;
    private int compressionLevel = 6;

    public RestServerConfigurationBuilder() {
        super(8080);
        this.name("rest");
    }

    public RestServerConfigurationBuilder extendedHeaders(ExtendedHeaders extendedHeaders) {
        this.extendedHeaders = extendedHeaders;
        return this;
    }

    public RestServerConfigurationBuilder contextPath(String contextPath) {
        this.contextPath = contextPath;
        return this;
    }

    public RestServerConfigurationBuilder maxContentLength(int maxContentLength) {
        this.maxContentLength = maxContentLength;
        return this;
    }

    public RestServerConfigurationBuilder compressionLevel(int compressLevel) {
        this.compressionLevel = compressLevel;
        return this;
    }

    public RestServerConfigurationBuilder corsAllowForLocalhost(String scheme, int port) {
        String local1 = scheme + "://127.0.0.1:" + port;
        String local2 = scheme + "://localhost:" + port;
        String local3 = scheme + "://[::1]:" + port;
        CorsConfig corsConfig = CorsConfigBuilder.forOrigins((String[])new String[]{local1, local2, local3}).allowCredentials().allowedRequestMethods(new HttpMethod[]{HttpMethod.GET, HttpMethod.POST, HttpMethod.PUT, HttpMethod.DELETE, HttpMethod.HEAD, HttpMethod.OPTIONS}).allowedRequestHeaders(new CharSequence[]{HttpHeaderNames.CONTENT_TYPE}).build();
        this.corsRules.add(corsConfig);
        return this;
    }

    public RestServerConfigurationBuilder addAll(List<CorsConfig> corsConfig) {
        this.corsRules.addAll(corsConfig);
        return this;
    }

    public void validate() {
        if (this.compressionLevel < 0 || this.compressionLevel > 9) {
            throw logger.illegalCompressionLevel(this.compressionLevel);
        }
    }

    public RestServerConfiguration create() {
        return new RestServerConfiguration(this.defaultCacheName, this.name, this.extendedHeaders, this.host, this.port, this.ignoredCaches, this.ssl.create(), this.startTransport, this.contextPath, this.adminOperationsHandler, this.maxContentLength, this.corsRules, this.compressionLevel);
    }

    public Builder<?> read(RestServerConfiguration template) {
        this.extendedHeaders = template.extendedHeaders();
        this.host = template.host();
        this.port = template.port();
        this.maxContentLength = template.maxContentLength();
        this.corsRules = template.getCorsRules();
        this.compressionLevel = template.getCompressionLevel();
        return this;
    }

    public RestServerConfiguration build() {
        return this.build(true);
    }

    public RestServerConfiguration build(boolean validate) {
        if (validate) {
            this.validate();
        }
        return this.create();
    }

    public RestServerConfigurationBuilder self() {
        return this;
    }

    public RestServerConfigurationBuilder defaultCacheName(String defaultCacheName) {
        throw logger.unsupportedConfigurationOption();
    }

    public RestServerConfigurationBuilder idleTimeout(int idleTimeout) {
        throw logger.unsupportedConfigurationOption();
    }

    public RestServerConfigurationBuilder tcpNoDelay(boolean tcpNoDelay) {
        throw logger.unsupportedConfigurationOption();
    }

    public RestServerConfigurationBuilder recvBufSize(int recvBufSize) {
        throw logger.unsupportedConfigurationOption();
    }

    public RestServerConfigurationBuilder sendBufSize(int sendBufSize) {
        throw logger.unsupportedConfigurationOption();
    }

    public RestServerConfigurationBuilder workerThreads(int workerThreads) {
        throw logger.unsupportedConfigurationOption();
    }
}

