/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.search;

import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.IOException;
import java.util.Optional;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.map.ObjectMapper;
import org.infinispan.commons.CacheException;
import org.infinispan.rest.InfinispanRequest;
import org.infinispan.rest.InfinispanResponse;
import org.infinispan.rest.search.InfinispanSearchRequest;
import org.infinispan.rest.search.ProjectedResult;
import org.infinispan.rest.search.QueryErrorResult;
import org.infinispan.rest.search.QueryResponse;
import org.infinispan.rest.search.QueryResult;

public class InfinispanSearchResponse
extends InfinispanResponse {
    private static final ObjectMapper mapper = new ObjectMapper();

    private InfinispanSearchResponse(InfinispanRequest request) {
        super(Optional.of(request));
        this.contentType("application/json");
    }

    public static InfinispanSearchResponse inReplyTo(InfinispanSearchRequest infinispanSearchRequest) {
        return new InfinispanSearchResponse(infinispanSearchRequest);
    }

    public static InfinispanSearchResponse badRequest(InfinispanSearchRequest infinispanSearchRequest, String message, String cause) {
        InfinispanSearchResponse searchResponse = new InfinispanSearchResponse(infinispanSearchRequest);
        searchResponse.status(HttpResponseStatus.BAD_REQUEST);
        searchResponse.setQueryResult(new QueryErrorResult(message, cause));
        return searchResponse;
    }

    public void setQueryResult(QueryResponse queryResult) {
        try {
            byte[] bytes = mapper.writerWithDefaultPrettyPrinter().writeValueAsBytes((Object)queryResult);
            this.contentAsBytes(bytes);
        }
        catch (IOException e) {
            throw new CacheException("Invalid query result");
        }
    }

    static {
        mapper.registerSubtypes(new Class[]{ProjectedResult.class, QueryResult.class});
        mapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_CONTROL_CHARS, true);
    }
}

