/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.http2;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpScheme;
import io.netty.handler.codec.http2.HttpConversionUtil;
import io.netty.handler.ssl.SslContext;
import io.netty.util.internal.PlatformDependent;
import java.util.AbstractMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.infinispan.rest.http2.CommunicationHandler;

public class Http2ResponseHandler
extends SimpleChannelInboundHandler<FullHttpResponse>
implements CommunicationHandler {
    private final TimeUnit TIMEOUT_UNITS = TimeUnit.MINUTES;
    private final int TIMEOUT = 15;
    private final Map<Integer, Map.Entry<ChannelFuture, ChannelPromise>> streamidPromiseMap;
    private final Queue<FullHttpResponse> responses = new LinkedBlockingQueue<FullHttpResponse>();
    private final AtomicInteger streamCounter = new AtomicInteger(3);

    public Http2ResponseHandler() {
        this.streamidPromiseMap = PlatformDependent.newConcurrentHashMap();
    }

    public Map.Entry<ChannelFuture, ChannelPromise> put(int streamId, ChannelFuture writeFuture, ChannelPromise promise) {
        return this.streamidPromiseMap.put(streamId, new AbstractMap.SimpleEntry<ChannelFuture, ChannelPromise>(writeFuture, promise));
    }

    private void awaitResponses(long timeout, TimeUnit unit) {
        Iterator<Map.Entry<Integer, Map.Entry<ChannelFuture, ChannelPromise>>> itr = this.streamidPromiseMap.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry<Integer, Map.Entry<ChannelFuture, ChannelPromise>> entry = itr.next();
            ChannelFuture writeFuture = entry.getValue().getKey();
            if (!writeFuture.awaitUninterruptibly(timeout, unit)) {
                throw new IllegalStateException("Timed out waiting to write for stream id " + entry.getKey());
            }
            if (!writeFuture.isSuccess()) {
                throw new RuntimeException(writeFuture.cause());
            }
            ChannelPromise promise = entry.getValue().getValue();
            if (!promise.awaitUninterruptibly(timeout, unit)) {
                throw new IllegalStateException("Timed out waiting for response on stream id " + entry.getKey());
            }
            if (!promise.isSuccess()) {
                throw new RuntimeException(promise.cause());
            }
            itr.remove();
        }
    }

    protected void channelRead0(ChannelHandlerContext ctx, FullHttpResponse msg) throws Exception {
        Integer streamId = msg.headers().getInt((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_ID.text());
        if (streamId == null) {
            throw new IllegalArgumentException("Http2ResponseHandler unexpected message received: " + msg);
        }
        Map.Entry<ChannelFuture, ChannelPromise> entry = this.streamidPromiseMap.get(streamId);
        if (entry == null) {
            throw new IllegalArgumentException("Message received for unknown stream id " + streamId);
        }
        this.responses.add(msg);
        entry.getValue().setSuccess();
    }

    @Override
    public Queue<FullHttpResponse> getResponses() {
        this.awaitResponses(15L, this.TIMEOUT_UNITS);
        return this.responses;
    }

    @Override
    public void sendRequest(FullHttpRequest request, SslContext sslContext, Channel channel) {
        int streamId = this.streamCounter.getAndAdd(2);
        HttpScheme scheme = sslContext != null ? HttpScheme.HTTPS : HttpScheme.HTTP;
        request.headers().add((CharSequence)HttpConversionUtil.ExtensionHeaderNames.SCHEME.text(), (Object)scheme.name());
        request.headers().add((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_ID.text(), (Object)streamId);
        this.put(streamId, channel.write((Object)request), channel.newPromise());
        channel.flush();
    }
}

