/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.http2;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpScheme;
import io.netty.handler.codec.http2.HttpConversionUtil;
import io.netty.handler.ssl.SslContext;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.Semaphore;
import org.infinispan.rest.http2.CommunicationHandler;

public class Http11ResponseHandler
extends SimpleChannelInboundHandler<FullHttpResponse>
implements CommunicationHandler {
    private final Queue<FullHttpResponse> responses = new LinkedBlockingQueue<FullHttpResponse>();
    private final Semaphore semaphore = new Semaphore(1);

    protected void channelRead0(ChannelHandlerContext ctx, FullHttpResponse msg) throws Exception {
        this.responses.add(msg);
        this.semaphore.release();
        System.out.println("Released");
    }

    @Override
    public Queue<FullHttpResponse> getResponses() {
        try {
            System.out.println("Getting responses");
            this.semaphore.acquireUninterruptibly();
            Queue<FullHttpResponse> queue = this.responses;
            return queue;
        }
        finally {
            this.semaphore.release();
        }
    }

    @Override
    public void sendRequest(FullHttpRequest request, SslContext sslContext, Channel channel) {
        HttpScheme scheme = sslContext != null ? HttpScheme.HTTPS : HttpScheme.HTTP;
        request.headers().set((CharSequence)HttpConversionUtil.ExtensionHeaderNames.SCHEME.text(), (Object)scheme.name());
        request.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.CLOSE);
        request.headers().set((CharSequence)HttpHeaderNames.ACCEPT_ENCODING, (Object)HttpHeaderValues.TEXT_PLAIN);
        channel.writeAndFlush((Object)request);
        this.semaphore.acquireUninterruptibly();
        System.out.println("Acquired");
    }
}

