/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.search;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.infinispan.query.dsl.IndexedQueryMode;
import org.infinispan.query.remote.json.JsonQueryReader;
import org.infinispan.query.remote.json.JsonQueryRequest;
import org.infinispan.rest.InfinispanErrorResponse;
import org.infinispan.rest.InfinispanRequest;
import org.infinispan.rest.InfinispanResponse;
import org.infinispan.rest.operations.SearchOperations;
import org.infinispan.rest.operations.exceptions.NoCacheFoundException;
import org.infinispan.rest.operations.exceptions.NoDataFoundException;
import org.infinispan.rest.search.InfinispanSearchResponse;

public class InfinispanSearchRequest
extends InfinispanRequest {
    private final SearchOperations searchOperations;

    public InfinispanSearchRequest(SearchOperations searchOperations, FullHttpRequest request, ChannelHandlerContext ctx, String cacheName, String context, Map<String, List<String>> parameters) {
        super(request, ctx, cacheName, context, parameters);
        this.searchOperations = searchOperations;
    }

    @Override
    protected InfinispanResponse execute() {
        Optional<String> cacheName = this.getCacheName();
        if (!cacheName.isPresent()) {
            throw new NoCacheFoundException("Cache name must be provided");
        }
        try {
            JsonQueryRequest jsonQueryRequest;
            switch (this.request.method().name()) {
                case "GET": 
                case "HEAD": 
                case "OPTIONS": {
                    jsonQueryRequest = this.getQueryFromString();
                    break;
                }
                case "POST": 
                case "PUT": {
                    jsonQueryRequest = this.getQueryFromJSON();
                    break;
                }
                default: {
                    return InfinispanErrorResponse.asError(this, HttpResponseStatus.NOT_IMPLEMENTED, null);
                }
            }
            String queryString = jsonQueryRequest.getQuery();
            if (queryString == null || queryString.isEmpty()) {
                return InfinispanSearchResponse.badRequest(this, "Invalid search request, missing 'query' parameter", null);
            }
            return this.searchOperations.search(cacheName.get(), jsonQueryRequest, this);
        }
        catch (IOException e) {
            return InfinispanSearchResponse.badRequest(this, "Invalid search request", e.getMessage());
        }
    }

    private JsonQueryRequest getQueryFromString() {
        String queryString = this.getParameterValue("query");
        String strOffset = this.getParameterValue("offset");
        String queryMode = this.getParameterValue("query_mode");
        String strMaxResults = this.getParameterValue("max_results");
        Integer offset = strOffset != null ? Integer.valueOf(strOffset) : null;
        Integer maxResults = strMaxResults != null ? Integer.valueOf(strMaxResults) : null;
        IndexedQueryMode qm = queryMode == null ? IndexedQueryMode.FETCH : IndexedQueryMode.valueOf((String)queryMode);
        return new JsonQueryRequest(queryString, offset, maxResults, qm);
    }

    private JsonQueryRequest getQueryFromJSON() throws IOException {
        byte[] data = this.data().orElseThrow(NoDataFoundException::new);
        return JsonQueryReader.getQueryFromJSON((byte[])data);
    }
}

