/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.rest.helper;

import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.internal.PrivateGlobalConfigurationBuilder;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.registry.InternalCacheRegistry;
import org.infinispan.rest.RestServer;
import org.infinispan.rest.TestClass;
import org.infinispan.rest.authentication.Authenticator;
import org.infinispan.rest.authentication.impl.VoidAuthenticator;
import org.infinispan.rest.configuration.RestServerConfigurationBuilder;
import org.infinispan.server.core.configuration.ProtocolServerConfiguration;

public class RestServerHelper {
    private final EmbeddedCacheManager cacheManager;
    private final RestServer restServer = new RestServer();
    private final RestServerConfigurationBuilder restServerConfigurationBuilder = new RestServerConfigurationBuilder();
    private Authenticator authenticator = new VoidAuthenticator();

    public RestServerHelper(EmbeddedCacheManager cacheManager) {
        this.cacheManager = cacheManager;
        ((RestServerConfigurationBuilder)((RestServerConfigurationBuilder)this.restServerConfigurationBuilder.host("localhost")).corsAllowForLocalhost("http", 80).port(0)).maxContentLength(1000000);
    }

    public static RestServerHelper defaultRestServer(String ... cachesDefined) {
        return RestServerHelper.defaultRestServer(new ConfigurationBuilder(), cachesDefined);
    }

    public static RestServerHelper defaultRestServer(ConfigurationBuilder configuration, String ... cachesDefined) {
        GlobalConfigurationBuilder globalConfigurationBuilder = new GlobalConfigurationBuilder();
        ((PrivateGlobalConfigurationBuilder)globalConfigurationBuilder.addModule(PrivateGlobalConfigurationBuilder.class)).serverMode(true);
        GlobalConfigurationBuilder globalConfiguration = globalConfigurationBuilder.nonClusteredDefault();
        DefaultCacheManager cacheManager = new DefaultCacheManager(globalConfiguration.build(), configuration.build());
        cacheManager.getClassWhiteList().addClasses(new Class[]{TestClass.class});
        for (String cacheConfiguration : cachesDefined) {
            cacheManager.defineConfiguration(cacheConfiguration, configuration.build());
        }
        return new RestServerHelper((EmbeddedCacheManager)cacheManager);
    }

    public RestServerHelper withAuthenticator(Authenticator authenticator) {
        this.authenticator = authenticator;
        return this;
    }

    public void defineCache(String cacheName, ConfigurationBuilder configurationBuilder) {
        this.cacheManager.defineConfiguration(cacheName, configurationBuilder.build());
    }

    public RestServerHelper start(String name) {
        this.restServerConfigurationBuilder.name(name);
        this.restServer.setAuthenticator(this.authenticator);
        this.restServer.start((ProtocolServerConfiguration)this.restServerConfigurationBuilder.build(), this.cacheManager);
        return this;
    }

    public void clear() {
        InternalCacheRegistry registry = (InternalCacheRegistry)this.cacheManager.getGlobalComponentRegistry().getComponent(InternalCacheRegistry.class);
        this.cacheManager.getCacheNames().stream().filter(cacheName -> !registry.isInternalCache(cacheName)).forEach(cacheName -> this.cacheManager.getCache(cacheName).getAdvancedCache().getDataContainer().clear());
    }

    public void stop() {
        this.restServer.stop();
        this.cacheManager.stop();
    }

    public int getPort() {
        return this.restServer.getPort();
    }

    public EmbeddedCacheManager getCacheManager() {
        return this.cacheManager;
    }

    public RestServerHelper withKeyStore(String keyStorePath, String secret, String type) {
        this.restServerConfigurationBuilder.ssl().enable();
        this.restServerConfigurationBuilder.ssl().keyStoreFileName(keyStorePath).keyStorePassword(secret.toCharArray()).keyStoreType(type);
        return this;
    }

    public RestServerHelper withTrustStore(String trustStorePath, String secret, String type) {
        this.restServerConfigurationBuilder.ssl().enable();
        this.restServerConfigurationBuilder.ssl().trustStoreFileName(trustStorePath).trustStorePassword(secret.toCharArray()).trustStoreType(type);
        return this;
    }

    public RestServerHelper withClientAuth() {
        this.restServerConfigurationBuilder.ssl().enable();
        this.restServerConfigurationBuilder.ssl().requireClientAuth(true);
        return this;
    }

    public String getHost() {
        return this.restServer.getHost();
    }

    public void ignoreCache(String cacheName) {
        this.restServer.ignoreCache(cacheName);
    }

    public void unignoreCache(String cacheName) {
        this.restServer.unignore(cacheName);
    }
}

