/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.router.router.impl.singleport;

import io.netty.channel.Channel;
import io.netty.channel.ChannelInboundHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOutboundHandler;
import java.lang.invoke.MethodHandles;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.rest.RestServer;
import org.infinispan.server.core.AbstractProtocolServer;
import org.infinispan.server.core.ProtocolServer;
import org.infinispan.server.core.transport.NettyInitializer;
import org.infinispan.server.core.transport.NettyInitializers;
import org.infinispan.server.core.transport.NettyTransport;
import org.infinispan.server.router.RoutingTable;
import org.infinispan.server.router.configuration.SinglePortRouterConfiguration;
import org.infinispan.server.router.logging.RouterLogger;
import org.infinispan.server.router.router.EndpointRouter;
import org.infinispan.server.router.router.impl.singleport.SinglePortChannelInitializer;
import org.infinispan.server.router.routes.hotrod.HotRodServerRouteDestination;
import org.infinispan.server.router.routes.rest.RestServerRouteDestination;
import org.infinispan.server.router.routes.singleport.SinglePortRouteSource;

public class SinglePortEndpointRouter
extends AbstractProtocolServer<SinglePortRouterConfiguration>
implements EndpointRouter {
    private static final RouterLogger logger = (RouterLogger)LogFactory.getLog(MethodHandles.lookup().lookupClass(), RouterLogger.class);
    private RoutingTable routingTable;

    public SinglePortEndpointRouter(SinglePortRouterConfiguration configuration) {
        super(EndpointRouter.Protocol.SINGLE_PORT.toString());
        this.configuration = configuration;
    }

    @Override
    public void start(RoutingTable routingTable) {
        this.routingTable = routingTable;
        InetSocketAddress address = new InetSocketAddress(((SinglePortRouterConfiguration)this.configuration).host(), ((SinglePortRouterConfiguration)this.configuration).port());
        this.transport = new NettyTransport(address, this.configuration, this.getQualifiedName(), this.cacheManager);
        this.transport.initializeHandler(this.getInitializer());
        this.transport.start();
        logger.restRouterStarted(this.getTransport().getHostName() + ":" + this.getTransport().getPort());
    }

    @Override
    public void stop() {
        super.stop();
    }

    @Override
    public InetAddress getIp() {
        try {
            return InetAddress.getByName(this.getHost());
        }
        catch (UnknownHostException e) {
            throw new IllegalStateException("Unknown host", e);
        }
    }

    public ChannelOutboundHandler getEncoder() {
        return null;
    }

    public ChannelInboundHandler getDecoder() {
        return null;
    }

    public ChannelInitializer<Channel> getInitializer() {
        HashMap<String, ProtocolServer> upgradeServers = new HashMap<String, ProtocolServer>();
        RestServer restServer = this.routingTable.streamRoutes(SinglePortRouteSource.class, RestServerRouteDestination.class).findFirst().map(r -> ((RestServerRouteDestination)r.getRouteDestination()).getRestServer()).orElseThrow(() -> new IllegalStateException("There must be a REST route!"));
        this.routingTable.streamRoutes(SinglePortRouteSource.class, HotRodServerRouteDestination.class).findFirst().ifPresent(r -> upgradeServers.put("HR", (ProtocolServer)((HotRodServerRouteDestination)r.getRouteDestination()).getHotrodServer()));
        SinglePortChannelInitializer restChannelInitializer = new SinglePortChannelInitializer(this, this.transport, restServer, upgradeServers);
        return new NettyInitializers(new NettyInitializer[]{restChannelInitializer});
    }

    @Override
    public EndpointRouter.Protocol getProtocol() {
        return EndpointRouter.Protocol.SINGLE_PORT;
    }
}

