package org.infinispan.server.router.logging;

import java.util.Locale;
import java.lang.IllegalStateException;
import java.io.Serializable;
import javax.annotation.Generated;
import org.jboss.logging.DelegatingBasicLogger;
import java.lang.String;
import org.jboss.logging.Logger;
import java.lang.Exception;
import org.infinispan.server.router.RoutingTable;
import org.jboss.logging.BasicLogger;
import io.netty.util.DomainNameMapping;
import java.util.Arrays;
import java.lang.IllegalArgumentException;


import static org.jboss.logging.Logger.Level.ERROR;
import static org.jboss.logging.Logger.Level.INFO;
import static org.jboss.logging.Logger.Level.DEBUG;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2020-11-30T03:32:03-0500")
public class RouterLogger_$logger extends DelegatingBasicLogger implements RouterLogger, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = RouterLogger_$logger.class.getName();
    public RouterLogger_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void initializedSni(final DomainNameMapping domainNameMapping) {
        super.log.logf(FQCN, DEBUG, null, initializedSni$str(), domainNameMapping);
    }
    private static final String initializedSni = "ISPN014001: Using SNI Handler with domain mapping %s";
    protected String initializedSni$str() {
        return initializedSni;
    }
    private static final String noRouteFound = "ISPN014002: Could not find matching route";
    protected String noRouteFound$str() {
        return noRouteFound;
    }
    @Override
    public final IllegalArgumentException noRouteFound() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), noRouteFound$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void hotRodRouterStarted(final String address) {
        super.log.logf(FQCN, DEBUG, null, hotRodRouterStarted$str(), address);
    }
    private static final String hotRodRouterStarted = "ISPN014003: HotRod EndpointRouter listening on %s";
    protected String hotRodRouterStarted$str() {
        return hotRodRouterStarted;
    }
    @Override
    public final void restRouterStarted(final String address) {
        super.log.logf(FQCN, DEBUG, null, restRouterStarted$str(), address);
    }
    private static final String restRouterStarted = "ISPN014004: REST EndpointRouter listening on %s";
    protected String restRouterStarted$str() {
        return restRouterStarted;
    }
    @Override
    public final void printOutRoutingTable(final RoutingTable routingTable) {
        super.log.logf(FQCN, INFO, null, printOutRoutingTable$str(), routingTable);
    }
    private static final String printOutRoutingTable = "ISPN014005: Routing table: %s";
    protected String printOutRoutingTable$str() {
        return printOutRoutingTable;
    }
    private static final String configurationValidationError = "ISPN014007: Configuration validation error";
    protected String configurationValidationError$str() {
        return configurationValidationError;
    }
    @Override
    public final IllegalStateException configurationValidationError(final Exception e) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), configurationValidationError$str()), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String hotrodRouterStartFailed = "ISPN014008: Unable to start HotRod router";
    protected String hotrodRouterStartFailed$str() {
        return hotrodRouterStartFailed;
    }
    @Override
    public final IllegalStateException hotrodRouterStartFailed(final Exception e) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), hotrodRouterStartFailed$str()), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String restRouterStartFailed = "ISPN014009: Unable to start REST router";
    protected String restRouterStartFailed$str() {
        return restRouterStartFailed;
    }
    @Override
    public final IllegalStateException restRouterStartFailed(final Exception e) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), restRouterStartFailed$str()), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void errorWhileShuttingDown(final Exception e) {
        super.log.logf(FQCN, ERROR, e, errorWhileShuttingDown$str());
    }
    private static final String errorWhileShuttingDown = "ISPN014010: Error while shutting down the router";
    protected String errorWhileShuttingDown$str() {
        return errorWhileShuttingDown;
    }
}
