package org.infinispan.server.router.logging;

import java.util.Locale;
import java.lang.IllegalStateException;
import java.io.Serializable;
import javax.annotation.Generated;
import org.infinispan.server.router.RoutingTable;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import java.util.Arrays;
import java.lang.IllegalArgumentException;
import java.lang.Exception;


import static org.jboss.logging.Logger.Level.ERROR;
import static org.jboss.logging.Logger.Level.INFO;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2021-04-13T14:06:21-0400")
public class RouterLogger_$logger extends DelegatingBasicLogger implements RouterLogger, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = RouterLogger_$logger.class.getName();
    public RouterLogger_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    private static final String noRouteFound = "ISPN014002: Could not find matching route";
    protected String noRouteFound$str() {
        return noRouteFound;
    }
    @Override
    public final IllegalArgumentException noRouteFound() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), noRouteFound$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void printOutRoutingTable(final RoutingTable routingTable) {
        super.log.logf(FQCN, INFO, null, printOutRoutingTable$str(), routingTable);
    }
    private static final String printOutRoutingTable = "ISPN014005: Routing table: %s";
    protected String printOutRoutingTable$str() {
        return printOutRoutingTable;
    }
    private static final String configurationValidationError = "ISPN014007: Configuration validation error";
    protected String configurationValidationError$str() {
        return configurationValidationError;
    }
    @Override
    public final IllegalStateException configurationValidationError(final Exception e) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), configurationValidationError$str()), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String hotrodRouterStartFailed = "ISPN014008: Unable to start HotRod router";
    protected String hotrodRouterStartFailed$str() {
        return hotrodRouterStartFailed;
    }
    @Override
    public final IllegalStateException hotrodRouterStartFailed(final Exception e) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), hotrodRouterStartFailed$str()), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String restRouterStartFailed = "ISPN014009: Unable to start REST router";
    protected String restRouterStartFailed$str() {
        return restRouterStartFailed;
    }
    @Override
    public final IllegalStateException restRouterStartFailed(final Exception e) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), restRouterStartFailed$str()), e);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void errorWhileShuttingDown(final Exception e) {
        super.log.logf(FQCN, ERROR, e, errorWhileShuttingDown$str());
    }
    private static final String errorWhileShuttingDown = "ISPN014010: Error while shutting down the router";
    protected String errorWhileShuttingDown$str() {
        return errorWhileShuttingDown;
    }
}
