/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.router.router.impl.singleport;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerAdapter;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.util.List;
import org.infinispan.server.core.transport.AccessControlFilter;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.router.logging.RouterLogger;

public class HotRodPingDetector
extends ByteToMessageDecoder {
    public static final String NAME = "hotrod-ping-detector";
    private static final byte HOTROD_MAGIC = -96;
    private final HotRodServer hotRodServer;

    public HotRodPingDetector(HotRodServer hotRodServer) {
        this.hotRodServer = hotRodServer;
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) {
        if (in.readableBytes() < 1) {
            return;
        }
        byte b = in.getByte(in.readerIndex());
        if (b == -96) {
            ChannelHandlerAdapter dummyHandler = new ChannelHandlerAdapter(){};
            ctx.pipeline().addAfter(NAME, "dummy", (ChannelHandler)dummyHandler);
            ChannelHandler channelHandler = ctx.pipeline().removeLast();
            while (channelHandler != dummyHandler) {
                channelHandler = ctx.pipeline().removeLast();
            }
            ctx.pipeline().addLast(new ChannelHandler[]{this.hotRodServer.getInitializer()});
            RouterLogger.SERVER.tracef("Detected Hot Rod connection %s", ctx);
        }
        ctx.pipeline().fireUserEventTriggered((Object)AccessControlFilter.EVENT);
        ctx.pipeline().remove((ChannelHandler)this);
    }
}

