/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.router.profiling;

import io.netty.util.internal.logging.InternalLoggerFactory;
import io.netty.util.internal.logging.JdkLoggerFactory;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.commons.test.categories.Profiling;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.router.MultiTenantRouter;
import org.infinispan.server.router.profiling.PerfTestConfiguration;
import org.infinispan.server.router.routes.Route;
import org.infinispan.server.router.routes.RouteDestination;
import org.infinispan.server.router.routes.RouteSource;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.runner.Runner;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.runner.options.OptionsBuilder;

public class RouterPerfTest {
    private static final int MEASUREMENT_ITERATIONS_COUNT = 1;
    private static final int WARMUP_ITERATIONS_COUNT = 1;

    @Test
    @Category(value={Profiling.class})
    public void performRouterBenchmark() throws Exception {
        Options opt = new OptionsBuilder().include(this.getClass().getName() + ".*").mode(Mode.AverageTime).mode(Mode.SingleShotTime).timeUnit(TimeUnit.MILLISECONDS).warmupIterations(1).measurementIterations(1).threads(1).forks(1).shouldFailOnError(true).shouldDoGC(true).build();
        new Runner(opt).run();
    }

    @State(value=Scope.Thread)
    public static class BenchmarkState {
        @Param(value={"org.infinispan.server.router.performance.configuration.SingleServerNoSsl", "org.infinispan.server.router.performance.configuration.SingleServerWithSsl", "org.infinispan.server.router.performance.configuration.TwoServersWithSslSni"})
        public String configurationClassName;
        private List<HotRodServer> hotRodServers;
        private Optional<Set<Route<? extends RouteSource, ? extends RouteDestination>>> routes;
        private RemoteCacheManager preloadedClient;
        private Optional<MultiTenantRouter> router;
        private PerfTestConfiguration configuration;

        @Setup
        public void setup() throws Exception {
            InternalLoggerFactory.setDefaultFactory((InternalLoggerFactory)JdkLoggerFactory.INSTANCE);
            System.setProperty("infinispan.server.channel.epoll", "false");
            this.configuration = (PerfTestConfiguration)Class.forName(this.configurationClassName).getDeclaredConstructor(null).newInstance(null);
            this.hotRodServers = this.configuration.initServers();
            this.routes = this.configuration.initRoutes(this.hotRodServers);
            this.router = this.configuration.initRouter(this.routes);
            this.preloadedClient = this.configuration.initClient(this.router, this.routes, this.hotRodServers);
        }

        @TearDown
        public void tearDown() {
            this.preloadedClient.stop();
            this.configuration.shutdown(this.hotRodServers, this.router);
        }

        @Benchmark
        public void initConnectionOnly() {
            RemoteCacheManager client = this.configuration.initClient(this.router, this.routes, this.hotRodServers);
            client.stop();
        }

        @Benchmark
        public void initConnectionAndPerform10Puts() {
            RemoteCacheManager client = this.configuration.initClient(this.router, this.routes, this.hotRodServers);
            this.configuration.performLoadTesting(client, 10);
            client.stop();
        }

        @Benchmark
        public void initConnectionAndPerform10KPuts() {
            RemoteCacheManager client = this.configuration.initClient(this.router, this.routes, this.hotRodServers);
            this.configuration.performLoadTesting(client, 10000);
            client.stop();
        }

        @Benchmark
        public void perform10KPuts() {
            this.configuration.performLoadTesting(this.preloadedClient, 10000);
        }
    }
}

