/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.router.configuration;

import java.net.InetAddress;
import org.assertj.core.api.Assertions;
import org.infinispan.server.router.configuration.HotRodRouterConfiguration;
import org.infinispan.server.router.configuration.RestRouterConfiguration;
import org.infinispan.server.router.configuration.RouterConfiguration;
import org.infinispan.server.router.configuration.builder.RouterConfigurationBuilder;
import org.infinispan.server.router.routes.Route;
import org.infinispan.server.router.routes.RouteDestination;
import org.infinispan.server.router.routes.RouteSource;
import org.junit.Test;

public class ConfigurationTest {
    @Test
    public void shouldBuildProperRouterConfiguration() {
        RouterConfigurationBuilder multiTenantConfigurationBuilder = new RouterConfigurationBuilder();
        RouteSource s1 = new RouteSource(){};
        RouteDestination d1 = new RouteDestination(){};
        multiTenantConfigurationBuilder.hotrod().keepAlive(true).receiveBufferSize(1).sendBufferSize(1).tcpNoDelay(false).port(1010).ip(InetAddress.getLoopbackAddress()).rest().port(1111).ip(InetAddress.getLoopbackAddress()).routing().add(new Route(s1, d1));
        RouterConfiguration routerConfiguration = multiTenantConfigurationBuilder.build();
        HotRodRouterConfiguration hotRodRouterConfiguration = routerConfiguration.getHotRodRouterConfiguration();
        RestRouterConfiguration restRouterConfiguration = routerConfiguration.getRestRouterConfiguration();
        Assertions.assertThat((int)hotRodRouterConfiguration.getPort()).isEqualTo(1010);
        Assertions.assertThat((Object)hotRodRouterConfiguration.getIp()).isEqualTo((Object)InetAddress.getLoopbackAddress());
        Assertions.assertThat((boolean)hotRodRouterConfiguration.keepAlive()).isTrue();
        Assertions.assertThat((boolean)hotRodRouterConfiguration.tcpNoDelay()).isFalse();
        Assertions.assertThat((int)hotRodRouterConfiguration.sendBufferSize()).isEqualTo(1);
        Assertions.assertThat((int)hotRodRouterConfiguration.receiveBufferSize()).isEqualTo(1);
        Assertions.assertThat((int)restRouterConfiguration.getPort()).isEqualTo(1111);
        Assertions.assertThat((Object)restRouterConfiguration.getIp()).isEqualTo((Object)InetAddress.getLoopbackAddress());
        Assertions.assertThat((int)routerConfiguration.getRoutingTable().routesCount()).isEqualTo(1);
    }
}

