/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.router.integration;

import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.ssl.OpenSsl;
import io.netty.handler.ssl.SslContext;
import io.netty.util.CharsetUtil;
import java.lang.invoke.MethodHandles;
import java.net.InetAddress;
import java.util.Queue;
import org.assertj.core.api.Assertions;
import org.infinispan.rest.RestServer;
import org.infinispan.rest.http2.NettyHttpClient;
import org.infinispan.rest.http2.NettyTruststoreUtil;
import org.infinispan.server.hotrod.HotRodOperation;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.OperationStatus;
import org.infinispan.server.hotrod.test.HotRodClient;
import org.infinispan.server.hotrod.test.HotRodTestingUtil;
import org.infinispan.server.hotrod.test.TestResponse;
import org.infinispan.server.router.Router;
import org.infinispan.server.router.configuration.builder.RouterConfigurationBuilder;
import org.infinispan.server.router.router.EndpointRouter;
import org.infinispan.server.router.routes.Route;
import org.infinispan.server.router.routes.RouteDestination;
import org.infinispan.server.router.routes.RouteSource;
import org.infinispan.server.router.routes.hotrod.HotRodServerRouteDestination;
import org.infinispan.server.router.routes.rest.RestServerRouteDestination;
import org.infinispan.server.router.routes.singleport.SinglePortRouteSource;
import org.infinispan.server.router.utils.RestTestingUtil;
import org.infinispan.test.fwk.TestResourceTracker;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public class SinglePortTest {
    public static final String KEY_STORE_PATH = SinglePortTest.class.getClassLoader().getResource("./default_server_keystore.jks").getPath();
    public static final String KEY_STORE_PASSWORD = "secret";
    public static final String TRUST_STORE_PATH = SinglePortTest.class.getClassLoader().getResource("./default_client_truststore.jks").getPath();
    public static final String TRUST_STORE_PASSWORD = "secret";
    private Router router;
    private RestServer restServer;
    private HotRodServer hotrodServer;
    private NettyHttpClient httpClient;
    private HotRodClient hotRodClient;

    @BeforeClass
    public static void beforeClass() {
        TestResourceTracker.testStarted((String)MethodHandles.lookup().lookupClass().toString());
    }

    @AfterClass
    public static void afterClass() {
        TestResourceTracker.testFinished((String)MethodHandles.lookup().lookupClass().toString());
    }

    @After
    public void afterMethod() {
        if (this.router != null) {
            this.router.stop();
        }
        if (this.restServer != null) {
            this.restServer.stop();
            this.restServer.getCacheManager().stop();
        }
        if (this.hotrodServer != null) {
            this.hotrodServer.stop();
            this.hotrodServer.getCacheManager().stop();
        }
        if (this.httpClient != null) {
            this.httpClient.stop();
        }
        if (this.hotRodClient != null) {
            this.hotRodClient.stop();
        }
    }

    @Test
    public void shouldUpgradeThroughHTTP11UpgradeHeaders() throws Exception {
        this.restServer = RestTestingUtil.createDefaultRestServer("default");
        RestServerRouteDestination restDestination = new RestServerRouteDestination("rest1", this.restServer);
        SinglePortRouteSource singlePortSource = new SinglePortRouteSource();
        Route routeToRest = new Route((RouteSource)singlePortSource, (RouteDestination)restDestination);
        RouterConfigurationBuilder routerConfigurationBuilder = new RouterConfigurationBuilder();
        routerConfigurationBuilder.singlePort().port(0).ip(InetAddress.getLoopbackAddress()).routing().add(routeToRest);
        this.router = new Router(routerConfigurationBuilder.build());
        this.router.start();
        int port = ((EndpointRouter)this.router.getRouter(EndpointRouter.Protocol.SINGLE_PORT).get()).getPort();
        this.httpClient = NettyHttpClient.newHttp2ClientWithHttp11Upgrade();
        this.httpClient.start("localhost", port);
        DefaultFullHttpRequest putValueInCacheRequest = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.POST, "/rest/default/test", Unpooled.wrappedBuffer((byte[])"test".getBytes(CharsetUtil.UTF_8)));
        this.httpClient.sendRequest((FullHttpRequest)putValueInCacheRequest);
        Queue responses = this.httpClient.getResponses();
        Assertions.assertThat((Iterable)responses).hasSize(1);
        Assertions.assertThat((Comparable)((FullHttpResponse)responses.poll()).status()).isEqualTo((Object)HttpResponseStatus.OK);
    }

    @Test
    public void shouldUpgradeThroughALPN() throws Exception {
        if (!OpenSsl.isAlpnSupported()) {
            throw new IllegalStateException("OpenSSL is not present, can not test TLS/ALPN support. Version: " + OpenSsl.versionString() + " Cause: " + OpenSsl.unavailabilityCause());
        }
        this.restServer = RestTestingUtil.createDefaultRestServer("default");
        RestServerRouteDestination restDestination = new RestServerRouteDestination("rest1", this.restServer);
        SinglePortRouteSource singlePortSource = new SinglePortRouteSource();
        Route routeToRest = new Route((RouteSource)singlePortSource, (RouteDestination)restDestination);
        RouterConfigurationBuilder routerConfigurationBuilder = new RouterConfigurationBuilder();
        routerConfigurationBuilder.singlePort().sslWithAlpn(KEY_STORE_PATH, "secret".toCharArray()).port(0).ip(InetAddress.getLoopbackAddress()).routing().add(routeToRest);
        this.router = new Router(routerConfigurationBuilder.build());
        this.router.start();
        int port = ((EndpointRouter)this.router.getRouter(EndpointRouter.Protocol.SINGLE_PORT).get()).getPort();
        this.httpClient = NettyHttpClient.newHttp2ClientWithALPN((String)TRUST_STORE_PATH, (String)"secret");
        this.httpClient.start("localhost", port);
        DefaultFullHttpRequest putValueInCacheRequest = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.POST, "/rest/default/test", Unpooled.wrappedBuffer((byte[])"test".getBytes(CharsetUtil.UTF_8)));
        this.httpClient.sendRequest((FullHttpRequest)putValueInCacheRequest);
        Queue responses = this.httpClient.getResponses();
        Assertions.assertThat((Iterable)responses).hasSize(1);
        Assertions.assertThat((Comparable)((FullHttpResponse)responses.poll()).status()).isEqualTo((Object)HttpResponseStatus.OK);
    }

    @Test
    public void shouldUpgradeToHotRodThroughALPN() throws Exception {
        if (!OpenSsl.isAlpnSupported()) {
            throw new IllegalStateException("OpenSSL is not present, can not test TLS/ALPN support. Version: " + OpenSsl.versionString() + " Cause: " + OpenSsl.unavailabilityCause());
        }
        this.hotrodServer = HotRodTestingUtil.startHotRodServerWithoutTransport((String[])new String[]{"default"});
        this.restServer = RestTestingUtil.createDefaultRestServer("default");
        HotRodServerRouteDestination hotrodDestination = new HotRodServerRouteDestination("hotrod", this.hotrodServer);
        RestServerRouteDestination restDestination = new RestServerRouteDestination("rest", this.restServer);
        SinglePortRouteSource singlePortSource = new SinglePortRouteSource();
        Route routeToRest = new Route((RouteSource)singlePortSource, (RouteDestination)restDestination);
        Route routeToHotRod = new Route((RouteSource)singlePortSource, (RouteDestination)hotrodDestination);
        RouterConfigurationBuilder routerConfigurationBuilder = new RouterConfigurationBuilder();
        routerConfigurationBuilder.singlePort().sslWithAlpn(KEY_STORE_PATH, "secret".toCharArray()).port(0).ip(InetAddress.getLoopbackAddress()).routing().add(routeToRest).add(routeToHotRod);
        this.router = new Router(routerConfigurationBuilder.build());
        this.router.start();
        int port = ((EndpointRouter)this.router.getRouter(EndpointRouter.Protocol.SINGLE_PORT).get()).getPort();
        SslContext sslContext = NettyTruststoreUtil.createTruststoreContext((String)TRUST_STORE_PATH, (char[])"secret".toCharArray(), (String[])new String[]{"HR"});
        this.hotRodClient = new HotRodClient("localhost", port, "default", 60, 20, sslContext.newEngine(ByteBufAllocator.DEFAULT));
        TestResponse response = this.hotRodClient.put("test", "test");
        Assertions.assertThat((Comparable)response.getStatus()).isEqualTo((Object)OperationStatus.Success);
        Assertions.assertThat((Comparable)response.getOperation()).isEqualTo((Object)HotRodOperation.PUT);
    }
}

