/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.configuration;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.server.Server;
import org.infinispan.server.configuration.ServerConfiguration;
import org.infinispan.server.core.configuration.ProtocolServerConfiguration;
import org.infinispan.server.core.configuration.ProtocolServerConfigurationBuilder;
import org.infinispan.server.network.NetworkAddress;
import org.infinispan.server.network.SocketBinding;
import org.infinispan.server.security.ServerSecurityRealm;

public class ServerConfigurationBuilder
implements Builder<ServerConfiguration> {
    private final Map<String, NetworkAddress> networkInterfaces = new HashMap<String, NetworkAddress>(2);
    private final Map<String, ServerSecurityRealm> securityRealms = new HashMap<String, ServerSecurityRealm>(2);
    private final Map<String, SocketBinding> socketBindings = new HashMap<String, SocketBinding>(2);
    private final List<ProtocolServerConfigurationBuilder<?, ?>> endpoints = new ArrayList(2);
    private final GlobalConfigurationBuilder builder;

    public ServerConfigurationBuilder(GlobalConfigurationBuilder builder) {
        this.builder = builder;
    }

    public <T extends ProtocolServerConfigurationBuilder<?, ?>> T addEndpoint(Class<T> klass) {
        try {
            ProtocolServerConfigurationBuilder builder = (ProtocolServerConfigurationBuilder)klass.newInstance();
            this.endpoints.add(builder);
            return (T)builder;
        }
        catch (Exception e) {
            throw Server.log.cannotInstantiateProtocolServerConfigurationBuilder(klass, e);
        }
    }

    public void addSecurityRealm(String name, ServerSecurityRealm realm) {
        if (this.securityRealms.putIfAbsent(name, realm) != null) {
            throw Server.log.duplicateSecurityRealm(name);
        }
    }

    public void addNetworkInterface(NetworkAddress networkAddress) {
        if (this.networkInterfaces.putIfAbsent(networkAddress.getName(), networkAddress) != null) {
            throw Server.log.duplicatePath(networkAddress.getName());
        }
    }

    public void addSocketBinding(String name, NetworkAddress networkAddress, int port) {
        if (this.socketBindings.putIfAbsent(name, new SocketBinding(name, networkAddress, port)) != null) {
            throw Server.log.duplicatePath(name);
        }
    }

    public void addSocketBinding(String name, String interfaceName, int port) {
        if (!this.networkInterfaces.containsKey(interfaceName)) {
            throw Server.log.unknownInterface(interfaceName);
        }
        this.addSocketBinding(name, this.networkInterfaces.get(interfaceName), port);
    }

    public void validate() {
    }

    public ServerConfiguration create() {
        return new ServerConfiguration(this.networkInterfaces, this.socketBindings, this.securityRealms, this.endpoints.stream().map(b -> (ProtocolServerConfiguration)b.create()).collect(Collectors.toList()));
    }

    public Builder<?> read(ServerConfiguration template) {
        return this;
    }

    public SocketBinding getSocketBinding(String value) {
        return this.socketBindings.get(value);
    }

    public void applySocketBinding(String name, ProtocolServerConfigurationBuilder builder) {
        SocketBinding socketBinding = this.socketBindings.get(name);
        if (socketBinding == null) {
            throw Server.log.unknownSocketBinding(name);
        }
        builder.host(socketBinding.getAddress().getAddress().getHostAddress()).port(socketBinding.getPort());
    }
}

