/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.configuration.hotrod;

import java.util.HashMap;
import java.util.Map;

public enum Attribute {
    UNKNOWN(null),
    AWAIT_INITIAL_RETRIEVAL,
    CACHE_CONTAINER,
    EXTERNAL_HOST,
    EXTERNAL_PORT,
    IDLE_TIMEOUT,
    IO_THREADS,
    LAZY_RETRIEVAL,
    LOCK_TIMEOUT,
    MECHANISMS,
    NAME,
    QOP,
    RECEIVE_BUFFER_SIZE,
    REPLICATION_TIMEOUT,
    REQUIRE_SSL_CLIENT_AUTH,
    SECURITY_REALM,
    SEND_BUFFER_SIZE,
    SERVER_CONTEXT_NAME,
    SERVER_NAME,
    SOCKET_BINDING,
    STRENGTH,
    TCP_KEEPALIVE,
    TCP_NODELAY,
    WORKER_THREADS;

    private static final Map<String, Attribute> ATTRIBUTES;
    private final String name;

    private Attribute(String name) {
        this.name = name;
    }

    private Attribute() {
        this.name = this.name().toLowerCase().replace('_', '-');
    }

    public static Attribute forName(String localName) {
        Attribute attribute = ATTRIBUTES.get(localName);
        return attribute == null ? UNKNOWN : attribute;
    }

    public String toString() {
        return this.name;
    }

    static {
        HashMap<String, Attribute> map = new HashMap<String, Attribute>(64);
        for (Attribute attribute : Attribute.values()) {
            String name = attribute.name;
            if (name == null) continue;
            map.put(name, attribute);
        }
        ATTRIBUTES = map;
    }
}

