/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Properties;
import java.util.logging.LogManager;
import org.infinispan.Version;
import org.infinispan.server.DefaultExitHandler;
import org.infinispan.server.ExitHandler;
import org.infinispan.server.SecurityActions;
import org.infinispan.server.Server;
import org.infinispan.server.ShutdownHook;
import org.infinispan.server.logging.Messages;

public class Bootstrap {
    public static void main(String[] args) {
        Bootstrap.main(args, System.out, System.err, new DefaultExitHandler(), SecurityActions.getSystemProperties());
    }

    public static void main(String[] args, PrintStream stdOut, PrintStream stdErr, ExitHandler exitHandler, Properties properties) {
        String cwd = properties.getProperty("user.dir");
        File serverHome = new File(properties.getProperty("infinispan.server.home.path", cwd));
        File serverRoot = new File(properties.getProperty("infinispan.server.root.path", new File(serverHome, "server").getAbsolutePath()));
        File configurationFile = null;
        block35: for (int i = 0; i < args.length; ++i) {
            String command = args[i];
            String parameter = null;
            if (command.startsWith("--")) {
                int equals = command.indexOf(61);
                if (equals > 0) {
                    parameter = command.substring(equals + 1);
                    command = command.substring(0, equals);
                }
            } else if (command.startsWith("-")) {
                if (command.length() != 2) {
                    stdErr.println(Messages.MSG.invalidShortArgument(command));
                    exitHandler.exit(1);
                }
            } else {
                stdErr.println(Messages.MSG.invalidArgument(command));
                exitHandler.exit(1);
            }
            switch (command) {
                case "-h": 
                case "--help": {
                    Bootstrap.help(stdOut, true);
                    exitHandler.exit(0);
                    continue block35;
                }
                case "-c": {
                    parameter = args[++i];
                }
                case "--server-config": {
                    configurationFile = new File(parameter);
                    continue block35;
                }
                case "--s": {
                    parameter = args[++i];
                }
                case "--server-root": {
                    serverRoot = new File(parameter);
                    continue block35;
                }
                case "-b": {
                    parameter = args[++i];
                }
                case "--bind-address": {
                    properties.setProperty("infinispan.bind.address", parameter);
                    continue block35;
                }
                case "-o": {
                    parameter = args[++i];
                }
                case "--port-offset": {
                    properties.setProperty("infinispan.socket.binding.port-offset", parameter);
                    continue block35;
                }
                case "-v": 
                case "--version": {
                    Bootstrap.help(stdOut, false);
                    exitHandler.exit(0);
                    continue block35;
                }
                default: {
                    stdErr.println(Messages.MSG.unknownParameter(args[i]));
                    exitHandler.exit(1);
                }
            }
        }
        File confDir = new File(serverRoot, "conf");
        if (configurationFile == null) {
            configurationFile = new File(confDir, "infinispan.xml");
        }
        File logDir = new File(serverRoot, "log");
        properties.putIfAbsent("infinispan.server.log.path", logDir.getAbsolutePath());
        try (FileInputStream is = new FileInputStream(new File(confDir, "logging.properties"));){
            LogManager.getLogManager().readConfiguration(is);
        }
        catch (IOException e) {
            stdErr.printf("Could not load logging.properties: %s", e.getMessage());
            e.printStackTrace(stdErr);
        }
        try {
            Runtime.getRuntime().addShutdownHook(new ShutdownHook(exitHandler));
            Server.log.serverStarting(Version.getBrandName());
            Server.log.serverConfiguration(configurationFile.getAbsolutePath());
            Server server = new Server(serverRoot, configurationFile, properties);
            server.setExitHandler(exitHandler);
            server.run().get();
        }
        catch (Exception e) {
            Server.log.fatal("Error", e);
        }
    }

    public static void help(PrintStream stdOut, boolean usage) {
        stdOut.printf("%s Server %s (%s)\n", Version.getBrandName(), Version.getVersion(), Version.getCodename());
        if (usage) {
            stdOut.printf("Usage:\n", new Object[0]);
            stdOut.printf("  -b, --bind-address=<address>  Binds the server to the specified address.\n", new Object[0]);
            stdOut.printf("  -o, --port-offset=<offset>    Adds the specified offset to all ports.\n", new Object[0]);
            stdOut.printf("  -c, --server-config=<config>  Uses the specified configuration file. Defaults to '%s'.\n", "infinispan.xml");
            stdOut.printf("  -h, --help                    Displays this message and exits.\n", new Object[0]);
            stdOut.printf("  -s, --server-root=<path>      Uses the specified path as root for the server. Defaults to '%s'.\n", "server");
            stdOut.printf("  -v, --version                 Displays version information and exits.\n", new Object[0]);
        }
    }
}

